/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.internal.search.NlsKeySearchRequestor;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.ui.text.Match;

public class NlsFindKeysJob
extends Job {
    private final Pattern m_searchPattern;
    private NlsKeySearchRequestor m_searchRequstor;

    public NlsFindKeysJob(String nlsKey, String jobTitle) {
        this(Pattern.compile("\\\"" + nlsKey + "\\\""), jobTitle);
    }

    public NlsFindKeysJob(INlsProject project, String jobTitle) {
        this(NlsFindKeysJob.createPatternForAllNlsKeys(project), jobTitle);
    }

    public NlsFindKeysJob(Pattern searchPattern, String jobName) {
        super(jobName);
        this.m_searchPattern = searchPattern;
        this.m_searchRequstor = new NlsKeySearchRequestor();
    }

    public IStatus run(IProgressMonitor monitor) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> searchScopeRessources = new ArrayList<IProject>();
        TextSearchScope searchScope = null;
        try {
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.exists() && project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature") && project.hasNature("org.eclipse.pde.PluginNature")) {
                    searchScopeRessources.add(project);
                }
                ++n2;
            }
            searchScope = TextSearchScope.newSearchScope((IResource[])searchScopeRessources.toArray(new IResource[searchScopeRessources.size()]), (Pattern)Pattern.compile(".*\\.java"), (boolean)false);
        }
        catch (CoreException e) {
            NlsCore.logError("Could not create java projects for nls search.");
        }
        TextSearchEngine.create().search(searchScope, (TextSearchRequestor)this.m_searchRequstor, this.m_searchPattern, monitor);
        return Status.OK_STATUS;
    }

    public Map<String, List<Match>> getMatches() {
        if (this.getState() != 0) {
            throw new IllegalAccessError("job has not finished yet.");
        }
        return this.m_searchRequstor.getAllMatches();
    }

    public Match[] getMatches(String key) {
        if (this.getState() != 0) {
            throw new IllegalAccessError("job has not finished yet.");
        }
        return this.m_searchRequstor.getMatches(key);
    }

    public NlsKeySearchRequestor getSearchRequstor() {
        return this.m_searchRequstor;
    }

    public static Pattern createPatternForAllNlsKeys(INlsProject project) {
        StringBuilder patternBuilder = new StringBuilder();
        String[] allKeys = project.getAllKeys();
        if (allKeys.length > 0) {
            patternBuilder.append("\\\"").append(allKeys[0]).append("\\\"");
        }
        int i = 1;
        while (i < allKeys.length) {
            patternBuilder.append("|\\\"").append(allKeys[i]).append("\\\"");
            ++i;
        }
        return Pattern.compile(patternBuilder.toString());
    }
}

