/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.dialog;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ProjectChooserDialog
extends TitleAreaDialog {
    private String m_title;
    private HashMap<String, IProject> m_selection = new HashMap();
    private Collection<IProject> m_workspaceProjects = new LinkedList<IProject>();
    private CheckboxTableViewer m_viewer;

    public ProjectChooserDialog(Shell parentShell, String title) {
        super(parentShell);
        this.m_title = title;
        ResourcesPlugin.getWorkspace().getRoot();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.m_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite rootArea = new Composite(parent, 0);
        this.m_viewer = CheckboxTableViewer.newCheckList((Composite)rootArea, (int)2048);
        this.m_viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ProjectChooserDialog.this.handleSelectionChanged((IProject)event.getElement(), event.getChecked());
            }
        });
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (project.isOpen() && project.hasNature("org.eclipse.pde.PluginNature")) {
                    this.m_workspaceProjects.add(project);
                }
            }
            catch (CoreException e) {
                NlsCore.logWarning(e);
            }
            ++n2;
        }
        P_ProjectModel model = new P_ProjectModel(this.m_workspaceProjects);
        this.m_viewer.setContentProvider((IContentProvider)model);
        this.m_viewer.setLabelProvider((IBaseLabelProvider)model);
        this.m_viewer.setInput((Object)model);
        Control controlArea = this.createControlArea(rootArea);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        rootArea.setLayoutData((Object)data);
        rootArea.setLayout((Layout)new GridLayout(2, false));
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.m_viewer.getTable().setLayoutData((Object)data);
        controlArea.setLayoutData((Object)new GridData());
        return rootArea;
    }

    private Control createControlArea(Composite parent) {
        Composite rootArea = new Composite(parent, 0);
        Button selectAll = new Button(rootArea, 0x800008);
        selectAll.setText("Select all");
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectChooserDialog.this.m_viewer.setAllChecked(true);
                for (IProject project : ProjectChooserDialog.this.m_workspaceProjects) {
                    ProjectChooserDialog.this.m_selection.put(project.getName(), project);
                }
                ProjectChooserDialog.this.revalidate();
            }
        });
        Button deselectAll = new Button(rootArea, 0x800008);
        deselectAll.setText("Deselect all");
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectChooserDialog.this.m_viewer.setAllChecked(false);
                ProjectChooserDialog.this.m_selection.clear();
                ProjectChooserDialog.this.revalidate();
            }
        });
        rootArea.setLayout((Layout)new GridLayout(1, true));
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        selectAll.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        deselectAll.setLayoutData((Object)data);
        return rootArea;
    }

    public void setSelection(Collection<IProject> projects) {
        for (IProject project : projects) {
            if (!this.m_workspaceProjects.contains(project)) continue;
            this.m_viewer.setChecked((Object)project, true);
            this.m_selection.put(project.getName(), project);
        }
        this.revalidate();
    }

    public Collection<IProject> getSelection() {
        return this.m_selection.values();
    }

    private void handleSelectionChanged(IProject project, boolean checked) {
        if (checked) {
            this.m_selection.put(project.getName(), project);
        } else {
            this.m_selection.remove(project.getName());
        }
        this.revalidate();
    }

    private void revalidate() {
        if (this.m_selection.isEmpty()) {
            this.getButton(0).setEnabled(false);
        } else {
            this.getButton(0).setEnabled(true);
        }
    }

    private class P_ProjectModel
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private Collection<IProject> m_pluginProjects;

        private P_ProjectModel(Collection<IProject> workspaceProjects) {
            this.m_pluginProjects = workspaceProjects;
        }

        public Object[] getElements(Object inputElement) {
            return this.m_pluginProjects.toArray();
        }

        public Image getColumnImage(Object element, int column) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        }

        public String getColumnText(Object element, int column) {
            return ((IProject)element).getName();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

