/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.transformation;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.mobile.navigation.AbstractMobileBackAction;
import org.eclipse.scout.rt.client.mobile.navigation.IBreadCrumbsNavigation;
import org.eclipse.scout.rt.client.mobile.navigation.IBreadCrumbsNavigationService;
import org.eclipse.scout.rt.client.mobile.transformation.DeviceTransformationConfig;
import org.eclipse.scout.rt.client.mobile.transformation.DeviceTransformationHooks;
import org.eclipse.scout.rt.client.mobile.transformation.IDeviceTransformation;
import org.eclipse.scout.rt.client.mobile.transformation.IDeviceTransformationHook;
import org.eclipse.scout.rt.client.mobile.transformation.IDeviceTransformer;
import org.eclipse.scout.rt.client.mobile.transformation.MobileDeviceTransformation;
import org.eclipse.scout.rt.client.mobile.transformation.ToolFormCloseAction;
import org.eclipse.scout.rt.client.mobile.transformation.ToolFormHandler;
import org.eclipse.scout.rt.client.mobile.ui.action.ButtonWrappingAction;
import org.eclipse.scout.rt.client.mobile.ui.desktop.MobileDesktopUtility;
import org.eclipse.scout.rt.client.mobile.ui.form.AbstractMobileForm;
import org.eclipse.scout.rt.client.mobile.ui.form.outline.PageFormManager;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.view.IViewButton;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithNodes;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.form.FormUtility;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.IFormFieldVisitor;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.placeholder.IPlaceholderField;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;
import org.eclipse.scout.service.SERVICES;

public class MobileDeviceTransformer
implements IDeviceTransformer {
    private final Map<IForm, WeakReference<IForm>> m_modifiedForms = new WeakHashMap<IForm, WeakReference<IForm>>();
    private IDesktop m_desktop;
    private PageFormManager m_pageFormManager;
    private ToolFormHandler m_toolFormHandler;
    private boolean m_gridDataDirty;
    private DeviceTransformationConfig m_deviceTransformationConfig;

    public MobileDeviceTransformer(IDesktop desktop) {
        if (desktop == null) {
            desktop = ClientSyncJob.getCurrentSession().getDesktop();
        }
        this.m_desktop = desktop;
        if (this.m_desktop == null) {
            throw new IllegalArgumentException("No desktop found. Cannot create device transformer.");
        }
        this.m_deviceTransformationConfig = this.createDeviceTransformationConfig();
        this.initTransformationConfig();
        this.m_pageFormManager = this.createPageFormManager(desktop);
        this.m_toolFormHandler = this.createToolFormHandler(desktop);
        IBreadCrumbsNavigation breadCrumbsNavigation = ((IBreadCrumbsNavigationService)SERVICES.getService(IBreadCrumbsNavigationService.class)).getBreadCrumbsNavigation();
        if (breadCrumbsNavigation != null) {
            breadCrumbsNavigation.trackDisplayViewId("C");
        }
    }

    public MobileDeviceTransformer() {
        this(null);
    }

    protected PageFormManager createPageFormManager(IDesktop desktop) {
        return new PageFormManager(desktop, this.getAcceptedViewIds().toArray(new String[this.getAcceptedViewIds().size()]));
    }

    public PageFormManager getPageFormManager() {
        return this.m_pageFormManager;
    }

    protected ToolFormHandler createToolFormHandler(IDesktop desktop) {
        return new ToolFormHandler(this.getDesktop());
    }

    public ToolFormHandler getToolFormHandler() {
        return this.m_toolFormHandler;
    }

    protected DeviceTransformationConfig createDeviceTransformationConfig() {
        return new DeviceTransformationConfig();
    }

    @Override
    public DeviceTransformationConfig getDeviceTransformationConfig() {
        return this.m_deviceTransformationConfig;
    }

    protected void initTransformationConfig() {
        LinkedList<MobileDeviceTransformation> transformations = new LinkedList<MobileDeviceTransformation>();
        transformations.add(MobileDeviceTransformation.MOVE_FIELD_LABEL_TO_TOP);
        transformations.add(MobileDeviceTransformation.MAKE_FIELD_SCALEABLE);
        transformations.add(MobileDeviceTransformation.MAKE_MAINBOX_SCROLLABLE);
        transformations.add(MobileDeviceTransformation.REDUCE_GROUPBOX_COLUMNS_TO_ONE);
        transformations.add(MobileDeviceTransformation.HIDE_PLACEHOLDER_FIELD);
        transformations.add(MobileDeviceTransformation.DISABLE_FORM_CANCEL_CONFIRMATION);
        transformations.add(MobileDeviceTransformation.DISPLAY_FORM_HEADER);
        transformations.add(MobileDeviceTransformation.ADD_MISSING_BACK_ACTION_TO_FORM_HEADER);
        transformations.add(MobileDeviceTransformation.DISPLAY_OUTLINE_ROOT_NODE);
        transformations.add(MobileDeviceTransformation.DISPLAY_PAGE_TABLE);
        for (IDeviceTransformation iDeviceTransformation : transformations) {
            this.getDeviceTransformationConfig().enableTransformation(iDeviceTransformation);
        }
    }

    @Override
    public List<String> getAcceptedViewIds() {
        LinkedList<String> viewIds = new LinkedList<String>();
        viewIds.add("C");
        return viewIds;
    }

    @Override
    public void notifyTablePageLoaded(IPageWithTable<?> tablePage) throws ProcessingException {
        if (this.m_toolFormHandler != null) {
            this.m_toolFormHandler.notifyTablePageLoaded(tablePage);
        }
    }

    @Override
    public void adaptDesktopActions(Collection<IAction> actions) {
        Iterator<IAction> iterator = actions.iterator();
        while (iterator.hasNext()) {
            IAction action = iterator.next();
            if (!(action instanceof IViewButton) && !(action instanceof IKeyStroke) && !(action instanceof IMenu)) continue;
            iterator.remove();
        }
    }

    @Override
    public void adaptDesktopOutlines(Collection<IOutline> outlines) {
    }

    @Override
    public void transformForm(IForm form) throws ProcessingException {
        if (this.getDeviceTransformationConfig().isFormExcluded(form)) {
            return;
        }
        List<IDeviceTransformationHook> hooks = DeviceTransformationHooks.getFormTransformationHooks(form.getClass());
        if (hooks != null) {
            for (IDeviceTransformationHook hook : hooks) {
                hook.beforeFormTransformation(form);
            }
        }
        this.m_gridDataDirty = false;
        if (this.getDeviceTransformationConfig().isTransformationEnabled(MobileDeviceTransformation.DISABLE_FORM_CANCEL_CONFIRMATION)) {
            form.setAskIfNeedSave(false);
        }
        if (this.getDeviceTransformationConfig().isTransformationEnabled(MobileDeviceTransformation.DISPLAY_FORM_HEADER)) {
            AbstractMobileForm.setHeaderVisible(form, true);
        }
        if (form.getDisplayHint() == 20) {
            this.transformView(form);
        }
        this.transformFormFields(form);
        if (this.isGridDataDirty()) {
            FormUtility.rebuildFieldGrid((IForm)form, (boolean)true);
            this.m_gridDataDirty = false;
        }
    }

    protected void transformView(IForm form) {
        form.setDisplayViewId("C");
    }

    @Override
    public void transformOutline(IOutline outline) {
        if (outline == null || outline.getRootNode() == null) {
            return;
        }
        if (this.getDeviceTransformationConfig().isTransformationEnabled(MobileDeviceTransformation.DISPLAY_OUTLINE_ROOT_NODE)) {
            outline.setRootNodeVisible(true);
        }
    }

    @Override
    public void transformPageDetailTable(ITable table) {
        if (table == null && this.getDeviceTransformationConfig().isTransformationEnabled(MobileDeviceTransformation.DISPLAY_PAGE_TABLE)) {
            this.makeSurePageDetailTableIsVisible();
        }
    }

    @Override
    public boolean acceptFormAddingToDesktop(IForm form) {
        return this.m_pageFormManager.acceptForm(form);
    }

    private void makeSurePageDetailTableIsVisible() {
        IOutline outline = this.getDesktop().getOutline();
        if (outline == null) {
            return;
        }
        IPage activePage = outline.getActivePage();
        if (activePage == null || activePage.isTableVisible() || this.isPageDetailTableAllowedToBeClosed(activePage)) {
            return;
        }
        activePage.setTableVisible(true);
        if (activePage instanceof IPageWithNodes) {
            outline.setDetailTable(((IPageWithNodes)activePage).getInternalTable());
        } else if (activePage instanceof IPageWithTable) {
            outline.setDetailTable(((IPageWithTable)activePage).getTable());
        }
    }

    protected boolean isPageDetailTableAllowedToBeClosed(IPage activePage) {
        return activePage.isLeaf();
    }

    protected void transformFormFields(IForm form) throws ProcessingException {
        WeakReference<IForm> formRef = this.m_modifiedForms.get(form);
        if (formRef != null) {
            return;
        }
        form.visitFields(new IFormFieldVisitor(){

            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (MobileDeviceTransformer.this.getDeviceTransformationConfig().isFieldExcluded(field)) {
                    return true;
                }
                MobileDeviceTransformer.this.transformFormField(field);
                return true;
            }
        });
        if (!this.getDeviceTransformationConfig().isFieldExcluded((IFormField)form.getRootGroupBox())) {
            this.transformMainBox(form.getRootGroupBox());
        }
        this.m_modifiedForms.put(form, new WeakReference<IForm>(form));
    }

    protected void transformFormField(IFormField field) {
        List<IDeviceTransformationHook> hooks = DeviceTransformationHooks.getFormFieldTransformationHooks(field.getClass());
        if (hooks != null) {
            for (IDeviceTransformationHook hook : hooks) {
                hook.beforeFormFieldTransformation(field);
            }
        }
        if (this.getDeviceTransformationConfig().isTransformationEnabled((IDeviceTransformation)MobileDeviceTransformation.MOVE_FIELD_LABEL_TO_TOP, field)) {
            this.moveLabelToTop(field);
        }
        if (this.getDeviceTransformationConfig().isTransformationEnabled((IDeviceTransformation)MobileDeviceTransformation.MAKE_FIELD_SCALEABLE, field)) {
            this.makeFieldScalable(field);
        }
        if (field instanceof IGroupBox) {
            this.transformGroupBox((IGroupBox)field);
        } else if (field instanceof IPlaceholderField) {
            this.transformPlaceholderField((IPlaceholderField)field);
        }
    }

    protected void makeFieldScalable(IFormField field) {
        if (field.getParentField() instanceof ISequenceBox) {
            return;
        }
        GridData gridDataHints = field.getGridDataHints();
        if (gridDataHints.weightX == 0.0) {
            gridDataHints.weightX = 1.0;
            field.setGridDataHints(gridDataHints);
            this.markGridDataDirty();
        }
    }

    protected void moveLabelToTop(IFormField field) {
        if (field instanceof IGroupBox) {
            return;
        }
        if (2 == field.getLabelPosition()) {
            return;
        }
        if (field.getParentField() instanceof ISequenceBox) {
            return;
        }
        field.setLabelPosition(4);
        if (field instanceof IBooleanField) {
            field.setLabelVisible(false);
        }
    }

    protected void transformMainBox(IGroupBox groupBox) throws ProcessingException {
        if (this.getDeviceTransformationConfig().isTransformationEnabled((IDeviceTransformation)MobileDeviceTransformation.MAKE_MAINBOX_SCROLLABLE, (IFormField)groupBox)) {
            this.makeGroupBoxScrollable(groupBox);
        }
    }

    protected void makeGroupBoxScrollable(IGroupBox groupBox) {
        if (groupBox.getForm() == this.getDesktop().getPageDetailForm()) {
            if (groupBox.isScrollable()) {
                groupBox.setScrollable(false);
                this.markGridDataDirty();
            }
            return;
        }
        if (!groupBox.isScrollable()) {
            groupBox.setScrollable(true);
            this.markGridDataDirty();
        }
    }

    protected void transformGroupBox(IGroupBox groupBox) {
        if (this.getDeviceTransformationConfig().isTransformationEnabled((IDeviceTransformation)MobileDeviceTransformation.REDUCE_GROUPBOX_COLUMNS_TO_ONE, (IFormField)groupBox)) {
            groupBox.setGridColumnCountHint(1);
        }
    }

    protected void transformPlaceholderField(IPlaceholderField field) {
        if (this.getDeviceTransformationConfig().isTransformationEnabled((IDeviceTransformation)MobileDeviceTransformation.HIDE_PLACEHOLDER_FIELD, (IFormField)field)) {
            field.setVisible(false);
        }
    }

    protected IDesktop getDesktop() {
        return this.m_desktop;
    }

    @Override
    public boolean acceptMobileTabBoxTransformation(ITabBox tabBox) {
        IGroupBox mainBox = tabBox.getForm().getRootGroupBox();
        if (tabBox.getParentField() == mainBox) {
            return mainBox.getControlFields().get(0) != tabBox;
        }
        return false;
    }

    @Override
    public void adaptFormHeaderLeftActions(IForm form, List<IMenu> menuList) {
        if (MobileDesktopUtility.isToolForm(form) && !this.containsCloseAction(menuList)) {
            menuList.add((IMenu)new ToolFormCloseAction(form));
        }
        if (this.getDeviceTransformationConfig().isTransformationEnabled((IDeviceTransformation)MobileDeviceTransformation.ADD_MISSING_BACK_ACTION_TO_FORM_HEADER, form) && !this.containsCloseAction(menuList)) {
            menuList.add((IMenu)new P_BackAction());
        }
    }

    @Override
    public void adaptFormHeaderRightActions(IForm form, List<IMenu> menuList) {
    }

    protected boolean containsCloseAction(List<IMenu> menuList) {
        if (menuList == null) {
            return false;
        }
        block3: for (IMenu action : menuList) {
            if (action instanceof ToolFormCloseAction) {
                return true;
            }
            if (!(action instanceof ButtonWrappingAction)) continue;
            IButton wrappedButton = ((ButtonWrappingAction)action).getWrappedButton();
            switch (wrappedButton.getSystemType()) {
                case 1: 
                case 2: 
                case 3: 
                case 100: {
                    if (!wrappedButton.isVisible() || !wrappedButton.isEnabled()) continue block3;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isGridDataDirty() {
        return this.m_gridDataDirty;
    }

    protected void markGridDataDirty() {
        this.m_gridDataDirty = true;
    }

    private class P_BackAction
    extends AbstractMobileBackAction {
        private P_BackAction() {
        }
    }
}

