/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.ui.basic.table.form.fields;

import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.mobile.ui.form.fields.PropertyDelegator;
import org.eclipse.scout.rt.client.ui.basic.table.TableAdapter;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.TableListener;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;

public class ColumnFieldPropertyDelegator<SENDER extends IColumn<?>, RECEIVER extends IFormField>
extends PropertyDelegator<SENDER, RECEIVER> {
    private P_TableListener m_tableListener = new P_TableListener();

    public ColumnFieldPropertyDelegator(SENDER sender, RECEIVER receiver) {
        super(sender, receiver);
        ((IColumn)this.getSender()).getTable().addTableListener((TableListener)this.m_tableListener);
    }

    @Override
    public void dispose() {
        super.dispose();
        ((IColumn)this.getSender()).getTable().removeTableListener((TableListener)this.m_tableListener);
        this.m_tableListener = null;
    }

    @Override
    public void init() {
        ((IFormField)this.getReceiver()).setVisible(((IColumn)this.getSender()).isVisible());
        if (!((IColumn)this.getSender()).isVisible()) {
            ((IFormField)this.getReceiver()).setVisibleGranted(((IColumn)this.getSender()).isVisibleGranted());
        }
        String label = ((IColumn)this.getSender()).getHeaderCell().getText();
        if (this.isRemoveLabelLineBreaksEnabled()) {
            label = StringUtility.removeNewLines((String)label);
        }
        ((IFormField)this.getReceiver()).setLabel(label);
        ((IFormField)this.getReceiver()).setTooltipText(((IColumn)this.getSender()).getHeaderCell().getTooltipText());
        ((IFormField)this.getReceiver()).setEnabled(((IColumn)this.getSender()).isCellEditable(((IColumn)this.getSender()).getTable().getSelectedRow()));
    }

    @Override
    protected void handlePropertyChange(String name, Object newValue) {
        if (name.equals("visible")) {
            ((IFormField)this.getReceiver()).setVisible(((Boolean)newValue).booleanValue());
        }
        if (name.equals("editable")) {
            ((IFormField)this.getReceiver()).setEnabled(((Boolean)newValue).booleanValue());
        }
    }

    protected boolean isRemoveLabelLineBreaksEnabled() {
        return true;
    }

    protected void handleColumnHeaderChanged(IColumn<?> column) {
        String label = ((IColumn)this.getSender()).getHeaderCell().getText();
        if (this.isRemoveLabelLineBreaksEnabled()) {
            label = StringUtility.removeNewLines((String)label);
        }
        ((IFormField)this.getReceiver()).setLabel(label);
        ((IFormField)this.getReceiver()).setTooltipText(column.getHeaderCell().getTooltipText());
    }

    protected void handleTableEvent(TableEvent event) {
        if (780 == event.getType()) {
            for (IColumn column : event.getColumns()) {
                if (!column.equals(this.getSender())) continue;
                this.handleColumnHeaderChanged(column);
            }
        }
    }

    private class P_TableListener
    extends TableAdapter {
        private P_TableListener() {
        }

        public void tableChanged(TableEvent e) {
            ColumnFieldPropertyDelegator.this.handleTableEvent(e);
        }
    }
}

