/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.ui.form.outline;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.NumberUtility;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.ProcessingStatus;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.mobile.transformation.DeviceTransformationConfig;
import org.eclipse.scout.rt.client.mobile.transformation.DeviceTransformationUtility;
import org.eclipse.scout.rt.client.mobile.transformation.MobileDeviceTransformation;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.AbstractMobileTable;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.DrillDownStyleMap;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.MobileTable;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.TableRowForm;
import org.eclipse.scout.rt.client.mobile.ui.desktop.MobileDesktopUtility;
import org.eclipse.scout.rt.client.mobile.ui.form.AbstractMobileForm;
import org.eclipse.scout.rt.client.mobile.ui.form.IActionFetcher;
import org.eclipse.scout.rt.client.mobile.ui.form.fields.table.AbstractMobileTableField;
import org.eclipse.scout.rt.client.mobile.ui.form.outline.AutoLeafPageWithNodes;
import org.eclipse.scout.rt.client.mobile.ui.form.outline.AutoOutline;
import org.eclipse.scout.rt.client.mobile.ui.form.outline.IPageForm;
import org.eclipse.scout.rt.client.mobile.ui.form.outline.PageFormConfig;
import org.eclipse.scout.rt.client.mobile.ui.form.outline.PageFormFooterActionFetcher;
import org.eclipse.scout.rt.client.mobile.ui.form.outline.PageFormHeaderActionFetcher;
import org.eclipse.scout.rt.client.mobile.ui.form.outline.PageFormInitFieldVisitor;
import org.eclipse.scout.rt.client.mobile.ui.form.outline.PageFormManager;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableAdapter;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.TableListener;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractStringColumn;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.IFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.wrappedform.AbstractWrappedFormField;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.TEXTS;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public class PageForm
extends AbstractMobileForm
implements IPageForm {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(PageForm.class);
    private List<IButton> m_mainboxButtons;
    private IPage m_page;
    private P_PageTableListener m_pageTableListener;
    private P_PageTableSelectionListener m_pageTableSelectionListener;
    private PageFormConfig m_pageFormConfig;
    private PageFormManager m_pageFormManager;
    private Map<ITableRow, AutoLeafPageWithNodes> m_autoLeafPageMap;
    private boolean m_rowSelectionRequired;

    public PageForm(IPage page, PageFormManager manager, PageFormConfig pageFormConfig) throws ProcessingException {
        super(false);
        this.m_pageFormManager = manager;
        this.m_pageFormConfig = pageFormConfig;
        if (this.m_pageFormConfig == null) {
            this.m_pageFormConfig = new PageFormConfig();
        }
        this.m_autoLeafPageMap = new HashMap<ITableRow, AutoLeafPageWithNodes>();
        this.setPageInternal(page);
        this.initMainButtons();
        this.callInitializer();
        this.initFields();
    }

    public void initForm() throws ProcessingException {
        this.initFormInternal();
        PageFormInitFieldVisitor v = new PageFormInitFieldVisitor();
        this.visitFields(v);
        v.handleResult();
        this.execInitForm();
    }

    @Override
    public PageFormConfig getPageFormConfig() {
        return this.m_pageFormConfig;
    }

    protected boolean getConfiguredAskIfNeedSave() {
        return false;
    }

    protected int getConfiguredDisplayHint() {
        return 20;
    }

    protected String getConfiguredDisplayViewId() {
        return "C";
    }

    public MainBox.PageTableGroupBox.PageTableField getPageTableField() {
        return (MainBox.PageTableGroupBox.PageTableField)this.getFieldByClass(MainBox.PageTableGroupBox.PageTableField.class);
    }

    public MainBox.PageDetailFormField getPageDetailFormField() {
        return (MainBox.PageDetailFormField)this.getFieldByClass(MainBox.PageDetailFormField.class);
    }

    public MainBox.PageTableGroupBox getPageTableGroupBox() {
        return (MainBox.PageTableGroupBox)this.getFieldByClass(MainBox.PageTableGroupBox.class);
    }

    @Override
    public final IPage getPage() {
        return this.m_page;
    }

    private void setPageInternal(IPage page) throws ProcessingException {
        TableRowForm autoDetailForm;
        this.m_page = page;
        this.m_page = (IPage)this.m_page.getTree().resolveVirtualNode((ITreeNode)this.m_page);
        if (this.m_pageFormConfig.isDetailFormVisible() && this.m_page.getDetailForm() == null && (autoDetailForm = this.createAutoDetailForm()) != null) {
            this.m_page.setDetailForm((IForm)autoDetailForm);
            autoDetailForm.start();
        }
        this.setTitle(page.getCellForUpdate().getText());
    }

    protected void updateTableFieldVisibility() throws ProcessingException {
        boolean hasDetailForm;
        ITable table = this.getPageTableField().getTable();
        boolean bl = hasDetailForm = this.getPageDetailFormField().getInnerForm() != null;
        if (hasDetailForm) {
            boolean hasTableRows = table != null && table.getRowCount() > 0;
            this.getPageTableField().setVisible(hasTableRows);
        }
        if (this.getPageTableField().isVisible() != this.getPageTableGroupBox().isVisible()) {
            this.getPageTableGroupBox().setVisible(this.getPageTableField().isVisible());
            GridData gridData = this.getPageDetailFormField().getGridDataHints();
            gridData.weightY = !this.getPageTableField().isVisible() ? 1.0 : 0.0;
            this.getPageDetailFormField().setGridDataHints(gridData);
            this.getRootGroupBox().rebuildFieldGrid();
        }
    }

    private TableRowForm createAutoDetailForm() throws ProcessingException {
        ITable table = null;
        IPage parentPage = this.m_page.getParentPage();
        if (parentPage instanceof IPageWithTable) {
            table = ((IPageWithTable)parentPage).getTable();
        }
        if (table != null) {
            ITableRow row;
            if (table.getSelectedRow() == null && (row = MobileDesktopUtility.getTableRowFor(this.m_page.getParentPage(), this.m_page)) != null) {
                row.getTable().selectRow(row);
            }
            if (table.getSelectedRow() != null) {
                return new TableRowForm(table.getSelectedRow());
            }
        }
        return null;
    }

    @Override
    protected IActionFetcher createHeaderActionFetcher() {
        return new PageFormHeaderActionFetcher(this);
    }

    @Override
    protected IActionFetcher createFooterActionFetcher() {
        return new PageFormFooterActionFetcher(this);
    }

    private void initMainButtons() throws ProcessingException {
        LinkedList<IButton> buttonList = new LinkedList<IButton>();
        if (this.m_page.getDetailForm() != null) {
            buttonList.addAll(this.m_page.getDetailForm().getRootGroupBox().getCustomProcessButtons());
        }
        this.m_mainboxButtons = buttonList;
    }

    private void initFields() throws ProcessingException {
        if (this.m_pageFormConfig.isDetailFormVisible()) {
            this.getPageDetailFormField().setInnerForm(this.m_page.getDetailForm());
        }
        boolean hasDetailForm = this.getPageDetailFormField().getInnerForm() != null;
        this.getPageDetailFormField().setVisible(hasDetailForm);
        Object pageTable = MobileDesktopUtility.getPageTable(this.m_page);
        if (!this.m_pageFormConfig.isTablePageAllowed() && this.m_page instanceof IPageWithTable) {
            pageTable = new PlaceholderTable(this.m_page);
            pageTable.initTable();
            pageTable.addRowByArray((Object)new Object[]{TEXTS.get((String)"MobilePlaceholderTableTitle")});
            pageTable.setDefaultIconId(this.m_page.getCell().getIconId());
        }
        AbstractMobileTable.setAutoCreateRowForm(pageTable, false);
        this.getPageTableField().setTable((ITable)pageTable, true);
        this.getPageTableField().setTableStatusVisible(this.m_pageFormConfig.isTableStatusVisible());
        this.addTableListener();
        this.updateTableFieldVisibility();
        if (this.getPageTableGroupBox().isVisible() && !hasDetailForm) {
            this.getPageTableGroupBox().setBorderVisible(false);
            DeviceTransformationConfig config = DeviceTransformationUtility.getDeviceTransformationConfig();
            if (config != null) {
                config.excludeFieldTransformation((IFormField)this.getRootGroupBox(), MobileDeviceTransformation.MAKE_MAINBOX_SCROLLABLE);
            }
        }
    }

    protected void execDisposeForm() throws ProcessingException {
        this.removeTableListener();
        for (AutoLeafPageWithNodes autoLeafPage : this.m_autoLeafPageMap.values()) {
            this.disposeAutoLeafPage(autoLeafPage);
        }
    }

    private void updateDrillDownStyle() {
        ITable table = this.getPageTableField().getTable();
        if (table != null) {
            this.setTableRowDrillDownStyle(table, table.getRows());
        }
    }

    private void setTableRowDrillDownStyle(ITable table, List<ITableRow> rows) {
        if (rows == null) {
            return;
        }
        DrillDownStyleMap drillDownMap = MobileTable.getDrillDownStyleMap(table);
        if (drillDownMap == null) {
            drillDownMap = new DrillDownStyleMap();
            AbstractMobileTable.setDrillDownStyleMap(table, drillDownMap);
        }
        for (ITableRow row : rows) {
            if (!this.isDrillDownRow(row)) {
                drillDownMap.put(row, "none");
                continue;
            }
            drillDownMap.put(row, "icon");
        }
    }

    private boolean isDrillDownRow(ITableRow tableRow) {
        if (!this.m_pageFormConfig.isKeepSelection()) {
            return true;
        }
        return PageFormManager.isDrillDownPage(MobileDesktopUtility.getPageFor(this.getPage(), tableRow));
    }

    public void formAddedNotify() throws ProcessingException {
        LOG.debug(this + " added");
        this.clearTableSelectionIfNecessary();
        this.updateDrillDownStyle();
        if (!this.m_page.isSelectedNode()) {
            this.selectChildPageTableRowIfNecessary();
            this.m_page.getOutline().getUIFacade().setNodeSelectedAndExpandedFromUI((ITreeNode)this.m_page);
        }
        this.addTableSelectionListener();
        this.processSelectedTableRow();
    }

    @Override
    public void pageSelectedNotify() throws ProcessingException {
        if (this.m_rowSelectionRequired) {
            this.selectFirstChildPageTableRowIfNecessary(this.getPageTableField().getTable());
            this.m_rowSelectionRequired = false;
        }
    }

    private void clearTableSelectionIfNecessary() {
        if (this.getPageTableField().getTable() == null) {
            return;
        }
        ITableRow selectedRow = this.getPageTableField().getTable().getSelectedRow();
        if (selectedRow != null && this.isDrillDownRow(selectedRow)) {
            LOG.debug("Clearing row for table " + this.getPageTableField().getTable());
            this.getPageTableField().getTable().selectRow(null);
        }
    }

    public void formRemovedNotify() throws ProcessingException {
        this.removeTableSelectionListener();
    }

    private void addTableListener() {
        if (this.m_pageTableListener != null) {
            return;
        }
        this.m_pageTableListener = new P_PageTableListener();
        ITable table = this.getPageTableField().getTable();
        if (table != null) {
            table.addTableListener((TableListener)this.m_pageTableListener);
        }
    }

    private void removeTableListener() {
        if (this.m_pageTableListener == null) {
            return;
        }
        ITable table = this.getPageTableField().getTable();
        if (table != null) {
            table.removeTableListener((TableListener)this.m_pageTableListener);
        }
        this.m_pageTableListener = null;
    }

    private void addTableSelectionListener() {
        if (this.m_pageTableSelectionListener != null) {
            return;
        }
        this.m_pageTableSelectionListener = new P_PageTableSelectionListener();
        ITable table = this.getPageTableField().getTable();
        if (table != null) {
            table.addTableListener((TableListener)this.m_pageTableSelectionListener);
        }
    }

    private void removeTableSelectionListener() {
        if (this.m_pageTableSelectionListener == null) {
            return;
        }
        ITable table = this.getPageTableField().getTable();
        if (table != null) {
            table.removeTableListener((TableListener)this.m_pageTableSelectionListener);
        }
        this.m_pageTableSelectionListener = null;
    }

    private void processSelectedTableRow() throws ProcessingException {
        if (!this.m_pageFormConfig.isKeepSelection() && !this.m_pageFormConfig.isAutoSelectFirstChildPage()) {
            return;
        }
        ITable pageTable = MobileDesktopUtility.getPageTable(this.getPage());
        if (pageTable == null) {
            return;
        }
        ITableRow selectedRow = pageTable.getSelectedRow();
        if (!PageFormManager.isDrillDownPage(MobileDesktopUtility.getPageFor(this.getPage(), selectedRow))) {
            if (selectedRow != null) {
                if (this.m_pageFormConfig.isKeepSelection()) {
                    this.handleTableRowSelected(pageTable, selectedRow);
                }
            } else if (this.m_pageFormConfig.isAutoSelectFirstChildPage()) {
                this.selectFirstChildPageTableRowIfNecessary(pageTable);
            }
        }
    }

    @Override
    public boolean isDirty() {
        ITable pageTable;
        if (this.m_pageFormConfig.isDetailFormVisible() && this.m_page.getDetailForm() != this.getPageDetailFormField().getInnerForm()) {
            return true;
        }
        return this.m_pageFormConfig.isTablePageAllowed() && this.m_page instanceof IPageWithTable && (pageTable = ((IPageWithTable)this.m_page).getTable()) != this.getPageTableField().getTable();
    }

    protected void execUpdatePageTableStatus() {
        if (!this.m_pageFormConfig.isTableStatusVisible()) {
            return;
        }
        if (this.getPage() instanceof IPageWithTable) {
            IPageWithTable tablePage = (IPageWithTable)this.getPage();
            IProcessingStatus populateStatus = tablePage.getPagePopulateStatus();
            this.getPageTableField().setTablePopulateStatus(populateStatus);
            if (tablePage.isSearchActive() && tablePage.getSearchFilter() != null && !tablePage.getSearchFilter().isCompleted() && tablePage.isSearchRequired()) {
                this.getPageTableField().setTableSelectionStatus(null);
            } else if (populateStatus != null && populateStatus.getSeverity() == 2) {
                this.getPageTableField().setTableSelectionStatus(null);
            } else {
                this.getPageTableField().setTableSelectionStatus((IProcessingStatus)new ProcessingStatus(this.getPageTableField().createDefaultTableStatus(), 1));
            }
        } else {
            this.getPageTableField().setTablePopulateStatus(null);
            this.getPageTableField().setTableSelectionStatus(null);
        }
    }

    protected String createDefaultPageTableStatus(ITable table) {
        StringBuilder statusText = new StringBuilder();
        if (table != null) {
            int nTotal = table.getFilteredRowCount();
            if (nTotal == 1) {
                statusText.append(ScoutTexts.get((String)"OneRow", (String[])new String[0]));
            } else {
                statusText.append(ScoutTexts.get((String)"XRows", (String[])new String[]{NumberUtility.format((Number)nTotal)}));
            }
        }
        if (statusText.length() == 0) {
            return null;
        }
        return statusText.toString();
    }

    public Object computeExclusiveKey() throws ProcessingException {
        return this.m_page;
    }

    @Override
    public void start() throws ProcessingException {
        this.startInternalExclusive((IFormHandler)new FormHandler());
    }

    private void handleTableRowSelected(ITable table, ITableRow tableRow) throws ProcessingException {
        LOG.debug("Table row selected: " + tableRow);
        if (!this.m_page.isLeaf() && !this.m_page.isChildrenLoaded()) {
            if (tableRow == null) {
                this.m_rowSelectionRequired = true;
            }
            return;
        }
        if (tableRow == null) {
            this.selectFirstChildPageTableRowIfNecessary(table);
            return;
        }
        Object rowPage = null;
        rowPage = table instanceof PlaceholderTable ? ((PlaceholderTable)table).getActualPage() : (this.m_autoLeafPageMap.containsKey(tableRow) ? (IPage)this.m_autoLeafPageMap.get(tableRow) : MobileDesktopUtility.getPageFor(this.m_page, tableRow));
        if (rowPage == null) {
            AutoLeafPageWithNodes autoPage = new AutoLeafPageWithNodes(tableRow, this.m_page);
            AutoOutline autoOutline = new AutoOutline((IPage)autoPage);
            autoOutline.selectNode((ITreeNode)autoPage);
            this.m_autoLeafPageMap.put(tableRow, autoPage);
            rowPage = autoPage;
        }
        this.m_pageFormManager.pageSelectedNotify(this, (IPage)rowPage);
    }

    private void handleTableRowsDeleted(ITable table, Collection<ITableRow> tableRows) throws ProcessingException {
        if (tableRows == null) {
            return;
        }
        for (ITableRow tableRow : tableRows) {
            AutoLeafPageWithNodes autoPage = this.m_autoLeafPageMap.remove(tableRow);
            if (autoPage == null) continue;
            this.disposeAutoLeafPage(autoPage);
            this.m_pageFormManager.pageRemovedNotify(this, (IPage)autoPage);
        }
    }

    private void disposeAutoLeafPage(AutoLeafPageWithNodes page) {
        if (page == null || page.getOutline() == null) {
            return;
        }
        IOutline outline = page.getOutline();
        outline.removeAllChildNodes(outline.getRootNode());
        outline.disposeTree();
    }

    private void handleTableRowsInserted(ITable table, List<ITableRow> tableRows) throws ProcessingException {
        this.setTableRowDrillDownStyle(table, tableRows);
    }

    protected void selectFirstChildPageTableRowIfNecessary(ITable pageDetailTable) throws ProcessingException {
        if (!this.m_pageFormConfig.isAutoSelectFirstChildPage() || pageDetailTable == null || pageDetailTable.getRowCount() == 0) {
            return;
        }
        IPage pageToSelect = MobileDesktopUtility.getPageFor(this.m_page, pageDetailTable.getRow(0));
        if (pageDetailTable.getSelectedRow() == null && !PageFormManager.isDrillDownPage(pageToSelect)) {
            pageDetailTable.selectFirstRow();
        }
    }

    private void selectChildPageTableRowIfNecessary() {
        ITableRow row;
        if (!this.m_pageFormConfig.isKeepSelection()) {
            return;
        }
        IPage selectedPage = (IPage)this.m_page.getOutline().getSelectedNode();
        if (selectedPage != null && selectedPage.getParentPage() == this.m_page && (row = MobileDesktopUtility.getTableRowFor(this.m_page, selectedPage)) != null && !this.isDrillDownRow(row)) {
            row.getTable().selectRow(row);
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + " with page " + this.m_page;
    }

    @Order(value=10.0)
    public class FormHandler
    extends AbstractFormHandler {
        protected boolean getConfiguredOpenExclusive() {
            return true;
        }
    }

    @Order(value=10.0)
    public class MainBox
    extends AbstractGroupBox {
        protected boolean getConfiguredBorderVisible() {
            return false;
        }

        protected int getConfiguredGridColumnCount() {
            return 1;
        }

        protected void injectFieldsInternal(List<IFormField> fieldList) {
            if (PageForm.this.m_mainboxButtons != null) {
                fieldList.addAll(PageForm.this.m_mainboxButtons);
            }
            super.injectFieldsInternal(fieldList);
        }

        @Order(value=5.0)
        public class PageDetailFormField
        extends AbstractWrappedFormField<IForm> {
            protected int getConfiguredGridW() {
                return 2;
            }

            protected int getConfiguredGridH() {
                return 2;
            }

            protected double getConfiguredGridWeightY() {
                return 0.0;
            }
        }

        @Order(value=10.0)
        public class PageTableGroupBox
        extends AbstractGroupBox {

            @Order(value=10.0)
            public class PageTableField
            extends AbstractMobileTableField<ITable> {
                protected boolean getConfiguredLabelVisible() {
                    return false;
                }

                protected boolean getConfiguredTableStatusVisible() {
                    return false;
                }

                protected boolean getConfiguredGridUseUiHeight() {
                    return PageForm.this.m_pageFormConfig.isDetailFormVisible() && PageForm.this.m_page.getDetailForm() != null;
                }

                protected void execUpdateTableStatus() {
                    PageForm.this.execUpdatePageTableStatus();
                }

                public String createDefaultTableStatus() {
                    return PageForm.this.createDefaultPageTableStatus(this.getTable());
                }
            }
        }
    }

    private class P_PageTableListener
    extends TableAdapter {
        private P_PageTableListener() {
        }

        public void tableChanged(TableEvent event) {
            try {
                switch (event.getType()) {
                    case 102: 
                    case 105: {
                        this.handleTableRowDeleted(event);
                        break;
                    }
                    case 100: {
                        this.handleTableRowsInserted(event);
                    }
                }
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }

        private void handleTableRowDeleted(TableEvent event) throws ProcessingException {
            PageForm.this.handleTableRowsDeleted(event.getTable(), event.getRows());
            PageForm.this.updateTableFieldVisibility();
        }

        private void handleTableRowsInserted(TableEvent event) throws ProcessingException {
            PageForm.this.handleTableRowsInserted(event.getTable(), event.getRows());
            PageForm.this.updateTableFieldVisibility();
        }
    }

    private class P_PageTableSelectionListener
    extends TableAdapter {
        private P_PageTableSelectionListener() {
        }

        public void tableChanged(TableEvent event) {
            try {
                switch (event.getType()) {
                    case 103: {
                        this.handleTableRowSelected(event);
                    }
                }
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }

        private void handleTableRowSelected(TableEvent event) throws ProcessingException {
            if (event.isConsumed()) {
                return;
            }
            ITableRow tableRow = event.getFirstRow();
            PageForm.this.handleTableRowSelected(event.getTable(), tableRow);
        }
    }

    private class PlaceholderTable
    extends AbstractTable {
        private IPage m_actualPage;

        public PlaceholderTable(IPage page) {
            this.m_actualPage = page;
        }

        public IPage getActualPage() {
            return this.m_actualPage;
        }

        protected boolean getConfiguredSortEnabled() {
            return false;
        }

        protected boolean getConfiguredAutoResizeColumns() {
            return true;
        }

        protected boolean getConfiguredMultiSelect() {
            return false;
        }

        public LabelColumn getLabelColumn() {
            return (LabelColumn)this.getColumnSet().getColumnByClass(LabelColumn.class);
        }

        @Order(value=1.0)
        public class LabelColumn
        extends AbstractStringColumn {
            protected String getConfiguredHeaderText() {
                return ScoutTexts.get((String)"Folders", (String[])new String[0]);
            }
        }
    }
}

