/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.ui.form.outline;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.mobile.ui.desktop.ActiveOutlineObserver;
import org.eclipse.scout.rt.client.mobile.ui.desktop.MobileDesktopUtility;
import org.eclipse.scout.rt.client.mobile.ui.form.outline.AutoLeafPageWithNodes;
import org.eclipse.scout.rt.client.mobile.ui.form.outline.IMainPageForm;
import org.eclipse.scout.rt.client.mobile.ui.form.outline.IPageForm;
import org.eclipse.scout.rt.client.mobile.ui.form.outline.MainPageForm;
import org.eclipse.scout.rt.client.mobile.ui.form.outline.PageForm;
import org.eclipse.scout.rt.client.mobile.ui.form.outline.PageFormConfig;
import org.eclipse.scout.rt.client.mobile.ui.form.outline.PageFormMap;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeAdapter;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeListener;
import org.eclipse.scout.rt.client.ui.desktop.DesktopEvent;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListener;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutlineTableForm;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutlineTreeForm;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithNodes;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public class PageFormManager {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(PageFormManager.class);
    private PageFormMap m_pageFormMap;
    private ActiveOutlineObserver m_activeOutlineObserver;
    private P_OutlineTreeListener m_outlineTreeListener;
    private P_DesktopListener m_desktopListener;
    private Map<IPage, String> m_selectedPageSlotMap;
    private String m_leftPageSlotViewId;
    private String m_middlePageSlotViewId;
    private IDesktop m_desktop;
    private List<IForm> m_blockedForms;
    private boolean m_pageSelectionRunning;

    public PageFormManager(String ... pageSlotViewIds) {
        this((IDesktop)null, pageSlotViewIds);
    }

    public PageFormManager(IDesktop desktop, String ... pageSlotViewIds) {
        if (desktop == null) {
            desktop = ClientSyncJob.getCurrentSession().getDesktop();
        }
        this.m_desktop = desktop;
        if (this.m_desktop == null) {
            throw new IllegalArgumentException("No desktop found. Cannot create OutlineFormsMediator.");
        }
        this.initPageSlots(pageSlotViewIds);
        this.m_pageFormMap = new PageFormMap();
        this.m_blockedForms = new LinkedList<IForm>();
        this.m_activeOutlineObserver = new ActiveOutlineObserver(desktop);
        this.m_selectedPageSlotMap = new HashMap<IPage, String>();
        this.m_outlineTreeListener = new P_OutlineTreeListener();
        this.m_activeOutlineObserver.addOutlineUITreeListener((TreeListener)this.m_outlineTreeListener);
        this.m_desktopListener = new P_DesktopListener();
        desktop.addDesktopListener((DesktopListener)this.m_desktopListener);
    }

    private void initPageSlots(String ... pageSlotViewIds) {
        if (pageSlotViewIds == null || pageSlotViewIds.length == 0 || !StringUtility.hasText((String)pageSlotViewIds[0])) {
            throw new IllegalArgumentException("At least one pageSlotViewId needs to be specified.");
        }
        this.m_leftPageSlotViewId = pageSlotViewIds[0];
        if (pageSlotViewIds.length > 1) {
            this.m_middlePageSlotViewId = pageSlotViewIds[1];
        }
    }

    public String getLeftPageSlotViewId() {
        return this.m_leftPageSlotViewId;
    }

    public String getMiddlePageSlotViewId() {
        return this.m_middlePageSlotViewId;
    }

    public boolean hasOnlyOnePageSlot() {
        return this.m_middlePageSlotViewId == null;
    }

    public boolean isPageSelectionRunning() {
        return this.m_pageSelectionRunning;
    }

    protected void setPageSelectionRunning(boolean pageSelectionRunning) {
        this.m_pageSelectionRunning = pageSelectionRunning;
    }

    public static boolean isDrillDownPage(IPage page) {
        return page instanceof IPageWithTable && page.getParentNode() instanceof IPageWithNodes;
    }

    private void destroy() {
        if (this.m_desktopListener != null) {
            this.getDesktop().removeDesktopListener((DesktopListener)this.m_desktopListener);
            this.m_desktopListener = null;
        }
        if (this.m_outlineTreeListener != null) {
            this.m_activeOutlineObserver.removeOutlineUITreeListener((TreeListener)this.m_outlineTreeListener);
            this.m_outlineTreeListener = null;
        }
        this.m_pageFormMap.clear();
    }

    private void hidePageForms() {
        for (IPageForm pageForm : this.getDesktop().findForms(IPageForm.class)) {
            this.getDesktop().removeForm((IForm)pageForm);
        }
    }

    private void hidePage(IPage page) throws ProcessingException {
        if (page == null) {
            return;
        }
        LOG.debug("Hiding page: " + page);
        IPageForm pageForm = this.m_pageFormMap.get(page);
        if (pageForm != null) {
            this.getDesktop().removeForm((IForm)pageForm);
        }
    }

    private IPageForm showPage(IPage page) throws ProcessingException {
        IPageForm pageForm = this.getPageForm(page, true);
        if (pageForm != null) {
            return pageForm;
        }
        LOG.debug("Showing page: " + page);
        String displayViewId = this.getLeftPageSlotViewId();
        if (!this.hasOnlyOnePageSlot()) {
            displayViewId = this.computePageFormSlot(page);
        }
        return this.showPage(page, displayViewId);
    }

    public IPageForm getPageForm(IPage page, boolean onlyShowing) {
        return this.m_pageFormMap.get(page, onlyShowing);
    }

    public String computePageFormSlot(IPage page) {
        if (page == null) {
            return null;
        }
        if (page instanceof AutoLeafPageWithNodes) {
            return this.getMiddlePageSlotViewId();
        }
        if (page.getParentNode() == null) {
            return this.getLeftPageSlotViewId();
        }
        if (PageFormManager.isDrillDownPage(page)) {
            return this.getLeftPageSlotViewId();
        }
        String currentViewId = this.m_selectedPageSlotMap.get(page);
        if (this.getMiddlePageSlotViewId().equals(currentViewId) && page.getParentPage() instanceof IPageWithTable) {
            return this.getLeftPageSlotViewId();
        }
        return this.getMiddlePageSlotViewId();
    }

    private IPageForm showPage(IPage page, String viewId) throws ProcessingException {
        this.updateLeftPageIfNecessary(page, viewId);
        IPageForm pageForm = this.m_pageFormMap.get(viewId, page);
        if (pageForm != null && pageForm.isDirty()) {
            pageForm.doClose();
            this.m_pageFormMap.remove(pageForm);
            pageForm = null;
        }
        if (pageForm == null) {
            pageForm = this.getLeftPageSlotViewId().equals(viewId) ? this.createMainPageForm(page) : this.createPageForm(page);
            pageForm.setAutoAddRemoveOnDesktop(false);
            pageForm.setDisplayViewId(viewId);
            pageForm.start();
            this.m_pageFormMap.put(pageForm);
        }
        if (!pageForm.isShowing()) {
            this.getDesktop().addForm((IForm)pageForm);
        }
        return pageForm;
    }

    private void updateLeftPageIfNecessary(IPage page, String viewId) throws ProcessingException {
        IPageForm parentPageForm;
        if (this.getMiddlePageSlotViewId() == null) {
            return;
        }
        if (this.getMiddlePageSlotViewId().equals(viewId) && page.getParentPage() != null && !(page instanceof AutoLeafPageWithNodes) && ((parentPageForm = this.m_pageFormMap.get(page.getParentPage(), true)) == null || this.getMiddlePageSlotViewId().equals(parentPageForm.getDisplayViewId()))) {
            this.showPage(page.getParentPage(), this.getLeftPageSlotViewId());
        }
    }

    protected IMainPageForm createMainPageForm(IPage page) throws ProcessingException {
        PageFormConfig config = this.createMainPageFormConfig(page);
        return new MainPageForm(page, this, config);
    }

    protected IPageForm createPageForm(IPage page) throws ProcessingException {
        PageFormConfig config = this.createPageFormConfig(page);
        return new PageForm(page, this, config);
    }

    protected PageFormConfig createMainPageFormConfig(IPage page) {
        PageFormConfig config = new PageFormConfig();
        config.setTablePageAllowed(true);
        config.setTableStatusVisible(true);
        if (this.hasOnlyOnePageSlot()) {
            config.setDetailFormVisible(true);
        } else {
            config.setKeepSelection(true);
            config.setAutoSelectFirstChildPage(true);
        }
        return config;
    }

    protected PageFormConfig createPageFormConfig(IPage page) {
        PageFormConfig config = new PageFormConfig();
        config.setDetailFormVisible(true);
        return config;
    }

    private IDesktop getDesktop() {
        return this.m_desktop;
    }

    public void pageSelectedNotify(PageForm pageForm, IPage selectedPage) throws ProcessingException {
        if (selectedPage == null) {
            return;
        }
        if (selectedPage instanceof AutoLeafPageWithNodes) {
            this.showPage(selectedPage);
        } else {
            if (selectedPage.isSelectedNode()) {
                selectedPage.getOutline().selectNode(null);
            }
            this.m_selectedPageSlotMap.put(selectedPage, pageForm.getDisplayViewId());
            try {
                this.selectAndExpandPage(selectedPage);
            }
            finally {
                this.m_selectedPageSlotMap.remove(selectedPage);
            }
        }
    }

    private void selectAndExpandPage(IPage page) throws ProcessingException {
        try {
            ITreeNode node;
            this.setPageSelectionRunning(true);
            IOutline outline = page.getOutline();
            if (this.getDesktop().getOutline() != page.getOutline()) {
                this.getDesktop().setOutline(page.getOutline());
            }
            if ((node = outline.resolveVirtualNode((ITreeNode)page)) != null) {
                if (node.isChildrenDirty() || node.isChildrenVolatile()) {
                    node.loadChildren();
                }
                outline.selectNode(node, false);
                outline.setNodeExpanded(node, true);
                if (!outline.isScrollToSelection()) {
                    outline.scrollToSelection();
                }
            }
        }
        finally {
            this.setPageSelectionRunning(false);
            this.showBlockedForms();
        }
    }

    private void handleTreeNodeSelected(ITreeNode deselctedNode, ITreeNode selectedNode) throws ProcessingException {
        LOG.debug("Tree node selected: " + selectedNode);
        if (selectedNode == null) {
            this.hidePageForms();
            return;
        }
        IPageForm pageForm = this.showPage((IPage)selectedNode);
        pageForm.pageSelectedNotify();
    }

    private void handleTreeNodesDeleted(Collection<ITreeNode> deletedNodes) throws ProcessingException {
        if (deletedNodes == null) {
            return;
        }
        for (ITreeNode node : deletedNodes) {
            this.handleTreeNodesDeleted(node.getChildNodes());
            if (!(node instanceof IPage) || node.getTree() != null) continue;
            IPage page = (IPage)node;
            this.handlePageRemoved(page);
        }
    }

    public void pageRemovedNotify(PageForm pageForm, IPage page) throws ProcessingException {
        this.handlePageRemoved(page);
    }

    private void handlePageRemoved(IPage page) throws ProcessingException {
        IPage parentPage;
        if (page == null) {
            return;
        }
        try {
            IPageForm pageForm = this.m_pageFormMap.get(page);
            if (pageForm != null) {
                pageForm.doClose();
                this.hidePage(page);
            }
        }
        finally {
            this.m_pageFormMap.remove(page);
        }
        if (page instanceof AutoLeafPageWithNodes && (parentPage = ((AutoLeafPageWithNodes)page).getActualParentPage()).isSelectedNode()) {
            this.showPage(parentPage);
        }
    }

    public boolean acceptForm(IForm form) {
        if (form instanceof IOutlineTreeForm || form instanceof IOutlineTableForm) {
            return false;
        }
        if (form == this.getDesktop().getPageDetailForm()) {
            return false;
        }
        if (this.isPageSelectionRunning() && !(form instanceof PageForm)) {
            if (!this.m_blockedForms.contains(form)) {
                this.m_blockedForms.add(form);
            }
            return false;
        }
        return true;
    }

    private void showBlockedForms() {
        IForm[] iFormArray = this.m_blockedForms.toArray(new IForm[this.m_blockedForms.size()]);
        int n = iFormArray.length;
        int n2 = 0;
        while (n2 < n) {
            IForm form = iFormArray[n2];
            this.m_blockedForms.remove(form);
            MobileDesktopUtility.addFormToDesktop(form);
            ++n2;
        }
    }

    private void handlePageFormAdded(PageForm pageForm) throws ProcessingException {
        if (pageForm == null) {
            return;
        }
        String displayViewId = pageForm.getDisplayViewId();
        MobileDesktopUtility.removeFormsFromDesktop(IPageForm.class, displayViewId, pageForm);
        if (this.getLeftPageSlotViewId().equals(displayViewId)) {
            MobileDesktopUtility.removeFormsFromDesktop(IPageForm.class, this.getMiddlePageSlotViewId(), pageForm);
        }
        pageForm.formAddedNotify();
    }

    private void handlePageFormRemoved(PageForm pageForm) throws ProcessingException {
        if (pageForm == null) {
            return;
        }
        pageForm.formRemovedNotify();
    }

    private class P_DesktopListener
    implements DesktopListener {
        private P_DesktopListener() {
        }

        public void desktopChanged(DesktopEvent event) {
            try {
                switch (event.getType()) {
                    case 600: {
                        this.handleFormAdded(event);
                        break;
                    }
                    case 610: {
                        this.handleFormRemoved(event);
                        break;
                    }
                    case 100: {
                        PageFormManager.this.destroy();
                    }
                }
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }

        private void handleFormAdded(DesktopEvent event) throws ProcessingException {
            IForm form = event.getForm();
            if (form instanceof PageForm) {
                PageFormManager.this.handlePageFormAdded((PageForm)form);
            }
        }

        private void handleFormRemoved(DesktopEvent event) throws ProcessingException {
            IForm form = event.getForm();
            if (form instanceof PageForm) {
                PageFormManager.this.handlePageFormRemoved((PageForm)form);
            }
        }
    }

    private class P_OutlineTreeListener
    extends TreeAdapter {
        private P_OutlineTreeListener() {
        }

        public void treeChanged(TreeEvent event) {
            try {
                switch (event.getType()) {
                    case 40: {
                        PageFormManager.this.handleTreeNodeSelected(event.getDeselectedNode(), event.getNewSelectedNode());
                        break;
                    }
                    case 30: {
                        PageFormManager.this.handleTreeNodesDeleted(event.getNodes());
                    }
                }
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }
    }
}

