/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.bookmark.internal;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import java.util.zip.CRC32;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.ProcessingStatus;
import org.eclipse.scout.commons.exception.VetoException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.services.common.bookmark.DefaultBookmarkAdapter;
import org.eclipse.scout.rt.client.services.common.bookmark.IBookmarkAdapter;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.basic.table.ColumnSet;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.customizer.ITableCustomizer;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithNodes;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.TEXTS;
import org.eclipse.scout.rt.shared.services.common.bookmark.AbstractPageState;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;
import org.eclipse.scout.rt.shared.services.common.bookmark.NodePageState;
import org.eclipse.scout.rt.shared.services.common.bookmark.TableColumnState;
import org.eclipse.scout.rt.shared.services.common.bookmark.TablePageState;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;

public final class BookmarkUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BookmarkUtility.class);

    private BookmarkUtility() {
    }

    public static IOutline resolveOutline(List<? extends IOutline> outlines, String className) {
        if (className == null) {
            return null;
        }
        for (IOutline iOutline : outlines) {
            if (!iOutline.getClass().getName().equals(className)) continue;
            return iOutline;
        }
        String string = className.replaceAll("^.*\\.", "");
        for (IOutline iOutline : outlines) {
            if (!iOutline.getClass().getSimpleName().equalsIgnoreCase(string)) continue;
            return iOutline;
        }
        return null;
    }

    public static IColumn resolveColumn(List<? extends IColumn> columns, String identifier) {
        if (identifier == null) {
            return null;
        }
        for (IColumn iColumn : columns) {
            if (!identifier.equals(iColumn.getClass().getName())) continue;
            return iColumn;
        }
        for (IColumn iColumn : columns) {
            if (!identifier.equals(iColumn.getColumnId())) continue;
            return iColumn;
        }
        String string = identifier.replaceAll("^.*\\.", "");
        for (IColumn iColumn : columns) {
            if (!string.equalsIgnoreCase(iColumn.getClass().getSimpleName())) continue;
            return iColumn;
        }
        return null;
    }

    public static IPage resolvePage(List<? extends IPage> pages, String className, String bookmarkIdentifier) {
        if (className == null) {
            return null;
        }
        TreeMap<CompositeObject, IPage> sortMap = new TreeMap<CompositeObject, IPage>();
        String simpleClassName = className.replaceAll("^.*\\.", "");
        int index = 0;
        for (IPage iPage : pages) {
            int classNameScore = 0;
            int userPreferenceContextScore = 0;
            if (iPage.getClass().getName().equals(className)) {
                classNameScore = -2;
            } else if (iPage.getClass().getSimpleName().equalsIgnoreCase(simpleClassName)) {
                classNameScore = -1;
            }
            IBookmarkAdapter bookmarkAdapter = BookmarkUtility.getBookmarkAdapter(iPage);
            if (bookmarkIdentifier == null || bookmarkIdentifier.equalsIgnoreCase(bookmarkAdapter.getIdentifier())) {
                userPreferenceContextScore = -1;
            }
            if (classNameScore != 0 && userPreferenceContextScore != 0) {
                sortMap.put(new CompositeObject(new Object[]{classNameScore, userPreferenceContextScore, index}), iPage);
            }
            ++index;
        }
        if (sortMap.isEmpty()) {
            return null;
        }
        CompositeObject compositeObject = (CompositeObject)sortMap.firstKey();
        IPage bestMatchingPage = (IPage)sortMap.remove(compositeObject);
        if (!sortMap.isEmpty()) {
            CompositeObject nextKey = (CompositeObject)sortMap.firstKey();
            if (CompareUtility.equals((Object)compositeObject.getComponent(0), (Object)nextKey.getComponent(0)) && CompareUtility.equals((Object)compositeObject.getComponent(1), (Object)nextKey.getComponent(1))) {
                LOG.warn("More than one pages found for page class [" + className + "] and bookmark Identifier [" + bookmarkIdentifier + "]");
            }
        }
        return bestMatchingPage;
    }

    public static List<Object> makeSerializableKeys(List<?> a, boolean useLegacySupport) {
        return (List)BookmarkUtility.makeSerializableKey(a, useLegacySupport);
    }

    public static Object makeSerializableKey(Object o, boolean useLegacySupport) {
        if (o == null) {
            return o;
        }
        if (o instanceof Number) {
            return o;
        }
        if (o instanceof String) {
            return o;
        }
        if (o instanceof Boolean) {
            return o;
        }
        if (o instanceof Date) {
            return o;
        }
        if (o instanceof Collection) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object oi : (Collection)o) {
                result.add(BookmarkUtility.makeSerializableKey(oi, useLegacySupport));
            }
            return result;
        }
        if (o.getClass().isArray()) {
            ArrayList<Integer> dimList = new ArrayList<Integer>();
            Class<?> xc = o.getClass();
            Object xo = o;
            while (xc.isArray()) {
                int len = xo != null ? Array.getLength(xo) : 0;
                dimList.add(len);
                xc = xc.getComponentType();
                if (xo == null || len <= 0) continue;
                xo = Array.get(xo, 0);
            }
            int[] dim = new int[dimList.size()];
            int i = 0;
            while (i < dim.length) {
                dim[i] = (Integer)dimList.get(i);
                ++i;
            }
            Object b = Array.newInstance(BookmarkUtility.makeSerializableClass(xc, useLegacySupport), dim);
            int i2 = 0;
            while (i2 < dim[0]) {
                Array.set(b, i2, BookmarkUtility.makeSerializableKey(Array.get(o, i2), useLegacySupport));
                ++i2;
            }
            return b;
        }
        if (!useLegacySupport && o instanceof Serializable) {
            return o;
        }
        if (!useLegacySupport && !(o instanceof String)) {
            if (ConfigurationUtility.isMethodOverwrite(Object.class, (String)"toString", (Class[])new Class[0], o.getClass())) {
                LOG.warn("Bookmark key is not serializable. Falling back to toString(). Note: keys may not be stable [class=" + o.getClass() + ", string representation: " + o.toString() + "]");
            } else {
                LOG.error("Bookmark key is not serializable. Falling back to toString() which is not overriden by the given class [" + o.getClass() + "]");
            }
        }
        return o.toString();
    }

    public static Class makeSerializableClass(Class c, boolean useLegacySupport) {
        if (c == null) {
            throw new IllegalArgumentException("class must not be null");
        }
        if (c.isArray()) {
            throw new IllegalArgumentException("class must not be an array class");
        }
        if (c.isPrimitive()) {
            return c;
        }
        if (Number.class.isAssignableFrom(c)) {
            return c;
        }
        if (String.class.isAssignableFrom(c)) {
            return c;
        }
        if (Boolean.class.isAssignableFrom(c)) {
            return c;
        }
        if (Date.class.isAssignableFrom(c)) {
            return c;
        }
        if (Object.class == c) {
            return c;
        }
        if (!useLegacySupport && Serializable.class.isAssignableFrom(c)) {
            return c;
        }
        return String.class;
    }

    public static void activateBookmark(IDesktop desktop, Bookmark bm, boolean forceReload) throws ProcessingException {
        if (bm.getOutlineClassName() == null) {
            return;
        }
        IOutline outline = BookmarkUtility.resolveOutline(desktop.getAvailableOutlines(), bm.getOutlineClassName());
        if (outline == null) {
            throw new ProcessingException("outline '" + bm.getOutlineClassName() + "' was not found");
        }
        if (!outline.isVisible() || !outline.isEnabled()) {
            throw new VetoException(TEXTS.get((String)"BookmarkActivationFailedOutlineNotAvailable", (String[])new String[]{outline.getTitle()}));
        }
        desktop.setOutline(outline);
        try {
            outline.setTreeChanging(true);
            IPage parentPage = outline.getRootPage();
            boolean pathFullyRestored = true;
            List path = bm.getPath();
            AbstractPageState parentPageState = (AbstractPageState)path.get(0);
            boolean resetViewAndWarnOnFail = bm.getId() != 0L;
            int i = 1;
            while (i < path.size()) {
                IPage childPage = null;
                AbstractPageState childState = (AbstractPageState)path.get(i);
                if (parentPageState instanceof TablePageState) {
                    TablePageState tablePageState = (TablePageState)parentPageState;
                    if (parentPage instanceof IPageWithTable) {
                        IPageWithTable tablePage = (IPageWithTable)parentPage;
                        childPage = BookmarkUtility.bmLoadTablePage(tablePage, tablePageState, false, resetViewAndWarnOnFail);
                    }
                } else if (parentPageState instanceof NodePageState) {
                    NodePageState nodePageState = (NodePageState)parentPageState;
                    if (parentPage instanceof IPageWithNodes) {
                        IPageWithNodes nodePage = (IPageWithNodes)parentPage;
                        childPage = BookmarkUtility.bmLoadNodePage(nodePage, nodePageState, childState, resetViewAndWarnOnFail);
                    }
                }
                if (childPage != null) {
                    parentPage = childPage;
                    parentPageState = childState;
                } else if (i < path.size()) {
                    pathFullyRestored = false;
                    break;
                }
                ++i;
            }
            if (pathFullyRestored) {
                if (parentPageState instanceof TablePageState && parentPage instanceof IPageWithTable) {
                    BookmarkUtility.bmLoadTablePage((IPageWithTable)parentPage, (TablePageState)parentPageState, true, resetViewAndWarnOnFail);
                } else if (parentPage instanceof IPageWithNodes) {
                    BookmarkUtility.bmLoadNodePage((IPageWithNodes)parentPage, (NodePageState)parentPageState, null, resetViewAndWarnOnFail);
                }
            }
            IPage p = parentPage;
            if (pathFullyRestored && parentPageState.isExpanded() != null) {
                p.setExpanded(parentPageState.isExpanded());
            } else if (!(p instanceof IPageWithTable)) {
                p.setExpanded(true);
            }
            p = p.getParentPage();
            while (p != null) {
                p.setExpanded(true);
                p = p.getParentPage();
            }
            outline.selectNode(parentPage, false);
        }
        finally {
            outline.setTreeChanging(false);
        }
    }

    public static List<TableColumnState> backupTableColumns(ITable table) {
        ArrayList<TableColumnState> allColumns = new ArrayList<TableColumnState>();
        ColumnSet columnSet = table.getColumnSet();
        for (IColumn<?> c : columnSet.getAllColumnsInUserOrder()) {
            TableColumnState colState = new TableColumnState();
            colState.setColumnClassName(c.getColumnId());
            colState.setDisplayable(Boolean.valueOf(c.isDisplayable()));
            colState.setVisible(Boolean.valueOf(c.isDisplayable() && c.isVisible()));
            colState.setWidth(c.getWidth());
            if (columnSet.isUserSortColumn(c) && c.isSortExplicit()) {
                int sortOrder = columnSet.getSortColumnIndex(c);
                if (sortOrder >= 0) {
                    colState.setSortOrder(sortOrder);
                    colState.setSortAscending(c.isSortAscending());
                } else {
                    colState.setSortOrder(-1);
                }
            }
            if (table.getColumnFilterManager() != null && c.isColumnFilterActive()) {
                colState.setColumnFilterData(table.getColumnFilterManager().getSerializedFilter(c));
            }
            allColumns.add(colState);
        }
        return allColumns;
    }

    public static void restoreTableColumns(ITable table, List<TableColumnState> oldColumns) throws ProcessingException {
        if (oldColumns != null && oldColumns.size() > 0 && table != null) {
            ColumnSet columnSet = table.getColumnSet();
            ArrayList<Object> visibleColumns = new ArrayList<Object>();
            for (TableColumnState colState : oldColumns) {
                Object col;
                if (colState.getVisible() != null && !colState.getVisible().booleanValue() || (col = BookmarkUtility.resolveColumn(columnSet.getDisplayableColumns(), colState.getClassName())) == null || !col.isDisplayable()) continue;
                if (colState.getWidth() > 0) {
                    col.setWidth(colState.getWidth());
                }
                visibleColumns.add(col);
            }
            List<IColumn<?>> existingVisibleCols = columnSet.getVisibleColumns();
            if (!existingVisibleCols.equals(visibleColumns)) {
                columnSet.setVisibleColumns(visibleColumns);
            }
            if (table.getColumnFilterManager() != null) {
                table.getColumnFilterManager().reset();
                for (TableColumnState colState : oldColumns) {
                    IColumn col;
                    if (colState.getColumnFilterData() == null || (col = BookmarkUtility.resolveColumn(columnSet.getColumns(), colState.getClassName())) == null) continue;
                    table.getColumnFilterManager().setSerializedFilter(colState.getColumnFilterData(), col);
                }
            }
            boolean userSortValid = true;
            TreeMap<Integer, IColumn> sortColMap = new TreeMap<Integer, IColumn>();
            HashMap<IColumn, Boolean> sortColAscMap = new HashMap<IColumn, Boolean>();
            for (TableColumnState colState : oldColumns) {
                IColumn col;
                if (colState.getSortOrder() < 0 || (col = BookmarkUtility.resolveColumn(columnSet.getColumns(), colState.getClassName())) == null) continue;
                sortColMap.put(colState.getSortOrder(), col);
                sortColAscMap.put(col, colState.isSortAscending());
                if (col.getSortIndex() != colState.getSortOrder()) {
                    userSortValid = false;
                }
                if (col.isSortAscending() == colState.isSortAscending()) continue;
                userSortValid = false;
            }
            HashSet existingExplicitUserSortCols = new HashSet();
            for (IColumn<?> c : columnSet.getUserSortColumns()) {
                if (!c.isSortExplicit()) continue;
                existingExplicitUserSortCols.add(c);
            }
            if (!sortColMap.values().containsAll(existingExplicitUserSortCols)) {
                userSortValid = false;
            }
            if (!userSortValid) {
                columnSet.clearSortColumns();
                for (IColumn<Object> col : sortColMap.values()) {
                    columnSet.addSortColumn(col, (Boolean)sortColAscMap.get(col));
                }
                table.sort();
            }
            ClientUIPreferences.getInstance().setAllTableColumnPreferences(table);
        }
    }

    public static IBookmarkAdapter getBookmarkAdapter(IPage page) {
        IBookmarkAdapter bookmarkAdapter = page.getAdapter(IBookmarkAdapter.class);
        if (bookmarkAdapter != null) {
            return bookmarkAdapter;
        }
        return new DefaultBookmarkAdapter(page);
    }

    public static Bookmark createBookmark(IDesktop desktop) throws ProcessingException {
        IOutline outline = desktop.getOutline();
        if (outline == null) {
            return null;
        }
        IPage activePage = outline.getActivePage();
        return BookmarkUtility.createBookmark(activePage);
    }

    public static Bookmark createBookmark(IPage page) throws ProcessingException {
        if (page == null || page.getOutline() == null) {
            return null;
        }
        IBookmarkAdapter bookmarkAdapter = BookmarkUtility.getBookmarkAdapter(page);
        IOutline outline = page.getOutline();
        Bookmark b = new Bookmark();
        b.setIconId(bookmarkAdapter.getIconId());
        b.setOutlineClassName(bookmarkAdapter.getOutlineClassName());
        ArrayList<IPage> path = new ArrayList<IPage>();
        ArrayList<String> titleSegments = new ArrayList<String>();
        while (page != null) {
            IBookmarkAdapter currentBookmarkAdapter = BookmarkUtility.getBookmarkAdapter(page);
            path.add(0, page);
            String s = currentBookmarkAdapter.getTitle();
            if (s != null) {
                titleSegments.add(0, s);
            }
            page = (IPage)page.getParentNode();
        }
        if (bookmarkAdapter.getOutlineTitle() != null) {
            titleSegments.add(0, bookmarkAdapter.getOutlineTitle());
        }
        int len = 0;
        if (titleSegments.size() > 0) {
            len += ((String)titleSegments.get(0)).length();
        }
        if (titleSegments.size() > 1) {
            len += ((String)titleSegments.get(titleSegments.size() - 1)).length();
        }
        int i = titleSegments.size() - 1;
        while (i > 0) {
            if (len > 200) {
                titleSegments.remove(i);
            } else if (len + ((String)titleSegments.get(i)).length() <= 200) {
                len += ((String)titleSegments.get(i)).length();
            } else {
                titleSegments.set(i, "...");
                len = 201;
            }
            --i;
        }
        StringBuilder buf = new StringBuilder();
        for (String s : titleSegments) {
            if (buf.length() > 0) {
                buf.append(" - ");
            }
            buf.append(s);
        }
        b.setTitle(buf.toString());
        StringBuffer text = new StringBuffer();
        String prefix = "";
        int i2 = 0;
        while (i2 < path.size()) {
            page = (IPage)path.get(i2);
            IBookmarkAdapter currentBookmarkAdapter = BookmarkUtility.getBookmarkAdapter(page);
            if (i2 > 0 || outline.isRootNodeVisible()) {
                IPageWithTable tablePage;
                SearchFilter search;
                text.append(String.valueOf(prefix) + currentBookmarkAdapter.getText());
                text.append("\n");
                if (page instanceof IPageWithTable && (search = (tablePage = (IPageWithTable)page).getSearchFilter()) != null) {
                    String[] stringArray = search.getDisplayTexts();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        if (s != null) {
                            String indent = String.valueOf(prefix) + "  ";
                            if ((s = s.trim().replaceAll("[\\n]", "\n" + indent)).length() > 0) {
                                text.append(String.valueOf(indent) + s);
                                text.append("\n");
                            }
                        }
                        ++n2;
                    }
                }
                prefix = String.valueOf(prefix) + "  ";
            }
            ++i2;
        }
        b.setText(text.toString().trim());
        i2 = 0;
        while (i2 < path.size()) {
            page = (IPage)path.get(i2);
            if (page instanceof IPageWithTable) {
                IPageWithTable tablePage = (IPageWithTable)page;
                IPage childPage = null;
                if (i2 + 1 < path.size()) {
                    childPage = (IPage)path.get(i2 + 1);
                }
                b.addPathElement((AbstractPageState)BookmarkUtility.bmStoreTablePage(tablePage, childPage));
            } else if (page instanceof IPageWithNodes) {
                IPageWithNodes nodePage = (IPageWithNodes)page;
                b.addPathElement((AbstractPageState)BookmarkUtility.bmStoreNodePage(nodePage));
            }
            ++i2;
        }
        return b;
    }

    private static IPage bmLoadTablePage(IPageWithTable tablePage, TablePageState tablePageState, boolean leafState, boolean resetViewAndWarnOnFail) throws ProcessingException {
        boolean loadChildren;
        ISearchForm searchForm;
        Object curData;
        Object table = tablePage.getTable();
        if (tablePageState.getTableCustomizerData() != null && tablePage.getTable().getTableCustomizer() != null) {
            byte[] newData = tablePageState.getTableCustomizerData();
            ITableCustomizer tc = tablePage.getTable().getTableCustomizer();
            curData = tc.getSerializedData();
            if (!CompareUtility.equals((Object)curData, (Object)newData)) {
                tc.removeAllColumns();
                tc.setSerializedData(newData);
                table.resetColumnConfiguration();
                tablePage.setChildrenLoaded(false);
            }
        }
        tablePage.getSearchFilter();
        try {
            table.setTableChanging(true);
            ArrayList<TableColumnState> allColumns = new ArrayList();
            curData = tablePageState.getAvailableColumns().iterator();
            while (curData.hasNext()) {
                TableColumnState tcs = (TableColumnState)curData.next();
                if (!tcs.getVisible().booleanValue()) continue;
                allColumns.add(tcs);
            }
            if (allColumns == null || allColumns.size() == 0) {
                allColumns = tablePageState.getAvailableColumns();
            }
            BookmarkUtility.restoreTableColumns(tablePage.getTable(), allColumns);
        }
        finally {
            table.setTableChanging(false);
        }
        if (tablePageState.getSearchFormState() != null && (searchForm = tablePage.getSearchFormInternal()) != null) {
            boolean doSearch = true;
            String newSearchFilterState = tablePageState.getSearchFilterState();
            String oldSearchFilterState = "" + BookmarkUtility.createSearchFilterCRC(searchForm.getSearchFilter());
            if (CompareUtility.equals((Object)oldSearchFilterState, (Object)newSearchFilterState)) {
                String newSearchFormState = tablePageState.getSearchFormState();
                String oldSearchFormState = searchForm.getXML("UTF-8");
                if (CompareUtility.equals((Object)oldSearchFormState, (Object)newSearchFormState)) {
                    doSearch = false;
                }
            }
            if (tablePage.getTable().getRowCount() == 0) {
                doSearch = true;
            }
            if (doSearch) {
                searchForm.setXML(tablePageState.getSearchFormState());
                if (tablePageState.isSearchFilterComplete()) {
                    searchForm.doSaveWithoutMarkerChange();
                }
            }
        }
        ITreeNode childPage = null;
        boolean bl = loadChildren = !leafState;
        if (tablePage.isChildrenDirty() || tablePage.isChildrenVolatile()) {
            loadChildren = true;
            tablePage.setChildrenLoaded(false);
        }
        if (loadChildren) {
            tablePage.ensureChildrenLoaded();
            tablePage.setChildrenDirty(false);
            CompositeObject childPk = tablePageState.getExpandedChildPrimaryKey();
            if (childPk != null) {
                int r = 0;
                while (r < table.getRowCount()) {
                    CompositeObject testPkLegacy = new CompositeObject(new Object[]{BookmarkUtility.makeSerializableKeys(table.getRowKeys(r), true)});
                    CompositeObject testPk = new CompositeObject(new Object[]{BookmarkUtility.makeSerializableKeys(table.getRowKeys(r), false)});
                    if (testPk.equals((Object)childPk) || testPkLegacy.equals((Object)childPk)) {
                        if (r < tablePage.getChildNodeCount()) {
                            childPage = tablePage.getChildPage(r);
                        }
                        break;
                    }
                    ++r;
                }
            } else {
                List<ITreeNode> filteredChildNodes = tablePage.getFilteredChildNodes();
                if (filteredChildNodes.size() > 0) {
                    childPage = (IPage)CollectionUtility.firstElement(filteredChildNodes);
                } else if (tablePage.getChildNodeCount() > 0) {
                    childPage = tablePage.getChildPage(0);
                }
            }
        }
        if (leafState) {
            if (tablePageState.getSelectedChildrenPrimaryKeys().size() > 0) {
                tablePage.ensureChildrenLoaded();
                HashSet selectionSet = new HashSet(tablePageState.getSelectedChildrenPrimaryKeys());
                ArrayList<ITableRow> rowList = new ArrayList<ITableRow>();
                for (ITableRow row : table.getRows()) {
                    CompositeObject testPkLegacy = new CompositeObject(new Object[]{BookmarkUtility.makeSerializableKeys(row.getKeyValues(), true)});
                    CompositeObject testPk = new CompositeObject(new Object[]{BookmarkUtility.makeSerializableKeys(row.getKeyValues(), false)});
                    if (!selectionSet.contains(testPk) && !selectionSet.contains(testPkLegacy) || !row.isFilterAccepted()) continue;
                    rowList.add(row);
                }
                if (rowList.size() > 0) {
                    table.selectRows(rowList);
                }
            }
            return childPage;
        }
        if (resetViewAndWarnOnFail && (childPage == null || !childPage.isFilterAccepted() && table.getColumnFilterManager() != null && table.getColumnFilterManager().isEnabled())) {
            table.getColumnFilterManager().reset();
            tablePage.setPagePopulateStatus((IProcessingStatus)new ProcessingStatus(ScoutTexts.get((String)"BookmarkResetColumnFilters", (String[])new String[0]), 2));
        }
        if (childPage == null || !childPage.isFilterAccepted()) {
            if (resetViewAndWarnOnFail) {
                if (tablePage.isSearchActive() && tablePage.getSearchFormInternal() != null) {
                    tablePage.setPagePopulateStatus((IProcessingStatus)new ProcessingStatus(ScoutTexts.get((String)"BookmarkResolutionCanceledCheckSearchCriteria", (String[])new String[0]), 2));
                } else {
                    tablePage.setPagePopulateStatus((IProcessingStatus)new ProcessingStatus(ScoutTexts.get((String)"BookmarkResolutionCanceled", (String[])new String[0]), 2));
                }
            }
            childPage = null;
        }
        return childPage;
    }

    private static IPage bmLoadNodePage(IPageWithNodes nodePage, NodePageState nodePageState, AbstractPageState childState, boolean resetViewAndWarnOnFail) throws ProcessingException {
        IPage childPage = null;
        if (childState != null) {
            nodePage.ensureChildrenLoaded();
            IPage p = BookmarkUtility.resolvePage(nodePage.getChildPages(), childState.getPageClassName(), childState.getBookmarkIdentifier());
            if (p != null) {
                ITable table = nodePage.getInternalTable();
                if (resetViewAndWarnOnFail && !p.isFilterAccepted() && table.getColumnFilterManager() != null && table.getColumnFilterManager().isEnabled()) {
                    table.getColumnFilterManager().reset();
                }
                if (p.isFilterAccepted()) {
                    childPage = p;
                }
            }
            if (childPage == null && resetViewAndWarnOnFail) {
                nodePage.setPagePopulateStatus((IProcessingStatus)new ProcessingStatus(ScoutTexts.get((String)"BookmarkResolutionCanceled", (String[])new String[0]), 2));
            }
        }
        return childPage;
    }

    private static TablePageState bmStoreTablePage(IPageWithTable page, IPage childPage) throws ProcessingException {
        Object table = page.getTable();
        TablePageState state = new TablePageState();
        state.setPageClassName(page.getClass().getName());
        IBookmarkAdapter bookmarkAdapter = BookmarkUtility.getBookmarkAdapter(page);
        state.setBookmarkIdentifier(bookmarkAdapter.getIdentifier());
        state.setLabel(bookmarkAdapter.getText());
        state.setExpanded(Boolean.valueOf(page.isExpanded()));
        ISearchForm searchForm = page.getSearchFormInternal();
        if (searchForm != null) {
            state.setSearchFormState(searchForm.getXML("UTF-8"));
            state.setSearchFilterState(searchForm.getSearchFilter().isCompleted(), "" + BookmarkUtility.createSearchFilterCRC(searchForm.getSearchFilter()));
        }
        if (page.getTable().getTableCustomizer() != null) {
            state.setTableCustomizerData(page.getTable().getTableCustomizer().getSerializedData());
        }
        List<TableColumnState> allColumns = BookmarkUtility.backupTableColumns(page.getTable());
        state.setAvailableColumns(allColumns);
        ArrayList<CompositeObject> pkList = new ArrayList<CompositeObject>();
        for (ITableRow row : table.getSelectedRows()) {
            pkList.add(new CompositeObject(new Object[]{BookmarkUtility.makeSerializableKeys(row.getKeyValues(), false)}));
        }
        state.setSelectedChildrenPrimaryKeys(pkList);
        if (childPage != null) {
            int j = 0;
            while (j < table.getRowCount()) {
                if (page.getChildNode(j) == childPage) {
                    ITableRow childRow = table.getRow(j);
                    state.setExpandedChildPrimaryKey(new CompositeObject(new Object[]{BookmarkUtility.makeSerializableKeys(childRow.getKeyValues(), false)}));
                    break;
                }
                ++j;
            }
        }
        return state;
    }

    private static NodePageState bmStoreNodePage(IPageWithNodes page) throws ProcessingException {
        NodePageState state = new NodePageState();
        state.setPageClassName(page.getClass().getName());
        IBookmarkAdapter bookmarkAdapter = BookmarkUtility.getBookmarkAdapter(page);
        state.setBookmarkIdentifier(bookmarkAdapter.getIdentifier());
        state.setLabel(bookmarkAdapter.getText());
        state.setExpanded(Boolean.valueOf(page.isExpanded()));
        return state;
    }

    private static long createSearchFilterCRC(SearchFilter filter) {
        if (filter == null) {
            return 0L;
        }
        try {
            CRC32 crc = new CRC32();
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            ObjectOutputStream oo = new ObjectOutputStream(bo);
            oo.writeObject(filter);
            oo.close();
            crc.update(bo.toByteArray());
            return crc.getValue();
        }
        catch (Throwable t) {
            return -1L;
        }
    }
}

