/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.exceptionhandler;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.VetoException;
import org.eclipse.scout.rt.client.services.common.exceptionhandler.UserInterruptedException;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBox;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.servicetunnel.HttpException;
import org.eclipse.scout.rt.shared.servicetunnel.VersionMismatchException;

public class ErrorHandler {
    private String m_title;
    private String m_text;
    private String m_detail;
    private String m_acceptText;
    private String m_copyPasteText;
    private ProcessingException m_cause;

    public ErrorHandler(Throwable t) {
        this.parse(t);
    }

    public String getTitle() {
        return this.m_title;
    }

    public String getText() {
        return this.m_text;
    }

    public String getDetail() {
        return this.m_detail;
    }

    public String getCopyPasteText() {
        return this.m_copyPasteText;
    }

    public String getAcceptText() {
        return this.m_acceptText;
    }

    public ProcessingException getCause() {
        return this.m_cause;
    }

    public IProcessingStatus getStatus() {
        return this.m_cause.getStatus();
    }

    public void showMessageBox() {
        MessageBox mbox = new MessageBox(this.m_title, this.m_text, this.m_detail, this.m_acceptText, null, null, this.m_copyPasteText, null);
        mbox.setSeverity(this.m_cause.getStatus().getSeverity());
        mbox.startMessageBox();
    }

    private void parse(Throwable exception) {
        if (exception instanceof UndeclaredThrowableException) {
            exception = ((UndeclaredThrowableException)exception).getCause();
        }
        this.m_cause = exception instanceof ProcessingException ? (ProcessingException)exception : new ProcessingException(ScoutTexts.get((String)"Error", (String[])new String[0]), ScoutTexts.get((String)"ErrorAndRetryTextDefault", (String[])new String[0]), exception);
        this.m_text = this.m_cause.getStatus().getTitle();
        if (this.m_text == null || this.m_text.length() == 0) {
            this.m_text = ScoutTexts.get((String)"Error", (String[])new String[0]);
        }
        this.m_detail = this.m_cause.getStatus().getMessage();
        this.m_acceptText = ScoutTexts.get((String)"Ok", (String[])new String[0]);
        Throwable t = exception;
        while (t != null) {
            String msg = "\n\n" + StringUtility.wrapWord((String)ScoutTexts.get((String)"OriginalErrorMessageIs", (String[])new String[]{String.valueOf(t.getClass().getSimpleName()) + " " + t.getLocalizedMessage()}), (int)80);
            if (t instanceof HttpException) {
                int statusCode = ((HttpException)t).getStatusCode();
                switch (statusCode) {
                    case 401: 
                    case 403: {
                        this.m_title = ScoutTexts.get((String)"ErrorTitleLogin", (String[])new String[0]);
                        this.m_text = String.valueOf(ScoutTexts.get((String)"ErrorTextLogin", (String[])new String[0])) + msg;
                        break;
                    }
                    default: {
                        this.m_title = ScoutTexts.get((String)"NetErrorTitle", (String[])new String[0]);
                        this.m_text = String.valueOf(ScoutTexts.get((String)"NetErrorText", (String[])new String[0])) + msg;
                        this.m_detail = ScoutTexts.get((String)"NetErrorInfo", (String[])new String[0]);
                    }
                }
                return;
            }
            if (t instanceof GeneralSecurityException) {
                this.m_title = ScoutTexts.get((String)"ErrorTitleLogin", (String[])new String[0]);
                this.m_text = String.valueOf(ScoutTexts.get((String)"ErrorTextLogin", (String[])new String[0])) + msg;
                return;
            }
            if (t instanceof SecurityException) {
                this.m_title = ScoutTexts.get((String)"ErrorTitleSecurity", (String[])new String[0]);
                this.m_text = String.valueOf(ScoutTexts.get((String)"ErrorTextSecurity", (String[])new String[0])) + msg;
                return;
            }
            if (t instanceof MalformedURLException) {
                this.m_title = ScoutTexts.get((String)"NetErrorTitle", (String[])new String[0]);
                this.m_text = String.valueOf(ScoutTexts.get((String)"NetErrorText", (String[])new String[0])) + msg;
                this.m_detail = ScoutTexts.get((String)"NetErrorInfo", (String[])new String[0]);
                return;
            }
            if (t instanceof InterruptedException) {
                this.m_title = ScoutTexts.get((String)"InterruptedErrorTitle", (String[])new String[0]);
                this.m_text = ScoutTexts.get((String)"InterruptedErrorText", (String[])new String[0]);
                return;
            }
            if (t instanceof UnknownHostException) {
                this.m_title = ScoutTexts.get((String)"NetErrorTitle", (String[])new String[0]);
                this.m_text = String.valueOf(ScoutTexts.get((String)"NetErrorText", (String[])new String[0])) + msg;
                this.m_detail = ScoutTexts.get((String)"NetErrorInfo", (String[])new String[0]);
                return;
            }
            if (t instanceof FileNotFoundException) {
                this.m_title = ScoutTexts.get((String)"FileNotFoundTitle", (String[])new String[0]);
                this.m_text = ScoutTexts.get((String)"FileNotFoundMessage", (String[])new String[]{((FileNotFoundException)t).getMessage()});
                return;
            }
            if (t instanceof NoRouteToHostException) {
                this.m_title = ScoutTexts.get((String)"NetErrorTitle", (String[])new String[0]);
                this.m_text = String.valueOf(ScoutTexts.get((String)"NetErrorText", (String[])new String[0])) + msg;
                this.m_detail = ScoutTexts.get((String)"NetErrorInfo", (String[])new String[0]);
                return;
            }
            if (t instanceof SocketException) {
                this.m_title = ScoutTexts.get((String)"NetErrorTitle", (String[])new String[0]);
                this.m_text = String.valueOf(ScoutTexts.get((String)"NetErrorText", (String[])new String[0])) + msg;
                this.m_detail = ScoutTexts.get((String)"NetErrorInfo", (String[])new String[0]);
                return;
            }
            if (t instanceof UserInterruptedException) {
                this.m_title = ScoutTexts.get((String)"IOErrorTitle", (String[])new String[0]);
                this.m_text = UserInterruptedException.class.getSimpleName();
                this.m_detail = ScoutTexts.get((String)"IOErrorInfo", (String[])new String[0]);
                return;
            }
            if (t instanceof IOException) {
                this.m_title = ScoutTexts.get((String)"IOErrorTitle", (String[])new String[0]);
                this.m_text = String.valueOf(ScoutTexts.get((String)"IOErrorText", (String[])new String[0])) + ": " + t.getLocalizedMessage() + msg;
                this.m_detail = ScoutTexts.get((String)"IOErrorInfo", (String[])new String[0]);
                return;
            }
            if (t instanceof VersionMismatchException) {
                VersionMismatchException ve = (VersionMismatchException)t;
                this.m_title = ScoutTexts.get((String)"VersionMismatchTitle", (String[])new String[0]);
                this.m_text = ScoutTexts.get((String)"VersionMismatchTextXY", (String[])new String[]{ve.getOldVersion(), ve.getNewVersion()});
                this.m_detail = null;
                return;
            }
            if (t instanceof VetoException) {
                this.m_text = ((VetoException)t).getStatus().getTitle();
                this.m_detail = StringUtility.hasText((String)((VetoException)t).getStatus().getMessage()) ? ((VetoException)t).getStatus().getMessage() : String.valueOf(ScoutTexts.get((String)"VetoErrorText", (String[])new String[0])) + msg;
                return;
            }
            t = t.getCause();
        }
        StringWriter buf = new StringWriter();
        t = exception;
        String indent = "";
        while (t != null) {
            String s = null;
            s = t instanceof ProcessingException ? ((ProcessingException)t).getStatus().getMessage() : t.getMessage();
            buf.append(indent);
            if (s != null) {
                buf.append(String.valueOf(s) + (t.getClass() != ProcessingException.class ? " (" + t.getClass().getSimpleName() + ")" : ""));
            } else {
                buf.append(t.getClass().getSimpleName());
            }
            buf.append("\n");
            indent = String.valueOf(indent) + "  ";
            t = t.getCause();
        }
        this.m_detail = StringUtility.wrapWord((String)ScoutTexts.get((String)"OriginalErrorMessageIs", (String[])new String[]{buf.toString()}), (int)120);
        this.m_copyPasteText = this.createCopyPasteText(this.m_text, this.m_detail, (Throwable)this.m_cause);
    }

    private String createCopyPasteText(String text, String detail, Throwable cause) {
        StringWriter logText = new StringWriter();
        logText.append(String.valueOf(this.m_title) + "\n");
        logText.append("\n");
        if (text != null) {
            logText.append(String.valueOf(text) + "\n");
            logText.append("\n");
        }
        if (detail != null) {
            logText.append(String.valueOf(detail) + "\n");
            logText.append("\n");
        }
        if (cause != null) {
            cause.printStackTrace(new PrintWriter((Writer)logText, true));
            logText.append("\n");
        }
        return logText.toString();
    }
}

