/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.action.menu.root.internal;

import java.beans.PropertyChangeEvent;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.IActionVisitor;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuUtility;
import org.eclipse.scout.rt.client.ui.action.menu.root.AbstractPropertyObserverContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.ITableContextMenu;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableAdapter;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public class TableContextMenu
extends AbstractPropertyObserverContextMenu<ITable>
implements ITableContextMenu {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(TableContextMenu.class);
    private List<? extends ITableRow> m_currentSelection;

    public TableContextMenu(ITable owner, List<? extends IMenu> initialChildMenus) {
        super(owner, initialChildMenus);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        ((ITable)this.getOwner()).addTableListener(new P_OwnerTableListener());
        this.setCurrentMenuTypes(MenuUtility.getMenuTypesForTableSelection(((ITable)this.getOwner()).getSelectedRows()));
        this.calculateLocalVisibility();
    }

    @Override
    protected void afterChildMenusAdd(List<? extends IMenu> newChildMenus) {
        super.afterChildMenusAdd(newChildMenus);
        this.handleOwnerEnabledChanged();
    }

    @Override
    protected void afterChildMenusRemove(List<? extends IMenu> childMenusToRemove) {
        super.afterChildMenusRemove(childMenusToRemove);
        this.handleOwnerEnabledChanged();
    }

    protected void handleOwnerEnabledChanged() {
        if (this.getOwner() != null) {
            final boolean enabled = ((ITable)this.getOwner()).isEnabled();
            this.acceptVisitor(new IActionVisitor(){

                @Override
                public int visit(IAction action) {
                    IMenu menu;
                    if (action instanceof IMenu && !(menu = (IMenu)action).hasChildActions() && menu.isInheritAccessibility()) {
                        menu.setEnabled(enabled);
                    }
                    return 1;
                }
            });
        }
    }

    @Override
    public void callOwnerValueChanged() {
        this.handleOwnerValueChanged();
    }

    protected void handleOwnerValueChanged() {
        this.m_currentSelection = null;
        if (this.getOwner() != null) {
            final List<ITableRow> ownerValue = ((ITable)this.getOwner()).getSelectedRows();
            this.m_currentSelection = CollectionUtility.arrayList(ownerValue);
            this.acceptVisitor(new IActionVisitor(){

                @Override
                public int visit(IAction action) {
                    if (action instanceof IMenu) {
                        IMenu menu = (IMenu)action;
                        try {
                            menu.handleOwnerValueChanged(ownerValue);
                        }
                        catch (ProcessingException ex) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
                        }
                    }
                    return 1;
                }
            });
            this.setCurrentMenuTypes(MenuUtility.getMenuTypesForTableSelection(ownerValue));
            this.calculateLocalVisibility();
            this.calculateEnableState(ownerValue);
        }
    }

    protected void calculateEnableState(List<? extends ITableRow> ownerValue) {
        boolean enabled = true;
        for (ITableRow iTableRow : ownerValue) {
            if (iTableRow.isEnabled()) continue;
            enabled = false;
            break;
        }
        final boolean bl = enabled;
        this.acceptVisitor(new IActionVisitor(){

            @Override
            public int visit(IAction action) {
                IMenu menu;
                if (action instanceof IMenu && !(menu = (IMenu)action).hasChildActions() && menu.isInheritAccessibility()) {
                    menu.setEnabledInheritAccessibility(bl);
                }
                return 1;
            }
        });
    }

    protected void handleRowsUpdated(List<ITableRow> rows) {
        if (CollectionUtility.containsAny(rows, this.m_currentSelection)) {
            this.calculateEnableState(this.m_currentSelection);
        }
    }

    @Override
    protected void handleOwnerPropertyChanged(PropertyChangeEvent evt) {
        if ("enabled".equals(evt.getPropertyName())) {
            this.handleOwnerEnabledChanged();
        }
    }

    private class P_OwnerTableListener
    extends TableAdapter {
        private P_OwnerTableListener() {
        }

        @Override
        public void tableChanged(TableEvent e) {
            if (e.getType() == 103) {
                TableContextMenu.this.handleOwnerValueChanged();
            } else if (e.getType() == 101) {
                TableContextMenu.this.handleRowsUpdated(e.getRows());
            }
        }
    }
}

