/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.BooleanUtility;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.HTMLUtility;
import org.eclipse.scout.commons.ITypeWithClassId;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;
import org.eclipse.scout.commons.dnd.TextTransferObject;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.IEventHistory;
import org.eclipse.scout.rt.client.ui.MouseButton;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.IActionVisitor;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.keystroke.KeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuSeparator;
import org.eclipse.scout.rt.client.ui.action.menu.root.ITableContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.TableContextMenu;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTableRowBuilder;
import org.eclipse.scout.rt.client.ui.basic.table.ColumnSet;
import org.eclipse.scout.rt.client.ui.basic.table.DefaultTableEventHistory;
import org.eclipse.scout.rt.client.ui.basic.table.IHeaderCell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRowDataMapper;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRowFilter;
import org.eclipse.scout.rt.client.ui.basic.table.ITableUIFacade;
import org.eclipse.scout.rt.client.ui.basic.table.KeyStrokeBuffer;
import org.eclipse.scout.rt.client.ui.basic.table.RowIndexComparator;
import org.eclipse.scout.rt.client.ui.basic.table.TableAdapter;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.TableListener;
import org.eclipse.scout.rt.client.ui.basic.table.TableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableRowComparator;
import org.eclipse.scout.rt.client.ui.basic.table.TableRowDataMapper;
import org.eclipse.scout.rt.client.ui.basic.table.TableUtility;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ColumnFilterMenu;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.DefaultTableColumnFilterManager;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ITableColumnFilter;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ITableColumnFilterManager;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractBooleanColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBooleanColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IContentAssistColumn;
import org.eclipse.scout.rt.client.ui.basic.table.customizer.AddCustomColumnMenu;
import org.eclipse.scout.rt.client.ui.basic.table.customizer.ITableCustomizer;
import org.eclipse.scout.rt.client.ui.basic.table.customizer.ModifyCustomColumnMenu;
import org.eclipse.scout.rt.client.ui.basic.table.customizer.RemoveCustomColumnMenu;
import org.eclipse.scout.rt.client.ui.basic.table.internal.InternalTableRow;
import org.eclipse.scout.rt.client.ui.basic.table.menus.CopyWidthsOfColumnsMenu;
import org.eclipse.scout.rt.client.ui.basic.table.menus.OrganizeColumnsMenu;
import org.eclipse.scout.rt.client.ui.basic.table.menus.ResetColumnsMenu;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField;
import org.eclipse.scout.rt.client.ui.profiler.DesktopProfiler;
import org.eclipse.scout.rt.shared.data.basic.table.AbstractTableRowData;
import org.eclipse.scout.rt.shared.data.form.fields.tablefield.AbstractTableFieldBeanData;
import org.eclipse.scout.rt.shared.data.form.fields.tablefield.AbstractTableFieldData;
import org.eclipse.scout.rt.shared.services.common.code.ICode;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.lookup.BatchLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.BatchLookupResultCache;
import org.eclipse.scout.rt.shared.services.lookup.IBatchLookupService;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractTable
extends AbstractPropertyObserver
implements ITable {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractTable.class);
    private boolean m_initialized;
    private final OptimisticLock m_initLock;
    private ColumnSet m_columnSet;
    private final List<ITableRow> m_rows;
    private final Object m_cachedRowsLock;
    private List<ITableRow> m_cachedRows;
    private final HashMap<CompositeObject, ITableRow> m_deletedRows;
    private List<ITableRow> m_selectedRows = new ArrayList<ITableRow>();
    private Map<Class<?>, Class<? extends IMenu>> m_menuReplacementMapping;
    private ITableUIFacade m_uiFacade;
    private final List<ITableRowFilter> m_rowFilters;
    private String m_userPreferenceContext;
    private boolean m_autoDiscardOnDelete;
    private boolean m_sortEnabled;
    private boolean m_sortValid;
    private boolean m_initialMultiLineText;
    private int m_tableChanging;
    private List<TableEvent> m_tableEventBuffer = new ArrayList<TableEvent>();
    private final HashSet<P_CellLookup> m_cellLookupBuffer = new HashSet();
    private HashSet<ITableRow> m_rowDecorationBuffer = new HashSet();
    private final KeyStrokeBuffer m_keyStrokeBuffer;
    private final EventListenerList m_listenerList = new EventListenerList();
    private P_CellEditorContext m_editContext;
    private Set<ITableRow> m_rowValidty;
    private IBooleanColumn m_checkableColumn;
    private final Object m_cachedFilteredRowsLock;
    private List<ITableRow> m_cachedFilteredRows;
    private IEventHistory<TableEvent> m_eventHistory;
    private boolean m_actionRunning;
    private int m_processEventBufferLoopDetection;

    public AbstractTable() {
        this(true);
    }

    public AbstractTable(boolean callInitializer) {
        if (DesktopProfiler.getInstance().isEnabled()) {
            DesktopProfiler.getInstance().registerTable(this);
        }
        this.m_rowValidty = new HashSet<ITableRow>();
        this.m_cachedRowsLock = new Object();
        this.m_cachedFilteredRowsLock = new Object();
        this.m_rows = Collections.synchronizedList(new ArrayList(1));
        this.m_deletedRows = new HashMap();
        this.m_keyStrokeBuffer = new KeyStrokeBuffer(500L);
        this.m_rowFilters = new ArrayList<ITableRowFilter>(1);
        this.m_initLock = new OptimisticLock();
        this.m_actionRunning = false;
        this.addTableListener(new P_TableListener());
        if (callInitializer) {
            this.callInitializer();
        }
    }

    protected void callInitializer() {
        this.initConfig();
    }

    public String classId() {
        return String.valueOf(ConfigurationUtility.getAnnotatedClassIdWithFallback(this.getClass())) + "_" + this.getContainer().classId();
    }

    @ConfigProperty(value="TEXT")
    @Order(value=10.0)
    protected String getConfiguredTitle() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=20.0)
    protected String getConfiguredDefaultIconId() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=30.0)
    protected boolean getConfiguredMultiSelect() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=32.0)
    protected boolean getConfiguredMultiCheck() {
        return true;
    }

    @ConfigProperty(value="MENU_CLASS")
    @Order(value=35.0)
    protected Class<? extends IMenu> getConfiguredDefaultMenu() {
        return null;
    }

    protected Class<? extends IMenu> getDefaultMenuInternal() {
        return this.getConfiguredDefaultMenu();
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=50.0)
    protected boolean getConfiguredAutoDiscardOnDelete() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=60.0)
    protected boolean getConfiguredSortEnabled() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=70.0)
    protected boolean getConfiguredHeaderVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=80.0)
    protected boolean getConfiguredAutoResizeColumns() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=90.0)
    protected boolean getConfiguredMultilineText() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=92.0)
    protected int getConfiguredRowHeightHint() {
        return -1;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=100.0)
    protected boolean getConfiguredCheckable() {
        return false;
    }

    @ConfigProperty(value="TABLE_COLUMN")
    @Order(value=102.0)
    protected Class<? extends AbstractBooleanColumn> getConfiguredCheckableColumn() {
        return null;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=190.0)
    protected int getConfiguredDropType() {
        return 0;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=190.0)
    protected int getConfiguredDragType() {
        return 0;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=200.0)
    protected boolean getConfiguredKeyboardNavigation() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=230.0)
    protected boolean getConfiguredScrollToSelection() {
        return false;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected TransferObject execDrag(List<ITableRow> rows) throws ProcessingException {
        return null;
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execDrop(ITableRow row, TransferObject t) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=30.0)
    protected TransferObject execCopy(List<? extends ITableRow> rows) throws ProcessingException {
        if (!CollectionUtility.hasElements(rows)) {
            return null;
        }
        StringBuilder plainText = new StringBuilder();
        StringBuilder htmlText = new StringBuilder("<html>");
        htmlText.append("<head><style type=\"text/css\"> br {mso-data-placement:same-cell;} </style></head>");
        htmlText.append("<body><table border=\"0\">");
        List<IColumn<?>> columns = this.getColumnSet().getVisibleColumns();
        Pattern patternHtmlCheck = Pattern.compile(".*?<\\s*html.*?>.*", 42);
        Pattern patternBodyContent = Pattern.compile("<\\s*body.*?>(.*?)<\\s*/\\s*body\\s*>", 42);
        boolean firstRow = true;
        for (ITableRow iTableRow : rows) {
            htmlText.append("<tr>");
            if (!firstRow) {
                plainText.append(System.getProperty("line.separator"));
            }
            boolean firstColumn = true;
            for (IColumn<?> column : columns) {
                Matcher matcher;
                boolean value;
                ICell cell = iTableRow.getCell(column);
                String text = column instanceof IBooleanColumn ? ((value = BooleanUtility.nvl((Boolean)((Boolean)((IBooleanColumn)column).getValue(iTableRow)), (boolean)false)) ? "X" : "") : StringUtility.emptyIfNull((Object)cell.getText());
                if (!firstColumn) {
                    plainText.append("\t");
                }
                plainText.append(StringUtility.emptyIfNull((Object)StringUtility.unwrapText((String)text)));
                String html = null;
                if (patternHtmlCheck.matcher(text).matches() && (matcher = patternBodyContent.matcher(HTMLUtility.cleanupHtml((String)text, (boolean)false, (boolean)false, null))).find()) {
                    html = matcher.group(1);
                }
                if (html == null) {
                    html = StringUtility.htmlEncode((String)text);
                }
                if (!cell.isHtmlEnabled()) {
                    html = StringUtility.htmlEncode((String)html);
                }
                htmlText.append("<td>");
                htmlText.append(html);
                htmlText.append("</td>");
                firstColumn = false;
            }
            htmlText.append("</tr>");
            firstRow = false;
        }
        htmlText.append("</table></body></html>");
        TextTransferObject textTransferObject = new TextTransferObject(plainText.toString(), htmlText.toString());
        return textTransferObject;
    }

    @ConfigOperation
    @Order(value=40.0)
    protected void execContentChanged() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execDecorateCell(Cell view, ITableRow row, IColumn<?> col) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=60.0)
    protected void execInitTable() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=70.0)
    protected void execDisposeTable() throws ProcessingException {
    }

    @Deprecated
    protected void execRowClick(ITableRow row) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=80.0)
    protected void execRowClick(ITableRow row, MouseButton mouseButton) throws ProcessingException {
        TableEvent e = new TableEvent(this, 810, CollectionUtility.arrayList((Object)row));
        this.fireTableEventInternal(e);
        this.execRowClick(row);
    }

    @ConfigOperation
    @Order(value=90.0)
    protected void execRowAction(ITableRow row) throws ProcessingException {
        Class<? extends IMenu> defaultMenuType = this.getDefaultMenuInternal();
        if (defaultMenuType != null) {
            try {
                this.runMenu(defaultMenuType);
            }
            catch (ProcessingException ex) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(this.createNewUnexpectedProcessingException(t));
            }
        } else {
            TableEvent e = new TableEvent(this, 104, CollectionUtility.arrayList((Object)row));
            this.fireTableEventInternal(e);
        }
    }

    @ConfigOperation
    @Order(value=100.0)
    protected void execRowsSelected(List<? extends ITableRow> rows) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=110.0)
    protected void execDecorateRow(ITableRow row) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=120.0)
    protected void execHyperlinkAction(URL url, String path, boolean local) throws ProcessingException {
    }

    protected void execCreateHeaderMenus(List<IMenu> menuList) {
        if (this.getTableCustomizer() != null) {
            menuList.add(new AddCustomColumnMenu(this));
            menuList.add(new ModifyCustomColumnMenu(this));
            menuList.add(new RemoveCustomColumnMenu(this));
        }
        if (menuList.size() > 0) {
            menuList.add(new MenuSeparator());
        }
        menuList.add(new ResetColumnsMenu(this));
        menuList.add(new OrganizeColumnsMenu(this));
        menuList.add(new ColumnFilterMenu(this));
        menuList.add(new CopyWidthsOfColumnsMenu(this));
        menuList.add(new MenuSeparator());
    }

    protected List<Class<? extends IMenu>> getDeclaredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, IMenu.class);
        List foca = ConfigurationUtility.sortFilteredClassesByOrderAnnotation((List)filtered, IMenu.class);
        return ConfigurationUtility.removeReplacedClasses((List)foca);
    }

    private List<? extends Class<? extends IColumn>> getConfiguredColumns() {
        Object[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List foca = ConfigurationUtility.sortFilteredClassesByOrderAnnotation((List)CollectionUtility.arrayList((Object[])dca), IColumn.class);
        return ConfigurationUtility.removeReplacedClasses((List)foca);
    }

    private List<? extends Class<? extends IKeyStroke>> getConfiguredKeyStrokes() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List fca = ConfigurationUtility.filterClasses((Class[])dca, IKeyStroke.class);
        return ConfigurationUtility.removeReplacedClasses((List)fca);
    }

    /*
     * WARNING - void declaration
     */
    protected void initConfig() {
        this.m_eventHistory = this.createEventHistory();
        this.m_uiFacade = this.createUIFacade();
        this.setTitle(this.getConfiguredTitle());
        this.setAutoDiscardOnDelete(this.getConfiguredAutoDiscardOnDelete());
        this.setSortEnabled(this.getConfiguredSortEnabled());
        this.setDefaultIconId(this.getConfiguredDefaultIconId());
        this.setHeaderVisible(this.getConfiguredHeaderVisible());
        this.setAutoResizeColumns(this.getConfiguredAutoResizeColumns());
        this.setCheckable(this.getConfiguredCheckable());
        this.setMultiCheck(this.getConfiguredMultiCheck());
        this.setMultiSelect(this.getConfiguredMultiSelect());
        this.setInitialMultilineText(this.getConfiguredMultilineText());
        this.setMultilineText(this.getConfiguredMultilineText());
        this.setRowHeightHint(this.getConfiguredRowHeightHint());
        this.setKeyboardNavigation(this.getConfiguredKeyboardNavigation());
        this.setDragType(this.getConfiguredDragType());
        this.setDropType(this.getConfiguredDropType());
        this.setScrollToSelection(this.getConfiguredScrollToSelection());
        if (this.getTableCustomizer() == null) {
            this.setTableCustomizer(this.createTableCustomizer());
        }
        this.createColumnsInternal();
        ArrayList<IMenu> menuList = new ArrayList<IMenu>();
        List<Class<? extends IMenu>> ma = this.getDeclaredMenus();
        Map replacements = ConfigurationUtility.getReplacementMapping(ma);
        if (!replacements.isEmpty()) {
            this.m_menuReplacementMapping = replacements;
        }
        for (Class<? extends IMenu> clazz : ma) {
            try {
                IMenu menu = (IMenu)ConfigurationUtility.newInnerInstance((Object)this, clazz);
                menuList.add(menu);
            }
            catch (Throwable t) {
                void var7_9;
                String string = "null";
                if (clazz != null) {
                    String string2 = clazz.getName();
                }
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + (String)var7_9 + "'.", t));
            }
        }
        try {
            this.injectMenusInternal(menuList);
        }
        catch (Exception e) {
            LOG.error("error occured while dynamically contributing menus.", (Throwable)e);
        }
        this.execCreateHeaderMenus(menuList);
        for (IMenu menu : menuList) {
            menu.setContainerInternal(this);
        }
        TableContextMenu contextMenu = new TableContextMenu(this, (List<? extends IMenu>)menuList);
        this.setContextMenu(contextMenu);
        ArrayList<IKeyStroke> ksList = new ArrayList<IKeyStroke>();
        List<? extends Class<? extends IKeyStroke>> ksArray = this.getConfiguredKeyStrokes();
        for (Class<? extends IKeyStroke> clazz : ksArray) {
            try {
                IKeyStroke ks = (IKeyStroke)ConfigurationUtility.newInnerInstance((Object)this, clazz);
                ksList.add(ks);
            }
            catch (Throwable t) {
                String className = "null";
                if (clazz != null) {
                    className = clazz.getName();
                }
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + className + "'.", t));
            }
        }
        Class<? extends IMenu> clazz = this.getDefaultMenuInternal();
        if (clazz != null || ConfigurationUtility.isMethodOverwrite(AbstractTable.class, (String)"execRowAction", (Class[])new Class[]{ITableRow.class}, this.getClass())) {
            ksList.add(new KeyStroke("ENTER"){

                @Override
                protected void execAction() throws ProcessingException {
                    AbstractTable.this.fireRowAction(AbstractTable.this.getSelectedRow());
                }
            });
        }
        this.setKeyStrokes(ksList);
        this.addTableListener(new TableAdapter(){

            @Override
            public void tableChanged(TableEvent e) {
                IEventHistory<TableEvent> h = AbstractTable.this.getEventHistory();
                if (h != null) {
                    h.notifyEvent(e);
                }
                switch (e.getType()) {
                    case 730: {
                        if (e.getDragObject() != null) break;
                        try {
                            e.setDragObject(AbstractTable.this.execDrag(e.getRows()));
                        }
                        catch (ProcessingException ex) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
                        }
                        break;
                    }
                    case 740: {
                        if (e.getDropObject() == null) break;
                        try {
                            AbstractTable.this.execDrop(e.getFirstRow(), e.getDropObject());
                        }
                        catch (ProcessingException ex) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
                        }
                        break;
                    }
                    case 760: {
                        if (e.getCopyObject() != null) break;
                        try {
                            e.setCopyObject(AbstractTable.this.execCopy(e.getRows()));
                        }
                        catch (ProcessingException ex) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
                        }
                        break;
                    }
                    case 100: 
                    case 101: 
                    case 102: 
                    case 105: {
                        try {
                            AbstractTable.this.execContentChanged();
                            break;
                        }
                        catch (ProcessingException ex) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
                        }
                    }
                }
            }
        });
    }

    private void initColumnsInternal() {
        for (IColumn<?> c : this.getColumnSet().getColumns()) {
            try {
                c.initColumn();
            }
            catch (Throwable t) {
                LOG.error("column " + c, t);
            }
        }
        this.getColumnSet().initialize();
    }

    private void disposeColumnsInternal() {
        for (IColumn<?> c : this.getColumnSet().getColumns()) {
            try {
                c.disposeColumn();
            }
            catch (Throwable t) {
                LOG.error("column " + c, t);
            }
        }
    }

    private void createColumnsInternal() {
        List<? extends Class<? extends IColumn>> ca = this.getConfiguredColumns();
        ArrayList colList = new ArrayList();
        for (Class<? extends IColumn> clazz : ca) {
            try {
                IColumn column = (IColumn)ConfigurationUtility.newInnerInstance((Object)this, clazz);
                colList.add(column);
            }
            catch (Exception e) {
                String className = "null";
                if (clazz != null) {
                    className = clazz.getName();
                }
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + className + "'.", (Throwable)e));
            }
        }
        try {
            this.injectColumnsInternal(colList);
        }
        catch (Exception exception) {
            LOG.error("error occured while dynamically contribute columns.", (Throwable)exception);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(colList);
        this.m_columnSet = new ColumnSet(this, arrayList);
        if (this.getConfiguredCheckableColumn() != null) {
            AbstractBooleanColumn checkableColumn = this.getColumnSet().getColumnByClass(this.getConfiguredCheckableColumn());
            this.setCheckableColumn(checkableColumn);
        }
    }

    protected void injectColumnsInternal(List<IColumn<?>> columnList) {
        ITableCustomizer c = this.getTableCustomizer();
        if (c != null) {
            c.injectCustomColumns(columnList);
        }
    }

    protected void injectMenusInternal(List<IMenu> menuList) {
    }

    protected ITableUIFacade createUIFacade() {
        return new P_TableUIFacade();
    }

    @Override
    public String getUserPreferenceContext() {
        return this.m_userPreferenceContext;
    }

    @Override
    public void setUserPreferenceContext(String context) {
        this.m_userPreferenceContext = context;
        if (this.isTableInitialized()) {
            try {
                this.initTable();
            }
            catch (ProcessingException e) {
                LOG.error("Failed re-initializing table " + this.getClass().getName(), (Throwable)e);
            }
        }
    }

    @Override
    public final void initTable() throws ProcessingException {
        block6: {
            try {
                if (!this.m_initLock.acquire()) break block6;
                try {
                    this.setTableChanging(true);
                    this.initTableInternal();
                    ActionUtility.initActions(this.getMenus());
                    this.execInitTable();
                }
                finally {
                    this.setTableChanging(false);
                }
            }
            finally {
                this.m_initialized = true;
                this.m_initLock.release();
            }
        }
    }

    protected void initTableInternal() throws ProcessingException {
        this.initColumnsInternal();
        if (this.getColumnFilterManager() == null) {
            this.setColumnFilterManager(this.createColumnFilterManager());
        }
    }

    @Override
    public final void disposeTable() {
        try {
            this.disposeTableInternal();
            this.execDisposeTable();
        }
        catch (Throwable t) {
            LOG.warn(this.getClass().getName(), t);
        }
    }

    protected void disposeTableInternal() throws ProcessingException {
        this.disposeColumnsInternal();
    }

    @Override
    public void doHyperlinkAction(ITableRow row, IColumn<?> col, URL url) throws ProcessingException {
        if (!this.m_actionRunning) {
            try {
                this.m_actionRunning = true;
                if (row != null) {
                    this.selectRow(row);
                }
                if (col != null) {
                    this.setContextColumn(col);
                }
                this.execHyperlinkAction(url, url.getPath(), url != null && url.getHost().equals("local"));
            }
            finally {
                this.m_actionRunning = false;
            }
        }
    }

    @Override
    public List<ITableRowFilter> getRowFilters() {
        return CollectionUtility.arrayList(this.m_rowFilters);
    }

    @Override
    public void addRowFilter(ITableRowFilter filter) {
        if (filter != null && !this.m_rowFilters.contains(filter)) {
            this.m_rowFilters.add(filter);
            this.applyRowFilters();
        }
    }

    @Override
    public void removeRowFilter(ITableRowFilter filter) {
        if (filter != null && this.m_rowFilters.remove(filter)) {
            this.applyRowFilters();
        }
    }

    @Override
    public void applyRowFilters() {
        this.applyRowFiltersInternal();
        this.fireRowFilterChanged();
    }

    private void applyRowFiltersInternal() {
        for (ITableRow row : this.m_rows) {
            this.applyRowFiltersInternal((InternalTableRow)row);
        }
    }

    private void applyRowFiltersInternal(InternalTableRow row) {
        row.setFilterAcceptedInternal(true);
        if (this.m_rowFilters.size() > 0) {
            for (ITableRowFilter filter : this.m_rowFilters) {
                if (filter.accept(row)) continue;
                row.setFilterAcceptedInternal(false);
                if (!this.isSelectedRow(row)) break;
                this.deselectRow(row);
                break;
            }
        }
    }

    @Override
    public String getTitle() {
        return this.propertySupport.getPropertyString("title");
    }

    @Override
    public void setTitle(String s) {
        this.propertySupport.setPropertyString("title", s);
    }

    @Override
    public boolean isAutoResizeColumns() {
        return this.propertySupport.getPropertyBool("autoResizeColumns");
    }

    @Override
    public void setAutoResizeColumns(boolean b) {
        this.propertySupport.setPropertyBool("autoResizeColumns", b);
    }

    @Override
    public ColumnSet getColumnSet() {
        return this.m_columnSet;
    }

    @Override
    public int getColumnCount() {
        return this.getColumnSet().getColumnCount();
    }

    @Override
    public List<IColumn<?>> getColumns() {
        return this.getColumnSet().getColumns();
    }

    @Override
    public List<String> getColumnNames() {
        ArrayList<String> columnNames = new ArrayList<String>(this.getColumnCount());
        for (IColumn<?> col : this.getColumns()) {
            columnNames.add(col.getHeaderCell().getText());
        }
        return columnNames;
    }

    @Override
    public int getVisibleColumnCount() {
        return this.getColumnSet().getVisibleColumnCount();
    }

    @Override
    public IHeaderCell getVisibleHeaderCell(int visibleColumnIndex) {
        return this.getHeaderCell(this.getColumnSet().getVisibleColumn(visibleColumnIndex));
    }

    @Override
    public IHeaderCell getHeaderCell(int columnIndex) {
        return this.getHeaderCell(this.getColumnSet().getColumn(columnIndex));
    }

    @Override
    public IHeaderCell getHeaderCell(IColumn<?> col) {
        return col.getHeaderCell();
    }

    @Override
    public ICell getVisibleCell(int rowIndex, int visibleColumnIndex) {
        return this.getVisibleCell(this.getRow(rowIndex), visibleColumnIndex);
    }

    @Override
    public ICell getVisibleCell(ITableRow row, int visibleColumnIndex) {
        return this.getCell(row, this.getColumnSet().getVisibleColumn(visibleColumnIndex));
    }

    @Override
    public ICell getCell(int rowIndex, int columnIndex) {
        return this.getCell(this.getRow(rowIndex), this.getColumnSet().getColumn(columnIndex));
    }

    @Override
    public ICell getSummaryCell(int rowIndex) {
        return this.getSummaryCell(this.getRow(rowIndex));
    }

    @Override
    public ICell getSummaryCell(ITableRow row) {
        Cell cell;
        IColumn col;
        ArrayList a = this.getColumnSet().getSummaryColumns();
        if (a.size() == 0 && (col = this.getColumnSet().getFirstDefinedVisibileColumn()) != null) {
            a = CollectionUtility.arrayList((Object)col);
        }
        if (a.isEmpty()) {
            return new Cell();
        }
        if (a.size() == 1) {
            cell = new Cell(this.getCell(row, (IColumn)a.get(0)));
            if (cell.getIconId() == null) {
                cell.setIconId(row.getIconId());
            }
            return cell;
        }
        cell = new Cell(this.getCell(row, (IColumn)a.get(0)));
        if (cell.getIconId() == null) {
            cell.setIconId(row.getIconId());
        }
        StringBuilder b = new StringBuilder();
        for (IColumn c : a) {
            if (b.length() > 0) {
                b.append(" ");
            }
            b.append(this.getCell(row, c).getText());
        }
        cell.setText(b.toString());
        return cell;
    }

    @Override
    public ICell getCell(ITableRow row, IColumn<?> col) {
        if ((row = this.resolveRow(row)) == null || col == null) {
            return null;
        }
        return row.getCell(col.getColumnIndex());
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.isCellEditable(this.getRow(rowIndex), this.getColumnSet().getColumn(columnIndex));
    }

    @Override
    public boolean isCellEditable(ITableRow row, int visibleColumnIndex) {
        return this.isCellEditable(row, this.getColumnSet().getVisibleColumn(visibleColumnIndex));
    }

    @Override
    public boolean isCellEditable(ITableRow row, IColumn<?> column) {
        return row != null && column != null && column.isVisible() && column.isCellEditable(row);
    }

    @Override
    public Object getProperty(String name) {
        return this.propertySupport.getProperty(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.propertySupport.setProperty(name, value);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.propertySupport.hasProperty(name);
    }

    @Override
    public boolean isCheckable() {
        return this.propertySupport.getPropertyBool("checkable");
    }

    @Override
    public void setCheckable(boolean b) {
        this.propertySupport.setPropertyBool("checkable", b);
    }

    @Override
    public void setDragType(int dragType) {
        this.propertySupport.setPropertyInt("dragType", dragType);
    }

    @Override
    public int getDragType() {
        return this.propertySupport.getPropertyInt("dragType");
    }

    @Override
    public void setDropType(int dropType) {
        this.propertySupport.setPropertyInt("dropType", dropType);
    }

    @Override
    public int getDropType() {
        return this.propertySupport.getPropertyInt("dropType");
    }

    @Override
    public boolean isMultilineText() {
        return this.propertySupport.getPropertyBool("multilineText");
    }

    @Override
    public void setMultilineText(boolean on) {
        this.propertySupport.setPropertyBool("multilineText", on);
    }

    @Override
    public int getRowHeightHint() {
        return this.propertySupport.getPropertyInt("rowHeightHint");
    }

    @Override
    public void setRowHeightHint(int h) {
        this.propertySupport.setPropertyInt("rowHeightHint", h);
    }

    @Override
    public boolean isInitialMultilineText() {
        return this.m_initialMultiLineText;
    }

    @Override
    public void setInitialMultilineText(boolean on) {
        this.m_initialMultiLineText = on;
    }

    @Override
    public boolean hasKeyboardNavigation() {
        return this.propertySupport.getPropertyBool("keyboardNavigation");
    }

    @Override
    public void setKeyboardNavigation(boolean on) {
        this.propertySupport.setPropertyBool("keyboardNavigation", on);
    }

    @Override
    public boolean isMultiSelect() {
        return this.propertySupport.getPropertyBool("multiSelect");
    }

    @Override
    public void setMultiSelect(boolean b) {
        this.propertySupport.setPropertyBool("multiSelect", b);
    }

    @Override
    public boolean isMultiCheck() {
        return this.propertySupport.getPropertyBool("multiCheck");
    }

    @Override
    public void setMultiCheck(boolean b) {
        this.propertySupport.setPropertyBool("multiCheck", b);
    }

    @Override
    public IBooleanColumn getCheckableColumn() {
        return this.m_checkableColumn;
    }

    @Override
    public void setCheckableColumn(IBooleanColumn checkableColumn) {
        this.m_checkableColumn = checkableColumn;
    }

    @Override
    public boolean isAutoDiscardOnDelete() {
        return this.m_autoDiscardOnDelete;
    }

    @Override
    public void setAutoDiscardOnDelete(boolean on) {
        this.m_autoDiscardOnDelete = on;
    }

    @Override
    public boolean isTableInitialized() {
        return this.m_initialized;
    }

    @Override
    public boolean isTableChanging() {
        return this.m_tableChanging > 0;
    }

    @Override
    public void setTableChanging(boolean b) {
        if (b) {
            ++this.m_tableChanging;
            if (this.m_tableChanging == 1) {
                this.propertySupport.setPropertiesChanging(true);
            }
        } else if (this.m_tableChanging > 0) {
            Throwable saveEx;
            block17: {
                saveEx = null;
                if (this.m_tableChanging == 1) {
                    try {
                        this.processDecorationBuffer();
                        if (!this.m_sortValid) {
                            this.sort();
                        }
                    }
                    catch (Throwable t) {
                        saveEx = t;
                    }
                }
                --this.m_tableChanging;
                if (this.m_tableChanging == 0) {
                    block16: {
                        try {
                            this.processEventBuffer();
                        }
                        catch (Throwable t) {
                            if (saveEx != null) break block16;
                            saveEx = t;
                        }
                    }
                    try {
                        this.propertySupport.setPropertiesChanging(false);
                    }
                    catch (Throwable t) {
                        if (saveEx != null) break block17;
                        saveEx = t;
                    }
                }
            }
            if (saveEx == null) {
                return;
            }
            if (saveEx instanceof RuntimeException) {
                throw (RuntimeException)saveEx;
            }
            if (saveEx instanceof Error) {
                throw (Error)saveEx;
            }
        }
    }

    @Override
    public List<IKeyStroke> getKeyStrokes() {
        return CollectionUtility.arrayList((Collection)this.propertySupport.getPropertyList("keyStroks"));
    }

    @Override
    public void setKeyStrokes(List<? extends IKeyStroke> keyStrokes0) {
        this.propertySupport.setPropertyList("keyStroks", (List)CollectionUtility.arrayListWithoutNullElements(keyStrokes0));
    }

    @Override
    public void requestFocus() {
        this.fireRequestFocus();
    }

    @Override
    public void requestFocusInCell(IColumn<?> column, ITableRow row) {
        if (this.isCellEditable(row, column)) {
            this.fireRequestFocusInCell(column, row);
        }
    }

    @Override
    public ITableRowDataMapper createTableRowDataMapper(Class<? extends AbstractTableRowData> rowType) throws ProcessingException {
        return this.execCreateTableRowDataMapper(rowType);
    }

    @ConfigOperation
    @Order(value=130.0)
    protected ITableRowDataMapper execCreateTableRowDataMapper(Class<? extends AbstractTableRowData> rowType) throws ProcessingException {
        return new TableRowDataMapper(rowType, this.getColumnSet());
    }

    @Override
    public void exportToTableBeanData(AbstractTableFieldBeanData target) throws ProcessingException {
        AbstractTableRowData rowData;
        ITableRowDataMapper rowMapper = this.createTableRowDataMapper(target.getRowType());
        int i = 0;
        int ni = this.getRowCount();
        while (i < ni) {
            ITableRow row = this.getRow(i);
            if (rowMapper.acceptExport(row)) {
                rowData = target.addRow();
                rowMapper.exportTableRowData(row, rowData);
            }
            ++i;
        }
        List<ITableRow> deletedRows = this.getDeletedRows();
        for (ITableRow delRow : deletedRows) {
            if (!rowMapper.acceptExport(delRow)) continue;
            rowData = target.addRow();
            rowMapper.exportTableRowData(delRow, rowData);
            rowData.setRowState(3);
        }
    }

    @Override
    public void importFromTableBeanData(AbstractTableFieldBeanData source) throws ProcessingException {
        this.importFromTableRowBeanData(CollectionUtility.arrayList((Object[])source.getRows()), source.getRowType());
    }

    public void importFromTableRowBeanData(List<? extends AbstractTableRowData> rowDatas, Class<? extends AbstractTableRowData> rowType) throws ProcessingException {
        TableRow newTableRow;
        AbstractTableRowData rowData;
        this.discardAllDeletedRows();
        this.clearValidatedValuesOnAllColumns();
        this.clearAllRowsValidity();
        int deleteCount = 0;
        ArrayList<TableRow> newRows = new ArrayList<TableRow>();
        ITableRowDataMapper mapper = this.createTableRowDataMapper(rowType);
        int i = 0;
        int ni = rowDatas.size();
        while (i < ni) {
            rowData = rowDatas.get(i);
            if (rowData.getRowState() != 3 && mapper.acceptImport(rowData)) {
                newTableRow = new TableRow(this.getColumnSet());
                mapper.importTableRowData(newTableRow, rowData);
                newRows.add(newTableRow);
            } else {
                ++deleteCount;
            }
            ++i;
        }
        this.replaceRows(newRows);
        if (deleteCount > 0) {
            try {
                this.setTableChanging(true);
                i = 0;
                ni = rowDatas.size();
                while (i < ni) {
                    rowData = rowDatas.get(i);
                    if (rowData.getRowState() == 3 && mapper.acceptImport(rowData)) {
                        newTableRow = new TableRow(this.getColumnSet());
                        mapper.importTableRowData(newTableRow, rowData);
                        newTableRow.setStatus(0);
                        ITableRow addedRow = this.addRow(newTableRow);
                        this.deleteRow(addedRow);
                    }
                    ++i;
                }
            }
            finally {
                this.setTableChanging(false);
            }
        }
    }

    @Override
    public void extractTableData(AbstractTableFieldData target) throws ProcessingException {
        int i = 0;
        int ni = this.getRowCount();
        while (i < ni) {
            ITableRow row = this.getRow(i);
            int newRowIndex = target.addRow();
            int j = 0;
            int nj = row.getCellCount();
            while (j < nj) {
                target.setValueAt(newRowIndex, j, row.getCellValue(j));
                ++j;
            }
            target.setRowState(newRowIndex, row.getStatus());
            ++i;
        }
        for (ITableRow delRow : this.getDeletedRows()) {
            int newRowIndex = target.addRow();
            int j = 0;
            int nj = delRow.getCellCount();
            while (j < nj) {
                target.setValueAt(newRowIndex, j, delRow.getCellValue(j));
                ++j;
            }
            target.setRowState(newRowIndex, 3);
        }
        target.setValueSet(true);
    }

    @Override
    public void updateTable(AbstractTableFieldData source) throws ProcessingException {
        if (source.isValueSet()) {
            int nj;
            TableRow newTableRow;
            int importState;
            this.clearValidatedValuesOnAllColumns();
            this.clearAllRowsValidity();
            this.discardAllDeletedRows();
            int deleteCount = 0;
            ArrayList<TableRow> newRows = new ArrayList<TableRow>();
            int i = 0;
            int ni = source.getRowCount();
            while (i < ni) {
                importState = source.getRowState(i);
                if (importState != 3) {
                    newTableRow = new TableRow(this.getColumnSet());
                    int j = 0;
                    nj = source.getColumnCount();
                    while (j < nj) {
                        if (j < this.getColumnCount()) {
                            this.getColumnSet().getColumn(j).setValue(newTableRow, source.getValueAt(i, j));
                        } else {
                            newTableRow.setCellValue(j, source.getValueAt(i, j));
                        }
                        ++j;
                    }
                    newTableRow.setStatus(importState);
                    newRows.add(newTableRow);
                } else {
                    ++deleteCount;
                }
                ++i;
            }
            this.replaceRows(newRows);
            if (deleteCount > 0) {
                try {
                    this.setTableChanging(true);
                    i = 0;
                    ni = source.getRowCount();
                    while (i < ni) {
                        importState = source.getRowState(i);
                        if (importState == 3) {
                            newTableRow = new TableRow(this.getColumnSet());
                            int j = 0;
                            nj = source.getColumnCount();
                            while (j < nj) {
                                if (j < this.getColumnCount()) {
                                    this.getColumnSet().getColumn(j).setValue(newTableRow, source.getValueAt(i, j));
                                } else {
                                    newTableRow.setCellValue(j, source.getValueAt(i, j));
                                }
                                ++j;
                            }
                            newTableRow.setStatus(0);
                            ITableRow addedRow = this.addRow(newTableRow);
                            this.deleteRow(addedRow);
                        }
                        ++i;
                    }
                }
                finally {
                    this.setTableChanging(false);
                }
            }
        }
    }

    @Override
    public void setMenus(List<? extends IMenu> menus) {
        this.getContextMenu().setChildActions(menus);
    }

    @Override
    public void addMenu(IMenu menu) {
        List<IMenu> menus = this.getMenus();
        menus.add(menu);
        this.setMenus(menus);
    }

    protected void setContextMenu(ITableContextMenu contextMenu) {
        this.propertySupport.setProperty("contextMenus", (Object)contextMenu);
    }

    @Override
    public ITableContextMenu getContextMenu() {
        return (ITableContextMenu)this.propertySupport.getProperty("contextMenus");
    }

    @Override
    public List<IMenu> getMenus() {
        return this.getContextMenu().getChildActions();
    }

    @Override
    public <T extends IMenu> T getMenu(final Class<T> menuType) throws ProcessingException {
        ITableContextMenu contextMenu = this.getContextMenu();
        if (contextMenu != null) {
            final Holder resultHolder = new Holder();
            contextMenu.acceptVisitor(new IActionVisitor(){

                @Override
                public int visit(IAction action) {
                    if (menuType.isAssignableFrom(action.getClass())) {
                        resultHolder.setValue((Object)((IMenu)action));
                        return 0;
                    }
                    return 1;
                }
            });
            return (T)((IMenu)resultHolder.getValue());
        }
        return null;
    }

    @Override
    public boolean runMenu(Class<? extends IMenu> menuType) throws ProcessingException {
        Class<? extends IMenu> c = this.getReplacingMenuClass(menuType);
        for (IMenu m : this.getMenus()) {
            if (m.getClass() != c) continue;
            if (!m.isEnabledProcessingAction()) {
                return false;
            }
            if (m.isInheritAccessibility() && !this.isEnabled()) continue;
            m.prepareAction();
            m.aboutToShow();
            if (m.isVisible() && m.isEnabled()) {
                m.doAction();
                return true;
            }
            return false;
        }
        return false;
    }

    private <T extends IMenu> Class<? extends T> getReplacingMenuClass(Class<T> c) {
        Class<? extends IMenu> replacingMenuClass;
        if (this.m_menuReplacementMapping != null && (replacingMenuClass = this.m_menuReplacementMapping.get(c)) != null) {
            return replacingMenuClass;
        }
        return c;
    }

    protected ITableColumnFilterManager createColumnFilterManager() {
        return new DefaultTableColumnFilterManager(this);
    }

    protected ITableCustomizer createTableCustomizer() {
        return null;
    }

    public ITableRow createRow() throws ProcessingException {
        return new P_TableRowBuilder().createRow();
    }

    public ITableRow createRow(Object rowValues) throws ProcessingException {
        return new P_TableRowBuilder().createRow(rowValues);
    }

    public List<ITableRow> createRowsByArray(Object dataArray) throws ProcessingException {
        return new P_TableRowBuilder().createRowsByArray(dataArray);
    }

    public List<ITableRow> createRowsByArray(Object dataArray, int rowStatus) throws ProcessingException {
        return new P_TableRowBuilder().createRowsByArray(dataArray, rowStatus);
    }

    public List<ITableRow> createRowsByMatrix(Object dataMatrixOrReference) throws ProcessingException {
        return new P_TableRowBuilder().createRowsByMatrix(dataMatrixOrReference);
    }

    public List<ITableRow> createRowsByMatrix(Object dataMatrixOrReference, int rowStatus) throws ProcessingException {
        return new P_TableRowBuilder().createRowsByMatrix(dataMatrixOrReference, rowStatus);
    }

    public List<ITableRow> createRowsByCodes(Collection<? extends ICode<?>> codes) throws ProcessingException {
        return new P_TableRowBuilder().createRowsByCodes(codes);
    }

    @Override
    public void replaceRowsByMatrix(Object dataMatrixOrReference) throws ProcessingException {
        this.replaceRows(this.createRowsByMatrix(dataMatrixOrReference));
    }

    @Override
    public void replaceRowsByArray(Object dataArray) throws ProcessingException {
        this.replaceRows(this.createRowsByArray(dataArray));
    }

    @Override
    public void replaceRows(List<? extends ITableRow> newRows) throws ProcessingException {
        if (this.isAutoDiscardOnDelete()) {
            this.replaceRowsCase1(newRows);
        } else {
            this.replaceRowsCase2(newRows);
        }
    }

    private void replaceRowsCase1(List<? extends ITableRow> newRows) throws ProcessingException {
        try {
            this.setTableChanging(true);
            ArrayList<CompositeObject> selectedKeys = new ArrayList<CompositeObject>();
            for (ITableRow r : this.getSelectedRows()) {
                selectedKeys.add(new CompositeObject(new Object[]{this.getRowKeys(r)}));
            }
            this.discardAllRows();
            this.addRows(newRows, false);
            ArrayList<ITableRow> selectedRows = new ArrayList<ITableRow>();
            if (selectedKeys.size() > 0) {
                for (ITableRow r : this.m_rows) {
                    if (!selectedKeys.remove(new CompositeObject(new Object[]{this.getRowKeys(r)}))) continue;
                    selectedRows.add(r);
                    if (selectedKeys.size() == 0) break;
                }
            }
            this.selectRows(selectedRows, false);
        }
        finally {
            this.setTableChanging(false);
        }
    }

    private void replaceRowsCase2(List<? extends ITableRow> newRows) throws ProcessingException {
        try {
            this.setTableChanging(true);
            int[] oldToNew = new int[this.getRowCount()];
            int[] newToOld = new int[newRows.size()];
            Arrays.fill(oldToNew, -1);
            Arrays.fill(newToOld, -1);
            HashMap<CompositeObject, Integer> newRowIndexMap = new HashMap<CompositeObject, Integer>();
            int i = newRows.size() - 1;
            while (i >= 0) {
                newRowIndexMap.put(new CompositeObject(new Object[]{this.getRowKeys(newRows.get(i))}), i);
                --i;
            }
            int mappedCount = 0;
            int i2 = 0;
            int ni = this.getRowCount();
            while (i2 < ni) {
                ITableRow existingRow = this.m_rows.get(i2);
                Integer newIndex = (Integer)newRowIndexMap.remove(new CompositeObject(new Object[]{this.getRowKeys(existingRow)}));
                if (newIndex != null) {
                    oldToNew[i2] = newIndex;
                    newToOld[newIndex.intValue()] = i2;
                    ++mappedCount;
                }
                ++i2;
            }
            ArrayList<ITableRow> updatedRows = new ArrayList<ITableRow>(mappedCount);
            int i3 = 0;
            while (i3 < oldToNew.length) {
                if (oldToNew[i3] >= 0) {
                    ITableRow oldRow = this.getRow(i3);
                    ITableRow newRow = newRows.get(oldToNew[i3]);
                    try {
                        oldRow.setRowChanging(true);
                        oldRow.setEnabled(newRow.isEnabled());
                        oldRow.setStatus(newRow.getStatus());
                        int columnIndex = 0;
                        while (columnIndex < this.getColumnCount()) {
                            if (columnIndex < newRow.getCellCount()) {
                                oldRow.getCellForUpdate(columnIndex).updateFrom(newRow.getCell(columnIndex));
                            } else {
                                oldRow.getCellForUpdate(columnIndex).setText(null);
                                oldRow.getCellForUpdate(columnIndex).setValue(null);
                            }
                            ++columnIndex;
                        }
                    }
                    finally {
                        oldRow.setRowPropertiesChanged(false);
                        oldRow.setRowChanging(false);
                    }
                    updatedRows.add(oldRow);
                }
                ++i3;
            }
            ArrayList<ITableRow> deletedRows = new ArrayList<ITableRow>(this.getRowCount() - mappedCount);
            int i4 = 0;
            while (i4 < oldToNew.length) {
                if (oldToNew[i4] < 0) {
                    deletedRows.add(this.m_rows.get(i4));
                }
                ++i4;
            }
            ArrayList<ITableRow> insertedRows = new ArrayList<ITableRow>(newRows.size() - mappedCount);
            int[] insertedRowIndexes = new int[newRows.size() - mappedCount];
            int index = 0;
            int i5 = 0;
            while (i5 < newToOld.length) {
                if (newToOld[i5] < 0) {
                    insertedRows.add(newRows.get(i5));
                    insertedRowIndexes[index] = i5;
                    ++index;
                }
                ++i5;
            }
            this.updateRows(updatedRows);
            this.deleteRows(deletedRows);
            this.addRows(insertedRows, false, insertedRowIndexes);
        }
        finally {
            this.setTableChanging(false);
        }
    }

    @Override
    public void updateRow(ITableRow row) {
        if (row != null) {
            this.updateRows(CollectionUtility.arrayList((Object)row));
        }
    }

    @Override
    public void updateAllRows() {
        this.updateRows(this.getRows());
    }

    @Override
    public void setRowState(ITableRow row, int rowState) throws ProcessingException {
        this.setRowState(CollectionUtility.arrayList((Object)row), rowState);
    }

    @Override
    public void setAllRowState(int rowState) throws ProcessingException {
        this.setRowState(this.getRows(), rowState);
    }

    @Override
    public void setRowState(Collection<? extends ITableRow> rows, int rowState) throws ProcessingException {
        try {
            this.setTableChanging(true);
            for (ITableRow iTableRow : rows) {
                iTableRow.setStatus(rowState);
            }
        }
        finally {
            this.setTableChanging(false);
        }
    }

    @Override
    public void updateRows(Collection<? extends ITableRow> rows) {
        try {
            this.setTableChanging(true);
            ArrayList<ITableRow> resolvedRowList = new ArrayList<ITableRow>(rows.size());
            for (ITableRow iTableRow : rows) {
                ITableRow resolvedRow = this.resolveRow(iTableRow);
                if (resolvedRow == null) continue;
                resolvedRowList.add(resolvedRow);
                this.updateRowImpl(resolvedRow);
            }
            if (resolvedRowList.size() > 0) {
                this.fireRowsUpdated(resolvedRowList);
            }
            if (this.getColumnSet().getSortColumnCount() > 0) {
                if (this.isTableChanging()) {
                    this.m_sortValid = false;
                } else {
                    this.sort();
                }
            }
        }
        finally {
            this.setTableChanging(false);
        }
    }

    private void updateRowImpl(ITableRow row) {
        if (row != null) {
            for (IColumn<?> col : this.getColumns()) {
                if (!(col instanceof AbstractColumn)) continue;
                ((AbstractColumn)col).validateColumnValue(row);
            }
            this.enqueueDecorationTasks(row);
        }
    }

    @Override
    public int getRowCount() {
        return this.m_rows.size();
    }

    @Override
    public int getDeletedRowCount() {
        return this.m_deletedRows.size();
    }

    @Override
    public int getSelectedRowCount() {
        return this.m_selectedRows.size();
    }

    @Override
    public ITableRow getSelectedRow() {
        return (ITableRow)CollectionUtility.firstElement(this.m_selectedRows);
    }

    @Override
    public List<ITableRow> getSelectedRows() {
        return CollectionUtility.arrayList(this.m_selectedRows);
    }

    @Override
    public boolean isSelectedRow(ITableRow row) {
        if ((row = this.resolveRow(row)) == null) {
            return false;
        }
        return this.m_selectedRows.contains(row);
    }

    @Override
    public void selectRow(int rowIndex) {
        this.selectRow(this.getRow(rowIndex));
    }

    @Override
    public void selectRow(ITableRow row) {
        this.selectRow(row, false);
    }

    @Override
    public void selectRow(ITableRow row, boolean append) {
        this.selectRows(CollectionUtility.arrayList((Object)row), append);
    }

    @Override
    public void selectRows(List<? extends ITableRow> rows) {
        this.selectRows(rows, false);
    }

    @Override
    public void selectRows(List<? extends ITableRow> rows, boolean append) {
        rows = this.resolveRows(rows);
        TreeSet<ITableRow> newSelection = new TreeSet<ITableRow>(new RowIndexComparator());
        if (append) {
            newSelection.addAll(this.m_selectedRows);
            newSelection.addAll(rows);
        } else {
            newSelection.addAll(rows);
        }
        if (newSelection.size() > 1 && !this.isMultiSelect()) {
            ITableRow first = newSelection.first();
            newSelection.clear();
            newSelection.add(first);
        }
        if (!CollectionUtility.equalsCollection(this.m_selectedRows, newSelection, (boolean)true)) {
            this.m_selectedRows = new ArrayList<ITableRow>(newSelection);
            ArrayList notificationCopy = CollectionUtility.arrayList(this.m_selectedRows);
            this.fireRowsSelected(notificationCopy);
        }
    }

    @Override
    public void selectFirstRow() {
        this.selectRow(this.getRow(0));
    }

    @Override
    public void selectNextRow() {
        ITableRow row = this.getSelectedRow();
        if (row != null && row.getRowIndex() + 1 < this.getRowCount()) {
            this.selectRow(this.getRow(row.getRowIndex() + 1));
        } else if (row == null && this.getRowCount() > 0) {
            this.selectRow(0);
        }
    }

    @Override
    public void selectPreviousRow() {
        ITableRow row = this.getSelectedRow();
        if (row != null && row.getRowIndex() - 1 >= 0) {
            this.selectRow(this.getRow(row.getRowIndex() - 1));
        } else if (row == null && this.getRowCount() > 0) {
            this.selectRow(this.getRowCount() - 1);
        }
    }

    @Override
    public void selectLastRow() {
        this.selectRow(this.getRow(this.getRowCount() - 1));
    }

    @Override
    public void deselectRow(ITableRow row) {
        if (row != null) {
            this.deselectRows(CollectionUtility.arrayList((Object)row));
        }
    }

    @Override
    public void deselectRows(List<? extends ITableRow> rows) {
        if (CollectionUtility.hasElements(rows = this.resolveRows(rows))) {
            TreeSet<ITableRow> newSelection = new TreeSet<ITableRow>(new RowIndexComparator());
            newSelection.addAll(this.m_selectedRows);
            if (newSelection.removeAll(rows)) {
                this.m_selectedRows = new ArrayList<ITableRow>(newSelection);
                this.fireRowsSelected(this.m_selectedRows);
            }
        }
    }

    @Override
    public void selectAllRows() {
        this.selectRows(this.getRows(), false);
    }

    @Override
    public void deselectAllRows() {
        this.selectRow(null, false);
    }

    @Override
    public void selectAllEnabledRows() {
        ArrayList<ITableRow> newList = new ArrayList<ITableRow>();
        int i = 0;
        int ni = this.getRowCount();
        while (i < ni) {
            ITableRow row = this.getRow(i);
            if (row.isEnabled()) {
                newList.add(row);
            } else if (this.isSelectedRow(row)) {
                newList.add(row);
            }
            ++i;
        }
        this.selectRows(newList, false);
    }

    @Override
    public void deselectAllEnabledRows() {
        List<ITableRow> selectedRows = this.getSelectedRows();
        ArrayList<ITableRow> newList = new ArrayList<ITableRow>();
        for (ITableRow selectedRow : selectedRows) {
            if (!selectedRow.isEnabled()) continue;
            newList.add(selectedRow);
        }
        this.deselectRows(newList);
    }

    @Override
    public Collection<ITableRow> getCheckedRows() {
        ArrayList<ITableRow> checkedRows = new ArrayList<ITableRow>();
        for (ITableRow row : this.getRows()) {
            if (!row.isChecked()) continue;
            checkedRows.add(row);
        }
        return checkedRows;
    }

    @Override
    public void checkRow(int row, boolean value) throws ProcessingException {
        this.checkRow(this.getRow(row), value);
    }

    @Override
    public void checkRow(ITableRow row, boolean value) throws ProcessingException {
        if (!row.isEnabled()) {
            return;
        }
        if (!this.isMultiCheck() && value && this.getCheckedRows().size() > 0) {
            this.uncheckAllRows();
        }
        row.setChecked(value);
        if (this.getCheckableColumn() != null) {
            this.getCheckableColumn().setValue(row, Boolean.valueOf(value));
        }
    }

    @Override
    public void checkRows(Collection<? extends ITableRow> rows, boolean value) throws ProcessingException {
        if ((rows = this.resolveRows(rows)).size() > 1 && !this.isMultiCheck()) {
            ITableRow iTableRow = (ITableRow)CollectionUtility.firstElement(rows);
            iTableRow.setChecked(value);
        } else {
            for (ITableRow iTableRow : rows) {
                this.checkRow(iTableRow, value);
            }
        }
    }

    @Override
    public void checkAllRows() throws ProcessingException {
        try {
            this.setTableChanging(true);
            int i = 0;
            while (i < this.getRowCount()) {
                this.checkRow(i, true);
                ++i;
            }
        }
        finally {
            this.setTableChanging(false);
        }
    }

    @Override
    public void uncheckAllRows() throws ProcessingException {
        try {
            this.setTableChanging(true);
            int i = 0;
            while (i < this.getRowCount()) {
                this.checkRow(i, false);
                ++i;
            }
        }
        finally {
            this.setTableChanging(false);
        }
    }

    @Override
    public String getDefaultIconId() {
        String iconId = this.propertySupport.getPropertyString("defaultIcon");
        if (iconId != null && iconId.length() == 0) {
            iconId = null;
        }
        return iconId;
    }

    @Override
    public void setDefaultIconId(String iconId) {
        this.propertySupport.setPropertyString("defaultIcon", iconId);
    }

    @Override
    public boolean isEnabled() {
        return this.propertySupport.getPropertyBool("enabled");
    }

    @Override
    public final void setEnabled(boolean b) {
        boolean changed = this.propertySupport.setPropertyBool("enabled", b);
        if (changed) {
            try {
                this.setTableChanging(true);
                for (ITableRow row : this.getRows()) {
                    this.enqueueDecorationTasks(row);
                }
            }
            finally {
                this.setTableChanging(false);
            }
        }
    }

    @Override
    public boolean isScrollToSelection() {
        return this.propertySupport.getPropertyBool("scrollToSelection");
    }

    @Override
    public void setScrollToSelection(boolean b) {
        this.propertySupport.setPropertyBool("scrollToSelection", b);
    }

    @Override
    public void scrollToSelection() {
        this.fireTableEventInternal(new TableEvent(this, 830));
    }

    @Override
    public ITableRow getRow(int rowIndex) {
        return (ITableRow)CollectionUtility.getElement(this.getRows(), (int)rowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ITableRow> getRows() {
        Object object = this.m_cachedRowsLock;
        synchronized (object) {
            if (this.m_cachedRows == null) {
                this.m_cachedRows = CollectionUtility.arrayList(this.m_rows);
            }
            return this.m_cachedRows;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ITableRow> getFilteredRows() {
        List<ITableRow> rows = this.getRows();
        if (this.m_rowFilters.size() > 0) {
            Object object = this.m_cachedFilteredRowsLock;
            synchronized (object) {
                if (this.m_cachedFilteredRows == null) {
                    if (this.m_rowFilters.size() > 0) {
                        ArrayList<ITableRow> filteredRows = new ArrayList<ITableRow>(this.getRowCount());
                        for (ITableRow row : rows) {
                            if (row == null || !row.isFilterAccepted()) continue;
                            filteredRows.add(row);
                        }
                        this.m_cachedFilteredRows = filteredRows;
                    } else {
                        this.m_cachedFilteredRows = CollectionUtility.emptyArrayList();
                    }
                }
                return this.m_cachedFilteredRows;
            }
        }
        return rows;
    }

    @Override
    public int getFilteredRowCount() {
        if (this.m_rowFilters.size() > 0) {
            return this.getFilteredRows().size();
        }
        return this.getRowCount();
    }

    @Override
    public ITableRow getFilteredRow(int index) {
        if (this.m_rowFilters.size() > 0) {
            ITableRow row = null;
            List<ITableRow> filteredRows = this.getFilteredRows();
            if (index >= 0 && index < filteredRows.size()) {
                row = filteredRows.get(index);
            }
            return row;
        }
        return this.getRow(index);
    }

    @Override
    public int getFilteredRowIndex(ITableRow row) {
        return this.getFilteredRows().indexOf(row);
    }

    @Override
    public List<ITableRow> getNotDeletedRows() {
        ArrayList<ITableRow> notDeletedRows = new ArrayList<ITableRow>();
        for (ITableRow row : this.getRows()) {
            if (row.getStatus() == 3) continue;
            notDeletedRows.add(row);
        }
        return notDeletedRows;
    }

    @Override
    public int getNotDeletedRowCount() {
        return this.getNotDeletedRows().size();
    }

    @Override
    public Object[][] getTableData() {
        Object[][] data = new Object[this.getRowCount()][this.getColumnCount()];
        int r = 0;
        while (r < this.getRowCount()) {
            int c = 0;
            while (c < this.getColumnCount()) {
                data[r][c] = this.getRow(r).getCellValue(c);
                ++c;
            }
            ++r;
        }
        return data;
    }

    @Override
    public Object[][] exportTableRowsAsCSV(List<? extends ITableRow> rows, List<? extends IColumn> columns, boolean includeLineForColumnNames, boolean includeLineForColumnTypes, boolean includeLineForColumnFormat) {
        return TableUtility.exportRowsAsCSV(rows, columns, includeLineForColumnNames, includeLineForColumnTypes, includeLineForColumnFormat);
    }

    @Override
    public List<ITableRow> getRows(int[] rowIndexes) {
        if (rowIndexes == null) {
            return CollectionUtility.emptyArrayList();
        }
        ArrayList<ITableRow> result = new ArrayList<ITableRow>(rowIndexes.length);
        int[] nArray = rowIndexes;
        int n = rowIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            int rowIndex = nArray[n2];
            ITableRow row = this.getRow(rowIndex);
            if (row != null) {
                result.add(row);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public List<ITableRow> getDeletedRows() {
        return CollectionUtility.arrayList(this.m_deletedRows.values());
    }

    @Override
    public int getInsertedRowCount() {
        int count = 0;
        for (ITableRow row : this.getRows()) {
            if (row.getStatus() != 1) continue;
            ++count;
        }
        return count;
    }

    @Override
    public List<ITableRow> getInsertedRows() {
        ArrayList<ITableRow> rowList = new ArrayList<ITableRow>();
        for (ITableRow row : this.getRows()) {
            if (row.getStatus() != 1) continue;
            rowList.add(row);
        }
        return rowList;
    }

    @Override
    public int getUpdatedRowCount() {
        int count = 0;
        for (ITableRow row : this.getRows()) {
            if (row.getStatus() != 2) continue;
            ++count;
        }
        return count;
    }

    @Override
    public List<ITableRow> getUpdatedRows() {
        ArrayList<ITableRow> rowList = new ArrayList<ITableRow>();
        for (ITableRow row : this.getRows()) {
            if (row.getStatus() != 2) continue;
            rowList.add(row);
        }
        return rowList;
    }

    @Override
    public ITableRow addRowByArray(Object dataArray) throws ProcessingException {
        if (dataArray == null) {
            return null;
        }
        List<ITableRow> result = this.addRowsByMatrix(new Object[]{dataArray});
        return (ITableRow)CollectionUtility.firstElement(result);
    }

    @Override
    public List<ITableRow> addRowsByMatrix(Object dataMatrix) throws ProcessingException {
        return this.addRowsByMatrix(dataMatrix, 1);
    }

    @Override
    public List<ITableRow> addRowsByMatrix(Object dataMatrix, int rowStatus) throws ProcessingException {
        return this.addRows(this.createRowsByMatrix(dataMatrix, rowStatus));
    }

    @Override
    public List<ITableRow> addRowsByArray(Object dataArray) throws ProcessingException {
        return this.addRowsByArray(dataArray, 1);
    }

    @Override
    public List<ITableRow> addRowsByArray(Object dataArray, int rowStatus) throws ProcessingException {
        return this.addRows(this.createRowsByArray(dataArray, rowStatus));
    }

    @Override
    public ITableRow addRow(ITableRow newRow) throws ProcessingException {
        return this.addRow(newRow, false);
    }

    @Override
    public ITableRow addRow(ITableRow newRow, boolean markAsInserted) throws ProcessingException {
        List<ITableRow> addedRows = this.addRows(CollectionUtility.arrayList((Object)newRow), markAsInserted);
        return (ITableRow)CollectionUtility.firstElement(addedRows);
    }

    @Override
    public List<ITableRow> addRows(List<? extends ITableRow> newRows) throws ProcessingException {
        return this.addRows(newRows, false);
    }

    @Override
    public List<ITableRow> addRows(List<? extends ITableRow> newRows, boolean markAsInserted) throws ProcessingException {
        return this.addRows(newRows, markAsInserted, null);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public List<ITableRow> addRows(List<? extends ITableRow> newRows, boolean markAsInserted, int[] insertIndexes) throws ProcessingException {
        if (newRows == null) {
            return CollectionUtility.emptyArrayList();
        }
        try {
            block13: {
                block12: {
                    this.setTableChanging(true);
                    oldRowCount = this.m_rows.size();
                    newIRows = new ArrayList<ITableRow>(newRows.size());
                    for (ITableRow newRow : newRows) {
                        newIRows.add(this.addRowImpl(newRow, markAsInserted));
                    }
                    this.fireRowsInserted(newIRows);
                    if (this.getColumnSet().getSortColumnCount() <= 0) break block12;
                    if (this.isTableChanging()) {
                        this.m_sortValid = false;
                    } else {
                        this.sort();
                    }
                    break block13;
                }
                if (insertIndexes == null) break block13;
                sortArray = new ITableRow[this.m_rows.size()];
                i = 0;
                while (i < insertIndexes.length) {
                    sortArray[insertIndexes[i]] = (ITableRow)newIRows.get(i);
                    ++i;
                }
                sortArrayIndex = 0;
                i = 0;
                ** GOTO lbl34
                {
                    ++sortArrayIndex;
                    do {
                        if (sortArray[sortArrayIndex] != null) continue block5;
                        sortArray[sortArrayIndex] = this.m_rows.get(i);
                        ++i;
lbl34:
                        // 2 sources

                    } while (i < oldRowCount);
                }
                i = insertIndexes.length;
                ** GOTO lbl42
                {
                    ++sortArrayIndex;
                    do {
                        if (sortArray[sortArrayIndex] != null) continue block7;
                        sortArray[sortArrayIndex] = (ITableRow)newIRows.get(i);
                        ++i;
lbl42:
                        // 2 sources

                    } while (i < newIRows.size());
                }
                this.sortInternal(Arrays.asList(sortArray));
            }
            var10_10 = newIRows;
            return var10_10;
        }
        finally {
            this.setTableChanging(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITableRow addRowImpl(ITableRow newRow, boolean markAsInserted) throws ProcessingException {
        if (markAsInserted) {
            newRow.setStatus(1);
        }
        InternalTableRow newIRow = new InternalTableRow(this, newRow);
        for (IColumn<?> col : this.getColumns()) {
            if (!(col instanceof AbstractColumn)) continue;
            ((AbstractColumn)col).validateColumnValue(newIRow);
        }
        this.wasEverValid(newIRow);
        Object object = this.m_cachedRowsLock;
        synchronized (object) {
            this.m_cachedRows = null;
            int newIndex = this.m_rows.size();
            newIRow.setRowIndex(newIndex);
            newIRow.setTableInternal(this);
            this.m_rows.add(newIRow);
        }
        this.enqueueDecorationTasks(newIRow);
        return newIRow;
    }

    @Override
    public void moveRow(int sourceIndex, int targetIndex) {
        this.moveRowImpl(sourceIndex, targetIndex);
    }

    @Override
    public void moveRowBefore(ITableRow movingRow, ITableRow targetRow) {
        movingRow = this.resolveRow(movingRow);
        targetRow = this.resolveRow(targetRow);
        if (movingRow != null && targetRow != null) {
            this.moveRowImpl(movingRow.getRowIndex(), targetRow.getRowIndex());
        }
    }

    @Override
    public void moveRowAfter(ITableRow movingRow, ITableRow targetRow) {
        movingRow = this.resolveRow(movingRow);
        targetRow = this.resolveRow(targetRow);
        if (movingRow != null && targetRow != null) {
            this.moveRowImpl(movingRow.getRowIndex(), targetRow.getRowIndex() + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveRowImpl(int sourceIndex, int targetIndex) {
        if (sourceIndex < 0) {
            sourceIndex = 0;
        }
        if (sourceIndex >= this.getRowCount()) {
            sourceIndex = this.getRowCount() - 1;
        }
        if (targetIndex < 0) {
            targetIndex = 0;
        }
        if (targetIndex >= this.getRowCount()) {
            targetIndex = this.getRowCount() - 1;
        }
        if (targetIndex != sourceIndex) {
            Object object = this.m_cachedRowsLock;
            synchronized (object) {
                this.m_cachedRows = null;
                ITableRow row = this.m_rows.remove(sourceIndex);
                this.m_rows.add(targetIndex, row);
            }
            int min = Math.min(sourceIndex, targetIndex);
            int max = Math.max(sourceIndex, targetIndex);
            ITableRow[] changedRows = new ITableRow[max - min + 1];
            int i = min;
            while (i <= max) {
                changedRows[i - min] = this.getRow(i);
                ((InternalTableRow)changedRows[i - min]).setRowIndex(i);
                ++i;
            }
            this.fireRowOrderChanged();
            this.selectRows(this.getSelectedRows(), false);
        }
    }

    @Override
    public void deleteRow(int rowIndex) {
        this.deleteRows(new int[]{rowIndex});
    }

    @Override
    public void deleteRows(int[] rowIndexes) {
        ArrayList<ITableRow> rowList = new ArrayList<ITableRow>();
        int i = 0;
        while (i < rowIndexes.length) {
            ITableRow row = this.getRow(rowIndexes[i]);
            if (row != null) {
                rowList.add(row);
            }
            ++i;
        }
        this.deleteRows(rowList);
    }

    @Override
    public void deleteRow(ITableRow row) {
        if (row != null) {
            this.deleteRows(CollectionUtility.arrayList((Object)row));
        }
    }

    @Override
    public void deleteAllRows() {
        this.deleteRows(this.getRows());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRows(Collection<? extends ITableRow> rows) {
        List<ITableRow> existingRows = this.getRows();
        if (rows != existingRows) {
            rows = this.resolveRows(rows);
        }
        if (CollectionUtility.hasElements(rows)) {
            try {
                ITableRow candidateRow;
                int i;
                this.setTableChanging(true);
                int rowCountBefore = this.getRowCount();
                int min = this.getRowCount();
                int max = 0;
                for (ITableRow iTableRow : rows) {
                    min = Math.min(min, iTableRow.getRowIndex());
                    max = Math.max(max, iTableRow.getRowIndex());
                }
                ArrayList<? extends ITableRow> arrayList = new ArrayList<ITableRow>(rows);
                this.deselectRows(arrayList);
                if (rows == existingRows) {
                    Object object = this.m_cachedRowsLock;
                    synchronized (object) {
                        this.m_rows.clear();
                        this.m_cachedRows = null;
                    }
                    this.clearValidatedValuesOnAllColumns();
                    this.clearAllRowsValidity();
                    i = arrayList.size() - 1;
                    while (i >= 0) {
                        candidateRow = (ITableRow)arrayList.get(i);
                        if (candidateRow != null) {
                            this.deleteRowImpl(candidateRow);
                        }
                        --i;
                    }
                } else {
                    i = arrayList.size() - 1;
                    while (i >= 0) {
                        candidateRow = (ITableRow)arrayList.get(i);
                        if (candidateRow != null) {
                            boolean removed = false;
                            Object object = this.m_cachedRowsLock;
                            synchronized (object) {
                                removed = this.m_rows.remove(candidateRow);
                                if (removed) {
                                    this.m_cachedRows = null;
                                }
                            }
                            if (removed) {
                                this.clearValidatedValueOnColumns(candidateRow);
                                this.clearRowValidity(candidateRow);
                                this.deleteRowImpl(candidateRow);
                            }
                        }
                        --i;
                    }
                }
                ArrayList<ITableRow> selectionRows = new ArrayList<ITableRow>(this.getSelectedRows());
                int minAffectedIndex = Math.max(min - 1, 0);
                ITableRow[] affectedRows = new ITableRow[this.getRowCount() - minAffectedIndex];
                int i2 = minAffectedIndex;
                while (i2 < this.getRowCount()) {
                    affectedRows[i2 - minAffectedIndex] = this.getRow(i2);
                    ((InternalTableRow)affectedRows[i2 - minAffectedIndex]).setRowIndex(i2);
                    selectionRows.remove(this.getRow(i2));
                    ++i2;
                }
                if (rowCountBefore == arrayList.size()) {
                    this.fireAllRowsDeleted(arrayList);
                } else {
                    this.fireRowsDeleted(arrayList);
                }
                this.selectRows(selectionRows, false);
            }
            finally {
                this.setTableChanging(false);
            }
        }
    }

    private void deleteRowImpl(ITableRow row) {
        if (!(row instanceof InternalTableRow)) {
            return;
        }
        InternalTableRow internalRow = (InternalTableRow)row;
        if (this.isAutoDiscardOnDelete()) {
            internalRow.setTableInternal(null);
        } else if (internalRow.getStatus() == 1) {
            internalRow.setTableInternal(null);
        } else {
            internalRow.setStatus(3);
            this.m_deletedRows.put(new CompositeObject(new Object[]{this.getRowKeys(internalRow)}), internalRow);
        }
    }

    private void clearValidatedValuesOnAllColumns() {
        for (IColumn<?> column : this.getColumnSet().getColumns()) {
            if (!(column instanceof AbstractColumn)) continue;
            ((AbstractColumn)column).clearValidatedValues();
        }
    }

    private void clearValidatedValueOnColumns(ITableRow row) {
        for (IColumn<?> column : this.getColumnSet().getColumns()) {
            if (!(column instanceof AbstractColumn)) continue;
            ((AbstractColumn)column).clearValidatedValue(row);
        }
    }

    @Override
    public void discardRow(int rowIndex) {
        this.discardRows(new int[]{rowIndex});
    }

    @Override
    public void discardRows(int[] rowIndexes) {
        ArrayList<ITableRow> rowList = new ArrayList<ITableRow>();
        int[] nArray = rowIndexes;
        int n = rowIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            int rIndex = nArray[n2];
            ITableRow row = this.getRow(rIndex);
            if (row != null) {
                rowList.add(row);
            }
            ++n2;
        }
        this.discardRows(rowList);
    }

    @Override
    public void discardRow(ITableRow row) {
        if (row != null) {
            this.discardRows(CollectionUtility.arrayList((Object)row));
        }
    }

    @Override
    public void discardAllRows() {
        this.discardRows(this.getRows());
    }

    @Override
    public void discardRows(Collection<? extends ITableRow> rows) {
        try {
            this.setTableChanging(true);
            for (ITableRow iTableRow : rows) {
                ((InternalTableRow)iTableRow).setStatus(1);
            }
            this.deleteRows(rows);
        }
        finally {
            this.setTableChanging(false);
        }
    }

    @Override
    public void discardAllDeletedRows() {
        Iterator<ITableRow> it = this.m_deletedRows.values().iterator();
        while (it.hasNext()) {
            ((InternalTableRow)it.next()).setTableInternal(null);
        }
        this.m_deletedRows.clear();
    }

    @Override
    public void discardDeletedRow(ITableRow deletedRow) {
        if (deletedRow != null) {
            this.discardDeletedRows(CollectionUtility.arrayList((Object)deletedRow));
        }
    }

    @Override
    public void discardDeletedRows(Collection<? extends ITableRow> deletedRows) {
        if (deletedRows != null) {
            for (ITableRow iTableRow : deletedRows) {
                this.m_deletedRows.remove(new CompositeObject(new Object[]{this.getRowKeys(iTableRow)}));
                ((InternalTableRow)iTableRow).setTableInternal(null);
            }
        }
    }

    @Override
    public void setContextColumn(IColumn<?> col) {
        this.propertySupport.setProperty("contextColumn", col);
    }

    @Override
    public IColumn<?> getContextColumn() {
        return (IColumn)this.propertySupport.getProperty("contextColumn");
    }

    @Override
    public List<Object> getRowKeys(int rowIndex) {
        ITableRow row = this.getRow(rowIndex);
        return this.getRowKeys(row);
    }

    @Override
    public List<Object> getRowKeys(ITableRow row) {
        if (row != null) {
            return row.getKeyValues();
        }
        return CollectionUtility.emptyArrayList();
    }

    @Override
    public ITableRow findRowByKey(List<?> keys) {
        List<IColumn<?>> keyColumns = this.getColumnSet().getKeyColumns();
        if (keyColumns.size() == 0) {
            keyColumns = this.getColumnSet().getColumns();
        }
        for (ITableRow row : this.m_rows) {
            boolean match = true;
            if (CollectionUtility.hasElements(keys)) {
                int i = 0;
                while (i < keyColumns.size() && i < keys.size()) {
                    if (!CompareUtility.equals(keyColumns.get(i).getValue(row), keys.get(i))) {
                        match = false;
                        break;
                    }
                    ++i;
                }
            }
            if (!match) continue;
            return row;
        }
        return null;
    }

    @Override
    public ITableColumnFilterManager getColumnFilterManager() {
        return (ITableColumnFilterManager)this.propertySupport.getProperty("columnFilterManger");
    }

    @Override
    public void setColumnFilterManager(ITableColumnFilterManager m) {
        this.propertySupport.setProperty("columnFilterManger", (Object)m);
    }

    @Override
    public ITableCustomizer getTableCustomizer() {
        return (ITableCustomizer)this.propertySupport.getProperty("tableCustomizer");
    }

    @Override
    public void setTableCustomizer(ITableCustomizer c) {
        this.propertySupport.setProperty("tableCustomizer", (Object)c);
    }

    @Override
    public ITypeWithClassId getContainer() {
        return (ITypeWithClassId)this.propertySupport.getProperty("container");
    }

    public void setContainerInternal(ITypeWithClassId container) {
        this.propertySupport.setProperty("container", (Object)container);
    }

    @Override
    public boolean isSortEnabled() {
        return this.m_sortEnabled;
    }

    @Override
    public void setSortEnabled(boolean b) {
        this.m_sortEnabled = b;
    }

    @Override
    public void sort() {
        try {
            List<IColumn<?>> sortCols;
            if (this.isSortEnabled() && (sortCols = this.getColumnSet().getSortColumns()).size() > 0) {
                this.processDecorationBuffer();
                ArrayList<ITableRow> a = new ArrayList<ITableRow>(this.getRows());
                Collections.sort(a, new TableRowComparator(sortCols));
                this.sortInternal(a);
            }
        }
        finally {
            this.m_sortValid = true;
        }
    }

    @Override
    public void sort(List<? extends ITableRow> rowsInNewOrder) {
        List<ITableRow> resolvedRows = this.resolveRows(rowsInNewOrder);
        if (resolvedRows.size() == rowsInNewOrder.size()) {
            this.sortInternal(resolvedRows);
        } else {
            ArrayList<ITableRow> list = new ArrayList<ITableRow>();
            list.addAll(this.m_rows);
            list.removeAll(resolvedRows);
            ArrayList<ITableRow> sortedList = new ArrayList<ITableRow>();
            sortedList.addAll(resolvedRows);
            sortedList.addAll(list);
            this.sortInternal(sortedList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortInternal(List<? extends ITableRow> resolvedRows) {
        int i = 0;
        for (ITableRow iTableRow : resolvedRows) {
            ((InternalTableRow)iTableRow).setRowIndex(i);
            ++i;
        }
        Object object = this.m_cachedRowsLock;
        synchronized (object) {
            this.m_cachedRows = null;
            this.m_rows.clear();
            this.m_rows.addAll(resolvedRows);
        }
        if (this.m_selectedRows != null && this.m_selectedRows.size() > 0) {
            TreeSet<ITableRow> treeSet = new TreeSet<ITableRow>(new RowIndexComparator());
            treeSet.addAll(this.m_selectedRows);
            this.m_selectedRows = new ArrayList<ITableRow>(treeSet);
        }
        this.fireRowOrderChanged();
    }

    @Override
    public void resetColumnConfiguration() {
        this.discardAllRows();
        try {
            this.setTableChanging(true);
            HashMap<String, Boolean> displayableState = new HashMap<String, Boolean>();
            for (IColumn<?> col : this.getColumns()) {
                displayableState.put(col.getColumnId(), col.isDisplayable());
            }
            this.disposeColumnsInternal();
            this.createColumnsInternal();
            this.initColumnsInternal();
            for (IColumn<?> col : this.getColumns()) {
                if (displayableState.get(col.getColumnId()) == null) continue;
                col.setDisplayable((Boolean)displayableState.get(col.getColumnId()));
            }
            ITableColumnFilterManager filterManager = this.getColumnFilterManager();
            if (filterManager != null && filterManager.getFilters() != null) {
                for (IColumn<?> col : this.getColumns()) {
                    for (ITableColumnFilter filter : filterManager.getFilters()) {
                        if (!filter.getColumn().getColumnId().equals(col.getColumnId())) continue;
                        filter.setColumn(col);
                    }
                    filterManager.refresh();
                }
            }
            this.fireTableEventInternal(new TableEvent(this, 1));
        }
        finally {
            this.setTableChanging(false);
        }
    }

    @Override
    public void resetColumnVisibilities() {
        this.resetColumns(true, false, false, false);
    }

    @Override
    public void resetColumnOrder() {
        this.resetColumns(false, true, false, false);
    }

    @Override
    public void resetColumnSortOrder() {
        this.resetColumns(false, false, true, false);
    }

    @Override
    public void resetColumnWidths() {
        this.resetColumns(false, false, false, true);
    }

    @Override
    public void resetDisplayableColumns() {
        this.resetColumns(true, true, true, true);
    }

    @Override
    public void resetColumns(boolean visibility, boolean order, boolean sorting, boolean widths) {
        try {
            this.setTableChanging(true);
            try {
                if (sorting) {
                    this.m_sortValid = false;
                }
                this.resetColumnsInternal(visibility, order, sorting, widths);
                this.execResetColumns(visibility, order, sorting, widths);
            }
            catch (Throwable t) {
                LOG.error("reset columns " + visibility + "," + order + "," + sorting + "," + widths, t);
            }
        }
        finally {
            this.setTableChanging(false);
        }
    }

    private void resetColumnsInternal(boolean visibility, boolean order, boolean sorting, boolean widths) {
        ClientUIPreferences env = ClientUIPreferences.getInstance();
        env.removeAllTableColumnPreferences(this, visibility, order, sorting, widths);
        if (visibility) {
            ArrayList list = new ArrayList();
            for (IColumn<?> col : this.getColumnSet().getAllColumnsInUserOrder()) {
                boolean configuredVisible;
                if (!col.isDisplayable() || !(configuredVisible = ((AbstractColumn)col).isInitialVisible())) continue;
                list.add(col);
            }
            this.getColumnSet().setVisibleColumns(list);
        }
        if (order) {
            TreeMap<CompositeObject, IColumn<Object>> orderMap = new TreeMap<CompositeObject, IColumn<Object>>();
            int index = 0;
            for (IColumn<Object> col : this.getColumns()) {
                if (!col.isDisplayable() || !col.isVisible()) continue;
                orderMap.put(new CompositeObject(new Object[]{col.getViewOrder(), index}), col);
                ++index;
            }
            this.getColumnSet().setVisibleColumns(orderMap.values());
        }
        if (sorting) {
            TreeMap<CompositeObject, IColumn<Object>> sortMap = new TreeMap<CompositeObject, IColumn<Object>>();
            int index = 0;
            for (IColumn<Object> col : this.getColumns()) {
                if (col.getInitialSortIndex() >= 0) {
                    sortMap.put(new CompositeObject(new Object[]{col.getInitialSortIndex(), index}), col);
                }
                ++index;
            }
            this.getColumnSet().clearSortColumns();
            this.getColumnSet().clearPermanentHeadSortColumns();
            this.getColumnSet().clearPermanentTailSortColumns();
            for (IColumn<Object> col : sortMap.values()) {
                if (col.isInitialAlwaysIncludeSortAtBegin()) {
                    this.getColumnSet().addPermanentHeadSortColumn(col, col.isInitialSortAscending());
                    continue;
                }
                if (col.isInitialAlwaysIncludeSortAtEnd()) {
                    this.getColumnSet().addPermanentTailSortColumn(col, col.isInitialSortAscending());
                    continue;
                }
                this.getColumnSet().addSortColumn(col, col.isInitialSortAscending());
            }
        }
        if (widths) {
            for (IColumn<?> col : this.getColumns()) {
                if (!col.isDisplayable()) continue;
                col.setWidth(col.getInitialWidth());
            }
        }
    }

    private void processDecorationBuffer() {
        block15: {
            try {
                try {
                    BatchLookupCall batchCall = null;
                    ArrayList<ITableRow> tableRowList = null;
                    Object columnIndexList = null;
                    if (this.m_cellLookupBuffer.size() > 0) {
                        batchCall = new BatchLookupCall();
                        tableRowList = new ArrayList<ITableRow>();
                        columnIndexList = new ArrayList();
                        BatchLookupResultCache lookupResultCache = new BatchLookupResultCache();
                        for (P_CellLookup lookup : this.m_cellLookupBuffer) {
                            ITableRow row = lookup.getRow();
                            if (row.getTable() != this) continue;
                            IContentAssistColumn<?, ?> col = lookup.getColumn();
                            ILookupCall<?> call = col.prepareLookupCall(row);
                            if (call != null && call.getKey() != null) {
                                if (call instanceof LocalLookupCall) {
                                    List result = lookupResultCache.getDataByKey(call);
                                    this.applyLookupResult((InternalTableRow)row, col.getColumnIndex(), result);
                                    continue;
                                }
                                tableRowList.add(row);
                                ((ArrayList)columnIndexList).add(col.getColumnIndex());
                                batchCall.addLookupCall(call);
                                continue;
                            }
                            this.applyLookupResult((InternalTableRow)row, col.getColumnIndex(), new ArrayList(0));
                        }
                    }
                    this.m_cellLookupBuffer.clear();
                    if (batchCall != null && tableRowList != null && columnIndexList != null && !batchCall.isEmpty()) {
                        ITableRow[] tableRows = tableRowList.toArray(new ITableRow[tableRowList.size()]);
                        IBatchLookupService service = (IBatchLookupService)SERVICES.getService(IBatchLookupService.class);
                        List resultArray = service.getBatchDataByKey(batchCall);
                        int i = 0;
                        while (i < tableRows.length) {
                            this.applyLookupResult((InternalTableRow)tableRows[i], ((Number)((ArrayList)columnIndexList).get(i)).intValue(), (List)resultArray.get(i));
                            ++i;
                        }
                    }
                }
                catch (ProcessingException e) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                    this.m_cellLookupBuffer.clear();
                    break block15;
                }
            }
            catch (Throwable throwable) {
                this.m_cellLookupBuffer.clear();
                throw throwable;
            }
            this.m_cellLookupBuffer.clear();
        }
        HashSet<ITableRow> set = this.m_rowDecorationBuffer;
        this.m_rowDecorationBuffer = new HashSet();
        for (ITableRow row : set) {
            if (row.getTable() != this) continue;
            this.applyRowDecorationsImpl(row);
        }
        if (this.m_rowFilters.size() > 0) {
            boolean filterChanged = false;
            for (ITableRow row : set) {
                if (row.getTable() != this || !(row instanceof InternalTableRow)) continue;
                InternalTableRow irow = (InternalTableRow)row;
                boolean oldFlag = irow.isFilterAccepted();
                this.applyRowFiltersInternal(irow);
                boolean newFlag = irow.isFilterAccepted();
                boolean bl = filterChanged = filterChanged || oldFlag != newFlag;
            }
            if (filterChanged) {
                this.fireRowFilterChanged();
            }
        }
    }

    private void processEventBuffer() {
        block26: {
            try {
                ++this.m_processEventBufferLoopDetection;
                if (this.m_processEventBufferLoopDetection > 100) {
                    LOG.error("LOOP DETECTION in " + this.getClass() + ". see stack trace for more details.", (Throwable)new Exception("LOOP DETECTION"));
                    return;
                }
                List<TableEvent> list = this.m_tableEventBuffer;
                this.m_tableEventBuffer = new ArrayList<TableEvent>();
                if (list.size() <= 0) break block26;
                HashMap<Integer, ArrayList<TableEvent>> coalesceMap = new HashMap<Integer, ArrayList<TableEvent>>();
                for (TableEvent e : list) {
                    ArrayList<TableEvent> subList = (ArrayList<TableEvent>)coalesceMap.get(e.getType());
                    if (subList == null) {
                        subList = new ArrayList<TableEvent>();
                        coalesceMap.put(e.getType(), subList);
                    }
                    subList.add(e);
                }
                TreeMap<Integer, TableEvent> sortedCoalescedMap = new TreeMap<Integer, TableEvent>();
                for (Map.Entry entry : coalesceMap.entrySet()) {
                    int type = (Integer)entry.getKey();
                    List subList = (List)entry.getValue();
                    int lastIndex = subList.size() - 1;
                    switch (type) {
                        case 105: {
                            ArrayList<TableEvent> singleList = new ArrayList<TableEvent>(1);
                            singleList.add((TableEvent)subList.get(lastIndex));
                            sortedCoalescedMap.put(10, this.coalesceTableEvents(singleList, false, true));
                            break;
                        }
                        case 102: {
                            sortedCoalescedMap.put(20, this.coalesceTableEvents(subList, false, true));
                            break;
                        }
                        case 100: {
                            sortedCoalescedMap.put(30, this.coalesceTableEvents(subList, true, false));
                            break;
                        }
                        case 101: {
                            sortedCoalescedMap.put(40, this.coalesceTableEvents(subList, true, false));
                            break;
                        }
                        case 780: {
                            sortedCoalescedMap.put(60, this.coalesceTableEvents(subList, false, false));
                            break;
                        }
                        case 770: {
                            sortedCoalescedMap.put(70, this.coalesceTableEvents(subList, false, false));
                            break;
                        }
                        case 1: {
                            sortedCoalescedMap.put(80, (TableEvent)subList.get(lastIndex));
                            break;
                        }
                        case 200: {
                            sortedCoalescedMap.put(90, (TableEvent)subList.get(lastIndex));
                            break;
                        }
                        case 730: {
                            sortedCoalescedMap.put(100, (TableEvent)subList.get(lastIndex));
                            break;
                        }
                        case 740: {
                            sortedCoalescedMap.put(110, (TableEvent)subList.get(lastIndex));
                            break;
                        }
                        case 104: {
                            sortedCoalescedMap.put(160, (TableEvent)subList.get(lastIndex));
                            break;
                        }
                        case 103: {
                            sortedCoalescedMap.put(170, (TableEvent)subList.get(lastIndex));
                            break;
                        }
                        case 830: {
                            sortedCoalescedMap.put(180, (TableEvent)subList.get(lastIndex));
                            break;
                        }
                        default: {
                            sortedCoalescedMap.put(-type, (TableEvent)subList.get(lastIndex));
                        }
                    }
                }
                try {
                    this.setTableChanging(true);
                    this.fireTableEventBatchInternal(new ArrayList(sortedCoalescedMap.values()));
                }
                finally {
                    this.setTableChanging(false);
                }
            }
            finally {
                --this.m_processEventBufferLoopDetection;
            }
        }
    }

    private TableEvent coalesceTableEvents(List<TableEvent> list, boolean includeExistingRows, boolean includeRemovedRows) {
        if (list.size() == 1) {
            return list.get(0);
        }
        TableEvent last = list.get(list.size() - 1);
        TableEvent ce = new TableEvent(last.getTable(), last.getType());
        ce.setSortInMemoryAllowed(last.isSortInMemoryAllowed());
        ce.setDragObject(last.getDragObject());
        ce.setDropObject(last.getDropObject());
        ce.setCopyObject(last.getCopyObject());
        ce.addPopupMenus(last.getPopupMenus());
        LinkedHashSet colList = new LinkedHashSet();
        for (TableEvent t : list) {
            if (t.getColumns() == null) continue;
            colList.addAll(t.getColumns());
        }
        ce.setColumns(colList);
        ArrayList<ITableRow> rowList = new ArrayList<ITableRow>();
        for (TableEvent t : list) {
            if (t.getRowCount() <= 0) continue;
            for (ITableRow row : t.getRows()) {
                if (row.getTable() == this && includeExistingRows) {
                    rowList.add(row);
                    continue;
                }
                if (row.getTable() == this || !includeRemovedRows) continue;
                rowList.add(row);
            }
        }
        ce.setRows(rowList);
        return ce;
    }

    private void enqueueDecorationTasks(ITableRow row) {
        if (row != null) {
            int i = 0;
            while (i < row.getCellCount()) {
                IContentAssistColumn assistColumn;
                IColumn column = this.getColumnSet().getColumn(i);
                if (column instanceof IContentAssistColumn && (assistColumn = (IContentAssistColumn)column).getLookupCall() != null) {
                    this.m_cellLookupBuffer.add(new P_CellLookup(row, assistColumn));
                }
                ++i;
            }
            this.m_rowDecorationBuffer.add(row);
        }
    }

    private void applyRowDecorationsImpl(ITableRow tableRow) {
        try {
            try {
                tableRow.setRowChanging(true);
                this.decorateRow(tableRow);
                ColumnSet cset = this.getColumnSet();
                int c = 0;
                while (c < tableRow.getCellCount()) {
                    IColumn col = cset.getColumn(c);
                    col.decorateCell(tableRow);
                    this.decorateCell(tableRow, col);
                    ++c;
                }
            }
            catch (Throwable t) {
                LOG.error("Error occured while applying row decoration", t);
                tableRow.setRowPropertiesChanged(false);
                tableRow.setRowChanging(false);
            }
        }
        finally {
            tableRow.setRowPropertiesChanged(false);
            tableRow.setRowChanging(false);
        }
    }

    private void applyLookupResult(InternalTableRow tableRow, int columnIndex, List<ILookupRow<?>> result) {
        try {
            tableRow.setRowChanging(true);
            Cell cell = (Cell)tableRow.getCell(columnIndex);
            if (result.size() == 1) {
                cell.setText(result.get(0).getText());
                cell.setTooltipText(result.get(0).getTooltipText());
            } else if (result.size() > 1) {
                StringBuffer buf = new StringBuffer();
                StringBuffer bufTooltip = new StringBuffer();
                int i = 0;
                while (i < result.size()) {
                    if (i > 0) {
                        if (this.isMultilineText()) {
                            buf.append("\n");
                            bufTooltip.append("\n");
                        } else {
                            buf.append(", ");
                            bufTooltip.append(", ");
                        }
                    }
                    ILookupRow<?> row = result.get(i);
                    buf.append(row.getText());
                    bufTooltip.append(row.getTooltipText());
                    ++i;
                }
                cell.setText(buf.toString());
                cell.setTooltipText(bufTooltip.toString());
            } else {
                cell.setText("");
                cell.setTooltipText("");
            }
        }
        finally {
            tableRow.setRowPropertiesChanged(false);
            tableRow.setRowChanging(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tablePopulated() {
        if (this.m_tableEventBuffer.isEmpty()) {
            Object object = this.m_cachedFilteredRowsLock;
            synchronized (object) {
                this.m_cachedFilteredRows = null;
            }
            this.fireTableEventInternal(new TableEvent(this, 820, null));
        }
    }

    @Override
    public ITableRow resolveRow(ITableRow row) {
        if (row == null) {
            return null;
        }
        if (!(row instanceof InternalTableRow)) {
            throw new IllegalArgumentException("only accept InternalTableRow, not " + (row != null ? row.getClass() : null));
        }
        if (row.getTable() == this) {
            return row;
        }
        return null;
    }

    @Override
    public List<ITableRow> resolveRows(Collection<? extends ITableRow> rows) {
        if (rows == null) {
            rows = CollectionUtility.emptyArrayList();
        }
        ArrayList<ITableRow> resolvedRows = new ArrayList<ITableRow>(rows.size());
        for (ITableRow row : rows) {
            if (this.resolveRow(row) == row) {
                resolvedRows.add(row);
                continue;
            }
            LOG.warn("could not resolve row " + row);
        }
        return resolvedRows;
    }

    @Override
    public boolean isHeaderVisible() {
        return this.propertySupport.getPropertyBool("headerVisible");
    }

    @Override
    public void setHeaderVisible(boolean b) {
        this.propertySupport.setPropertyBool("headerVisible", b);
    }

    @Override
    public final void decorateCell(ITableRow row, IColumn<?> col) {
        Cell cell = row.getCellForUpdate(col.getColumnIndex());
        this.decorateCellInternal(cell, row, col);
        try {
            this.execDecorateCell(cell, row, col);
        }
        catch (ProcessingException e) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
        catch (Throwable t) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(this.createNewUnexpectedProcessingException(t));
        }
    }

    public boolean wasEverValid(ITableRow row) {
        if (!this.m_rowValidty.contains(row)) {
            for (IColumn<?> col : this.getColumns()) {
                if (row.getCell(col).getErrorStatus() == null) continue;
                return false;
            }
            this.m_rowValidty.add(row);
        }
        return true;
    }

    private void clearRowValidity(ITableRow row) {
        this.m_rowValidty.remove(row);
    }

    private void clearAllRowsValidity() {
        this.m_rowValidty.clear();
    }

    protected void decorateCellInternal(Cell view, ITableRow row, IColumn<?> col) {
    }

    @Override
    public final void decorateRow(ITableRow row) {
        this.decorateRowInternal(row);
        try {
            this.execDecorateRow(row);
        }
        catch (ProcessingException e) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
        catch (Throwable t) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(this.createNewUnexpectedProcessingException(t));
        }
    }

    protected void decorateRowInternal(ITableRow row) {
        String s;
        if (row.getIconId() == null && (s = this.getDefaultIconId()) != null) {
            row.setIconId(s);
        }
    }

    @ConfigOperation
    @Order(value=90.0)
    protected void execResetColumns(boolean visibility, boolean order, boolean sorting, boolean widths) throws ProcessingException {
    }

    @Override
    public void addTableListener(TableListener listener) {
        this.m_listenerList.add(TableListener.class, (EventListener)listener);
    }

    @Override
    public void removeTableListener(TableListener listener) {
        this.m_listenerList.remove(TableListener.class, (EventListener)listener);
    }

    @Override
    public void addUITableListener(TableListener listener) {
        this.m_listenerList.insertAtFront(TableListener.class, (EventListener)listener);
    }

    protected IEventHistory<TableEvent> createEventHistory() {
        return new DefaultTableEventHistory(5000L);
    }

    @Override
    public IEventHistory<TableEvent> getEventHistory() {
        return this.m_eventHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRowsInserted(List<? extends ITableRow> rows) {
        Object object = this.m_cachedFilteredRowsLock;
        synchronized (object) {
            this.m_cachedFilteredRows = null;
        }
        this.fireTableEventInternal(new TableEvent(this, 100, rows));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRowsUpdated(List<? extends ITableRow> rows) {
        Object object = this.m_cachedFilteredRowsLock;
        synchronized (object) {
            this.m_cachedFilteredRows = null;
        }
        this.fireTableEventInternal(new TableEvent(this, 101, rows));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRowsDeleted(List<? extends ITableRow> rows) {
        Object object = this.m_cachedFilteredRowsLock;
        synchronized (object) {
            this.m_cachedFilteredRows = null;
        }
        this.fireTableEventInternal(new TableEvent(this, 102, rows));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAllRowsDeleted(List<? extends ITableRow> rows) {
        Object object = this.m_cachedFilteredRowsLock;
        synchronized (object) {
            this.m_cachedFilteredRows = null;
        }
        this.fireTableEventInternal(new TableEvent(this, 105, rows));
    }

    private void fireRowsSelected(List<? extends ITableRow> rows) {
        this.fireTableEventInternal(new TableEvent(this, 103, rows));
    }

    private void fireRowClick(ITableRow row, MouseButton mouseButton) {
        if (row != null) {
            try {
                this.interceptRowClickSingleObserver(row);
                this.execRowClick(row, mouseButton);
            }
            catch (ProcessingException ex) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(this.createNewUnexpectedProcessingException(t));
            }
        }
    }

    protected void interceptRowClickSingleObserver(ITableRow row) throws ProcessingException {
        if (row.isEnabled() && this.isEnabled()) {
            IColumn<?> ctxCol = this.getContextColumn();
            if (this.isCellEditable(row, ctxCol)) {
                IFormField field;
                if (ctxCol instanceof IBooleanColumn && (field = ctxCol.prepareEdit(row)) instanceof IBooleanField) {
                    IBooleanField bfield;
                    bfield.setChecked(!(bfield = (IBooleanField)field).isChecked());
                    ctxCol.completeEdit(row, field);
                }
            } else if (this.isCheckable()) {
                row.setChecked(!row.isChecked());
            }
        }
    }

    private void fireRowAction(ITableRow row) {
        if (!this.m_actionRunning) {
            try {
                this.m_actionRunning = true;
                if (row != null) {
                    try {
                        this.execRowAction(row);
                    }
                    catch (ProcessingException ex) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
                    }
                    catch (Throwable t) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(this.createNewUnexpectedProcessingException(t));
                    }
                }
            }
            finally {
                this.m_actionRunning = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRowOrderChanged() {
        Object object = this.m_cachedFilteredRowsLock;
        synchronized (object) {
            this.m_cachedFilteredRows = null;
        }
        this.fireTableEventInternal(new TableEvent(this, 200, this.getRows()));
    }

    private void fireRequestFocus() {
        this.fireTableEventInternal(new TableEvent(this, 800));
    }

    private void fireRequestFocusInCell(IColumn<?> column, ITableRow row) {
        TableEvent e = new TableEvent(this, 805);
        e.setColumns(CollectionUtility.hashSet(column));
        e.setRows(CollectionUtility.arrayList((Object)row));
        this.fireTableEventInternal(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRowFilterChanged() {
        Object object = this.m_cachedFilteredRowsLock;
        synchronized (object) {
            this.m_cachedFilteredRows = null;
        }
        this.fireTableEventInternal(new TableEvent(this, 210));
    }

    private TransferObject fireRowsDragRequest() {
        List<ITableRow> rows = this.getSelectedRows();
        if (CollectionUtility.hasElements(rows)) {
            TableEvent e = new TableEvent(this, 730, rows);
            this.fireTableEventInternal(e);
            return e.getDragObject();
        }
        return null;
    }

    private void fireRowDropAction(ITableRow row, TransferObject dropData) {
        ArrayList rows = null;
        if (row != null) {
            rows = CollectionUtility.arrayList((Object)row);
        }
        TableEvent e = new TableEvent(this, 740, rows);
        e.setDropObject(dropData);
        this.fireTableEventInternal(e);
    }

    private TransferObject fireRowsCopyRequest() {
        List<ITableRow> rows = this.getSelectedRows();
        if (CollectionUtility.hasElements(rows)) {
            TableEvent e = new TableEvent(this, 760, rows);
            this.fireTableEventInternal(e);
            return e.getCopyObject();
        }
        return null;
    }

    @ConfigOperation
    @Order(value=100.0)
    @Deprecated
    protected void execAddHeaderMenus(TableEvent e) throws ProcessingException {
        IMenu m;
        int n;
        int n2;
        IMenu[] iMenuArray;
        if (this.getTableCustomizer() != null) {
            if (e.getPopupMenuCount() > 0) {
                e.addPopupMenu(new MenuSeparator());
            }
            iMenuArray = new IMenu[]{new AddCustomColumnMenu(this), new ModifyCustomColumnMenu(this), new RemoveCustomColumnMenu(this)};
            n2 = iMenuArray.length;
            n = 0;
            while (n < n2) {
                m = iMenuArray[n];
                m.prepareAction();
                if (m.isVisible()) {
                    e.addPopupMenu(m);
                }
                ++n;
            }
        }
        if (e.getPopupMenuCount() > 0) {
            e.addPopupMenu(new MenuSeparator());
        }
        iMenuArray = new IMenu[]{new ResetColumnsMenu(this), new OrganizeColumnsMenu(this), new ColumnFilterMenu(this), new CopyWidthsOfColumnsMenu(this)};
        n2 = iMenuArray.length;
        n = 0;
        while (n < n2) {
            m = iMenuArray[n];
            m.prepareAction();
            if (m.isVisible()) {
                e.addPopupMenu(m);
            }
            ++n;
        }
    }

    protected void fireTableEventInternal(TableEvent e) {
        if (this.isTableChanging()) {
            this.m_tableEventBuffer.add(e);
        } else {
            EventListener[] listeners = this.m_listenerList.getListeners(TableListener.class);
            if (listeners != null && listeners.length > 0) {
                int i = 0;
                while (i < listeners.length) {
                    try {
                        ((TableListener)listeners[i]).tableChanged(e);
                    }
                    catch (Throwable t) {
                        LOG.error("fire " + e, t);
                    }
                    ++i;
                }
            }
        }
    }

    private void fireTableEventBatchInternal(List<? extends TableEvent> batch) {
        EventListener[] listeners;
        if (CollectionUtility.hasElements(batch) && (listeners = this.m_listenerList.getListeners(TableListener.class)) != null && listeners.length > 0) {
            int i = 0;
            while (i < listeners.length) {
                ((TableListener)listeners[i]).tableChangedBatch(batch);
                ++i;
            }
        }
    }

    protected boolean handleKeyStroke(String keyName, char keyChar) {
        if (keyName == null) {
            return false;
        }
        keyName = keyName.toLowerCase();
        for (IMenu m : this.getMenus()) {
            if (m.getKeyStroke() == null || !m.getKeyStroke().equalsIgnoreCase(keyName)) continue;
            return false;
        }
        for (IKeyStroke k : this.getKeyStrokes()) {
            if (k.getKeyStroke() == null || !k.getKeyStroke().equalsIgnoreCase(keyName)) continue;
            return false;
        }
        if (!(keyChar <= ' ' || keyName.contains("control") || keyName.contains("ctrl") || keyName.contains("alt"))) {
            String newText = "" + Character.toLowerCase(keyChar);
            this.m_keyStrokeBuffer.append(newText);
            String prefix = this.m_keyStrokeBuffer.getText();
            IColumn col = this.getContextColumn();
            if (col == null) {
                List<IColumn<?>> sortCols = this.getColumnSet().getSortColumns();
                if (sortCols.size() > 0) {
                    col = (IColumn)CollectionUtility.lastElement(sortCols);
                } else {
                    TreeMap sortMap = new TreeMap();
                    int index = 0;
                    for (IColumn<?> c : this.getColumnSet().getVisibleColumns()) {
                        if (c.getDataType() == String.class) {
                            sortMap.put(new CompositeObject(new Object[]{1, index}), c);
                        } else if (c.getDataType() == Boolean.class) {
                            sortMap.put(new CompositeObject(new Object[]{3, index}), c);
                        } else {
                            sortMap.put(new CompositeObject(new Object[]{2, index}), c);
                        }
                        ++index;
                    }
                    if (sortMap.size() > 0) {
                        col = (IColumn)sortMap.get(sortMap.firstKey());
                    }
                }
            }
            if (col != null) {
                int colIndex = col.getColumnIndex();
                String pattern = StringUtility.toRegExPattern((String)prefix.toLowerCase());
                pattern = String.valueOf(pattern) + ".*";
                if (LOG.isInfoEnabled()) {
                    LOG.info("finding regex:" + pattern + " in column " + this.getColumnSet().getColumn(colIndex).getHeaderCell().getText());
                }
                int rowCount = this.getRowCount();
                ITableRow selRow = this.getSelectedRow();
                int startIndex = 0;
                if (selRow != null) {
                    startIndex = prefix.length() <= 1 ? selRow.getRowIndex() + 1 : selRow.getRowIndex();
                }
                int i = 0;
                while (i < rowCount) {
                    ITableRow row = this.m_rows.get((startIndex + i) % rowCount);
                    String text = row.getCell(colIndex).getText();
                    if (text != null && text.toLowerCase().matches(pattern)) {
                        this.selectRow(row, false);
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    @Override
    public ITableUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    private ProcessingException createNewUnexpectedProcessingException(Throwable t) {
        return new ProcessingException("Unexpected", t);
    }

    private static class P_CellEditorContext {
        private final ITableRow m_row;
        private final IColumn<?> m_column;
        private final IFormField m_formField;

        public P_CellEditorContext(ITableRow row, IColumn<?> col, IFormField f) {
            this.m_row = row;
            this.m_column = col;
            this.m_formField = f;
        }

        public ITableRow getRow() {
            return this.m_row;
        }

        public IColumn<?> getColumn() {
            return this.m_column;
        }

        public IFormField getFormField() {
            return this.m_formField;
        }
    }

    private static class P_CellLookup {
        private final ITableRow m_row;
        private final IContentAssistColumn<?, ?> m_column;

        public P_CellLookup(ITableRow row, IContentAssistColumn<?, ?> col) {
            this.m_row = row;
            this.m_column = col;
        }

        public ITableRow getRow() {
            return this.m_row;
        }

        public IContentAssistColumn<?, ?> getColumn() {
            return this.m_column;
        }
    }

    private class P_TableListener
    extends TableAdapter {
        private P_TableListener() {
        }

        @Override
        public void tableChanged(TableEvent e) {
            switch (e.getType()) {
                case 103: {
                    try {
                        AbstractTable.this.execRowsSelected(e.getRows());
                        break;
                    }
                    catch (ProcessingException ex) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
                        break;
                    }
                    catch (Throwable t) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
                    }
                }
            }
        }
    }

    private class P_TableRowBuilder
    extends AbstractTableRowBuilder<Object> {
        private P_TableRowBuilder() {
        }

        @Override
        protected ITableRow createEmptyTableRow() {
            return new TableRow(AbstractTable.this.getColumnSet());
        }
    }

    protected class P_TableUIFacade
    implements ITableUIFacade {
        private int m_uiProcessorCount = 0;

        protected P_TableUIFacade() {
        }

        protected void pushUIProcessor() {
            ++this.m_uiProcessorCount;
        }

        protected void popUIProcessor() {
            --this.m_uiProcessorCount;
        }

        @Override
        public boolean isUIProcessing() {
            return this.m_uiProcessorCount > 0;
        }

        @Override
        public void fireRowClickFromUI(ITableRow row, MouseButton mouseButton) {
            try {
                this.pushUIProcessor();
                row = AbstractTable.this.resolveRow(row);
                if (row != null) {
                    AbstractTable.this.fireRowClick(AbstractTable.this.resolveRow(row), mouseButton);
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireRowActionFromUI(ITableRow row) {
            try {
                this.pushUIProcessor();
                row = AbstractTable.this.resolveRow(row);
                if (row != null) {
                    AbstractTable.this.fireRowAction(row);
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public boolean fireKeyTypedFromUI(String keyStrokeText, char keyChar) {
            try {
                this.pushUIProcessor();
                boolean bl = AbstractTable.this.handleKeyStroke(keyStrokeText, keyChar);
                return bl;
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireVisibleColumnsChangedFromUI(Collection<IColumn<?>> visibleColumns) {
            try {
                this.pushUIProcessor();
                AbstractTable.this.getColumnSet().setVisibleColumns(visibleColumns);
                ClientUIPreferences.getInstance().setAllTableColumnPreferences(AbstractTable.this);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireColumnMovedFromUI(IColumn<?> c, int toViewIndex) {
            try {
                this.pushUIProcessor();
                c = AbstractTable.this.getColumnSet().resolveColumn(c);
                if (c != null) {
                    AbstractTable.this.getColumnSet().moveColumnToVisibleIndex(c.getColumnIndex(), toViewIndex);
                    ClientUIPreferences.getInstance().setAllTableColumnPreferences(AbstractTable.this);
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void setColumnWidthFromUI(IColumn<?> c, int newWidth) {
            try {
                this.pushUIProcessor();
                c = AbstractTable.this.getColumnSet().resolveColumn(c);
                if (c != null) {
                    c.setWidthInternal(newWidth);
                    ClientUIPreferences.getInstance().setAllTableColumnPreferences(AbstractTable.this);
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireHeaderSortFromUI(IColumn<?> c, boolean multiSort) {
            try {
                this.pushUIProcessor();
                if (AbstractTable.this.isSortEnabled() && (c = AbstractTable.this.getColumnSet().resolveColumn(c)) != null) {
                    AbstractTable.this.getColumnSet().handleSortEvent(c, multiSort);
                    ClientUIPreferences.getInstance().setAllTableColumnPreferences(AbstractTable.this);
                    AbstractTable.this.sort();
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void setSelectedRowsFromUI(List<? extends ITableRow> rows) {
            try {
                this.pushUIProcessor();
                HashSet<ITableRow> requestedRows = new HashSet<ITableRow>(AbstractTable.this.resolveRows(rows));
                ArrayList<ITableRow> validRows = new ArrayList<ITableRow>();
                for (ITableRow row : AbstractTable.this.getSelectedRows()) {
                    if (row.isFilterAccepted()) continue;
                    validRows.add(row);
                }
                requestedRows.removeAll(validRows);
                for (ITableRow row : requestedRows) {
                    validRows.add(row);
                }
                AbstractTable.this.selectRows(validRows, false);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public TransferObject fireRowsDragRequestFromUI() {
            try {
                this.pushUIProcessor();
                TransferObject transferObject = AbstractTable.this.fireRowsDragRequest();
                return transferObject;
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireRowDropActionFromUI(ITableRow row, TransferObject dropData) {
            try {
                this.pushUIProcessor();
                row = AbstractTable.this.resolveRow(row);
                AbstractTable.this.fireRowDropAction(row, dropData);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public TransferObject fireRowsCopyRequestFromUI() {
            try {
                this.pushUIProcessor();
                TransferObject transferObject = AbstractTable.this.fireRowsCopyRequest();
                return transferObject;
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireHyperlinkActionFromUI(ITableRow row, IColumn<?> col, URL url) {
            try {
                try {
                    this.pushUIProcessor();
                    AbstractTable.this.doHyperlinkAction(AbstractTable.this.resolveRow(row), col, url);
                }
                catch (ProcessingException e) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                    this.popUIProcessor();
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void setContextColumnFromUI(IColumn<?> col) {
            try {
                this.pushUIProcessor();
                if (col != null && col.getTable() != AbstractTable.this) {
                    col = null;
                }
                AbstractTable.this.setContextColumn(col);
            }
            finally {
                this.popUIProcessor();
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public IFormField prepareCellEditFromUI(ITableRow row, IColumn<?> col) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void completeCellEditFromUI() {
            block10: {
                try {
                    this.pushUIProcessor();
                    if (AbstractTable.this.m_editContext == null) break block10;
                    try {
                        try {
                            AbstractTable.this.m_editContext.getColumn().completeEdit(AbstractTable.this.m_editContext.getRow(), AbstractTable.this.m_editContext.getFormField());
                        }
                        catch (ProcessingException e) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                            AbstractTable.this.m_editContext = null;
                        }
                        catch (Throwable t) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
                            AbstractTable.this.m_editContext = null;
                        }
                    }
                    finally {
                        AbstractTable.this.m_editContext = null;
                    }
                }
                finally {
                    this.popUIProcessor();
                }
            }
        }

        @Override
        public void cancelCellEditFromUI() {
            try {
                this.pushUIProcessor();
                AbstractTable.this.m_editContext = null;
            }
            finally {
                this.popUIProcessor();
            }
        }
    }
}

