/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerField;
import org.eclipse.scout.rt.shared.data.model.AbstractDataModel;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelEntity;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public class ComposerFieldDataModel
extends AbstractDataModel {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ComposerFieldDataModel.class);
    private static final long serialVersionUID = 1L;
    private final IComposerField m_field;

    public ComposerFieldDataModel(IComposerField field) {
        super(false);
        this.m_field = field;
        this.callInitializer();
    }

    protected List<IDataModelAttribute> createAttributes() {
        Class[] all = ConfigurationUtility.getDeclaredPublicClasses(this.m_field.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])all, IDataModelAttribute.class);
        List sortedAndFiltered = ConfigurationUtility.sortFilteredClassesByOrderAnnotation((List)filtered, IDataModelAttribute.class);
        ArrayList<IDataModelAttribute> attributes = new ArrayList<IDataModelAttribute>(sortedAndFiltered.size());
        for (Class c : sortedAndFiltered) {
            try {
                IDataModelAttribute a = (IDataModelAttribute)ConfigurationUtility.newInnerInstance((Object)this.m_field, (Class)c);
                attributes.add(a);
            }
            catch (Exception e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + c.getName() + "'.", (Throwable)e));
            }
        }
        return attributes;
    }

    protected List<IDataModelEntity> createEntities() {
        Class[] all = ConfigurationUtility.getDeclaredPublicClasses(this.m_field.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])all, IDataModelEntity.class);
        List sortedAndFiltered = ConfigurationUtility.sortFilteredClassesByOrderAnnotation((List)filtered, IDataModelEntity.class);
        ArrayList<IDataModelEntity> entities = new ArrayList<IDataModelEntity>(sortedAndFiltered.size());
        for (Class entityClazz : sortedAndFiltered) {
            try {
                entities.add((IDataModelEntity)ConfigurationUtility.newInnerInstance((Object)this.m_field, (Class)entityClazz));
            }
            catch (Exception e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + entityClazz.getName() + "'.", (Throwable)e));
            }
        }
        return entities;
    }
}

