/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer.internal;

import java.util.List;
import org.eclipse.scout.rt.client.services.common.search.TokenBasedSearchFilterService;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.attribute.AbstractComposerAttribute;
import org.eclipse.scout.rt.client.ui.form.fields.composer.entity.AbstractComposerEntity;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.AttributeNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.EitherOrNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.EntityNode;
import org.eclipse.scout.rt.shared.services.common.jdbc.TokenBasedSearchFilter;

public class TokenBasedComposerStatementBuilder {
    TokenBasedSearchFilterService m_service;

    public TokenBasedComposerStatementBuilder(TokenBasedSearchFilterService service) {
        this.m_service = service;
    }

    public TokenBasedSearchFilter.AndNodeToken build(ITreeNode node) {
        TokenBasedSearchFilter.AndNodeToken rootTok = new TokenBasedSearchFilter.AndNodeToken();
        this.visitAndNodes((TokenBasedSearchFilter.TreeNodeToken)rootTok, node.getChildNodes());
        return rootTok;
    }

    private void visitAndNodes(TokenBasedSearchFilter.TreeNodeToken parentTok, List<? extends ITreeNode> nodesList) {
        ITreeNode[] nodes = nodesList.toArray(new ITreeNode[nodesList.size()]);
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i] instanceof EntityNode) {
                TokenBasedSearchFilter.EntityNodeToken eTok = this.visitEntityNode((EntityNode)nodes[i]);
                if (eTok != null) {
                    parentTok.addChild((TokenBasedSearchFilter.TreeNodeToken)eTok);
                }
                ++i;
                continue;
            }
            if (nodes[i] instanceof AttributeNode) {
                TokenBasedSearchFilter.AttributeNodeToken aTok = this.visitAttributeNode((AttributeNode)nodes[i]);
                if (aTok != null) {
                    parentTok.addChild((TokenBasedSearchFilter.TreeNodeToken)aTok);
                }
                ++i;
                continue;
            }
            if (!(nodes[i] instanceof EitherOrNode)) continue;
            int k = i;
            while (k + 1 < nodes.length && nodes[k + 1] instanceof EitherOrNode && !((EitherOrNode)nodes[k + 1]).isBeginOfEitherOr()) {
                ++k;
            }
            EitherOrNode[] eNodes = new EitherOrNode[k - i + 1];
            System.arraycopy(nodes, i, eNodes, 0, eNodes.length);
            TokenBasedSearchFilter.OrNodeToken orTok = new TokenBasedSearchFilter.OrNodeToken();
            this.visitOrNodes((TokenBasedSearchFilter.TreeNodeToken)orTok, eNodes);
            if (orTok.getChildren().size() >= 2) {
                parentTok.addChild((TokenBasedSearchFilter.TreeNodeToken)orTok);
            } else if (orTok.getChildren().size() == 1) {
                parentTok.addChild((TokenBasedSearchFilter.TreeNodeToken)orTok.getChildren().get(0));
            }
            i = k + 1;
        }
    }

    private void visitOrNodes(TokenBasedSearchFilter.TreeNodeToken parentTok, EitherOrNode[] nodes) {
        EitherOrNode[] eitherOrNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            EitherOrNode node = eitherOrNodeArray[n2];
            TokenBasedSearchFilter.AndNodeToken andTok = new TokenBasedSearchFilter.AndNodeToken();
            this.visitAndNodes((TokenBasedSearchFilter.TreeNodeToken)andTok, node.getChildNodes());
            if (andTok.getChildren().size() >= 2) {
                andTok.setNegative(node.isNegative());
                parentTok.addChild((TokenBasedSearchFilter.TreeNodeToken)andTok);
            } else if (andTok.getChildren().size() == 1) {
                TokenBasedSearchFilter.TreeNodeToken firstTok = (TokenBasedSearchFilter.TreeNodeToken)andTok.getChildren().get(0);
                firstTok.setNegative(node.isNegative());
                parentTok.addChild(firstTok);
            }
            ++n2;
        }
    }

    private TokenBasedSearchFilter.EntityNodeToken visitEntityNode(EntityNode node) {
        Integer tokenId = this.m_service.resolveTokenIdByClass(((AbstractComposerEntity)node.getEntity()).getClass());
        if (tokenId == null) {
            return null;
        }
        TokenBasedSearchFilter.EntityNodeToken eTok = new TokenBasedSearchFilter.EntityNodeToken(tokenId.intValue());
        eTok.setNegative(node.isNegative());
        TokenBasedSearchFilter.AndNodeToken andTok = new TokenBasedSearchFilter.AndNodeToken();
        this.visitAndNodes((TokenBasedSearchFilter.TreeNodeToken)andTok, node.getChildNodes());
        if (andTok.getChildren().size() > 0) {
            eTok.addChild((TokenBasedSearchFilter.TreeNodeToken)andTok);
        }
        return eTok;
    }

    private TokenBasedSearchFilter.AttributeNodeToken visitAttributeNode(AttributeNode node) {
        Integer tokenId = this.m_service.resolveTokenIdByClass(((AbstractComposerAttribute)node.getAttribute()).getClass());
        if (tokenId == null) {
            return null;
        }
        TokenBasedSearchFilter.AttributeNodeToken aTok = new TokenBasedSearchFilter.AttributeNodeToken(tokenId.intValue(), node.getOp().getOperator(), node.getValues());
        return aTok;
    }
}

