/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer.node;

import java.util.ArrayList;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenuSeparator;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerField;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.AbstractAddAttributeMenu;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.AbstractComposerNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.EitherOrNode;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;

public class RootNode
extends AbstractComposerNode {
    public RootNode(IComposerField composerField) {
        super(composerField, true);
    }

    @Override
    protected void execInitTreeNode() {
        ArrayList<IMenu> menus = new ArrayList<IMenu>();
        for (IMenu m : this.getMenus()) {
            if (m.getClass() == AddEntityPlaceholderOnRootMenu.class) {
                this.attachAddEntityMenus(menus);
                continue;
            }
            menus.add(m);
        }
        this.setMenus(menus);
    }

    @Override
    protected void execDecorateCell(Cell cell) {
        if (this.getChildNodeCount() == 0) {
            cell.setFont(FontSpec.parse((String)"plain"));
        } else {
            cell.setFont(FontSpec.parse((String)"bold"));
        }
    }

    @Order(value=10.0)
    public class AddAttributeOnRootMenu
    extends AbstractAddAttributeMenu {
        public AddAttributeOnRootMenu() {
            super(RootNode.this.getComposerField(), RootNode.this);
        }
    }

    @Order(value=20.0)
    public class AddEitherOrOnRootMenu
    extends AbstractMenu {
        @Override
        protected String getConfiguredText() {
            return ScoutTexts.get((String)"ExtendedSearchAddEitherOrMenu", (String[])new String[0]);
        }

        @Override
        protected void execAction() throws ProcessingException {
            EitherOrNode node = RootNode.this.getComposerField().addEitherNode(RootNode.this, false);
            RootNode.this.getComposerField().addAdditionalOrNode(node, false);
        }
    }

    @Order(value=40.0)
    public class AddEntityPlaceholderOnRootMenu
    extends AbstractMenuSeparator {
    }

    @Order(value=30.0)
    public class Separator1Menu
    extends AbstractMenuSeparator {
    }
}

