/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.imagebox;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuUtility;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.FormFieldContextMenu;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.imagebox.IImageField;
import org.eclipse.scout.rt.client.ui.form.fields.imagebox.IImageFieldUIFacade;
import org.eclipse.scout.rt.client.ui.form.fields.imagebox.ImageFieldEvent;
import org.eclipse.scout.rt.client.ui.form.fields.imagebox.ImageFieldListener;
import org.eclipse.scout.rt.shared.data.basic.AffineTransformSpec;
import org.eclipse.scout.rt.shared.data.basic.BoundsSpec;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

@ClassId(value="480ea07e-9cec-4591-ba73-4bb9aa45a60d")
public abstract class AbstractImageField
extends AbstractFormField
implements IImageField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractImageField.class);
    private IImageFieldUIFacade m_uiFacade;
    private final EventListenerList m_listenerList = new EventListenerList();
    private IContextMenu m_contextMenu;
    private double m_zoomDelta;
    private double m_panDelta;
    private double m_rotateDelta;

    public AbstractImageField() {
        this(true);
    }

    public AbstractImageField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected int getConfiguredVerticalAlignment() {
        return 0;
    }

    @Override
    protected int getConfiguredHorizontalAlignment() {
        return 0;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=300.0)
    protected String getConfiguredImageId() {
        return null;
    }

    @Order(value=310.0)
    @Deprecated
    protected boolean getConfiguredFocusVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=320.0)
    protected boolean getConfiguredAutoFit() {
        return false;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=330.0)
    protected double getConfiguredZoomDelta() {
        return 1.25;
    }

    @Override
    @Order(value=190.0)
    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredFocusable() {
        return false;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=340.0)
    protected double getConfiguredPanDelta() {
        return 10.0;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=350.0)
    protected double getConfiguredRotateDelta() {
        return 10.0;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=360.0)
    protected boolean getConfiguredScrollBarEnabled() {
        return false;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=400.0)
    protected int getConfiguredDropType() {
        return 0;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=410.0)
    protected int getConfiguredDragType() {
        return 0;
    }

    @ConfigOperation
    @Order(value=500.0)
    protected TransferObject execDragRequest() throws ProcessingException {
        return null;
    }

    @ConfigOperation
    @Order(value=510.0)
    protected void execDropRequest(TransferObject transferObject) throws ProcessingException {
    }

    protected List<Class<? extends IMenu>> getDeclaredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, IMenu.class);
        List foca = ConfigurationUtility.sortFilteredClassesByOrderAnnotation((List)filtered, IMenu.class);
        return ConfigurationUtility.removeReplacedClasses((List)foca);
    }

    @Override
    public List<IKeyStroke> getContributedKeyStrokes() {
        return MenuUtility.getKeyStrokesFromMenus(this.getMenus());
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = new P_UIFacade();
        super.initConfig();
        this.setImageTransform(new AffineTransformSpec());
        this.setAutoFit(this.getConfiguredAutoFit());
        this.setFocusVisible(this.getConfiguredFocusVisible());
        this.setImageId(this.getConfiguredImageId());
        this.setPanDelta(this.getConfiguredPanDelta());
        this.setRotateDelta(this.getConfiguredRotateDelta());
        this.setZoomDelta(this.getConfiguredZoomDelta());
        this.setDragType(this.getConfiguredDragType());
        this.setDropType(this.getConfiguredDropType());
        this.setScrollBarEnabled(this.getConfiguredScrollBarEnabled());
        ArrayList<IMenu> menuList = new ArrayList<IMenu>();
        for (Class<? extends IMenu> menuClazz : this.getDeclaredMenus()) {
            try {
                menuList.add((IMenu)ConfigurationUtility.newInnerInstance((Object)this, menuClazz));
            }
            catch (Exception e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + menuClazz.getName() + "'.", (Throwable)e));
            }
        }
        try {
            this.injectMenusInternal(menuList);
        }
        catch (Exception e) {
            LOG.error("error occured while dynamically contributing menus.", (Throwable)e);
        }
        this.m_contextMenu = new FormFieldContextMenu<AbstractImageField>(this, (List<IMenu>)menuList);
        this.m_contextMenu.setContainerInternal(this);
    }

    @Override
    protected void initFieldInternal() throws ProcessingException {
        super.initFieldInternal();
        ActionUtility.initActions(this.getMenus());
    }

    protected void injectMenusInternal(List<IMenu> menuList) {
    }

    @Override
    public void addImageFieldListener(ImageFieldListener listener) {
        this.m_listenerList.add(ImageFieldListener.class, (EventListener)listener);
    }

    @Override
    public void removeImageFieldListener(ImageFieldListener listener) {
        this.m_listenerList.remove(ImageFieldListener.class, (EventListener)listener);
    }

    private void fireZoomRectangle(BoundsSpec r) {
        this.fireImageBoxEventInternal(new ImageFieldEvent(this, 10, r));
    }

    private void fireAutoFit() {
        this.fireImageBoxEventInternal(new ImageFieldEvent(this, 20));
    }

    private void fireImageBoxEventInternal(ImageFieldEvent e) {
        EventListener[] a = this.m_listenerList.getListeners(ImageFieldListener.class);
        if (a != null) {
            int i = 0;
            while (i < a.length) {
                ((ImageFieldListener)a[i]).imageFieldChanged(e);
                ++i;
            }
        }
    }

    @Override
    public Object getImage() {
        return this.propertySupport.getProperty("image");
    }

    @Override
    public void setImage(Object imgObj) {
        this.propertySupport.setProperty("image", imgObj);
    }

    @Override
    public String getImageId() {
        return this.propertySupport.getPropertyString("imageId");
    }

    @Override
    public void setImageId(String imageId) {
        this.propertySupport.setPropertyString("imageId", imageId);
    }

    @Override
    public IContextMenu getContextMenu() {
        return this.m_contextMenu;
    }

    @Override
    public List<IMenu> getMenus() {
        return this.getContextMenu().getChildActions();
    }

    @Override
    public double getZoomDeltaValue() {
        return this.m_zoomDelta;
    }

    @Override
    public void setZoomDelta(double d) {
        this.m_zoomDelta = d;
    }

    @Override
    public double getPanDelta() {
        return this.m_panDelta;
    }

    @Override
    public void setPanDelta(double d) {
        this.m_panDelta = d;
    }

    @Override
    public double getRotateDelta() {
        return this.m_rotateDelta;
    }

    @Override
    public void setRotateDelta(double deg) {
        this.m_rotateDelta = deg;
    }

    @Override
    public void setRotateDeltaInRadians(double rad) {
        this.setRotateDelta(Math.toDegrees(rad));
    }

    @Override
    public AffineTransformSpec getImageTransform() {
        return new AffineTransformSpec((AffineTransformSpec)this.propertySupport.getProperty("imageTransform"));
    }

    @Override
    public void setImageTransform(AffineTransformSpec t) {
        this.propertySupport.setProperty("imageTransform", (Object)new AffineTransformSpec(t));
    }

    @Override
    public boolean isFocusVisible() {
        return this.propertySupport.getPropertyBool("focusVisible");
    }

    @Override
    public void setFocusVisible(boolean b) {
        this.propertySupport.setPropertyBool("focusVisible", b);
    }

    @Override
    public BoundsSpec getAnalysisRectangle() {
        return (BoundsSpec)this.propertySupport.getProperty("analysisRectangle");
    }

    @Override
    public void setAnalysisRectangle(BoundsSpec rect) {
        this.propertySupport.setProperty("analysisRectangle", (Object)rect);
    }

    @Override
    public void setAnalysisRectangle(int x, int y, int w, int h) {
        this.setAnalysisRectangle(new BoundsSpec(x, y, w, h));
    }

    @Override
    public boolean isAutoFit() {
        return this.propertySupport.getPropertyBool("autoFit");
    }

    @Override
    public void setAutoFit(boolean b) {
        this.propertySupport.setPropertyBool("autoFit", b);
    }

    @Override
    public boolean isScrollBarEnabled() {
        return this.propertySupport.getPropertyBool("scrollBarEnabled");
    }

    @Override
    public void setScrollBarEnabled(boolean b) {
        this.propertySupport.setPropertyBool("scrollBarEnabled", b);
    }

    @Override
    public void setDragType(int dragType) {
        this.propertySupport.setPropertyInt("dragType", dragType);
    }

    @Override
    public int getDragType() {
        return this.propertySupport.getPropertyInt("dragType");
    }

    @Override
    public void setDropType(int dropType) {
        this.propertySupport.setPropertyInt("dropType", dropType);
    }

    @Override
    public int getDropType() {
        return this.propertySupport.getPropertyInt("dropType");
    }

    @Override
    public byte[] getByteArrayValue() {
        Object value = this.getImage();
        byte[] b = null;
        if (value instanceof byte[]) {
            b = (byte[])value;
        }
        return b;
    }

    @Override
    public void doAutoFit() {
        this.fireAutoFit();
    }

    @Override
    public void doZoomRectangle(int x, int y, int w, int h) {
        this.fireZoomRectangle(new BoundsSpec(x, y, w, h));
    }

    @Override
    public void doPan(double dx, double dy) {
        AffineTransformSpec t = this.getImageTransform();
        t.dx = dx;
        t.dy = dy;
        this.setImageTransform(t);
    }

    @Override
    public void doRelativePan(double dx, double dy) {
        AffineTransformSpec t = this.getImageTransform();
        t.dx += dx;
        t.dy += dy;
        this.setImageTransform(t);
    }

    @Override
    public void doZoom(double fx, double fy) {
        AffineTransformSpec t = this.getImageTransform();
        t.sx = fx;
        t.sy = fy;
        this.setImageTransform(t);
    }

    @Override
    public void doRelativeZoom(double fx, double fy) {
        AffineTransformSpec t = this.getImageTransform();
        t.sx *= fx;
        t.sy *= fy;
        this.setImageTransform(t);
    }

    @Override
    public void doRotate(double angle) {
        AffineTransformSpec t = this.getImageTransform();
        t.angle = angle;
        this.setImageTransform(t);
    }

    @Override
    public void doRelativeRotate(double angleInDegrees) {
        AffineTransformSpec t = this.getImageTransform();
        t.angle += Math.toRadians(angleInDegrees);
        this.setImageTransform(t);
    }

    @Override
    public IImageFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    private class P_UIFacade
    implements IImageFieldUIFacade {
        private P_UIFacade() {
        }

        @Override
        public void setImageTransformFromUI(AffineTransformSpec t) {
            AbstractImageField.this.setImageTransform(t);
        }

        @Override
        public TransferObject fireDragRequestFromUI() {
            TransferObject t = null;
            try {
                t = AbstractImageField.this.execDragRequest();
            }
            catch (ProcessingException e) {
                LOG.warn(null, (Throwable)e);
            }
            return t;
        }

        @Override
        public void fireDropActionFromUi(TransferObject scoutTransferable) {
            try {
                AbstractImageField.this.execDropRequest(scoutTransferable);
            }
            catch (ProcessingException e) {
                LOG.warn(null, (Throwable)e);
            }
        }
    }
}

