/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.pagefield;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.desktop.outline.AbstractOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.pagefield.IPageField;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.AbstractTableField;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.ITableField;
import org.eclipse.scout.rt.client.ui.form.fields.wrappedform.AbstractWrappedFormField;
import org.eclipse.scout.rt.client.ui.form.fields.wrappedform.IWrappedFormField;

@ClassId(value="e2f4e714-637f-4a9b-b3be-d672900e1374")
public abstract class AbstractPageField<T extends IPage>
extends AbstractGroupBox
implements IPageField<T> {
    private T m_page;
    private SimpleOutline m_outline;

    public AbstractPageField() {
        this(true);
    }

    public AbstractPageField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected boolean getConfiguredBorderVisible() {
        return false;
    }

    @Override
    protected void initConfig() {
        this.m_outline = new SimpleOutline();
        super.initConfig();
    }

    @Override
    public final T getPage() {
        return this.m_page;
    }

    @Override
    public void setPage(T newPage) {
        this.setPageInternal(newPage);
    }

    private void setPageInternal(T page) {
        if (this.m_page == page) {
            return;
        }
        this.getDetailFormField().setInnerForm(null);
        this.getTableField().setTable(null, true);
        this.getSearchFormField().setInnerForm(null);
        if (this.m_page != null) {
            this.m_outline.disposeTree();
            this.m_outline = null;
            this.m_page = null;
        }
        this.m_page = page;
        if (this.m_page != null) {
            this.m_outline = new SimpleOutline();
            this.m_outline.setRootNode((ITreeNode)this.m_page);
            this.m_outline.selectNode((ITreeNode)this.m_page);
            this.m_outline.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("detailForm")) {
                        AbstractPageField.this.getDetailFormField().setInnerForm(((IOutline)e.getSource()).getDetailForm());
                    } else if (e.getPropertyName().equals("detailTable")) {
                        AbstractPageField.this.getTableField().setTable(((IOutline)e.getSource()).getDetailTable(), true);
                    } else if (e.getPropertyName().equals("searchForm")) {
                        AbstractPageField.this.getSearchFormField().setInnerForm(((IOutline)e.getSource()).getSearchForm());
                    }
                }
            });
            this.getDetailFormField().setInnerForm(this.m_outline.getDetailForm());
            this.getTableField().setTable(this.m_outline.getDetailTable(), true);
            this.getSearchFormField().setInnerForm(this.m_outline.getSearchForm());
        }
    }

    @Override
    public IWrappedFormField<IForm> getDetailFormField() {
        return this.getFieldByClass(DetailFormField.class);
    }

    @Override
    public ITableField<ITable> getTableField() {
        return this.getFieldByClass(TableField.class);
    }

    @Override
    public IWrappedFormField<IForm> getSearchFormField() {
        return this.getFieldByClass(SearchFormField.class);
    }

    @Order(value=30.0)
    public class DetailFormField
    extends AbstractWrappedFormField<IForm> {
        @Override
        protected boolean getConfiguredVisible() {
            return true;
        }

        @Override
        protected int getConfiguredGridW() {
            return 0;
        }

        @Override
        protected boolean execCalculateVisible() {
            return this.getInnerForm() != null;
        }
    }

    @Order(value=10.0)
    public class SearchFormField
    extends AbstractWrappedFormField<IForm> {
        @Override
        protected int getConfiguredGridW() {
            return 0;
        }

        @Override
        protected int getConfiguredGridH() {
            return 2;
        }

        @Override
        protected double getConfiguredGridWeightY() {
            return 0.001;
        }
    }

    public static class SimpleOutline
    extends AbstractOutline {
        @Override
        protected boolean getConfiguredRootNodeVisible() {
            return true;
        }
    }

    @Order(value=20.0)
    public class TableField
    extends AbstractTableField<ITable> {
        @Override
        protected boolean getConfiguredLabelVisible() {
            return false;
        }

        @Override
        protected int getConfiguredGridW() {
            return 0;
        }

        @Override
        protected int getConfiguredGridH() {
            return 7;
        }

        @Override
        protected double getConfiguredGridWeightY() {
            return 1.0;
        }
    }
}

