/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.services.lookup.FormFieldProvisioningContext;
import org.eclipse.scout.rt.client.services.lookup.ILookupCallProvisioningService;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.IFormFieldVisitor;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractRadioButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.IRadioButton;
import org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.IRadioButtonGroup;
import org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.internal.RadioButtonGroupGrid;
import org.eclipse.scout.rt.shared.data.form.ValidationRule;
import org.eclipse.scout.rt.shared.services.common.code.CODES;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.lookup.CodeLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.service.SERVICES;

@ClassId(value="20dd4412-e677-4996-afcc-13c43b9dcae8")
public abstract class AbstractRadioButtonGroup<T>
extends AbstractValueField<T>
implements IRadioButtonGroup<T>,
ICompositeField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractRadioButtonGroup.class);
    private boolean m_valueAndSelectionMediatorActive;
    private ILookupCall<T> m_lookupCall;
    private Class<? extends ICodeType<?, T>> m_codeTypeClass;
    private RadioButtonGroupGrid m_grid;
    private List<IFormField> m_fields;
    private List<IRadioButton<T>> m_radioButtons;

    public AbstractRadioButtonGroup() {
        this(true);
    }

    public AbstractRadioButtonGroup(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="LOOKUP_CALL")
    @Order(value=240.0)
    @ValidationRule(value="lookupCall")
    protected Class<? extends ILookupCall<T>> getConfiguredLookupCall() {
        return null;
    }

    @ConfigProperty(value="CODE_TYPE")
    @Order(value=250.0)
    @ValidationRule(value="codeType")
    protected Class<? extends ICodeType<?, T>> getConfiguredCodeType() {
        return null;
    }

    @Override
    @Order(value=210.0)
    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredAutoAddDefaultMenus() {
        return false;
    }

    @ConfigOperation
    @Order(value=260.0)
    protected void execPrepareLookup(ILookupCall<T> call) {
    }

    @ConfigOperation
    @Order(value=270.0)
    protected void execFilterLookupResult(ILookupCall<T> call, List<ILookupRow<T>> result) throws ProcessingException {
    }

    @Override
    protected void initConfig() {
        Class<ILookupCall<T>> lookupCallClass;
        this.m_fields = CollectionUtility.emptyArrayList();
        this.m_grid = new RadioButtonGroupGrid(this);
        super.initConfig();
        if (this.getConfiguredCodeType() != null) {
            this.setCodeTypeClass(this.getConfiguredCodeType());
        }
        if ((lookupCallClass = this.getConfiguredLookupCall()) != null) {
            try {
                ILookupCall<T> call = lookupCallClass.newInstance();
                this.setLookupCall(call);
            }
            catch (Exception e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + lookupCallClass.getName() + "'.", (Throwable)e));
            }
        }
        List<Class<IFormField>> configuredFields = this.getConfiguredFields();
        ArrayList<IFormField> fieldList = new ArrayList<IFormField>(configuredFields.size());
        for (Class<IFormField> fieldClazz : configuredFields) {
            try {
                fieldList.add((IFormField)ConfigurationUtility.newInnerInstance((Object)this, fieldClazz));
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + fieldClazz.getName() + "'.", t));
            }
        }
        this.injectFieldsInternal(fieldList);
        for (IFormField f : fieldList) {
            f.setParentFieldInternal(this);
        }
        this.m_fields = fieldList;
        for (IFormField f : this.m_fields) {
            f.addPropertyChangeListener(new P_FieldPropertyChangeListenerEx());
        }
        ArrayList<IRadioButton<T>> buttonList = new ArrayList<IRadioButton<T>>();
        for (IFormField iFormField : this.m_fields) {
            IRadioButton<T> b = this.findFirstButtonInFieldTree(iFormField);
            if (b == null) continue;
            buttonList.add(b);
        }
        this.m_radioButtons = buttonList;
        for (IRadioButton iRadioButton : this.m_radioButtons) {
            iRadioButton.addPropertyChangeListener(new P_ButtonPropertyChangeListener());
        }
        this.handleFieldVisibilityChanged();
    }

    private IRadioButton<T> findFirstButtonInFieldTree(IFormField f) {
        if (f instanceof IRadioButton) {
            return (IRadioButton)f;
        }
        if (f instanceof ICompositeField) {
            for (IFormField sub : ((ICompositeField)f).getFields()) {
                IRadioButton<T> b = this.findFirstButtonInFieldTree(sub);
                if (b == null) continue;
                return b;
            }
        }
        return null;
    }

    protected void injectFieldsInternal(List<IFormField> fieldList) {
        if (this.getLookupCall() != null) {
            try {
                List<ILookupRow<T>> lookupRows = this.getLookupRows();
                for (ILookupRow<T> row : lookupRows) {
                    RadioButton radioButton = new RadioButton();
                    radioButton.setEnabled(row.isEnabled());
                    radioButton.setLabel(row.getText());
                    radioButton.setRadioValue(row.getKey());
                    radioButton.setTooltipText(row.getTooltipText());
                    radioButton.setBackgroundColor(row.getBackgroundColor());
                    radioButton.setForegroundColor(row.getForegroundColor());
                    radioButton.setFont(row.getFont());
                    fieldList.add(radioButton);
                }
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException(this.getClass().getSimpleName(), (Throwable)e));
            }
        }
    }

    public ILookupCall<T> getLookupCall() {
        return this.m_lookupCall;
    }

    public void setLookupCall(ILookupCall<T> call) {
        this.m_lookupCall = call;
    }

    public Class<? extends ICodeType<?, T>> getCodeTypeClass() {
        return this.m_codeTypeClass;
    }

    public void setCodeTypeClass(Class<? extends ICodeType<?, T>> codeTypeClass) {
        this.m_codeTypeClass = codeTypeClass;
        this.m_lookupCall = null;
        if (this.m_codeTypeClass != null) {
            this.m_lookupCall = CodeLookupCall.newInstanceByService(this.m_codeTypeClass);
        }
        if (this.getConfiguredLabel() == null) {
            this.setLabel(CODES.getCodeType(codeTypeClass).getText());
        }
    }

    protected List<Class<? extends IFormField>> getConfiguredFields() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, IFormField.class);
        return ConfigurationUtility.sortFilteredClassesByOrderAnnotation((List)filtered, IFormField.class);
    }

    @Override
    protected void initFieldInternal() throws ProcessingException {
        IRadioButton<Object> b = this.getButtonFor(null);
        if (b != null) {
            this.syncValueToButtons();
        }
        super.initFieldInternal();
    }

    private List<ILookupRow<T>> getLookupRows() throws ProcessingException {
        ArrayList data;
        ILookupCall<T> call = this.getLookupCall();
        if (call != null) {
            call = ((ILookupCallProvisioningService)SERVICES.getService(ILookupCallProvisioningService.class)).newClonedInstance(call, new FormFieldProvisioningContext(this));
            this.prepareLookupCall(call);
            data = CollectionUtility.arrayList((Collection)call.getDataByAll());
        } else {
            data = CollectionUtility.emptyArrayList();
        }
        this.filterLookup(call, data);
        return data;
    }

    private void prepareLookupCall(ILookupCall<T> call) {
        this.prepareLookupCallInternal(call);
        this.execPrepareLookup(call);
    }

    private void prepareLookupCallInternal(ILookupCall<T> call) {
        call.setActive(TriState.UNDEFINED);
        if (this.getMasterValue() != null || this.getLookupCall() == null || this.getLookupCall().getMaster() == null) {
            call.setMaster(this.getMasterValue());
        }
    }

    private void filterLookup(ILookupCall<T> call, List<ILookupRow<T>> result) throws ProcessingException {
        this.execFilterLookupResult(call, result);
        Iterator<ILookupRow<T>> resultIt = result.iterator();
        while (resultIt.hasNext()) {
            ILookupRow<T> row = resultIt.next();
            if (row == null) {
                resultIt.remove();
                continue;
            }
            if (row.getKey() != null) continue;
            LOG.warn("The key of a lookup row may not be null. Row has been removed for radio button group '" + this.getClass().getName() + "'.");
            resultIt.remove();
        }
    }

    @Override
    public void rebuildFieldGrid() {
        if (this.m_grid != null) {
            this.m_grid.validate();
            if (this.isInitialized()) {
                if (this.getParentField() != null) {
                    this.getParentField().rebuildFieldGrid();
                }
                if (this.getForm() != null) {
                    this.getForm().structureChanged(this);
                }
            }
        }
    }

    protected void handleFieldVisibilityChanged() {
        if (this.isInitialized()) {
            this.rebuildFieldGrid();
        }
    }

    @Override
    public final int getGridColumnCount() {
        return this.m_grid != null ? this.m_grid.getGridColumnCount() : 1;
    }

    @Override
    public final int getGridRowCount() {
        return this.m_grid != null ? this.m_grid.getGridRowCount() : 1;
    }

    @Override
    public void setFormInternal(IForm form) {
        super.setFormInternal(form);
        for (IFormField f : this.getFields()) {
            f.setFormInternal(form);
        }
    }

    @Override
    protected void valueChangedInternal() {
        super.valueChangedInternal();
        this.syncValueToButtons();
    }

    @Override
    protected T validateValueInternal(T rawValue) throws ProcessingException {
        T validValue;
        if (rawValue == null) {
            validValue = null;
        } else {
            IRadioButton<T> b = this.getButtonFor(rawValue);
            if (b != null) {
                validValue = rawValue;
            } else {
                throw new ProcessingException("Illegal radio value: " + rawValue);
            }
        }
        return validValue;
    }

    @Override
    protected double getConfiguredGridWeightY() {
        return 0.0;
    }

    @Override
    public T getSelectedKey() {
        return this.getValue();
    }

    @Override
    public IRadioButton<T> getButtonFor(T value) {
        for (IRadioButton<T> b : this.getButtons()) {
            T radioValue = b.getRadioValue();
            if (!CompareUtility.equals(radioValue, value)) continue;
            return b;
        }
        return null;
    }

    @Override
    public IRadioButton<T> getSelectedButton() {
        return this.getButtonFor(this.getSelectedKey());
    }

    @Override
    public void selectKey(T key) {
        this.setValue(key);
    }

    @Override
    public void selectButton(IRadioButton button) {
        for (IRadioButton<T> b : this.getButtons()) {
            if (b != button) continue;
            button.setSelected(true);
            break;
        }
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        for (IFormField f : this.m_fields) {
            f.setEnabled(b);
        }
    }

    @Override
    public void setEnabledGranted(boolean b) {
        super.setEnabledGranted(b);
        for (IFormField f : this.getFields()) {
            if (f.getEnabledPermission() != null) continue;
            f.setEnabledGranted(b);
        }
    }

    public <F extends IFormField> F getFieldByClass(final Class<F> c) {
        final Holder found = new Holder(IFormField.class);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (field.getClass() == c) {
                    found.setValue((Object)field);
                }
                return found.getValue() == null;
            }
        };
        this.visitFields(v, 0);
        return (F)((IFormField)found.getValue());
    }

    @Override
    public IFormField getFieldById(final String id) {
        final Holder found = new Holder(IFormField.class);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (field.getFieldId().equals(id)) {
                    found.setValue((Object)field);
                }
                return found.getValue() == null;
            }
        };
        this.visitFields(v, 0);
        return (IFormField)found.getValue();
    }

    public <X extends IFormField> X getFieldById(final String id, final Class<X> type) {
        final Holder found = new Holder(type);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (type.isAssignableFrom(field.getClass()) && field.getFieldId().equals(id)) {
                    found.setValue((Object)field);
                }
                return found.getValue() == null;
            }
        };
        this.visitFields(v, 0);
        return (X)((IFormField)found.getValue());
    }

    @Override
    public int getFieldCount() {
        return this.m_fields.size();
    }

    @Override
    public int getFieldIndex(IFormField f) {
        return this.m_fields.indexOf(f);
    }

    @Override
    public List<IFormField> getFields() {
        return CollectionUtility.arrayList(this.m_fields);
    }

    @Override
    public List<IRadioButton<T>> getButtons() {
        if (this.m_radioButtons == null) {
            return CollectionUtility.emptyArrayList();
        }
        return CollectionUtility.arrayList(this.m_radioButtons);
    }

    @Override
    public boolean visitFields(IFormFieldVisitor visitor, int startLevel) {
        if (!visitor.visitField(this, startLevel, 0)) {
            return false;
        }
        int index = 0;
        for (IFormField field : this.m_fields) {
            if (field instanceof ICompositeField ? !((ICompositeField)field).visitFields(visitor, startLevel + 1) : !visitor.visitField(field, startLevel, index)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    private void syncValueToButtons() {
        if (this.m_valueAndSelectionMediatorActive) {
            return;
        }
        try {
            this.m_valueAndSelectionMediatorActive = true;
            T selectedKey = this.getSelectedKey();
            IRadioButton<T> selectedButton = this.getButtonFor(selectedKey);
            for (IRadioButton<T> b : this.getButtons()) {
                b.setSelected(b == selectedButton);
            }
        }
        finally {
            this.m_valueAndSelectionMediatorActive = false;
        }
    }

    private void syncButtonsToValue(IRadioButton<T> selectedButton) {
        if (this.m_valueAndSelectionMediatorActive) {
            return;
        }
        try {
            this.m_valueAndSelectionMediatorActive = true;
            for (IRadioButton<T> b : this.getButtons()) {
                b.setSelected(b == selectedButton);
            }
            this.selectKey(selectedButton.getRadioValue());
        }
        finally {
            this.m_valueAndSelectionMediatorActive = false;
        }
    }

    private class P_ButtonPropertyChangeListener
    implements PropertyChangeListener {
        private P_ButtonPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("selected") && ((IRadioButton)e.getSource()).isSelected()) {
                AbstractRadioButtonGroup.this.syncButtonsToValue((IRadioButton)e.getSource());
            }
        }
    }

    private class P_FieldPropertyChangeListenerEx
    implements PropertyChangeListener {
        private P_FieldPropertyChangeListenerEx() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("visible")) {
                AbstractRadioButtonGroup.this.handleFieldVisibilityChanged();
            } else if (e.getPropertyName().equals("saveNeeded")) {
                AbstractRadioButtonGroup.this.checkSaveNeeded();
            } else if (e.getPropertyName().equals("empty")) {
                AbstractRadioButtonGroup.this.checkEmpty();
            }
        }
    }

    private final class RadioButton
    extends AbstractRadioButton<T> {
        private RadioButton() {
        }

        @Override
        protected void initConfig() {
            super.initConfig();
        }
    }
}

