/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.smartfield;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.annotations.ScoutSdkIgnore;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.VetoException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientAsyncJob;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.services.lookup.FormFieldProvisioningContext;
import org.eclipse.scout.rt.client.services.lookup.ILookupCallProvisioningService;
import org.eclipse.scout.rt.client.ui.form.fields.ParsingFailedStatus;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractContentAssistField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IContentAssistFieldDataFetchResult;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IContentAssistFieldProposalForm;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IContentAssistFieldUIFacade;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;
import org.eclipse.scout.service.SERVICES;

@ScoutSdkIgnore
public class AbstractMixedSmartField<VALUE_TYPE, LOOKUP_CALL_KEY_TYPE>
extends AbstractContentAssistField<VALUE_TYPE, LOOKUP_CALL_KEY_TYPE> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractMixedSmartField.class);
    private P_GetLookupRowByKeyJob m_currentGetLookupRowByKeyJob;
    private P_UIFacade m_uiFacade;

    public AbstractMixedSmartField() {
        this(true);
    }

    public AbstractMixedSmartField(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigOperation
    @Order(value=400.0)
    protected VALUE_TYPE execConvertKeyToValue(LOOKUP_CALL_KEY_TYPE key) {
        return (VALUE_TYPE)key;
    }

    @ConfigOperation
    @Order(value=410.0)
    protected LOOKUP_CALL_KEY_TYPE execConvertValueToKey(VALUE_TYPE value) {
        return (LOOKUP_CALL_KEY_TYPE)value;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.m_uiFacade = new P_UIFacade();
    }

    @Override
    public IContentAssistFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public LOOKUP_CALL_KEY_TYPE getValueAsLookupKey() {
        return this.execConvertValueToKey(this.getValue());
    }

    @Override
    protected VALUE_TYPE parseValueInternal(String text) throws ProcessingException {
        if (text != null && text.length() == 0) {
            text = null;
        }
        IContentAssistFieldProposalForm<Object> smartForm = this.getProposalForm();
        ILookupRow acceptedProposalRow = null;
        if (smartForm != null && StringUtility.equalsIgnoreNewLines((String)smartForm.getSearchText(), (String)text)) {
            acceptedProposalRow = smartForm.getAcceptedProposal();
        }
        try {
            String oldText = this.getDisplayText();
            boolean parsingError = this.getErrorStatus() instanceof ParsingFailedStatus;
            if (acceptedProposalRow == null && !parsingError && this.getCurrentLookupRow() != null && StringUtility.equalsIgnoreNewLines((String)StringUtility.emptyIfNull((Object)text), (String)StringUtility.emptyIfNull((Object)oldText))) {
                Object t = this.getValue();
                return (VALUE_TYPE)t;
            }
            if (acceptedProposalRow != null) {
                this.setCurrentLookupRow(acceptedProposalRow);
                VALUE_TYPE VALUE_TYPE = this.execConvertKeyToValue(acceptedProposalRow.getKey());
                return VALUE_TYPE;
            }
            if (text == null) {
                this.setCurrentLookupRow(this.EMPTY_LOOKUP_ROW);
                return null;
            }
            this.doSearch(text, false, true);
            IContentAssistFieldDataFetchResult fetchResult = this.getLookupRowFetcher().getResult();
            if (fetchResult != null && fetchResult.getLookupRows() != null && fetchResult.getLookupRows().size() == 1) {
                acceptedProposalRow = (ILookupRow)CollectionUtility.firstElement(fetchResult.getLookupRows());
            }
            if (acceptedProposalRow != null) {
                this.setCurrentLookupRow(acceptedProposalRow);
                VALUE_TYPE VALUE_TYPE = this.execConvertKeyToValue(acceptedProposalRow.getKey());
                return VALUE_TYPE;
            }
            if (smartForm == null) {
                smartForm = this.createProposalForm();
                smartForm.startForm();
                smartForm.dataFetchedDelegate(fetchResult, this.getConfiguredBrowseMaxRowCount());
            }
            this.registerProposalFormInternal(smartForm);
            smartForm = null;
            throw new VetoException(ScoutTexts.get((String)"SmartFieldCannotComplete", (String[])new String[]{text}));
        }
        finally {
            this.unregisterProposalFormInternal(smartForm);
        }
    }

    @Override
    public void acceptProposal(ILookupRow<LOOKUP_CALL_KEY_TYPE> row) {
        this.setCurrentLookupRow(row);
        this.setValue(this.execConvertKeyToValue(row.getKey()));
    }

    @Override
    public void applyLazyStyles() {
        if (this.m_currentGetLookupRowByKeyJob != null && this.m_currentGetLookupRowByKeyJob.getClientSession() == ClientSyncJob.getCurrentSession() && ClientSyncJob.isSyncClientJob()) {
            this.m_currentGetLookupRowByKeyJob.runNow((IProgressMonitor)new NullProgressMonitor());
        }
    }

    @Override
    protected void installLookupRowContext(ILookupRow<LOOKUP_CALL_KEY_TYPE> row) {
        this.setCurrentLookupRow(row);
        super.installLookupRowContext(row);
    }

    @Override
    protected String formatValueInternal(VALUE_TYPE validKey) {
        if (!(this.getCurrentLookupRow() == null || validKey == this.getCurrentLookupRow().getKey() || validKey != null && validKey.equals(this.getCurrentLookupRow().getKey()))) {
            this.setCurrentLookupRow(null);
        }
        if (this.m_currentGetLookupRowByKeyJob != null) {
            this.m_currentGetLookupRowByKeyJob.cancel();
            this.m_currentGetLookupRowByKeyJob = null;
        }
        if (this.getCurrentLookupRow() == null && validKey == null) {
            this.setCurrentLookupRow(this.EMPTY_LOOKUP_ROW);
        }
        if (this.getCurrentLookupRow() != null) {
            this.installLookupRowContext((ILookupRow<LOOKUP_CALL_KEY_TYPE>)this.getCurrentLookupRow());
            String text = this.getCurrentLookupRow().getText();
            if (text != null) {
                text = text.replaceAll("[\\n\\r]+", " ");
            }
            return text;
        }
        if (this.getLookupCall() != null) {
            try {
                if (this.getLookupCall() instanceof LocalLookupCall) {
                    List<ILookupRow<LOOKUP_CALL_KEY_TYPE>> rows = this.callKeyLookup(this.execConvertValueToKey(validKey));
                    if (rows != null && !rows.isEmpty()) {
                        this.installLookupRowContext(rows.get(0));
                    } else {
                        this.installLookupRowContext((ILookupRow<LOOKUP_CALL_KEY_TYPE>)this.EMPTY_LOOKUP_ROW);
                    }
                } else {
                    ILookupCall call = ((ILookupCallProvisioningService)SERVICES.getService(ILookupCallProvisioningService.class)).newClonedInstance(this.getLookupCall(), new FormFieldProvisioningContext(this));
                    this.prepareKeyLookup(call, this.execConvertValueToKey(validKey));
                    this.m_currentGetLookupRowByKeyJob = new P_GetLookupRowByKeyJob(call);
                    this.m_currentGetLookupRowByKeyJob.schedule();
                }
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }
        return this.propertySupport.getPropertyString("displayText");
    }

    @Override
    public void refreshDisplayText() {
        if (this.getLookupCall() != null && this.getValue() != null) {
            try {
                List<ILookupRow<LOOKUP_CALL_KEY_TYPE>> rows = this.callKeyLookup(this.execConvertValueToKey(this.getValue()));
                if (rows != null && !rows.isEmpty()) {
                    this.installLookupRowContext(rows.get(0));
                }
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }
    }

    @Override
    protected IContentAssistFieldProposalForm<LOOKUP_CALL_KEY_TYPE> createProposalForm() throws ProcessingException {
        return this.createProposalForm(false);
    }

    @Override
    protected void handleProposalFormClosed(IContentAssistFieldProposalForm<LOOKUP_CALL_KEY_TYPE> proposalForm) throws ProcessingException {
        if (this.getProposalForm() == proposalForm) {
            if (proposalForm.getCloseSystemType() == 3) {
                ILookupRow<LOOKUP_CALL_KEY_TYPE> row = proposalForm.getAcceptedProposal();
                if (row != null) {
                    this.acceptProposal(row);
                }
            } else {
                this.revertValue();
            }
            this.registerProposalFormInternal(null);
        }
    }

    @Override
    protected void handleFetchResult(IContentAssistFieldDataFetchResult<LOOKUP_CALL_KEY_TYPE> result) {
        IContentAssistFieldProposalForm<LOOKUP_CALL_KEY_TYPE> smartForm = this.getProposalForm();
        if (smartForm != null && result != null) {
            smartForm.dataFetchedDelegate(result, this.getBrowseMaxRowCount());
        }
    }

    private class P_GetLookupRowByKeyJob
    extends ClientSyncJob {
        private List<ILookupRow<LOOKUP_CALL_KEY_TYPE>> m_rows;
        private final ClientAsyncJob m_backgroundJob;

        public P_GetLookupRowByKeyJob(final ILookupCall<LOOKUP_CALL_KEY_TYPE> call) {
            super("Fetch smartfield data for " + AbstractMixedSmartField.this.getLabel(), P_GetLookupRowByKeyJob.getCurrentSession());
            this.m_backgroundJob = new ClientAsyncJob("Fetch smartfield data", ClientSyncJob.getCurrentSession()){

                @Override
                protected void runVoid(IProgressMonitor monitor) throws Throwable {
                    ArrayList result = new ArrayList(call.getDataByKey());
                    AbstractMixedSmartField.this.filterKeyLookup(call, result);
                    P_GetLookupRowByKeyJob.this.m_rows = AbstractMixedSmartField.this.cleanupResultList(result);
                }
            };
            this.m_backgroundJob.schedule();
        }

        @Override
        protected void runVoid(IProgressMonitor monitor) throws Throwable {
            if (this == AbstractMixedSmartField.this.m_currentGetLookupRowByKeyJob) {
                AbstractMixedSmartField.this.m_currentGetLookupRowByKeyJob = null;
                try {
                    this.m_backgroundJob.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.m_backgroundJob.getResult() != null) {
                    if (this.m_backgroundJob.getResult().getException() == null) {
                        if (this.m_rows != null && !this.m_rows.isEmpty()) {
                            AbstractMixedSmartField.this.installLookupRowContext(this.m_rows.get(0));
                        } else {
                            AbstractMixedSmartField.this.installLookupRowContext(AbstractMixedSmartField.this.EMPTY_LOOKUP_ROW);
                        }
                    } else {
                        LOG.error(null, this.m_backgroundJob.getResult().getException());
                    }
                }
            }
        }
    }

    private class P_UIFacade
    implements IContentAssistFieldUIFacade {
        private P_UIFacade() {
        }

        @Override
        public boolean setTextFromUI(String text) {
            block9: {
                String currentValidText;
                block7: {
                    IContentAssistFieldProposalForm smartForm;
                    block8: {
                        currentValidText = AbstractMixedSmartField.this.getCurrentLookupRow() != null ? AbstractMixedSmartField.this.getCurrentLookupRow().getText() : null;
                        smartForm = AbstractMixedSmartField.this.getProposalForm();
                        try {
                            if (smartForm != null && smartForm.getAcceptedProposal() != null) {
                                return this.acceptProposalFromUI();
                            }
                            if (smartForm == null || !StringUtility.equalsIgnoreNewLines((String)text, (String)smartForm.getSearchText()) && !StringUtility.equalsIgnoreNewLines((String)StringUtility.emptyIfNull((Object)text), (String)StringUtility.emptyIfNull((Object)currentValidText))) break block7;
                            if (text == null || text.length() == 0) {
                                boolean b = AbstractMixedSmartField.this.parseValue(text);
                                return b;
                            }
                            if (StringUtility.equalsIgnoreNewLines((String)StringUtility.emptyIfNull((Object)text), (String)StringUtility.emptyIfNull((Object)currentValidText))) break block8;
                            smartForm.forceProposalSelection();
                            return false;
                        }
                        catch (ProcessingException e) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                            return true;
                        }
                    }
                    smartForm.doClose();
                    return true;
                }
                if (!CompareUtility.equals((Object)text, (Object)currentValidText)) break block9;
                return true;
            }
            return AbstractMixedSmartField.this.parseValue(text);
        }

        @Override
        public void openProposalFromUI(String newText, boolean selectCurrentValue) {
            if (newText == null) {
                newText = "*";
            }
            try {
                IContentAssistFieldProposalForm<Object> smartForm = AbstractMixedSmartField.this.getProposalForm();
                if (smartForm == null) {
                    AbstractMixedSmartField.this.setActiveFilter(TriState.TRUE);
                    smartForm = AbstractMixedSmartField.this.createProposalForm();
                    smartForm.startForm();
                    smartForm.dataFetchedDelegate(AbstractMixedSmartField.this.getLookupRowFetcher().getResult(), AbstractMixedSmartField.this.getConfiguredBrowseMaxRowCount());
                    if (smartForm.isFormOpen()) {
                        AbstractMixedSmartField.this.doSearch(newText, selectCurrentValue, false);
                        AbstractMixedSmartField.this.registerProposalFormInternal(smartForm);
                    }
                } else if (!StringUtility.equalsIgnoreNewLines((String)AbstractMixedSmartField.this.getLookupRowFetcher().getLastSearchText(), (String)newText)) {
                    AbstractMixedSmartField.this.doSearch(newText, false, false);
                }
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }

        @Override
        public boolean acceptProposalFromUI() {
            block4: {
                IContentAssistFieldProposalForm smartForm;
                block6: {
                    block5: {
                        smartForm = AbstractMixedSmartField.this.getProposalForm();
                        if (smartForm == null) break block4;
                        if (smartForm.getAcceptedProposal() == null) break block5;
                        smartForm.doOk();
                        return true;
                    }
                    if (!StringUtility.isNullOrEmpty((String)AbstractMixedSmartField.this.getDisplayText())) break block6;
                    return true;
                }
                try {
                    smartForm.forceProposalSelection();
                    return false;
                }
                catch (ProcessingException e) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                }
            }
            return false;
        }

        @Override
        public void unregisterProposalFormFromUI(IContentAssistFieldProposalForm form) {
            AbstractMixedSmartField.this.unregisterProposalFormInternal(form);
        }
    }
}

