/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.smartfield;

import java.util.List;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IContentAssistFieldDataFetchResult;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;

public class ContentAssistFieldDataFetchResult<LOOKUP_TYPE>
implements IContentAssistFieldDataFetchResult<LOOKUP_TYPE> {
    private final List<? extends ILookupRow<LOOKUP_TYPE>> m_lookupRows;
    private final ProcessingException m_processingException;
    private final String m_searchText;
    private final boolean m_selectCurrentValue;

    public ContentAssistFieldDataFetchResult(List<? extends ILookupRow<LOOKUP_TYPE>> rows, ProcessingException failed, String searchText, boolean selectCurrentValue) {
        this.m_lookupRows = rows;
        this.m_processingException = failed;
        this.m_searchText = searchText;
        this.m_selectCurrentValue = selectCurrentValue;
    }

    @Override
    public List<? extends ILookupRow<LOOKUP_TYPE>> getLookupRows() {
        return this.m_lookupRows;
    }

    @Override
    public ProcessingException getProcessingException() {
        return this.m_processingException;
    }

    @Override
    public String getSearchText() {
        return this.m_searchText;
    }

    @Override
    public boolean isSelectCurrentValue() {
        return this.m_selectCurrentValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentAssistFieldDataFetchResult other = (ContentAssistFieldDataFetchResult)obj;
        if (this.m_lookupRows == null ? other.m_lookupRows != null : !this.m_lookupRows.equals(other.m_lookupRows)) {
            return false;
        }
        if (this.m_processingException == null && other.getProcessingException() != null) {
            return false;
        }
        if (this.m_processingException != null && other.getProcessingException() == null) {
            return false;
        }
        if (this.m_processingException != null && other.getProcessingException() != null) {
            IProcessingStatus status = this.m_processingException.getStatus();
            IProcessingStatus otherStatus = other.getProcessingException().getStatus();
            if (status == null ? otherStatus != null : !status.equals(otherStatus)) {
                return false;
            }
        }
        if (this.m_searchText == null ? other.m_searchText != null : !this.m_searchText.equals(other.m_searchText)) {
            return false;
        }
        return this.m_selectCurrentValue == other.m_selectCurrentValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_lookupRows == null ? 0 : this.m_lookupRows.hashCode());
        result = 31 * result + (this.m_processingException == null || this.m_processingException.getStatus() == null ? 0 : this.m_processingException.getStatus().hashCode());
        result = 31 * result + (this.m_searchText == null ? 0 : this.m_searchText.hashCode());
        result = 31 * result + (this.m_selectCurrentValue ? 1231 : 1237);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LookupRowFetcherResult {");
        builder.append("[searchText:'").append(this.getSearchText()).append("']");
        builder.append(" [rowCount:'");
        if (this.getLookupRows() != null) {
            builder.append(this.getLookupRows().size());
        } else {
            builder.append("null");
        }
        builder.append("']");
        builder.append(" [selectCurrentValue:'").append(this.isSelectCurrentValue()).append("']");
        builder.append(" [processingException:'").append((Object)this.getProcessingException()).append("']");
        builder.append("}");
        return builder.toString();
    }
}

