/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.smartfield;

import java.util.List;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractContentAssistFieldLookupRowFetcher;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ContentAssistFieldDataFetchResult;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IContentAssistField;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCallFetcher;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;

public class ContentAssistFieldDataFetcher<LOOKUP_TYPE>
extends AbstractContentAssistFieldLookupRowFetcher<LOOKUP_TYPE> {
    private JobEx m_dataLoadJob;

    public ContentAssistFieldDataFetcher(IContentAssistField<?, LOOKUP_TYPE> proposalField) {
        super(proposalField);
    }

    @Override
    public void update(String searchText, boolean selectCurrentValue, boolean synchronous) {
        String text = searchText;
        if (text == null) {
            text = "";
        }
        String textNonNull = text;
        int maxCount = this.getContentAssistField().getBrowseMaxRowCount();
        if (this.m_dataLoadJob != null) {
            this.m_dataLoadJob.cancel();
        }
        P_LookupCallFetcher fetcher = new P_LookupCallFetcher(searchText, selectCurrentValue);
        if (synchronous) {
            try {
                List rows = "*".equals(text) ? this.getContentAssistField().callBrowseLookup(text, maxCount > 0 ? maxCount + 1 : 0) : (text.length() == 0 ? this.getContentAssistField().callBrowseLookup(text, maxCount > 0 ? maxCount + 1 : 0) : this.getContentAssistField().callTextLookup(text, maxCount > 0 ? maxCount + 1 : 0));
                fetcher.dataFetched(rows, null);
            }
            catch (ProcessingException e) {
                fetcher.dataFetched(null, e);
            }
        } else {
            this.m_dataLoadJob = "*".equals(textNonNull) ? this.getContentAssistField().callBrowseLookupInBackground(textNonNull, maxCount > 0 ? maxCount + 1 : 0, fetcher) : (textNonNull.length() == 0 ? this.getContentAssistField().callBrowseLookupInBackground(textNonNull, maxCount > 0 ? maxCount + 1 : 0, fetcher) : this.getContentAssistField().callTextLookupInBackground(textNonNull, maxCount > 0 ? maxCount + 1 : 0, fetcher));
        }
    }

    private class P_LookupCallFetcher
    implements ILookupCallFetcher<LOOKUP_TYPE> {
        private String m_searchText;
        private boolean m_selectCurrentValue;

        private P_LookupCallFetcher(String searchText, boolean selectCurrentValue) {
            this.m_searchText = searchText;
            this.m_selectCurrentValue = selectCurrentValue;
        }

        public void dataFetched(List<? extends ILookupRow<LOOKUP_TYPE>> rows, ProcessingException failed) {
            ContentAssistFieldDataFetcher.this.setResult(new ContentAssistFieldDataFetchResult(rows, failed, this.m_searchText, this.m_selectCurrentValue));
        }
    }
}

