/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.IFormFieldVisitor;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;

public class FindFieldByXmlIdsVisitor
implements IFormFieldVisitor {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(FindFieldByXmlIdsVisitor.class);
    private final String[] m_xmlFieldIds;
    private final TreeMap<CompositeObject, IFormField> m_prioMap;
    private final Set<CompositeObject> m_ambiguousFieldKeys;

    public FindFieldByXmlIdsVisitor(String ... xmlFieldIds) {
        this.m_xmlFieldIds = xmlFieldIds;
        this.m_prioMap = new TreeMap();
        this.m_ambiguousFieldKeys = new HashSet<CompositeObject>();
    }

    @Override
    public boolean visitField(IFormField field, int level, int fieldIndex) {
        int fieldIdRank = this.getFieldIdRank(field);
        if (fieldIdRank > 0) {
            int enclosingFieldPathRank = this.getEnclosingFieldPathRank(field);
            CompositeObject key = field instanceof IValueField ? new CompositeObject(new Object[]{fieldIdRank, enclosingFieldPathRank, 2}) : (!(field instanceof ICompositeField) ? new CompositeObject(new Object[]{fieldIdRank, enclosingFieldPathRank, 1}) : new CompositeObject(new Object[]{fieldIdRank, enclosingFieldPathRank, 0}));
            if (this.m_prioMap.containsKey(key)) {
                this.m_ambiguousFieldKeys.add(key);
            } else {
                this.m_prioMap.put(key, field);
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getFieldIdRank(IFormField f) {
        int i = this.m_xmlFieldIds.length - 1;
        if (!this.m_xmlFieldIds[i].equals(f.getFieldId())) {
            return 0;
        }
        --i;
        f = f.getParentField();
        while (i >= 0 && f != null) {
            if (this.m_xmlFieldIds[i].equals(f.getFieldId())) {
                --i;
            }
            f = f.getParentField();
        }
        return this.m_xmlFieldIds.length - 1 - i;
    }

    private int getEnclosingFieldPathRank(IFormField f) {
        int rank = 0;
        int i = this.m_xmlFieldIds.length - 2;
        Class currentEnclosingContainerType = ConfigurationUtility.getEnclosingContainerType((Object)f);
        ICompositeField p = f.getParentField();
        while (p != null) {
            Class enclosingContainerType = ConfigurationUtility.getEnclosingContainerType((Object)p);
            if (enclosingContainerType != currentEnclosingContainerType) {
                if (i >= 0 && p.getFieldId().equals(this.m_xmlFieldIds[i])) {
                    --i;
                } else {
                    --rank;
                }
                currentEnclosingContainerType = enclosingContainerType;
            }
            p = p.getParentField();
        }
        return rank;
    }

    public IFormField getField() {
        if (this.m_prioMap.isEmpty()) {
            return null;
        }
        Map.Entry<CompositeObject, IFormField> candidate = this.m_prioMap.lastEntry();
        if (this.m_ambiguousFieldKeys.contains(candidate.getKey()) && Platform.inDevelopmentMode() && LOG.isWarnEnabled()) {
            LOG.warn("ambiguous fieldId: " + Arrays.toString(this.m_xmlFieldIds) + " returning first candidate [" + candidate.getValue() + "]");
        }
        return candidate.getValue();
    }
}

