/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.clientnotification;

import java.util.LinkedList;
import java.util.Set;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.ThreadContext;
import org.eclipse.scout.rt.server.services.common.clientnotification.ClientNotificationClusterNotification;
import org.eclipse.scout.rt.server.services.common.clientnotification.ClientNotificationClusterNotificationListener;
import org.eclipse.scout.rt.server.services.common.clientnotification.IClientNotificationFilter;
import org.eclipse.scout.rt.server.services.common.clientnotification.IClientNotificationQueueElement;
import org.eclipse.scout.rt.server.services.common.clientnotification.IClientNotificationQueueListener;
import org.eclipse.scout.rt.server.services.common.clientnotification.IClientNotificationService;
import org.eclipse.scout.rt.server.services.common.clientnotification.internal.ClientNotificationQueue;
import org.eclipse.scout.rt.server.services.common.clientnotification.internal.ClientNotificationQueueElement;
import org.eclipse.scout.rt.server.services.common.clientnotification.internal.ConsumableClientNotificationQueueElement;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterSynchronizationService;
import org.eclipse.scout.rt.server.transaction.AbstractTransactionMember;
import org.eclipse.scout.rt.server.transaction.ITransaction;
import org.eclipse.scout.rt.shared.services.common.clientnotification.IClientNotification;
import org.eclipse.scout.rt.shared.servicetunnel.RemoteServiceAccessDenied;
import org.eclipse.scout.service.AbstractService;
import org.eclipse.scout.service.SERVICES;
import org.osgi.framework.ServiceRegistration;

public class ClientNotificationService
extends AbstractService
implements IClientNotificationService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ClientNotificationService.class);
    private static final String TRANSACTION_MEMBER_ID = ClientNotificationService.class.getName();
    private final ClientNotificationQueue m_clientNotificationQueue = new ClientNotificationQueue();

    public void initializeService(ServiceRegistration registration) {
        super.initializeService(registration);
        this.addClusterNotificationListener();
    }

    @Override
    public Set<IClientNotification> getNextNotifications(long blockingTimeout) {
        Set<IClientNotification> n = this.m_clientNotificationQueue.getNextNotifications(blockingTimeout);
        this.addClusterInfo(n);
        return n;
    }

    @Override
    public void putNotification(IClientNotification notification, IClientNotificationFilter filter) {
        this.tryPutNotification(new ConsumableClientNotificationQueueElement(notification, filter));
        this.distributeCluster(new ClientNotificationQueueElement(notification, filter));
    }

    @Override
    public void putNonClusterDistributedNotification(IClientNotification notification, IClientNotificationFilter filter) {
        this.tryPutNotification(new ConsumableClientNotificationQueueElement(notification, filter));
    }

    private void tryPutNotification(ConsumableClientNotificationQueueElement queueElement) {
        try {
            this.ensureTransactionMember().putNotication(queueElement);
        }
        catch (ProcessingException e) {
            LOG.error("Error adding client notification", (Throwable)e);
        }
    }

    @Override
    public void ackNotifications(Set<String> notificationIds) {
        this.m_clientNotificationQueue.ackNotifications(notificationIds);
    }

    @Override
    @RemoteServiceAccessDenied
    public void addClientNotificationQueueListener(IClientNotificationQueueListener listener) {
        this.m_clientNotificationQueue.addClientNotificationQueueListener(listener);
    }

    @Override
    @RemoteServiceAccessDenied
    public void removeClientNotificationQueueListener(IClientNotificationQueueListener listener) {
        this.m_clientNotificationQueue.removeClientNotificationQueueListener(listener);
    }

    private ClientNotificationTransactionMember ensureTransactionMember() throws ProcessingException {
        ITransaction t = ThreadContext.getTransaction();
        if (t == null) {
            throw new IllegalStateException("not inside a scout transaction (ServerJob.schedule)");
        }
        ClientNotificationTransactionMember m = (ClientNotificationTransactionMember)t.getMember(TRANSACTION_MEMBER_ID);
        if (m == null) {
            m = new ClientNotificationTransactionMember();
            t.registerMember(m);
        }
        return m;
    }

    protected void addClusterNotificationListener() {
        IClusterSynchronizationService s = (IClusterSynchronizationService)SERVICES.getService(IClusterSynchronizationService.class);
        if (s != null) {
            s.addListener(new ClientNotificationClusterNotificationListener());
        }
    }

    protected void distributeCluster(IClientNotificationQueueElement element) {
        try {
            IClusterSynchronizationService s = (IClusterSynchronizationService)SERVICES.getService(IClusterSynchronizationService.class);
            if (s != null) {
                element.getNotification().setOriginalServerNode(s.getNodeId());
                s.publishNotification(new ClientNotificationClusterNotification(element));
            }
        }
        catch (ProcessingException e) {
            LOG.error("could not send cluster sync message", (Throwable)e);
        }
    }

    protected void addClusterInfo(Set<IClientNotification> notifications) {
        IClusterSynchronizationService s = (IClusterSynchronizationService)SERVICES.getService(IClusterSynchronizationService.class);
        if (s != null) {
            for (IClientNotification n : notifications) {
                n.setProvidingServerNode(s.getNodeId());
            }
        }
    }

    private class ClientNotificationTransactionMember
    extends AbstractTransactionMember {
        private final LinkedList<ConsumableClientNotificationQueueElement> m_transactionLocalQueue;
        private final Object m_queueLock;

        public ClientNotificationTransactionMember() {
            super(TRANSACTION_MEMBER_ID);
            this.m_queueLock = new Object();
            this.m_transactionLocalQueue = new LinkedList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putNotication(ConsumableClientNotificationQueueElement n) {
            Object object = this.m_queueLock;
            synchronized (object) {
                this.m_transactionLocalQueue.add(n);
            }
        }

        @Override
        public boolean needsCommit() {
            return !this.m_transactionLocalQueue.isEmpty();
        }

        @Override
        public boolean commitPhase1() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commitPhase2() {
            Object object = this.m_queueLock;
            synchronized (object) {
                for (IClientNotificationQueueElement iClientNotificationQueueElement : this.m_transactionLocalQueue) {
                    ClientNotificationService.this.m_clientNotificationQueue.putNotification(iClientNotificationQueueElement.getNotification(), iClientNotificationQueueElement.getFilter());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rollback() {
            Object object = this.m_queueLock;
            synchronized (object) {
                this.m_transactionLocalQueue.clear();
            }
        }

        @Override
        public void release() {
        }
    }
}

