/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.clustersync.internal;

import java.util.HashSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ServiceTunnelServlet;
import org.eclipse.scout.rt.server.internal.Activator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ServerSessionClassFinder {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ServerSessionClassFinder.class);

    public static Class<? extends IServerSession> find() {
        Bundle bundle = ServerSessionClassFinder.findServletContributorBundle();
        if (bundle == null) {
            return null;
        }
        String fqn = String.valueOf(bundle.getSymbolicName()) + ".ServerSession";
        Class<? extends IServerSession> serverSessionClass = ServerSessionClassFinder.loadServerSessionSafe(bundle, fqn);
        if (serverSessionClass == null) {
            return null;
        }
        return serverSessionClass;
    }

    private static Bundle findServletContributorBundle() {
        IExtensionPoint xpServlet;
        block16: {
            IExtensionRegistry reg;
            block15: {
                ServiceReference ref;
                BundleContext context;
                block14: {
                    context = Activator.getDefault().getBundle().getBundleContext();
                    ref = context.getServiceReference(IExtensionRegistry.class.getName());
                    if (ref != null) break block14;
                    return null;
                }
                reg = (IExtensionRegistry)context.getService(ref);
                if (reg != null) break block15;
                return null;
            }
            xpServlet = reg.getExtensionPoint("org.eclipse.equinox.http.registry.servlets");
            if (xpServlet != null) break block16;
            return null;
        }
        try {
            HashSet<Bundle> serviceTunnelContributorBundles = new HashSet<Bundle>();
            IExtension[] iExtensionArray = xpServlet.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension xServlet = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = xServlet.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement cServlet = iConfigurationElementArray[n4];
                    if (cServlet.getName().equals("servlet")) {
                        String servletFqn = cServlet.getAttribute("class");
                        Bundle bundle = Platform.getBundle((String)cServlet.getContributor().getName());
                        try {
                            Class servletClass = bundle.loadClass(servletFqn);
                            if (ServiceTunnelServlet.class.isAssignableFrom(servletClass)) {
                                serviceTunnelContributorBundles.add(bundle);
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            int count = serviceTunnelContributorBundles.size();
            if (count == 1) {
                return (Bundle)serviceTunnelContributorBundles.iterator().next();
            }
            if (count == 0) {
                LOG.warn("No contribution bundle found for servlet '" + ServiceTunnelServlet.class.getSimpleName() + "'");
            } else {
                LOG.warn("Multiple contribution bundles found for servlet '" + ServiceTunnelServlet.class.getSimpleName() + "'.");
            }
        }
        catch (Throwable e) {
            LOG.error("failed to find servlet contributor", e);
        }
        return null;
    }

    private static Class<? extends IServerSession> loadServerSessionSafe(Bundle bundle, String serverSessionFqn) {
        try {
            Class clazz = bundle.loadClass(serverSessionFqn);
            if (IServerSession.class.isAssignableFrom(clazz)) {
                return clazz;
            }
            LOG.error("Server session class '" + serverSessionFqn + "' could not be loaded as not of the type '" + IServerSession.class.getName() + "'");
        }
        catch (ClassNotFoundException e) {
            LOG.error("Server session class '" + serverSessionFqn + "' could not be found");
        }
        return null;
    }
}

