/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.ClassIdentifier;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.server.services.common.jdbc.builder.EntityContribution;
import org.eclipse.scout.rt.server.services.common.jdbc.builder.FormDataStatementBuilder;
import org.eclipse.scout.rt.shared.data.form.AbstractFormData;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractValueFieldData;
import org.eclipse.scout.rt.shared.data.form.properties.AbstractPropertyData;
import org.eclipse.scout.rt.shared.data.model.DataModelConstants;

public class BasicPartDefinition
implements DataModelConstants {
    private final ClassIdentifier[] m_valueTypeClassIdentifiers;
    private final String m_sqlAttribute;
    private final int m_operation;
    private final boolean m_plainBind;

    public BasicPartDefinition(Class<?> valueType, String sqlAttribute, int operator) {
        this(new Class[]{valueType}, sqlAttribute, operator, false);
    }

    public BasicPartDefinition(ClassIdentifier fieldTypeClassIdentifier, String sqlAttribute, int operator) {
        this(new ClassIdentifier[]{fieldTypeClassIdentifier}, sqlAttribute, operator, false);
    }

    public BasicPartDefinition(Class<?> valueType, String sqlAttribute) {
        this(new Class[]{valueType}, sqlAttribute, 0, false);
    }

    public BasicPartDefinition(Class<?>[] valueTypes, String sqlAttribute) {
        this(valueTypes, sqlAttribute, 0, false);
    }

    public BasicPartDefinition(Class<?> valueType, String sqlAttribute, int operator, boolean plainBind) {
        this(new Class[]{valueType}, sqlAttribute, operator, plainBind);
    }

    public BasicPartDefinition(ClassIdentifier valueTypeIdentifier, String sqlAttribute, int operator, boolean plainBind) {
        this(new ClassIdentifier[]{valueTypeIdentifier}, sqlAttribute, operator, plainBind);
    }

    public BasicPartDefinition(Class<?>[] valueTypes, String sqlAttribute, int operator) {
        this(valueTypes, sqlAttribute, operator, false);
    }

    public BasicPartDefinition(Class<?>[] valueTypes, String sqlAttribute, int operator, boolean plainBind) {
        this(ClassIdentifier.convertClassArrayToClassIdentifierArray((Class[])valueTypes), sqlAttribute, operator, plainBind);
    }

    public BasicPartDefinition(ClassIdentifier[] valueTypeClassIdentifiers, String sqlAttribute, int operator, boolean plainBind) {
        this.m_valueTypeClassIdentifiers = valueTypeClassIdentifiers != null ? valueTypeClassIdentifiers : new ClassIdentifier[]{};
        this.m_sqlAttribute = sqlAttribute;
        this.m_operation = operator;
        this.m_plainBind = plainBind;
        ClassIdentifier[] classIdentifierArray = this.m_valueTypeClassIdentifiers;
        int n = this.m_valueTypeClassIdentifiers.length;
        int n2 = 0;
        while (n2 < n) {
            ClassIdentifier classIdentifier = classIdentifierArray[n2];
            Class c = classIdentifier.getLastSegment();
            if (!AbstractPropertyData.class.isAssignableFrom(c) && !AbstractFormFieldData.class.isAssignableFrom(c)) {
                throw new IllegalArgumentException(c + " is not of type AbstractPropertyData or AbstractFormFieldData");
            }
            int i = 0;
            while (i < classIdentifier.getClasses().length - 1) {
                Class containerClass = classIdentifier.getClasses()[i];
                if (!AbstractFormFieldData.class.isAssignableFrom(containerClass)) {
                    throw new IllegalArgumentException(containerClass + " is not of type AbstractFormFieldData (segment " + i + " in " + classIdentifier + ")");
                }
                ++i;
            }
            ++n2;
        }
    }

    protected String getSqlAttribute() {
        return this.m_sqlAttribute;
    }

    protected int getOperation() {
        return this.m_operation;
    }

    protected boolean isPlainBind() {
        return this.m_plainBind;
    }

    protected ClassIdentifier[] getValueTypeClassIdentifiers() {
        return this.m_valueTypeClassIdentifiers;
    }

    public boolean accept(AbstractFormData formData) throws ProcessingException {
        Map fieldsBreathFirstMap = formData.getAllFieldsRec();
        Map propertiesBreathFirstMap = formData.getAllPropertiesRec();
        if (this.getValueTypeClassIdentifiers().length > 0) {
            ClassIdentifier[] classIdentifierArray = this.getValueTypeClassIdentifiers();
            int n = classIdentifierArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractPropertyData p;
                ClassIdentifier valueType = classIdentifierArray[n2];
                AbstractFormFieldData dataObject = formData.findFieldByClass(fieldsBreathFirstMap, valueType);
                if (dataObject instanceof AbstractFormFieldData) {
                    AbstractValueFieldData v = dataObject instanceof AbstractValueFieldData ? (AbstractValueFieldData)dataObject : null;
                    AbstractFormFieldData f = dataObject;
                    if (f.isValueSet() && (v == null || v.getValue() != null)) {
                        return true;
                    }
                }
                if ((dataObject = formData.findPropertyByClass(propertiesBreathFirstMap, valueType)) instanceof AbstractPropertyData && (p = (AbstractPropertyData)dataObject).isValueSet() && p.getValue() != null) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public EntityContribution createInstance(FormDataStatementBuilder builder, AbstractFormData formData, Map<String, String> parentAliasMap) throws ProcessingException {
        Map fieldsBreathFirstMap = formData.getAllFieldsRec();
        Map propertiesBreathFirstMap = formData.getAllPropertiesRec();
        ClassIdentifier[] valueTypes = this.getValueTypeClassIdentifiers();
        ArrayList<Object> valueDatas = new ArrayList<Object>(valueTypes.length);
        ArrayList<String> bindNames = new ArrayList<String>(valueTypes.length);
        ArrayList<Object> bindValues = new ArrayList<Object>(valueTypes.length);
        int i = 0;
        while (i < valueTypes.length) {
            if (AbstractFormFieldData.class.isAssignableFrom(valueTypes[i].getLastSegment())) {
                AbstractFormFieldData field = formData.findFieldByClass(fieldsBreathFirstMap, valueTypes[i]);
                valueDatas.add(field);
                bindNames.add("" + (char)(97 + i));
                if (field instanceof AbstractValueFieldData) {
                    bindValues.add(((AbstractValueFieldData)field).getValue());
                } else {
                    bindValues.add(null);
                }
            } else if (AbstractPropertyData.class.isAssignableFrom(valueTypes[i].getLastSegment())) {
                AbstractPropertyData property = formData.findPropertyByClass(propertiesBreathFirstMap, valueTypes[i]);
                valueDatas.add(property);
                bindNames.add("" + (char)(97 + i));
                bindValues.add(property.getValue());
            } else {
                valueDatas.add(null);
                bindNames.add("" + (char)(97 + i));
                bindValues.add(null);
            }
            ++i;
        }
        String wherePart = this.createInstanceImpl(builder, valueDatas, bindNames, bindValues, parentAliasMap);
        return EntityContribution.create(wherePart);
    }

    protected String createInstanceImpl(FormDataStatementBuilder builder, List<Object> valueDatas, List<String> bindNames, List<Object> bindValues, Map<String, String> parentAliasMap) throws ProcessingException {
        return builder.createSqlPart(0, this.getSqlAttribute(), this.getOperation(), bindNames, bindValues, this.isPlainBind(), parentAliasMap);
    }
}

