/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.form.fields.tablefield;

import java.util.ArrayList;
import org.eclipse.scout.commons.holders.ITableHolder;
import org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData;

public abstract class AbstractTableFieldData
extends AbstractFormFieldData
implements ITableHolder {
    private static final long serialVersionUID = 1L;
    private ArrayList<Object[]> m_rowList = new ArrayList();

    @Override
    protected void initConfig() {
        super.initConfig();
    }

    public int getRowCount() {
        return this.m_rowList.size();
    }

    public int getColumnCount() {
        return 0;
    }

    public Object getValueAt(int row, int column) {
        return null;
    }

    protected Object getValueInternal(int row, int column) {
        Object[] a = this.m_rowList.get(row);
        return a[column];
    }

    public void setValueAt(int row, int column, Object value) {
    }

    protected void setValueInternal(int row, int column, Object value) {
        Object[] a = this.m_rowList.get(row);
        a[column] = value;
        this.setValueSet(true);
    }

    public int getRowState(int row) {
        Number n = (Number)this.getValueInternal(row, this.getColumnCount());
        if (n != null) {
            return n.intValue();
        }
        return 0;
    }

    public void setRowState(int row, int state) {
        this.setValueInternal(row, this.getColumnCount(), new Integer(state));
    }

    public void setRowStates(int state) {
        int r = 0;
        int n = this.getRowCount();
        while (r < n) {
            this.setRowState(r, state);
            ++r;
        }
    }

    public int addRow() {
        return this.addRow(0);
    }

    public int addRow(int rowState) {
        return this.addRow(null, rowState);
    }

    public int addRow(Object[] values) {
        return this.addRow(values, 0);
    }

    public int addRow(Object[] values, int rowState) {
        this.m_rowList.add(new Object[this.getColumnCount() + 1]);
        int newRowIndex = this.m_rowList.size() - 1;
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                this.setValueAt(newRowIndex, i, values[i]);
                ++i;
            }
        }
        this.setRowState(newRowIndex, rowState);
        this.setValueSet(true);
        return newRowIndex;
    }

    public void ensureSize(int size) {
        while (this.m_rowList.size() < size) {
            this.addRow();
        }
        while (this.m_rowList.size() > size) {
            this.removeRow(this.m_rowList.size() - 1);
        }
        this.setValueSet(true);
    }

    public void removeRow(int index) {
        this.m_rowList.remove(index);
        this.setValueSet(true);
    }

    public void clearRows() {
        this.m_rowList.clear();
        this.setValueSet(true);
    }
}

