/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client;

import java.io.File;
import java.io.Writer;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.spec.client.SpecIOUtility;
import org.eclipse.scout.rt.spec.client.SpecUtility;
import org.eclipse.scout.rt.spec.client.config.IDocConfig;
import org.eclipse.scout.rt.spec.client.out.IDocSection;
import org.eclipse.scout.rt.spec.client.out.mediawiki.MediawikiWriter;
import org.eclipse.scout.testing.client.runner.ScoutClientGUITestRunner;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=ScoutClientGUITestRunner.class)
public abstract class AbstractSpecGenTest {
    @Test
    public abstract void generateSpec() throws ProcessingException;

    protected IDocConfig getConfiguration() {
        return SpecUtility.getDocConfigInstance();
    }

    protected void writeMediawikiFile(IDocSection section, String fileBaseName, String[] imagePaths) throws ProcessingException {
        File wiki = SpecIOUtility.createNewFile(SpecIOUtility.getSpecFileConfigInstance().getMediawikiDir(), fileBaseName, ".mediawiki");
        Writer fileWriter = SpecIOUtility.createWriter(wiki);
        MediawikiWriter w = new MediawikiWriter(fileWriter, section, imagePaths);
        w.write(this.getTopHeadingLevel());
    }

    protected int getTopHeadingLevel() {
        return this.getConfiguration().getDefaultTopHeadingLevel();
    }
}

