/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.spec.client.ISpecProcessor;
import org.eclipse.scout.rt.spec.client.SpecIOUtility;
import org.eclipse.scout.rt.spec.client.SpecUtility;
import org.eclipse.scout.rt.spec.client.gen.DocGenUtility;
import org.eclipse.scout.rt.spec.client.out.html.HtmlConverter;

public class MediawikiPostProcessor
implements ISpecProcessor {
    private static IScoutLogger LOG = ScoutLogManager.getLogger(MediawikiPostProcessor.class);
    protected HashMap<String, String> m_classIdTargets = new HashMap();

    public MediawikiPostProcessor() throws ProcessingException {
        for (Class<?> c : DocGenUtility.getAllDocEntityClasses()) {
            this.m_classIdTargets.put(c.getSimpleName(), SpecUtility.createAnchorId(ConfigurationUtility.getAnnotatedClassIdWithFallback(c)));
            this.m_classIdTargets.put(c.getName(), SpecUtility.createAnchorId(ConfigurationUtility.getAnnotatedClassIdWithFallback(c)));
        }
    }

    @Override
    public void process() throws ProcessingException {
        if (!SpecIOUtility.getSpecFileConfigInstance().getMediawikiDir().exists()) {
            LOG.warn("MediawikiDir does not exists! (" + SpecIOUtility.getSpecFileConfigInstance().getMediawikiDir().getPath() + ")");
            return;
        }
        SpecIOUtility.copyFilesFromAllSourceBundles(SpecIOUtility.getSpecFileConfigInstance().getHtmlDir(), SpecIOUtility.getSpecFileConfigInstance().getRelativeCssDirPath(), new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return SpecIOUtility.getSpecFileConfigInstance().getDefaultCssFileName().equals(name);
            }
        });
        File cssFile = new File(SpecIOUtility.getSpecFileConfigInstance().getHtmlDir(), SpecIOUtility.getSpecFileConfigInstance().getDefaultCssFileName());
        File[] fileArray = SpecIOUtility.getSpecFileConfigInstance().getMediawikiDir().listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File wiki = fileArray[n2];
            this.replaceLinks(wiki);
            File html = this.convertToHTML(wiki, cssFile);
            this.replaceWikiFileLinks(html);
            ++n2;
        }
    }

    protected void replaceLinks(File mediawikiFile) throws ProcessingException {
        Properties links = SpecIOUtility.loadLinkPropertiesFile();
        SpecIOUtility.process(mediawikiFile, new P_LinkProcessor(links, this.m_classIdTargets, mediawikiFile.getName()));
    }

    protected void replaceWikiFileLinks(File htmlFile) throws ProcessingException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("/wiki/", "");
        map.put(".mediawiki", ".html");
        SpecIOUtility.replaceAll(htmlFile, map);
    }

    protected File convertToHTML(File mediaWiki, File cssFile) throws ProcessingException {
        File htmlDir = SpecIOUtility.getSpecFileConfigInstance().getHtmlDir();
        File htmlFile = SpecIOUtility.createNewFile(htmlDir, mediaWiki.getName().replace(".mediawiki", ""), ".html");
        HtmlConverter htmlConverter = new HtmlConverter(cssFile);
        htmlConverter.convertWikiToHtml(mediaWiki, htmlFile);
        return htmlFile;
    }

    protected static class P_LinkProcessor
    implements SpecIOUtility.IStringProcessor {
        protected Properties m_links;
        private Map<String, String> m_classIdTargets;
        private String m_fileName;

        public P_LinkProcessor(Properties links, Map<String, String> classIdTargets, String fileName) {
            this.m_links = links;
            this.m_classIdTargets = classIdTargets;
            this.m_fileName = fileName;
        }

        @Override
        public String processLine(String input) {
            Pattern pattern = Pattern.compile("\\[\\[([A-Za-z][A-Za-z0-9_\\$\\.-]+)\\|(.*?)]]");
            Matcher matcher = pattern.matcher(input);
            StringBuilder sb = new StringBuilder();
            int index = 0;
            while (matcher.find()) {
                sb.append(input.substring(index, matcher.start(0)));
                String propValue = this.resolveTargetInLinksProperties(matcher.group(1));
                if (propValue != null) {
                    sb.append("[[").append(propValue).append("|").append(matcher.group(2)).append("]]");
                } else {
                    sb.append(matcher.group(2));
                    LOG.warn(String.valueOf(this.m_fileName) + ": Could not resolve link target:" + matcher.group(1) + ". Replacing with plain text: " + matcher.group(2));
                }
                index = matcher.end();
            }
            sb.append(input.substring(index));
            return sb.toString();
        }

        protected String resolveTargetInLinksProperties(String target) {
            String propValue = this.m_links.getProperty(target);
            if (propValue == null) {
                String classIdTarget = this.m_classIdTargets.get(target);
                if (classIdTarget != null) {
                    propValue = this.m_links.getProperty(classIdTarget);
                } else if (target.startsWith("lo_")) {
                    String classIdTargetWithoutprefix = this.m_classIdTargets.get(target.substring("lo_".length()));
                    String prefixedClassIdTarget = "lo_" + classIdTargetWithoutprefix;
                    propValue = this.m_links.getProperty(prefixedClassIdTarget);
                }
            }
            return propValue;
        }

        private String searchFormClassId(String group) {
            return null;
        }

        protected String qualifiedAnchorId(String anchorId) {
            return anchorId;
        }
    }
}

