/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.commons.ITypeWithClassId;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.osgi.BundleInspector;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.spec.client.config.DefaultDocConfig;
import org.eclipse.scout.rt.spec.client.config.IDocConfig;

public final class SpecUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SpecUtility.class);
    private static Set<Class<?>> s_allClasses;
    private static IDocConfig s_docConfigInstance;

    private SpecUtility() {
    }

    public static String getSpecFileBaseName(ITypeWithClassId object) {
        return String.valueOf(object.getClass().getSimpleName()) + "_" + object.classId();
    }

    public static Set<Class<?>> getAllClasses(BundleInspector.IClassFilter filter) throws ProcessingException {
        if (s_allClasses == null) {
            s_allClasses = BundleInspector.getAllClasses((BundleInspector.IClassFilter)new BundleInspector.IClassFilter(){

                public boolean accept(Class c) {
                    return true;
                }
            });
        }
        HashSet filteredClasses = new HashSet();
        for (Class<?> c : s_allClasses) {
            if (!filter.accept(c)) continue;
            filteredClasses.add(c);
        }
        return filteredClasses;
    }

    public static IDocConfig getDocConfigInstance() {
        if (s_docConfigInstance == null) {
            s_docConfigInstance = new DefaultDocConfig();
        }
        return s_docConfigInstance;
    }

    public static void setDocConfig(IDocConfig specFileConfig) {
        s_docConfigInstance = specFileConfig;
    }

    public static String createAnchorId(ITypeWithClassId object) {
        String classId = object.classId();
        return SpecUtility.createAnchorId(classId);
    }

    public static String createAnchorId(String classId) {
        return "c_" + classId;
    }

    public static List<IMenu> expandMenuHierarchy(List<IMenu> menus) {
        ArrayList<IMenu> menuList = new ArrayList<IMenu>();
        for (IMenu menu : menus) {
            SpecUtility.addMenuRecursive(menuList, menu);
        }
        return menuList;
    }

    private static void addMenuRecursive(ArrayList<IMenu> menuList, IMenu menu) {
        menuList.add(menu);
        for (IMenu subMenu : menu.getChildActions()) {
            SpecUtility.addMenuRecursive(menuList, subMenu);
        }
    }
}

