/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.gen;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.ITableField;
import org.eclipse.scout.rt.spec.client.SpecUtility;
import org.eclipse.scout.rt.spec.client.config.IDocConfig;
import org.eclipse.scout.rt.spec.client.gen.DocGenUtility;
import org.eclipse.scout.rt.spec.client.gen.IDocFormFieldVisitor;
import org.eclipse.scout.rt.spec.client.out.IDocSection;
import org.eclipse.scout.rt.spec.client.out.internal.Section;

public class TableFieldVisitor
implements IDocFormFieldVisitor {
    private final IDocConfig m_config;
    private final List<IDocSection> m_sections = new ArrayList<IDocSection>();

    public TableFieldVisitor(IDocConfig config) {
        this.m_config = config;
    }

    public boolean visitField(IFormField field, int level, int fieldIndex) {
        if (field instanceof ITableField) {
            IDocSection fieldDesc = this.createDocSection((ITableField)field);
            this.m_sections.add(fieldDesc);
        }
        return true;
    }

    private IDocSection createDocSection(ITableField<?> field) {
        String title = this.m_config.getTableFieldConfig().getTitleExtractor().getText(field);
        IDocSection menuSection = DocGenUtility.createDocSection(SpecUtility.expandMenuHierarchy(field.getTable().getMenus()), this.m_config.getMenuTableConfig(), false);
        IDocSection columnsSection = DocGenUtility.createDocSection(field.getTable().getColumns(), this.m_config.getColumnTableConfig(), false);
        return new Section(title, menuSection, columnsSection);
    }

    @Override
    public List<IDocSection> getDocSections() {
        return this.m_sections;
    }
}

