/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.gen.extract;

import java.util.ArrayList;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.shared.TEXTS;
import org.eclipse.scout.rt.shared.services.common.code.CODES;
import org.eclipse.scout.rt.shared.services.common.code.ICode;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.spec.client.gen.extract.AbstractNamedTextExtractor;
import org.eclipse.scout.rt.spec.client.gen.extract.SimpleTypeTextExtractor;

public class CodeTypeCodesExtractor
extends AbstractNamedTextExtractor<Class<?>> {
    public CodeTypeCodesExtractor() {
        super(TEXTS.get((String)"org.eclipse.scout.rt.spec.protectedCodes"));
    }

    @Override
    public String getText(Class<?> c) {
        SimpleTypeTextExtractor fallBackExtractor = new SimpleTypeTextExtractor();
        if (!ICodeType.class.isAssignableFrom(c)) {
            return null;
        }
        ArrayList<String> codes = new ArrayList<String>();
        Class<?>[] classArray = c.getDeclaredClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> innerClass = classArray[n2];
            if (ICode.class.isAssignableFrom(innerClass)) {
                ICode code = CODES.getCode(innerClass);
                String codeText = code != null ? code.getText() : null;
                codes.add(StringUtility.nvl((Object)codeText, (String)fallBackExtractor.getText(innerClass)));
            }
            ++n2;
        }
        return CollectionUtility.format(codes);
    }
}

