/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.commons;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.job.JobEx;
import org.junit.Assert;

public final class ScoutAssert {
    private ScoutAssert() {
    }

    public static <T> void assertSetEquals(T[] expected, Collection<T> actual) {
        ScoutAssert.assertSetEquals(new ArrayList<T>(Arrays.asList(expected)), actual);
    }

    public static <T> void assertSetEquals(Collection<T> expected, Collection<T> actual) {
        if (actual == null) {
            Assert.fail((String)ScoutAssert.format("sets are not equal", expected, actual));
        }
        if (!new HashSet<T>(expected).equals(new HashSet<T>(actual))) {
            Assert.fail((String)ScoutAssert.format("sets are not equal", expected, actual));
        }
    }

    public static <T> void assertListEquals(T[] expected, Collection<T> actual) {
        ScoutAssert.assertListEquals(new ArrayList<T>(Arrays.asList(expected)), actual);
    }

    public static <T> void assertListEquals(Collection<T> expected, Collection<T> actual) {
        if (actual == null) {
            Assert.fail((String)ScoutAssert.format("lists are not equal", expected, actual));
        }
        if (!new ArrayList<T>(expected).equals(new ArrayList<T>(actual))) {
            Assert.fail((String)ScoutAssert.format("lists are not equal", expected, actual));
        }
    }

    public static void assertOrder(Object[] expected, Object[] actual) {
        ScoutAssert.assertOrder(null, expected, actual);
    }

    public static void assertOrder(String message, Object[] expected, Object[] actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            Assert.fail();
        }
        int actualIndex = 0;
        Object[] objectArray = expected;
        int n = expected.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                Object expectedElement = objectArray[n2];
                int j = actualIndex;
                while (j < actual.length) {
                    if (expectedElement.equals(actual[j])) {
                        actualIndex = j + 1;
                        break block5;
                    }
                    ++j;
                }
                Assert.fail((String)ScoutAssert.format(message, expected, actual));
            }
            ++n2;
        }
    }

    public static <T extends Comparable<T>> void assertComparableEquals(T expected, T actual) {
        ScoutAssert.assertComparableEquals(null, expected, actual);
    }

    public static <T extends Comparable<T>> void assertComparableEquals(String message, T expected, T actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null || actual == null) {
            Assert.fail((String)ScoutAssert.format(message, expected, actual));
        } else if (expected.compareTo(actual) == 0) {
            return;
        }
        Assert.fail((String)ScoutAssert.format(message, expected, actual));
    }

    private static String format(String message, Object expected, Object actual) {
        String s = "";
        if (message != null) {
            s = String.valueOf(message) + " ";
        }
        return String.valueOf(s) + "expected:<" + expected + "> but was:<" + actual + ">";
    }

    public static void jobSuccessfullyCompleted(JobEx job) throws Throwable {
        Assert.assertEquals((long)job.getState(), (long)0L);
        try {
            job.throwOnError();
        }
        catch (ProcessingException e) {
            Throwable originalException;
            if (job.getResult() != null && (originalException = job.getResult().getException()) != null && originalException != e) {
                throw originalException;
            }
            throw e;
        }
        if (job.getResult() != null && !job.getResult().isOK()) {
            Assert.fail((String)job.getResult().getMessage());
        }
    }

    public static void assertTextFileEquals(File expectedFile, File actualFile, String charsetName) throws ProcessingException {
        if (!expectedFile.exists()) {
            Assert.fail((String)("File does not exists:" + expectedFile.getPath()));
        }
        if (!actualFile.exists()) {
            Assert.fail((String)("File does not exists:" + expectedFile.getPath()));
        }
        List expectedLines = IOUtility.readLines((File)expectedFile, (String)charsetName);
        List actualLines = IOUtility.readLines((File)actualFile, (String)charsetName);
        ScoutAssert.assertListEquals(expectedLines, actualLines);
    }
}

