/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.server;

import java.security.Principal;
import javax.security.auth.Subject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.security.SimplePrincipal;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ServerJob;
import org.eclipse.scout.rt.server.ThreadContext;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.rt.testing.server.ITestServerSessionProvider;
import org.osgi.framework.Bundle;

public class DefaultTestServerSessionProvider
implements ITestServerSessionProvider {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DefaultTestServerSessionProvider.class);

    @Override
    public <T extends IServerSession> T createServerSession(Class<T> clazz, final Subject subject) throws ProcessingException {
        IServerSession serverSession;
        try {
            serverSession = (IServerSession)clazz.newInstance();
        }
        catch (Throwable t) {
            throw new ProcessingException("create instance of " + clazz, t);
        }
        serverSession.setUserAgent(UserAgent.createDefault());
        ServerJob initJob = new ServerJob("new " + clazz.getSimpleName(), serverSession, subject){

            protected IStatus runTransaction(IProgressMonitor monitor) throws Exception {
                IServerSession serverSessionInside = ThreadContext.getServerSession();
                String symbolicName = serverSessionInside.getClass().getPackage().getName();
                Bundle bundle = Platform.getBundle((String)symbolicName);
                DefaultTestServerSessionProvider.this.beforeStartSession(serverSessionInside, subject);
                serverSessionInside.loadSession(bundle);
                DefaultTestServerSessionProvider.this.afterStartSession(serverSessionInside, subject);
                return Status.OK_STATUS;
            }
        };
        initJob.runNow((IProgressMonitor)new NullProgressMonitor());
        initJob.throwOnError();
        return (T)serverSession;
    }

    @Override
    public Subject login(String runAs) {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new SimplePrincipal(runAs));
        return subject;
    }

    protected void beforeStartSession(IServerSession serverSession, Subject subject) {
    }

    protected void afterStartSession(IServerSession serverSession, Subject subject) {
    }
}

