/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.server.runner;

import java.util.List;
import javax.security.auth.Subject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ServerJob;
import org.eclipse.scout.rt.testing.commons.ScoutAssert;
import org.eclipse.scout.rt.testing.shared.Activator;
import org.eclipse.scout.rt.testing.shared.TestingUtility;
import org.eclipse.scout.rt.testing.shared.services.common.exceptionhandler.WrappingProcessingRuntimeExceptionHandlerService;
import org.junit.runners.model.Statement;
import org.osgi.framework.Bundle;

public class ScoutServerJobWrapperStatement
extends Statement {
    private final IServerSession m_serverSession;
    private final Subject m_subject;
    private final Statement m_statement;

    public ScoutServerJobWrapperStatement(IServerSession serverSession, Subject subject, Statement statement) {
        this.m_serverSession = serverSession;
        this.m_subject = subject;
        this.m_statement = statement;
    }

    public void evaluate() throws Throwable {
        if (ServerJob.getCurrentSession() != null) {
            this.doEvaluate();
        } else {
            ServerJob job = new ServerJob("JUnit Server Job Runner", this.m_serverSession, this.m_subject){

                protected IStatus runTransaction(IProgressMonitor monitor) throws Exception {
                    ScoutServerJobWrapperStatement.this.doEvaluate();
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
            job.join();
            ScoutAssert.jobSuccessfullyCompleted((JobEx)job);
        }
    }

    private void doEvaluate() throws Exception {
        List serviceReg = null;
        try {
            WrappingProcessingRuntimeExceptionHandlerService handler = new WrappingProcessingRuntimeExceptionHandlerService();
            serviceReg = TestingUtility.registerServices((Bundle)Activator.getDefault().getBundle(), (int)1000, (Object[])new Object[]{handler});
            try {
                this.m_statement.evaluate();
            }
            catch (Exception e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                throw new Exception(e);
            }
        }
        catch (Throwable throwable) {
            if (serviceReg != null) {
                TestingUtility.unregisterServices(serviceReg);
            }
            throw throwable;
        }
        if (serviceReg != null) {
            TestingUtility.unregisterServices((List)serviceReg);
        }
    }
}

