/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.shared;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import junit.framework.Test;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.osgi.BundleInspector;
import org.eclipse.scout.commons.runtime.BundleBrowser;
import org.eclipse.scout.rt.testing.shared.Activator;
import org.eclipse.scout.rt.testing.shared.DevTestMarker;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

public class JUnitTestClassBrowser {
    private static final String REGEX_MARKER = "regex:";
    private static final Pattern[] DEFAULT_CLASS_NAME_INCLUDE_PATTERNS = new Pattern[]{Pattern.compile(".*Test.*")};
    private Pattern[] m_bundleNameIncludePatterns;
    private Pattern[] m_bundleNameExcludePatterns;
    private Pattern[] m_classNameIncludePatterns;
    private Pattern[] m_classNameExcludePatterns;

    public JUnitTestClassBrowser() {
        this.setClassNameIncludePatterns(DEFAULT_CLASS_NAME_INCLUDE_PATTERNS);
    }

    public Pattern[] getBundleNameIncludePatterns() {
        return this.m_bundleNameIncludePatterns;
    }

    public void setBundleNameIncludePatterns(Pattern[] bundleNameIncludePatterns) {
        this.m_bundleNameIncludePatterns = bundleNameIncludePatterns;
    }

    public Pattern[] getBundleNameExcludePatterns() {
        return this.m_bundleNameExcludePatterns;
    }

    public void setBundleNameExcludePatterns(Pattern[] bundleNameExcludePatterns) {
        this.m_bundleNameExcludePatterns = bundleNameExcludePatterns;
    }

    public Pattern[] getClassNameIncludePatterns() {
        return this.m_classNameIncludePatterns;
    }

    public void setClassNameIncludePatterns(Pattern[] classNameIncludePatterns) {
        this.m_classNameIncludePatterns = classNameIncludePatterns == null || classNameIncludePatterns.length == 0 ? DEFAULT_CLASS_NAME_INCLUDE_PATTERNS : classNameIncludePatterns;
    }

    public Pattern[] getClassNameExcludePatterns() {
        return this.m_classNameExcludePatterns;
    }

    public void setClassNameExcludePatterns(Pattern[] classNameExcludePatterns) {
        this.m_classNameExcludePatterns = classNameExcludePatterns;
    }

    public List<Class<?>> collectAllJUnitTestClasses() {
        boolean dev = Platform.inDevelopmentMode();
        if (dev) {
            System.out.println("In -dev mode: only the test(s) marked with @DevTestMarker are run as a convenience (all tests if no such annotation is found)");
        }
        ArrayList junitTestClasses = new ArrayList();
        ArrayList devClasses = new ArrayList();
        Bundle[] bundleArray = Activator.getDefault().getBundle().getBundleContext().getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                Bundle bundle = bundleArray[n2];
                if (this.acceptBundle(bundle)) {
                    String[] classNames;
                    try {
                        BundleBrowser bundleBrowser = new BundleBrowser(bundle.getSymbolicName(), "");
                        classNames = bundleBrowser.getClasses(false, true);
                    }
                    catch (Exception e1) {
                        System.err.println(e1);
                        break block12;
                    }
                    String[] stringArray = classNames;
                    int n3 = classNames.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String className = stringArray[n4];
                        if (this.acceptClassName(bundle, className)) {
                            try {
                                Class c = BundleInspector.getHostBundle((Bundle)bundle).loadClass(className);
                                if (this.acceptClass(bundle, c)) {
                                    if (dev && c.getAnnotation(DevTestMarker.class) != null) {
                                        devClasses.add(c);
                                    }
                                    junitTestClasses.add(c);
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        if (!devClasses.isEmpty()) {
            return devClasses;
        }
        return junitTestClasses;
    }

    protected boolean acceptBundle(Bundle bundle) {
        return !Platform.isFragment((Bundle)bundle) && JUnitTestClassBrowser.accept(bundle.getSymbolicName(), this.getBundleNameIncludePatterns(), this.getBundleNameExcludePatterns());
    }

    protected boolean acceptClassName(Bundle bundle, String className) {
        return JUnitTestClassBrowser.accept(className, this.getClassNameIncludePatterns(), this.getClassNameExcludePatterns());
    }

    protected boolean acceptClass(Bundle bundle, Class<?> c) {
        if ((c.getModifiers() & 0x400) != 0) {
            return false;
        }
        if (Test.class.isAssignableFrom(c)) {
            return true;
        }
        if (c.getAnnotation(RunWith.class) != null) {
            return true;
        }
        Method[] methods = c.getMethods();
        if (methods != null) {
            Method[] methodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (m.getAnnotation(org.junit.Test.class) != null) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean accept(String s, Pattern[] includePatterns, Pattern[] excludePatterns) {
        Pattern p;
        int n;
        int n2;
        Pattern[] patternArray;
        if (s == null) {
            return false;
        }
        boolean included = true;
        boolean excluded = false;
        if (includePatterns != null) {
            included = false;
            patternArray = includePatterns;
            n2 = includePatterns.length;
            n = 0;
            while (n < n2) {
                p = patternArray[n];
                if (p.matcher(s).matches()) {
                    included = true;
                    break;
                }
                ++n;
            }
        }
        if (included && excludePatterns != null) {
            patternArray = excludePatterns;
            n2 = excludePatterns.length;
            n = 0;
            while (n < n2) {
                p = patternArray[n];
                if (p.matcher(s).matches()) {
                    excluded = true;
                    break;
                }
                ++n;
            }
        }
        return included && !excluded;
    }

    public static Pattern[] parseFilterPatterns(String filter) {
        if (filter == null) {
            return null;
        }
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        String[] stringArray = filter.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            if ((f = f.trim()).length() > 0) {
                try {
                    f = JUnitTestClassBrowser.toRegexPattern(f);
                    Pattern pattern = Pattern.compile(f);
                    patterns.add(pattern);
                }
                catch (Exception e) {
                    System.err.println("invalid bundle filter pattern: " + e);
                }
            }
            ++n2;
        }
        if (patterns.isEmpty()) {
            return null;
        }
        return patterns.toArray(new Pattern[patterns.size()]);
    }

    public static String toRegexPattern(String s) {
        if (s == null) {
            return null;
        }
        String pattern = s.trim();
        if (pattern.startsWith(REGEX_MARKER)) {
            return pattern.substring(REGEX_MARKER.length());
        }
        pattern = pattern.replaceAll("[.]", "\\\\.");
        pattern = pattern.replaceAll("[*]", ".*");
        pattern = pattern.replaceAll("[?]", ".");
        return pattern;
    }
}

