/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.svg.calendar.builder;

import java.awt.Point;
import java.io.InputStream;
import java.security.InvalidParameterException;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.dom.svg.SVGTextContentSupport;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.DateUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.calendar.CalendarComponent;
import org.eclipse.scout.rt.client.ui.basic.calendar.DateTimeFormatFactory;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.ui.svg.calendar.Activator;
import org.eclipse.scout.rt.ui.svg.calendar.CalendarSvgUtility;
import org.eclipse.scout.rt.ui.svg.calendar.builder.CalendarDayBuilder;
import org.eclipse.scout.rt.ui.svg.calendar.builder.CalendarMonthBuilder;
import org.eclipse.scout.rt.ui.svg.calendar.builder.CalendarWeekBuilder;
import org.eclipse.scout.rt.ui.svg.calendar.builder.CalendarWorkWeekBuilder;
import org.eclipse.scout.rt.ui.svg.calendar.builder.listener.CalendarDocumentEvent;
import org.eclipse.scout.rt.ui.svg.calendar.builder.listener.ICalendarDocumentListener;
import org.eclipse.scout.rt.ui.svg.calendar.comp.IComponentElementFactory;
import org.eclipse.scout.svg.client.SVGUtility;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGStylable;

public abstract class AbstractCalendarDocumentBuilder {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractCalendarDocumentBuilder.class);
    private static final Pattern REGEX_URL_GRID_CLICK = Pattern.compile("http://local/grid/([0-9]{1})([0-9]{1})");
    private static final Pattern REGEX_URL_COMP_CLICK = Pattern.compile("http://local/comp/([0-9]*)/([0-9]{1})([0-9]{1})");
    public static final float ORIG_CALENDAR_WIDTH = 557.0f;
    public static final float ORIG_CALENDAR_HEIGHT = 464.667f;
    private static final float MARGIN = 12.0f;
    private static final float MIN_FONT_SIZE = 8.0f;
    private static final float ORIG_FONT_SIZE = 12.0f;
    private static final float MAX_FONT_SIZE = 23.0f;
    private static final int NUM_TIME_LINE_ROWS = 15;
    protected static final int NUM_DAYS_IN_WEEK = 7;
    protected static final int NUM_MILLIS_PER_DAY = 86400000;
    private static final String LINK_NEXT_SMALL = "http://local/arrow/nextSmall";
    private static final String LINK_NEXT_BIG = "http://local/arrow/nextBig";
    private static final String LINK_PREV_SMALL = "http://local/arrow/prevSmall";
    private static final String LINK_PREV_BIG = "http://local/arrow/prevBig";
    private static final String LINK_CONTEXT_MENU = "http://local/menu";
    private static final String FONT = "Arial";
    private static final String LINK_COMPONENT_PREFIX = "http://local/comp/";
    private static final String LINK_DISPLAY_MODE_PREFIX = "http://local/displayMode/";
    private static final String LINK_GRID_PREFIX = "http://local/grid/";
    private static final String COLOR_LINKS = "#67a8ce";
    private static final String COLOR_BLACK = "#000000";
    private static final String COLOR_WHITE = "#ffffff";
    private static final String COLOR_FOREIGN_MONTH_BACKGROUND = "#eeeeee";
    private static final String COLOR_TIME_LINE = "#cccccc";
    private static final String COLOR_MONTH_BACKGROUND = "#ffffff";
    private static final String COLOR_SELECTED_DAY_BORDER = "#000000";
    private static final String COLOR_NOT_SELECTED_DAY_BORDER = "#c0c0c0";
    private final BridgeContext m_bridgeContext;
    private final EventListenerList m_listenerList;
    private final String[] m_monthsLabels;
    private final String[] m_weekDayLabels;
    private final String[] m_weekDayLongLabels;
    private final String[] m_displayModeLabels;
    private final int m_firstDayOfWeek;
    private final float[] m_displayModeTextWidth;
    private final Element[] m_elDisplayMode;
    private final Element m_elTitle;
    private final Element m_elComponentsContainer;
    private final Element m_elMoveNextBig;
    private final Element m_elMoveNextSmall;
    private final Element m_elMovePrevBig;
    private final Element m_elMovePrevSmall;
    private final Element m_elLinkMenuContainer;
    private final Element[][] m_elGridBox;
    private final Element[][] m_elGridText;
    private Element[][] m_elTimeLineGrid;
    private final Element[] m_elTimeLineTexts;
    private final Element[] m_elWeekDayHeadings;
    private final Element m_elMenuContainer;
    private Element m_selectedElement;
    private Date m_selectedDate;
    private Date m_shownDate;
    private Date m_startDate;
    private Date m_endDate;
    private CalendarComponent m_selectedComponent;
    private Set<? extends CalendarComponent> m_components;
    private int m_numContextMenus;
    private final Map<Element, Date> m_gridDateMap;
    private int m_linkCounter;
    private final Map<Integer, Object> m_linkIdToItemIdMap;
    private final Map<Object, Integer> m_ItemIdToLinkIdMap;
    private int m_startHour = 6;
    private int m_endHour = 19;
    private boolean m_useOverflowCells = true;
    private boolean m_showDisplayModeSelectionPanel = true;
    private boolean m_markNoonHour = true;
    private boolean m_markOutOfMonthDays = true;
    private DateFormat m_formatHHMM;

    protected AbstractCalendarDocumentBuilder(String svgFile) {
        InputStream is = null;
        try {
            try {
                is = Activator.getDefault().getBundle().getResource(svgFile).openStream();
                this.m_bridgeContext = SVGUtility.readSVGDocumentForGraphicalModification((InputStream)is);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot find svg resource '" + svgFile + "'", e);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        this.m_listenerList = new EventListenerList();
        this.m_formatHHMM = new DateTimeFormatFactory().getHourMinute();
        DateFormatSymbols dateSymbols = new DateFormatSymbols(LocaleThreadLocal.get());
        this.m_monthsLabels = dateSymbols.getMonths();
        this.m_weekDayLabels = dateSymbols.getShortWeekdays();
        this.m_weekDayLongLabels = dateSymbols.getWeekdays();
        this.m_displayModeLabels = new String[]{ScoutTexts.get((String)"Day", (String[])new String[0]), ScoutTexts.get((String)"WorkWeek", (String[])new String[0]), ScoutTexts.get((String)"Week", (String[])new String[0]), ScoutTexts.get((String)"Month", (String[])new String[0])};
        this.m_firstDayOfWeek = AbstractCalendarDocumentBuilder.createCalendar().getFirstDayOfWeek();
        SVGDocument doc = this.getSVGDocument();
        this.m_elComponentsContainer = doc.getElementById("Components");
        this.m_elTitle = doc.getElementById("Title");
        this.m_elLinkMenuContainer = doc.getElementById("LinkMenuLayer");
        this.m_elMoveNextBig = doc.getElementById("nextYear");
        this.m_elMoveNextSmall = doc.getElementById("nextMonth");
        this.m_elMovePrevBig = doc.getElementById("prevYear");
        this.m_elMovePrevSmall = doc.getElementById("prevMonth");
        this.m_elGridBox = this.getGridElements("b", this.getNumWeekdays(), this.getNumWeeks());
        this.m_elGridText = this.getGridElements("t", this.getNumWeekdays(), this.getNumWeeks());
        this.m_elWeekDayHeadings = new Element[]{doc.getElementById("Mo"), doc.getElementById("Tu"), doc.getElementById("We"), doc.getElementById("Th"), doc.getElementById("Fr"), doc.getElementById("Sa"), doc.getElementById("So")};
        this.m_elDisplayMode = new Element[]{doc.getElementById("displayModeDay"), doc.getElementById("displayModeWorkWeek"), doc.getElementById("displayModeWeek"), doc.getElementById("displayModeMonth")};
        this.m_elMenuContainer = doc.getElementById("MenuLayer");
        this.m_elTimeLineGrid = this.getGridElements("tlg", this.getNumWeekdays(), 15);
        this.m_elTimeLineTexts = new Element[15];
        int i = 0;
        while (i < this.m_elTimeLineTexts.length) {
            this.m_elTimeLineTexts[i] = doc.getElementById("tlt" + i);
            ++i;
        }
        this.m_displayModeTextWidth = new float[this.m_elDisplayMode.length];
        this.m_gridDateMap = new HashMap<Element, Date>();
        CalendarSvgUtility.setFont(this.m_elTitle, FONT);
        this.visitGrid(this.m_elGridText, new IGridVisitor(){

            @Override
            public void visit(Element element, int weekday, int week) {
                if (element != null) {
                    CalendarSvgUtility.setFont(element, AbstractCalendarDocumentBuilder.FONT);
                }
            }
        });
        if (this.hasTimeLine()) {
            i = 0;
            while (i < this.m_elTimeLineTexts.length) {
                if (this.m_elTimeLineTexts[i] != null) {
                    CalendarSvgUtility.setFont(this.m_elTimeLineTexts[i], FONT);
                }
                ++i;
            }
        }
        CalendarSvgUtility.setFontWeightBold(this.m_elTitle);
        CalendarSvgUtility.setTextAlignCenter(this.m_elTitle);
        SVGUtility.addHyperlink((Element)this.m_elMoveNextBig, (String)LINK_NEXT_BIG);
        SVGUtility.addHyperlink((Element)this.m_elMovePrevSmall, (String)LINK_PREV_SMALL);
        SVGUtility.addHyperlink((Element)this.m_elMoveNextSmall, (String)LINK_NEXT_SMALL);
        SVGUtility.addHyperlink((Element)this.m_elMovePrevBig, (String)LINK_PREV_BIG);
        this.initWeekdayHeadingNames();
        this.initDisplayModeLinks();
        this.initTimeLineText();
        this.initGridHyperlink();
        this.m_linkCounter = 1;
        this.m_linkIdToItemIdMap = new HashMap<Integer, Object>();
        this.m_ItemIdToLinkIdMap = new HashMap<Object, Integer>();
    }

    protected abstract int getNumWeekdays();

    protected abstract int getNumWeeks();

    protected abstract int getSmallNextField();

    protected abstract int getBigNextField();

    protected abstract void truncateToRange(Calendar var1);

    protected abstract String getRangeTitle(Calendar var1);

    protected abstract String getDayTitle(Calendar var1);

    protected abstract boolean hasTimeLine();

    protected abstract int getDisplayMode();

    protected abstract IComponentElementFactory getComponentElementFactory();

    protected abstract void resizeDayBoxes(double var1);

    protected abstract double getGridTop();

    protected void resetTimeLineGrid() {
        this.m_elTimeLineGrid = this.getGridElements("tlg", this.getNumWeekdays(), this.getEndHour() - this.getStartHour() + 2);
    }

    protected String formatHour(int h) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2000, 1, 1, h, 0, 0);
        String s = this.m_formatHHMM.format(cal.getTime());
        if (s.charAt(1) == ':') {
            s = "0" + s;
        }
        return s;
    }

    public void hyperlinkActivated(String hyperlinkUrl) {
        Date currentDate = this.getShownDate();
        if (currentDate == null) {
            return;
        }
        Calendar cal = AbstractCalendarDocumentBuilder.createCalendar(currentDate);
        if (LINK_NEXT_SMALL.equals(hyperlinkUrl)) {
            cal.add(this.getSmallNextField(), 1);
            this.setShownDate(cal.getTime());
        } else if (LINK_NEXT_BIG.equals(hyperlinkUrl)) {
            cal.add(this.getBigNextField(), 1);
            this.setShownDate(cal.getTime());
        } else if (LINK_PREV_SMALL.equals(hyperlinkUrl)) {
            cal.add(this.getSmallNextField(), -1);
            this.setShownDate(cal.getTime());
        } else if (LINK_PREV_BIG.equals(hyperlinkUrl)) {
            cal.add(this.getBigNextField(), -1);
            this.setShownDate(cal.getTime());
        } else if (LINK_CONTEXT_MENU.equals(hyperlinkUrl)) {
            this.firePopupMenuActivatedEvent();
        } else if (hyperlinkUrl.startsWith(LINK_GRID_PREFIX)) {
            Matcher m = REGEX_URL_GRID_CLICK.matcher(hyperlinkUrl);
            if (m.matches()) {
                int weekday = Integer.parseInt(m.group(1));
                int week = Integer.parseInt(m.group(2));
                Date clickedDate = this.getDateAt(weekday, week);
                this.setSelection(clickedDate);
            }
        } else if (hyperlinkUrl.startsWith(LINK_COMPONENT_PREFIX)) {
            Matcher m = REGEX_URL_COMP_CLICK.matcher(hyperlinkUrl);
            if (m.matches()) {
                int linkId = Integer.parseInt(m.group(1));
                int weekday = Integer.parseInt(m.group(2));
                int week = Integer.parseInt(m.group(3));
                Date clickedDate = this.getDateAt(weekday, week);
                Object itemId = this.getItemId(linkId);
                CalendarComponent selected = this.getComponentWithId(itemId);
                this.setSelection(clickedDate, selected);
            }
        } else if (hyperlinkUrl.startsWith(LINK_DISPLAY_MODE_PREFIX)) {
            int displayMode = Integer.parseInt(hyperlinkUrl.substring(LINK_DISPLAY_MODE_PREFIX.length()));
            this.fireDisplayModeLinkActivatedEvent(displayMode);
        }
    }

    public static Calendar createCalendar(Date initDate) {
        Calendar cal = AbstractCalendarDocumentBuilder.createCalendar();
        cal.setTime(initDate);
        return cal;
    }

    public static Calendar createCalendar() {
        return new GregorianCalendar(LocaleThreadLocal.get());
    }

    public static AbstractCalendarDocumentBuilder createInstance(int displayMode) {
        switch (displayMode) {
            case 1: {
                return new CalendarDayBuilder();
            }
            case 4: {
                return new CalendarWorkWeekBuilder();
            }
            case 2: {
                return new CalendarWeekBuilder();
            }
            case 3: {
                return new CalendarMonthBuilder();
            }
        }
        return null;
    }

    private void initDisplayModeLinks() {
        int[] linkMenuIds = new int[]{1, 4, 2, 3};
        float xPos = 4.0f;
        int i = 0;
        while (i < this.m_elDisplayMode.length) {
            boolean isCurrentDisplayMode = linkMenuIds[i] == this.getDisplayMode();
            Element e = this.m_elDisplayMode[i];
            SVGUtility.setTextContent((Element)e, (String)this.m_displayModeLabels[i]);
            CalendarSvgUtility.setFontWeightNormal(e);
            CalendarSvgUtility.setFont(e, FONT);
            CalendarSvgUtility.setFontSize(e, 12.0f);
            CalendarSvgUtility.setFontColor(e, COLOR_LINKS, isCurrentDisplayMode);
            CalendarSvgUtility.setCalendarDisplayModeXPos(e, xPos);
            this.m_displayModeTextWidth[i] = xPos;
            if (this.getShowDisplayModeSelectionPanel()) {
                SVGUtility.addHyperlink((Element)e, (String)(LINK_DISPLAY_MODE_PREFIX + linkMenuIds[i]));
                xPos += SVGTextContentSupport.getComputedTextLength((Element)e) + 12.0f;
            }
            if (isCurrentDisplayMode) {
                CalendarSvgUtility.setFontWeightBold(e);
            }
            ++i;
        }
    }

    private void initTimeLineText() {
        Element late;
        Element early = this.getSVGDocument().getElementById("tlt0");
        if (early != null) {
            SVGUtility.setTextContent((Element)early, (String)ScoutTexts.get((String)"Calendar_earlier", (String[])new String[0]));
        }
        if ((late = this.getSVGDocument().getElementById("tlt13")) != null) {
            SVGUtility.setTextContent((Element)late, (String)ScoutTexts.get((String)"Calendar_later", (String[])new String[0]));
        }
    }

    private void initGridHyperlink() {
        if (this.hasTimeLine()) {
            this.visitGrid(this.m_elGridBox, new IGridVisitor(){

                @Override
                public void visit(Element element, int x, int y) {
                    int i = 0;
                    while (i < AbstractCalendarDocumentBuilder.this.m_elTimeLineGrid.length) {
                        SVGUtility.addHyperlink((Element)AbstractCalendarDocumentBuilder.this.m_elTimeLineGrid[i][x], (String)AbstractCalendarDocumentBuilder.this.getGridClickUrl(x, y));
                        ++i;
                    }
                }
            });
        } else {
            this.visitGrid(this.m_elGridBox, new IGridVisitor(){

                @Override
                public void visit(Element element, int x, int y) {
                    SVGUtility.addHyperlink((Element)element, (String)AbstractCalendarDocumentBuilder.this.getGridClickUrl(x, y));
                }
            });
            this.visitGrid(this.m_elGridText, new IGridVisitor(){

                @Override
                public void visit(Element element, int x, int y) {
                    SVGUtility.addHyperlink((Element)element, (String)AbstractCalendarDocumentBuilder.this.getGridClickUrl(x, y));
                }
            });
        }
    }

    private void initWeekdayHeadingNames() {
        int weekstart = this.m_firstDayOfWeek - 1;
        int numDays = Math.min(this.m_elWeekDayHeadings.length, this.getNumWeekdays());
        int i = 0;
        while (i < numDays) {
            String label = this.getWeekDayLabel(1 + (i + weekstart) % 7);
            Element e = this.m_elWeekDayHeadings[i];
            if (e != null) {
                SVGUtility.setTextContent((Element)e, (String)label);
                CalendarSvgUtility.setFontWeightBold(e);
                CalendarSvgUtility.setTextAlignCenter(e);
                CalendarSvgUtility.setFont(e, FONT);
            }
            ++i;
        }
    }

    public void reconfigureLayout() {
        Element newEl;
        if (this.getDisplayMode() == 3) {
            return;
        }
        if (!this.getShowDisplayModeSelectionPanel()) {
            Element el = this.getSVGDocument().getElementById("LinkMenuLayer");
            el.setAttribute("display", "none");
        }
        int nrOfHours = this.getEndHour() - this.getStartHour() + 1;
        double gridTop = this.getGridTop();
        double gridLeft = 73.998;
        double gridHeight = 441.075 - gridTop;
        if (!this.getShowDisplayModeSelectionPanel()) {
            gridHeight = 474.597 - gridTop;
        }
        this.resizeDayBoxes(gridHeight);
        double gridWidth = 550.16 - gridLeft;
        double cellWidth = gridWidth / (double)this.getNumWeekdays();
        double cellHeight = gridHeight / (double)(nrOfHours + 1);
        SVGDocument svgDoc = this.getSVGDocument();
        Element el = svgDoc.getElementById("TimeLineText");
        if (el.hasChildNodes()) {
            while (el.getChildNodes().getLength() >= 1) {
                el.removeChild(el.getFirstChild());
            }
        }
        Element[] timeLineTexts = this.getElementTimeLineTexts();
        timeLineTexts = new Element[nrOfHours];
        int i = 0;
        while (i < nrOfHours) {
            double y = gridTop + cellHeight + gridHeight / (double)(nrOfHours + 1) * (double)i;
            newEl = svgDoc.createElementNS("http://www.w3.org/2000/svg", "rect");
            newEl.setAttribute("x", "6.377");
            newEl.setAttribute("y", String.valueOf(y));
            newEl.setAttribute("width", "57.371");
            newEl.setAttribute("height", "20.414");
            newEl.setAttribute("fill", "none");
            el.appendChild(newEl);
            newEl = svgDoc.createElementNS("http://www.w3.org/2000/svg", "text");
            newEl.setAttribute("transform", "matrix(1 0 0 1 6.3774 " + String.valueOf(y += 12.8877) + ")");
            newEl.setAttribute("style", "fill:#9D9D9C; font-family:Arial; font-size:11");
            String rowText = this.formatHour(this.getStartHour() + i);
            if (this.getUseOverflowCells()) {
                if (i == 0) {
                    rowText = ScoutTexts.get((String)"Calendar_earlier", (String[])new String[0]);
                } else if (this.getStartHour() + i == this.getEndHour()) {
                    rowText = ScoutTexts.get((String)"Calendar_later", (String[])new String[0]);
                }
            }
            Text textNode = svgDoc.createTextNode(rowText);
            newEl.appendChild(textNode);
            el.appendChild(newEl);
            timeLineTexts[i] = newEl;
            ++i;
        }
        Element elTimeLineGrid = this.getSVGDocument().getElementById("TimeLineGrid");
        if (elTimeLineGrid.hasChildNodes()) {
            while (elTimeLineGrid.getChildNodes().getLength() >= 1) {
                elTimeLineGrid.removeChild(elTimeLineGrid.getFirstChild());
            }
        }
        String cellStyle = "fill:none;stroke:#C0C0C0;stroke-width:0.5;stroke-miterlimit:10;";
        int d = 0;
        while (d < this.getNumWeekdays()) {
            int h = 0;
            while (h < nrOfHours + 1) {
                newEl = svgDoc.createElementNS("http://www.w3.org/2000/svg", "rect");
                newEl.setAttribute("id", "tlg" + String.valueOf(d) + String.valueOf(h));
                newEl.setAttribute("x", String.valueOf(gridLeft + cellWidth * (double)d));
                newEl.setAttribute("y", String.valueOf(gridTop + cellHeight * (double)h));
                newEl.setAttribute("width", String.valueOf(cellWidth));
                newEl.setAttribute("height", String.valueOf(cellHeight));
                newEl.setAttribute("style", cellStyle);
                elTimeLineGrid.appendChild(newEl);
                ++h;
            }
            ++d;
        }
        this.resetTimeLineGrid();
        this.initGridHyperlink();
    }

    public void setSize(int w, int h) {
        Element e;
        float ratio = Math.max(Math.min((float)w / 557.0f, 1.5f), 0.5217391f);
        final float newFontSize = 12.0f / ratio;
        CalendarSvgUtility.setFontSize(this.m_elTitle, newFontSize);
        this.visitGrid(this.m_elGridText, new IGridVisitor(){

            @Override
            public void visit(Element element, int weekday, int week) {
                if (element != null) {
                    CalendarSvgUtility.setFontSize(element, newFontSize);
                }
            }
        });
        Element[] elementArray = this.m_elWeekDayHeadings;
        int n = this.m_elWeekDayHeadings.length;
        int n2 = 0;
        while (n2 < n) {
            e = elementArray[n2];
            if (e != null) {
                CalendarSvgUtility.setFontSize(e, newFontSize);
            }
            ++n2;
        }
        elementArray = CalendarSvgUtility.getAllChildElements(this.m_elComponentsContainer, "text");
        n = elementArray.length;
        n2 = 0;
        while (n2 < n) {
            e = elementArray[n2];
            CalendarSvgUtility.setFontSize(e, newFontSize);
            CalendarSvgUtility.setFont(e, FONT);
            ++n2;
        }
        if (this.hasTimeLine()) {
            elementArray = this.m_elTimeLineTexts;
            n = this.m_elTimeLineTexts.length;
            n2 = 0;
            while (n2 < n) {
                e = elementArray[n2];
                if (e != null) {
                    CalendarSvgUtility.setFontSize(e, newFontSize);
                }
                ++n2;
            }
        }
        int i = 0;
        while (i < this.m_elDisplayMode.length) {
            CalendarSvgUtility.setFontSize(this.m_elDisplayMode[i], newFontSize);
            CalendarSvgUtility.setCalendarDisplayModeXPos(this.m_elDisplayMode[i], this.m_displayModeTextWidth[i] / ratio);
            ++i;
        }
    }

    private Element[][] getGridElements(final String idPrefix, int numX, int numY) {
        final Element[][] ret = new Element[numY][numX];
        this.visitGrid(ret, new IGridVisitor(){

            @Override
            public void visit(Element element, int weekday, int week) {
                ret[week][weekday] = AbstractCalendarDocumentBuilder.this.getSVGDocument().getElementById(String.valueOf(idPrefix) + weekday + week);
            }
        });
        return ret;
    }

    private void visitGrid(Element[][] grid, IGridVisitor visitor) {
        int row = 0;
        while (row < grid.length) {
            int col = 0;
            while (col < grid[row].length) {
                visitor.visit(grid[row][col], col, row);
                ++col;
            }
            ++row;
        }
    }

    public void addCalendarDocumentListener(ICalendarDocumentListener listener) {
        this.m_listenerList.add(ICalendarDocumentListener.class, (EventListener)listener);
    }

    public void removeCalendarDocumentListener(ICalendarDocumentListener listener) {
        this.m_listenerList.remove(ICalendarDocumentListener.class, (EventListener)listener);
    }

    private void firePopupMenuActivatedEvent() {
        CalendarDocumentEvent event = new CalendarDocumentEvent(1);
        this.fireCalendarDocumentEvent(event);
    }

    private void fireDisplayModeLinkActivatedEvent(int mode) {
        CalendarDocumentEvent event = new CalendarDocumentEvent(8);
        event.displayMode = mode;
        this.fireCalendarDocumentEvent(event);
    }

    private void fireSelectionChangedEvent(Date selectedDate, CalendarComponent selectedComponent) {
        CalendarDocumentEvent event = new CalendarDocumentEvent(2);
        event.selectedDate = selectedDate;
        event.selectedComponent = selectedComponent;
        this.fireCalendarDocumentEvent(event);
    }

    private void fireVisibleRangeChangedEvent(Date start, Date end) {
        CalendarDocumentEvent event = new CalendarDocumentEvent(4);
        event.startDate = start;
        event.endDate = end;
        this.fireCalendarDocumentEvent(event);
    }

    private void fireCalendarDocumentEvent(CalendarDocumentEvent event) {
        ICalendarDocumentListener[] iCalendarDocumentListenerArray = (ICalendarDocumentListener[])this.m_listenerList.getListeners(ICalendarDocumentListener.class);
        int n = iCalendarDocumentListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICalendarDocumentListener l = iCalendarDocumentListenerArray[n2];
            try {
                switch (event.type) {
                    case 1: {
                        l.popupMenuActivated();
                        break;
                    }
                    case 2: {
                        l.selectionChanged(event.selectedDate, event.selectedComponent);
                        break;
                    }
                    case 4: {
                        l.visibleRangeChanged(event.startDate, event.endDate);
                        break;
                    }
                    case 8: {
                        l.displayModeMenuActivated(event.displayMode);
                        break;
                    }
                    default: {
                        throw new InvalidParameterException(String.valueOf(event.type) + " is no valid calendar document event type.");
                    }
                }
            }
            catch (Exception ex) {
                LOG.error("Calendar document listener error", (Throwable)ex);
            }
            ++n2;
        }
    }

    protected int getNumOfDaysInWeekBefore(Calendar cal) {
        int numDaysBefore = cal.get(7) - this.m_firstDayOfWeek;
        if (numDaysBefore < 0) {
            numDaysBefore += 7;
        }
        return numDaysBefore;
    }

    protected String getMonthLabel(int month) {
        return this.m_monthsLabels[month];
    }

    protected String getWeekDayLabel(int weekday) {
        return this.m_weekDayLabels[weekday];
    }

    protected String getWeekDayLabelLong(int weekday) {
        return this.m_weekDayLongLabels[weekday];
    }

    public void setShownDate(Date d) {
        this.m_shownDate = DateUtility.truncDate((Date)d);
        final Calendar cal = AbstractCalendarDocumentBuilder.createCalendar(this.getShownDate());
        final int month = cal.get(2);
        this.truncateToRange(cal);
        this.m_startDate = cal.getTime();
        Calendar end = AbstractCalendarDocumentBuilder.createCalendar();
        end.setTime(this.m_startDate);
        end.add(5, this.m_elGridBox.length * this.m_elGridBox[0].length);
        this.m_endDate = new Date(end.getTimeInMillis() - 1L);
        this.visitGrid(this.m_elGridBox, new IGridVisitor(){

            @Override
            public void visit(Element gridElement, int wd, int week) {
                Date curDate = cal.getTime();
                Element textElement = AbstractCalendarDocumentBuilder.this.m_elGridText[week][wd];
                if (textElement != null) {
                    String dayTitle = AbstractCalendarDocumentBuilder.this.getDayTitle(cal);
                    if (dayTitle != null) {
                        SVGUtility.setTextContent((Element)textElement, (String)dayTitle);
                    }
                    CalendarSvgUtility.setTextAlignCenter(textElement);
                }
                String bgColor = null;
                bgColor = "#ffffff";
                if (month != cal.get(2) && AbstractCalendarDocumentBuilder.this.getMarkOutOfMonthDays()) {
                    bgColor = AbstractCalendarDocumentBuilder.COLOR_FOREIGN_MONTH_BACKGROUND;
                }
                if (AbstractCalendarDocumentBuilder.this.hasTimeLine()) {
                    int i = 0;
                    while (i < AbstractCalendarDocumentBuilder.this.m_elTimeLineGrid.length) {
                        CalendarSvgUtility.setBackgroundColor(AbstractCalendarDocumentBuilder.this.m_elTimeLineGrid[i][wd], bgColor);
                        ++i;
                    }
                } else {
                    CalendarSvgUtility.setBackgroundColor(gridElement, bgColor);
                }
                AbstractCalendarDocumentBuilder.this.m_gridDateMap.put(gridElement, curDate);
                cal.add(5, 1);
            }
        });
        SVGUtility.setTextContent((Element)this.m_elTitle, (String)this.getRangeTitle(AbstractCalendarDocumentBuilder.createCalendar(this.getShownDate())));
        this.setSelectedDate(this.getSelectedDate());
        this.refreshComponents();
        this.fireVisibleRangeChangedEvent(this.getStartDate(), this.getEndDate());
    }

    private Point getPosition(Date d) {
        if (this.isInRange(d)) {
            int dif = DateUtility.getDaysBetween((Date)this.m_startDate, (Date)d);
            int x = dif % 7;
            int y = dif / 7;
            return new Point(x, y);
        }
        return null;
    }

    private Date getDateOfGridElement(Element e) {
        return this.m_gridDateMap.get(e);
    }

    private String getGridClickUrl(int weekday, int week) {
        return LINK_GRID_PREFIX + weekday + week;
    }

    public void setSelection(Date d) {
        this.setSelection(d, null);
    }

    public void setSelection(Date d, CalendarComponent c) {
        this.setSelectedDate(d);
        this.setSelectedComponent(c);
        this.fireSelectionChangedEvent(d, c);
    }

    private Date getSelectedDate() {
        return this.m_selectedDate;
    }

    private void setSelectedDate(Date d) {
        this.m_selectedDate = d;
        Point p = this.getPosition(d);
        if (p != null) {
            this.setHighlightedBox(p.x, p.y);
        } else {
            this.clearHighlightedBox();
        }
    }

    private CalendarComponent getSelectedComponent() {
        return this.m_selectedComponent;
    }

    private void setSelectedComponent(CalendarComponent c) {
        CalendarComponent old = this.m_selectedComponent;
        this.m_selectedComponent = c;
        if (old != this.m_selectedComponent) {
            this.refreshComponents();
        }
    }

    public void setWorkHours(int startHour, int endHour, boolean useOverflowCells) {
        this.m_startHour = startHour;
        this.m_endHour = endHour;
        this.m_useOverflowCells = useOverflowCells;
        this.initTimeLineText();
    }

    public void setShowDisplayModeSelectionPanel(boolean showDisplayModeSelectionPanel) {
        this.m_showDisplayModeSelectionPanel = showDisplayModeSelectionPanel;
    }

    public void setMarkNoonHour(boolean markNoonHour) {
        this.m_markNoonHour = markNoonHour;
    }

    public void setMarkOutOfMonthDays(boolean markOutOfMonthDays) {
        this.m_markOutOfMonthDays = markOutOfMonthDays;
    }

    public Set<? extends CalendarComponent> getComponents() {
        return this.m_components;
    }

    public void setComponents(Set<? extends CalendarComponent> components) {
        this.m_components = components;
        HashMap<Date, Set<CalendarComponent>> map = new HashMap<Date, Set<CalendarComponent>>();
        if (this.m_components != null) {
            for (CalendarComponent calendarComponent : this.m_components) {
                Date[] dateArray = calendarComponent.getCoveredDays();
                int n = dateArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Date d = dateArray[n2];
                    TreeSet<CalendarComponent> l = (TreeSet<CalendarComponent>)map.get(d);
                    if (l == null) {
                        l = new TreeSet<CalendarComponent>();
                        map.put(d, l);
                    }
                    l.add(calendarComponent);
                    ++n2;
                }
            }
        }
        this.refreshComponents(map);
    }

    private Object getItemId(int linkId) {
        return this.m_linkIdToItemIdMap.get(linkId);
    }

    private int getOrCreateLinkId(Object itemId) {
        if (itemId == null) {
            throw new IllegalArgumentException("itemId must not be null");
        }
        Integer linkId = this.m_ItemIdToLinkIdMap.get(itemId);
        if (linkId == null) {
            linkId = this.m_linkCounter++;
            this.m_linkIdToItemIdMap.put(linkId, itemId);
            this.m_ItemIdToLinkIdMap.put(itemId, linkId);
        }
        return linkId;
    }

    private CalendarComponent getComponentWithId(Object itemId) {
        if (itemId == null) {
            return null;
        }
        for (CalendarComponent calendarComponent : this.getComponents()) {
            if (calendarComponent == null || calendarComponent.getItem() == null || !CompareUtility.equals((Object)calendarComponent.getItem().getItemId(), (Object)itemId)) continue;
            return calendarComponent;
        }
        return null;
    }

    private void refreshComponents() {
        this.setComponents(this.m_components);
    }

    private void refreshComponents(Map<Date, Set<CalendarComponent>> map) {
        CalendarSvgUtility.clearChildNodes(this.m_elComponentsContainer);
        for (Map.Entry<Date, Set<CalendarComponent>> e : map.entrySet()) {
            Point p = this.getPosition(e.getKey());
            if (p == null || e.getValue() == null) continue;
            Element parent = this.m_elGridBox[p.y][p.x];
            CalendarComponent[] comps = e.getValue().toArray(new CalendarComponent[e.getValue().size()]);
            IComponentElementFactory fact = this.getComponentElementFactory();
            if (fact == null) continue;
            fact.setSelectedComponent(this.getSelectedComponent());
            Map<CalendarComponent, Element> compEls = fact.create(parent, this.getDateOfGridElement(parent), comps);
            if (compEls == null || compEls.size() <= 0) continue;
            for (Map.Entry<CalendarComponent, Element> el : compEls.entrySet()) {
                this.m_elComponentsContainer.appendChild(el.getValue());
                int linkId = this.getOrCreateLinkId(el.getKey().getItem().getItemId());
                SVGUtility.addHyperlink((Element)el.getValue(), (String)(LINK_COMPONENT_PREFIX + linkId + "/" + p.x + p.y));
            }
        }
    }

    private boolean isInRange(Date d) {
        if (this.m_startDate == null || this.m_endDate == null || d == null) {
            return false;
        }
        return d.after(this.m_startDate) && d.before(this.m_endDate) || d.equals(this.m_startDate) || d.equals(this.m_endDate);
    }

    private void clearHighlightedBox() {
        if (this.m_selectedElement != null) {
            this.setBorder(this.m_selectedElement, false);
            this.m_selectedElement = null;
        }
    }

    private void setBorder(Element element, boolean selected) {
        SVGStylable css = (SVGStylable)element;
        CalendarSvgUtility.setBorderColor(element, selected ? "#000000" : COLOR_NOT_SELECTED_DAY_BORDER);
        css.getStyle().setProperty("stroke-width", "2", "");
    }

    private void setHighlightedBox(int weekday, int week) {
        if (this.m_selectedElement != null) {
            this.setBorder(this.m_selectedElement, false);
        }
        this.m_selectedElement = this.m_elGridBox[week][weekday];
        this.setBorder(this.m_selectedElement, true);
    }

    private Date getDateAt(int weekday, int week) {
        Element e = this.m_elGridBox[week][weekday];
        return this.m_gridDateMap.get(e);
    }

    public Date getEndDate() {
        if (this.m_endDate == null) {
            return null;
        }
        return (Date)this.m_endDate.clone();
    }

    public Date getStartDate() {
        if (this.m_startDate == null) {
            return null;
        }
        return (Date)this.m_startDate.clone();
    }

    public SVGDocument getSVGDocument() {
        return (SVGDocument)this.m_bridgeContext.getDocument();
    }

    public void dispose() {
        this.m_bridgeContext.dispose();
    }

    public void setNumContextMenus(int numContextMenus) {
        this.m_numContextMenus = numContextMenus;
        this.refreshContextMenu();
    }

    public int getNumContextMenus() {
        return this.m_numContextMenus;
    }

    protected int getEndHour() {
        return this.m_endHour;
    }

    protected int getStartHour() {
        return this.m_startHour;
    }

    protected boolean getUseOverflowCells() {
        return this.m_useOverflowCells;
    }

    protected boolean getShowDisplayModeSelectionPanel() {
        return this.m_showDisplayModeSelectionPanel;
    }

    protected boolean getMarkNoonHour() {
        return this.m_markNoonHour;
    }

    protected boolean getMarkOutOfMonthDays() {
        return this.m_markOutOfMonthDays;
    }

    protected Element[] getElementTimeLineTexts() {
        return this.m_elTimeLineTexts;
    }

    protected Element[][] getElementTimeLineGrid() {
        return this.m_elTimeLineGrid;
    }

    private Date getShownDate() {
        return this.m_shownDate;
    }

    private void refreshContextMenu() {
        CalendarSvgUtility.clearChildNodes(this.m_elMenuContainer);
        if (this.getNumContextMenus() > 0) {
            float[] rectDimensions = new float[]{536.088f, 447.602f, 14.912f, 14.914f};
            Element rect = this.getSVGDocument().createElementNS("http://www.w3.org/2000/svg", "rect");
            rect.setAttribute("x", "" + rectDimensions[0]);
            rect.setAttribute("y", "" + rectDimensions[1]);
            rect.setAttribute("width", "" + rectDimensions[2]);
            rect.setAttribute("height", "" + rectDimensions[3]);
            CalendarSvgUtility.setBorderColor(rect, COLOR_NOT_SELECTED_DAY_BORDER);
            CalendarSvgUtility.setBackgroundColor(rect, "#ffffff");
            this.m_elMenuContainer.appendChild(rect);
            SVGUtility.addHyperlink((Element)rect, (String)LINK_CONTEXT_MENU);
            String trianglePoints = "549.525,451.794 543.614,458.496 537.703,451.794";
            Element triangle = this.getSVGDocument().createElementNS("http://www.w3.org/2000/svg", "polygon");
            triangle.setAttribute("points", "549.525,451.794 543.614,458.496 537.703,451.794");
            this.m_elMenuContainer.appendChild(triangle);
            SVGUtility.addHyperlink((Element)triangle, (String)LINK_CONTEXT_MENU);
        }
    }

    private static interface IGridVisitor {
        public void visit(Element var1, int var2, int var3);
    }
}

