/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.decoration;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.ext.decoration.AbstractDecoration;
import org.eclipse.scout.rt.ui.swing.ext.decoration.DecorationMouseEvent;
import org.eclipse.scout.rt.ui.swing.ext.decoration.IDecorationItem;

public abstract class AbstractDecorationItem
extends AbstractDecoration
implements IDecorationItem {
    private IDecorationItem.State m_state = IDecorationItem.State.Normal;
    private boolean m_enabled = true;
    private boolean m_visible = true;
    private EventListenerList m_eventListeners = new EventListenerList();
    private Cursor m_mouseOverCursor;
    private Cursor m_defaultCursor;

    public AbstractDecorationItem(JComponent owner, ISwingEnvironment environment, boolean callInitializer) {
        super(owner, environment, callInitializer);
        this.m_defaultCursor = owner.getCursor();
    }

    @Override
    protected void init() {
    }

    private boolean updateState(boolean mouseOver) {
        IDecorationItem.State newState = IDecorationItem.State.Normal;
        if (!this.m_visible) {
            return false;
        }
        newState = !this.m_enabled ? IDecorationItem.State.Disabled : (mouseOver ? IDecorationItem.State.Rollover : IDecorationItem.State.Normal);
        if (!CompareUtility.equals((Object)((Object)newState), (Object)((Object)this.m_state))) {
            this.m_state = newState;
            return true;
        }
        return false;
    }

    @Override
    public IDecorationItem.State getState() {
        return this.m_state;
    }

    public boolean isVisible() {
        return this.m_visible;
    }

    public void setVisible(boolean visible) {
        this.m_visible = visible;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
        this.updateState(false);
    }

    public void setMouseOverCursor(Cursor mouseOverCursor) {
        this.m_mouseOverCursor = mouseOverCursor;
    }

    public Cursor getMouseOverCursor() {
        return this.m_mouseOverCursor;
    }

    public synchronized void addMouseListener(MouseListener l) {
        if (l == null) {
            return;
        }
        this.m_eventListeners.add(MouseListener.class, l);
    }

    public synchronized void removeMouseListener(MouseListener l) {
        if (l == null) {
            return;
        }
        this.m_eventListeners.remove(MouseListener.class, l);
    }

    @Override
    public void handleMouseChlicked(MouseEvent e) {
        if (this.isVisible() && this.isEnabled()) {
            MouseListener[] mouseListenerArray = (MouseListener[])this.m_eventListeners.getListeners(MouseListener.class);
            int n = mouseListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                MouseListener l = mouseListenerArray[n2];
                l.mouseClicked(e);
                ++n2;
            }
        }
    }

    @Override
    public void handleMouseMoved(DecorationMouseEvent e) {
        boolean mouseOver;
        if (!this.isVisible() || !this.isEnabled()) {
            return;
        }
        boolean bl = mouseOver = this.getBounds() != null && this.getBounds().contains(e.getPoint());
        if (mouseOver && this.getMouseOverCursor() != e.getCurrentCursor()) {
            e.setCursorToApply(this.getMouseOverCursor());
        }
        if (this.updateState(mouseOver)) {
            e.setRepaintNeeded(true);
        }
    }

    @Override
    public void handleMouseExit(DecorationMouseEvent e) {
        if (!this.isVisible() || !this.isEnabled()) {
            return;
        }
        if (this.updateState(false)) {
            e.setRepaintNeeded(true);
        }
    }
}

