/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.checkbox;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField;
import org.eclipse.scout.rt.ui.swing.LogicalGridData;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.ext.JCheckBoxEx;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.checkbox.ISwingScoutCheckBox;
import org.eclipse.scout.rt.ui.swing.icons.CheckboxIcon;

public class SwingScoutCheckBox
extends SwingScoutValueFieldComposite<IBooleanField>
implements ISwingScoutCheckBox {
    private static final long serialVersionUID = 1L;
    private boolean m_mandatoryCached;
    private boolean m_tableCellContext;
    private Insets m_tableCellInsets;

    @Override
    protected void initializeSwing() {
        JPanelEx container = new JPanelEx();
        container.setOpaque(false);
        JStatusLabelEx label = this.getSwingEnvironment().createStatusLabel((IFormField)this.getScoutObject());
        container.add(label);
        JCheckBox swingCheckBox = this.createCheckBox(container);
        container.add(swingCheckBox);
        swingCheckBox.setVerifyInputWhenFocusTarget(true);
        swingCheckBox.setAlignmentX(0.0f);
        swingCheckBox.setVerticalAlignment(1);
        swingCheckBox.addActionListener(new P_SwingActionListener());
        this.setSwingLabel(label);
        this.setSwingField(swingCheckBox);
        this.setSwingContainer(container);
        LogicalGridData gd = (LogicalGridData)swingCheckBox.getClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME);
        gd.fillHorizontal = false;
        if (this.isTableCellContext()) {
            CheckboxIcon iconNormalState = new CheckboxIcon();
            CheckboxIcon iconSelectedState = new CheckboxIcon();
            iconSelectedState.setSelected(true);
            iconSelectedState.setEnabled(true);
            CheckboxIcon iconDisabledState = new CheckboxIcon();
            iconDisabledState.setEnabled(false);
            CheckboxIcon iconDisabledSelectedState = new CheckboxIcon();
            iconDisabledSelectedState.setEnabled(false);
            iconDisabledSelectedState.setSelected(true);
            swingCheckBox.setIcon(iconNormalState);
            swingCheckBox.setSelectedIcon(iconSelectedState);
            swingCheckBox.setDisabledIcon(iconDisabledState);
            swingCheckBox.setDisabledSelectedIcon(iconDisabledSelectedState);
            swingCheckBox.setRolloverEnabled(false);
            swingCheckBox.setRolloverIcon(null);
            swingCheckBox.setPressedIcon(null);
            Insets cellInsets = new Insets(0, 0, 0, 0);
            if (this.getTableCellInsets() != null) {
                cellInsets = (Insets)this.getTableCellInsets().clone();
            }
            if (((IBooleanField)this.getScoutObject()).getGridDataHints().verticalAlignment == -1) {
                cellInsets.top += 4;
            }
            swingCheckBox.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
            container.setBorder(new EmptyBorder(cellInsets));
            gd.fillVertical = false;
            gd.horizontalAlignment = ((IBooleanField)this.getScoutObject()).getGridDataHints().horizontalAlignment;
            gd.verticalAlignment = ((IBooleanField)this.getScoutObject()).getGridDataHints().verticalAlignment;
            gd.weighty = 1.0;
        }
        this.getSwingContainer().setLayout(new LogicalGridLayout(this.getSwingEnvironment(), 1, 0));
    }

    protected JCheckBox createCheckBox(JComponent container) {
        JCheckBoxEx swingCheckBox = new JCheckBoxEx();
        swingCheckBox.setOpaque(false);
        return swingCheckBox;
    }

    @Override
    public JCheckBoxEx getSwingCheckBox() {
        return (JCheckBoxEx)this.getSwingField();
    }

    @Override
    protected void setHorizontalAlignmentFromScout(int scoutAlign) {
        if (this.getSwingCheckBox() != null) {
            this.getSwingCheckBox().setHorizontalAlignment(SwingUtility.createHorizontalAlignment(scoutAlign));
        }
    }

    @Override
    protected void setLabelFromScout(String s) {
        this.getSwingCheckBox().setText(s);
    }

    @Override
    protected void setValueFromScout(Object o) {
        this.getSwingCheckBox().setSelected((Boolean)o);
    }

    @Override
    protected void setMandatoryFromScout(boolean b) {
        if (b != this.m_mandatoryCached) {
            this.m_mandatoryCached = b;
            this.getSwingCheckBox().setMandatory(b);
            this.getSwingLabel().setMandatory(b);
        }
    }

    public boolean isTableCellContext() {
        return this.m_tableCellContext;
    }

    public void setTableCellContext(boolean tableCellContext) {
        this.m_tableCellContext = tableCellContext;
    }

    public Insets getTableCellInsets() {
        return this.m_tableCellInsets;
    }

    public void setTableCellInsets(Insets insets) {
        this.m_tableCellInsets = insets;
    }

    protected void handleSwingAction(ActionEvent e) {
        if (!this.getSwingCheckBox().isEnabled()) {
            return;
        }
        Runnable t = new Runnable(){

            @Override
            public void run() {
                boolean newSelection;
                boolean oldSelection = ((IBooleanField)SwingScoutCheckBox.this.getScoutObject()).isChecked();
                if (oldSelection == (newSelection = ((IBooleanField)SwingScoutCheckBox.this.getScoutObject()).getUIFacade().setSelectedFromUI())) {
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            SwingScoutCheckBox.this.getSwingCheckBox().setSelected(newSelection);
                        }
                    };
                    SwingScoutCheckBox.this.getSwingEnvironment().invokeSwingLater(r);
                }
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 0L);
    }

    private class P_SwingActionListener
    implements ActionListener {
        private P_SwingActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingScoutCheckBox.this.handleSwingAction(e);
        }
    }
}

