/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.imagebox.imageviewer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swing.ext.MouseClickedBugFix;
import org.eclipse.scout.rt.ui.swing.form.fields.imagebox.imageviewer.ImageTransformEvent;
import org.eclipse.scout.rt.ui.swing.form.fields.imagebox.imageviewer.ImageTransformListener;

public class SwingImageViewer
extends JComponent {
    public static final float EPS = 1.0E-6f;
    private static final long serialVersionUID = 1L;
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingImageViewer.class);
    protected static final int FOCUS_BORDER_OFFSET_PX = 2;
    protected static final int NO_FOCUS_BORDER_OFFSET_PX = 0;
    private EventListenerList m_eventListenerList = new EventListenerList();
    private Image m_origImg;
    private double m_dx = 0.0;
    private double m_dy = 0.0;
    private double m_sx = 1.0;
    private double m_sy = 1.0;
    private double m_angle = 0.0;
    private Rectangle m_analysisRect;
    private Rectangle m_selectionRect;
    private boolean m_autoFit = false;
    private boolean m_insideValidateTreeProcess;
    private Point m_imageLocation;

    public SwingImageViewer() {
        this.addMouseListener(new MouseAdapter(){
            MouseClickedBugFix fix;

            @Override
            public void mousePressed(MouseEvent e) {
                this.fix = new MouseClickedBugFix(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.fix != null) {
                    this.fix.mouseReleased(this, e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (this.fix.mouseClicked()) {
                    return;
                }
                SwingImageViewer.this.requestFocus();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SwingImageViewer.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                SwingImageViewer.this.repaint();
            }
        });
    }

    public void revalidateAndRepaint() {
        if (!this.m_insideValidateTreeProcess) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setAutoFit(boolean b) {
        this.m_autoFit = b;
        if (this.isAutoFit()) {
            this.doFitImage();
        }
    }

    public void doZoomRectangle(Rectangle rect) {
        this.m_selectionRect = (Rectangle)rect.clone();
        this.doFitImage();
    }

    public boolean isAutoFit() {
        return this.m_autoFit;
    }

    private AffineTransform calculateCurrentTransformation() {
        AffineTransform af = new AffineTransform();
        af.translate(this.m_dx, this.m_dy);
        af.scale(this.m_sx, this.m_sy);
        if (this.m_selectionRect != null) {
            af.translate(this.m_selectionRect.getCenterX(), this.m_selectionRect.getCenterY());
            af.rotate(this.m_angle);
            af.translate(-this.m_selectionRect.getCenterX(), -this.m_selectionRect.getCenterY());
        } else {
            af.translate(this.m_origImg.getWidth(this) / 2, this.m_origImg.getHeight(this) / 2);
            af.rotate(this.m_angle);
            af.translate(-this.m_origImg.getWidth(this) / 2, -this.m_origImg.getHeight(this) / 2);
        }
        return af;
    }

    public void setImage(Object imgData) {
        byte[] b;
        Image img = null;
        if (imgData instanceof Image) {
            img = (Image)imgData;
        } else if (imgData instanceof byte[] && (b = (byte[])imgData) != null) {
            img = Toolkit.getDefaultToolkit().createImage(b);
        }
        if (img != null) {
            new ImageIcon(img).getIconWidth();
        }
        this.m_origImg = img;
        if (this.isAutoFit()) {
            this.doFitImage();
        }
        this.revalidateAndRepaint();
    }

    private void doZoomToSelection(Rectangle selectionRect) {
        int selectionWidth = (int)selectionRect.getWidth();
        int selectionHeight = (int)selectionRect.getHeight();
        Dimension frame = this.getSize();
        double wfactor = Math.max(0.001, 1.0 * (double)frame.width / (double)selectionWidth);
        double hfactor = Math.max(0.001, 1.0 * (double)frame.height / (double)selectionHeight);
        double fitScale = Math.min(hfactor, wfactor);
        AffineTransform newAT = AffineTransform.getScaleInstance(fitScale, fitScale);
        Rectangle txSelectionRect = newAT.createTransformedShape(selectionRect).getBounds();
        int translateX = this.getAlignmentX() == 0.0f ? -txSelectionRect.x : (this.getAlignmentX() == 0.5f ? -txSelectionRect.x + Math.max(0, frame.width - txSelectionRect.width) / 2 : -txSelectionRect.x + Math.max(0, frame.width - txSelectionRect.width));
        int translateY = this.getAlignmentY() == 0.0f ? -txSelectionRect.y : (this.getAlignmentY() == 0.5f ? -txSelectionRect.y + Math.max(0, frame.height - txSelectionRect.height) / 2 : -txSelectionRect.y + Math.max(0, frame.height - txSelectionRect.height));
        this.m_dx = translateX;
        this.m_dy = translateY;
        this.m_sx = fitScale;
        this.m_sy = fitScale;
        this.revalidateAndRepaint();
        this.fireImageTransformChange();
    }

    public void doZoomToSelection(int x, int y, int width, int heigth) {
        this.doZoomToSelection(new Rectangle(x, y, width, heigth));
    }

    public void doFitImage() {
        if (this.m_origImg != null) {
            if (this.m_selectionRect != null) {
                this.doZoomToSelection(this.m_selectionRect);
            } else {
                this.doZoomToSelection(0, 0, this.m_origImg.getWidth(this), this.m_origImg.getHeight(this));
            }
        }
    }

    public void setAnalysisRect(Rectangle rect) {
        this.m_analysisRect = rect;
        this.revalidateAndRepaint();
    }

    public void setImageTransform(double dx, double dy, double sx, double sy, double angle) {
        this.m_dx = dx;
        this.m_dy = dy;
        this.m_sx = sx;
        this.m_sy = sy;
        this.m_angle = angle;
        this.revalidateAndRepaint();
    }

    @Override
    public void reshape(int x, int y, int w, int h) {
        boolean changed = this.getWidth() != w || this.getHeight() != h;
        super.reshape(x, y, w, h);
        if (changed && (this.isAutoFit() || this.m_selectionRect != null)) {
            try {
                this.m_insideValidateTreeProcess = true;
                this.doFitImage();
            }
            finally {
                this.m_insideValidateTreeProcess = false;
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = new Dimension(0, 0);
        Image img = this.m_origImg;
        if (img != null) {
            d.width = Math.max(d.width, img.getWidth(this));
            d.height = Math.max(d.height, img.getHeight(this));
        }
        return d;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension d = this.isAutoFit() ? new Dimension(0, 0) : this.getPreferredSize();
        return d;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension d;
        Image img = this.m_origImg;
        if (img != null) {
            d = new Dimension(0, 0);
            d.width = Math.max(d.width, img.getWidth(this));
            d.height = Math.max(d.height, img.getHeight(this));
        } else {
            d = this.getPreferredSize();
        }
        return d;
    }

    @Override
    public void paintComponent(Graphics g) {
        block9: {
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (this.m_origImg != null) {
                Graphics2D g2 = (Graphics2D)g;
                AffineTransform oldAt = g2.getTransform();
                Color oldColor = g2.getColor();
                try {
                    AffineTransform af = this.calculateCurrentTransformation();
                    g2.transform(af);
                    int imgW = this.m_origImg.getWidth(this);
                    int imgH = this.m_origImg.getHeight(this);
                    this.setImageLocation(this.getImageLocation(imgW, imgH));
                    g2.drawImage(this.m_origImg, this.getImageLocation().x, this.getImageLocation().y, this);
                    if (this.m_analysisRect != null) {
                        g.setColor(this.getForeground());
                        g2.drawRect(this.m_analysisRect.x, this.m_analysisRect.y, this.m_analysisRect.width, this.m_analysisRect.height);
                    }
                    if (!this.hasFocus() || !this.isFocusable()) break block9;
                    Color origColor = g.getColor();
                    Stroke origStroke = g2.getStroke();
                    try {
                        int focusBorderOffset = this.getFocusBorderOffset();
                        g.setColor(Color.BLUE);
                        g2.setStroke(new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{1.0f}, 0.0f));
                        g2.drawRect(this.getImageLocation().x - focusBorderOffset, this.getImageLocation().y - focusBorderOffset, imgW + 2 * focusBorderOffset, imgH + 2 * focusBorderOffset);
                    }
                    finally {
                        g.setColor(origColor);
                        g2.setStroke(origStroke);
                    }
                }
                finally {
                    g2.setTransform(oldAt);
                    g2.setColor(oldColor);
                }
            }
        }
    }

    protected int getFocusBorderOffset() {
        if (this.isFocusable()) {
            return 2;
        }
        return 0;
    }

    protected Point getImageLocation(int imgW, int imgH) {
        Point location = new Point();
        if (!this.isAutoFit()) {
            int focusBorderOffset = this.getFocusBorderOffset();
            Rectangle clipingBounds = this.getBounds();
            location.x = imgW >= clipingBounds.width ? focusBorderOffset : (Math.abs((double)this.getAlignmentX() - 0.5) < (double)1.0E-6f ? (clipingBounds.width - imgW - 2 * focusBorderOffset) / 2 : ((double)this.getAlignmentX() > 0.5 ? clipingBounds.width - imgW - 2 * focusBorderOffset : focusBorderOffset));
            location.y = imgH >= clipingBounds.height ? focusBorderOffset : (Math.abs((double)this.getAlignmentY() - 0.5) < (double)1.0E-6f ? (clipingBounds.height - imgH - 2 * focusBorderOffset) / 2 : ((double)this.getAlignmentY() > 0.5 ? clipingBounds.height - imgH - 2 * focusBorderOffset : focusBorderOffset));
        }
        return location;
    }

    public void addImageTransformListener(ImageTransformListener listener) {
        this.m_eventListenerList.add(ImageTransformListener.class, listener);
    }

    public void removeImageTransformListener(ImageTransformListener listener) {
        this.m_eventListenerList.remove(ImageTransformListener.class, listener);
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("dx = " + this.m_dx);
        buf.append(" dy = " + this.m_dy);
        buf.append(" sx = " + this.m_sx);
        buf.append(" sy = " + this.m_sy);
        buf.append(" angle = " + this.m_angle);
        if (this.m_origImg != null) {
            buf.append(" center = " + this.m_origImg.getWidth(this) / 2 + " " + this.m_origImg.getHeight(this) / 2);
        }
        return buf.toString();
    }

    protected void fireImageTransformChange() {
        this.fireImageTransformChange(this.m_dx, this.m_dy, this.m_sx, this.m_sy, this.m_angle);
    }

    protected void fireImageTransformChange(double dx, double dy, double sx, double sy, double angle) {
        EventListener[] eventlisters = this.m_eventListenerList.getListeners(ImageTransformListener.class);
        if (eventlisters != null && eventlisters.length > 0) {
            ImageTransformEvent event = new ImageTransformEvent(this, dx, dy, sx, sy, angle);
            int i = 0;
            while (i < eventlisters.length) {
                ((ImageTransformListener)eventlisters[i]).transformChanged(event);
                ++i;
            }
        }
    }

    public Point getImageLocation() {
        return this.m_imageLocation;
    }

    protected void setImageLocation(Point imageLocation) {
        this.m_imageLocation = imageLocation;
    }

    private class P_SwingFit
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private P_SwingFit() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingImageViewer.this.doFitImage();
        }
    }
}

