/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.textfield;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scout.rt.client.services.common.spellchecker.ISpellingMonitor;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.action.menu.SwingScoutContextMenu;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.JTextFieldEx;
import org.eclipse.scout.rt.ui.swing.ext.decoration.ContextMenuDecorationItem;
import org.eclipse.scout.rt.ui.swing.ext.decoration.JTextFieldWithDecorationIcons;
import org.eclipse.scout.rt.ui.swing.form.fields.textfield.ISwingScoutTextField;
import org.eclipse.scout.rt.ui.swing.form.fields.textfield.SwingScoutTextFieldComposite;
import org.eclipse.scout.rt.ui.swing.spellchecker.ISwingSpellCheckerService;
import org.eclipse.scout.rt.ui.swing.spellchecker.SwingFieldHolder;
import org.eclipse.scout.service.SERVICES;

public class SwingScoutTextField
extends SwingScoutTextFieldComposite<IStringField>
implements ISwingScoutTextField {
    private ISpellingMonitor m_spellingMonitor;
    private ContextMenuDecorationItem m_contextMenuMarker;
    private SwingScoutContextMenu m_contextMenu;

    @Override
    protected void initializeSwing() {
        super.initializeSwing();
        JPanelEx container = new JPanelEx();
        container.setOpaque(false);
        JStatusLabelEx label = this.getSwingEnvironment().createStatusLabel((IFormField)this.getScoutObject());
        container.add(label);
        JTextFieldWithDecorationIcons textField = new JTextFieldWithDecorationIcons();
        this.m_contextMenuMarker = new ContextMenuDecorationItem((IContextMenu)((IStringField)this.getScoutObject()).getContextMenu(), textField, this.getSwingEnvironment());
        this.m_contextMenuMarker.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SwingScoutTextField.this.m_contextMenu.showSwingPopup(e.getX(), e.getY(), false);
            }
        });
        textField.setDecorationIcon(this.m_contextMenuMarker);
        container.add(textField);
        this.setSwingContainer(container);
        this.setSwingLabel(label);
        this.setSwingField(textField);
        this.getSwingContainer().setLayout(new LogicalGridLayout(this.getSwingEnvironment(), 1, 0));
    }

    @Override
    protected void installContextMenu() {
        ((IStringField)this.getScoutObject()).getContextMenu().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("visible".equals(evt.getPropertyName())) {
                    SwingScoutTextField.this.m_contextMenuMarker.setMarkerVisible(((IStringField)SwingScoutTextField.this.getScoutObject()).getContextMenu().isVisible());
                }
            }
        });
        this.m_contextMenuMarker.setMarkerVisible(((IStringField)this.getScoutObject()).getContextMenu().isVisible());
        this.m_contextMenu = SwingScoutContextMenu.installContextMenuWithSystemMenus(this.getSwingTextField(), (IContextMenu)((IStringField)this.getScoutObject()).getContextMenu(), this.getSwingEnvironment());
    }

    @Override
    public JTextFieldEx getSwingTextField() {
        return (JTextFieldEx)this.getSwingTextComponent();
    }

    @Override
    protected void setHorizontalAlignmentFromScout(int scoutAlign) {
        int swingAlign = SwingUtility.createHorizontalAlignment(scoutAlign);
        this.getSwingTextField().setHorizontalAlignment(swingAlign);
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        ISwingSpellCheckerService spellCheckerService = (ISwingSpellCheckerService)SERVICES.getService(ISwingSpellCheckerService.class);
        if (spellCheckerService != null && spellCheckerService.isInstalled()) {
            this.m_spellingMonitor = spellCheckerService.createSpellingMonitor(new SwingFieldHolder(this, this.getSwingTextField()));
        }
        this.updateContextMenuFromScout();
    }

    @Override
    protected void detachScout() {
        if (this.m_spellingMonitor != null) {
            this.m_spellingMonitor.dispose();
            this.m_spellingMonitor = null;
        }
        super.detachScout();
    }
}

