/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window;

import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.JDialog;

public class DependentCloseListener {
    private Window m_parent;
    private Vector<Window> m_dependingWindows;
    private WindowListener m_windowListener;
    private ComponentListener m_componentListener;

    public DependentCloseListener(Window parent) {
        this.m_parent = parent;
        Window[] ownedWindows = parent.getOwnedWindows();
        if (ownedWindows != null && ownedWindows.length > 0) {
            this.m_windowListener = new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    DependentCloseListener.this.handleWindowHide(e.getWindow());
                }
            };
            this.m_componentListener = new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    DependentCloseListener.this.handleWindowHide((Window)e.getComponent());
                }
            };
            this.m_dependingWindows = new Vector();
            Window[] windowArray = ownedWindows;
            int n = ownedWindows.length;
            int n2 = 0;
            while (n2 < n) {
                Window w = windowArray[n2];
                if (w.isVisible() && w instanceof JDialog) {
                    this.m_dependingWindows.add(w);
                    w.addWindowListener(this.m_windowListener);
                    w.addComponentListener(this.m_componentListener);
                }
                ++n2;
            }
        }
    }

    private void handleWindowHide(Window w) {
        if (this.m_windowListener != null) {
            w.removeWindowListener(this.m_windowListener);
        }
        if (this.m_componentListener != null) {
            w.removeComponentListener(this.m_componentListener);
        }
        this.m_dependingWindows.remove(w);
        this.checkState();
    }

    public boolean close() {
        return this.checkState();
    }

    private boolean checkState() {
        if (this.m_parent != null && this.m_parent.isVisible()) {
            int activeCount = 0;
            if (this.m_dependingWindows != null && this.m_dependingWindows.size() > 0) {
                for (Window w : this.m_dependingWindows) {
                    if (!w.isVisible()) continue;
                    ++activeCount;
                }
            }
            if (activeCount == 0) {
                this.m_parent.setVisible(false);
                this.m_parent.dispose();
                this.m_parent = null;
                if (this.m_dependingWindows != null) {
                    this.m_dependingWindows.clear();
                }
                return true;
            }
            return false;
        }
        return true;
    }
}

