/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.basic.ISwtScoutPropertyObserver;

public abstract class AbstractSwtScoutPropertyObserver<T extends IPropertyObserver>
implements ISwtScoutPropertyObserver<T> {
    private final OptimisticLock m_updateSwtFromScoutLock = new OptimisticLock();
    private final Set<String> m_ignoredScoutEvents = new HashSet<String>();
    private ISwtEnvironment m_environment;
    private T m_scoutObject;
    private P_ScoutPropertyChangeListener m_scoutPropertyListener;
    private boolean m_connectedToScout;

    protected void setScoutObjectAndSwtEnvironment(T scoutObject, ISwtEnvironment environment) {
        this.m_scoutObject = scoutObject;
        this.m_environment = environment;
    }

    public OptimisticLock getUpdateSwtFromScoutLock() {
        return this.m_updateSwtFromScoutLock;
    }

    public void addIgnoredScoutEvent(Class eventType, String name) {
        this.m_ignoredScoutEvents.add(String.valueOf(eventType.getSimpleName()) + ":" + name);
    }

    public void removeIgnoredScoutEvent(Class eventType, String name) {
        this.m_ignoredScoutEvents.remove(String.valueOf(eventType.getSimpleName()) + ":" + name);
    }

    @Override
    public T getScoutObject() {
        return this.m_scoutObject;
    }

    @Override
    public ISwtEnvironment getEnvironment() {
        return this.m_environment;
    }

    public boolean isConnectedToScout() {
        return this.m_connectedToScout;
    }

    protected final void connectToScout() {
        if (!this.m_connectedToScout) {
            try {
                this.getUpdateSwtFromScoutLock().acquire();
                this.attachScout();
                this.applyScoutProperties();
                this.applyScoutState();
                this.m_connectedToScout = true;
            }
            finally {
                this.getUpdateSwtFromScoutLock().release();
            }
        }
    }

    protected final void disconnectFromScout() {
        if (this.m_connectedToScout) {
            try {
                this.getUpdateSwtFromScoutLock().acquire();
                this.detachScout();
                this.m_connectedToScout = false;
            }
            finally {
                this.getUpdateSwtFromScoutLock().release();
            }
        }
    }

    protected void attachScout() {
        if (this.m_scoutObject != null && this.m_scoutPropertyListener == null) {
            this.m_scoutPropertyListener = new P_ScoutPropertyChangeListener();
            this.m_scoutObject.addPropertyChangeListener((PropertyChangeListener)this.m_scoutPropertyListener);
        }
    }

    protected void detachScout() {
        if (this.m_scoutObject != null && this.m_scoutPropertyListener != null) {
            this.m_scoutObject.removePropertyChangeListener((PropertyChangeListener)this.m_scoutPropertyListener);
            this.m_scoutPropertyListener = null;
        }
    }

    protected boolean isHandleScoutPropertyChange(String name, Object newValue) {
        return true;
    }

    protected boolean isHandleScoutPropertyChangeSwtThread() {
        return true;
    }

    protected void handleScoutPropertyChange(String name, Object newValue) {
    }

    protected void applyScoutProperties() {
    }

    protected void applyScoutState() {
    }

    public boolean isIgnoredScoutEvent(Class eventType, String name) {
        if (this.m_ignoredScoutEvents.isEmpty()) {
            return false;
        }
        boolean b = this.m_ignoredScoutEvents.contains(String.valueOf(eventType.getSimpleName()) + ":" + name);
        return b;
    }

    protected void debugHandlePropertyChanged(PropertyChangeEvent e) {
    }

    private class P_ScoutPropertyChangeListener
    implements PropertyChangeListener {
        private P_ScoutPropertyChangeListener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent e) {
            AbstractSwtScoutPropertyObserver.this.debugHandlePropertyChanged(e);
            if (AbstractSwtScoutPropertyObserver.this.isIgnoredScoutEvent(PropertyChangeEvent.class, e.getPropertyName())) {
                return;
            }
            if (AbstractSwtScoutPropertyObserver.this.isHandleScoutPropertyChange(e.getPropertyName(), e.getNewValue())) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        if (AbstractSwtScoutPropertyObserver.this.isHandleScoutPropertyChangeSwtThread()) {
                            try {
                                AbstractSwtScoutPropertyObserver.this.getUpdateSwtFromScoutLock().acquire();
                                AbstractSwtScoutPropertyObserver.this.handleScoutPropertyChange(e.getPropertyName(), e.getNewValue());
                            }
                            finally {
                                AbstractSwtScoutPropertyObserver.this.getUpdateSwtFromScoutLock().release();
                            }
                        }
                    }
                };
                AbstractSwtScoutPropertyObserver.this.m_environment.invokeSwtLater(t);
            }
        }
    }
}

