/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.application;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.tool.IToolButton;
import org.eclipse.scout.rt.client.ui.action.view.IViewButton;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironmentListener;
import org.eclipse.scout.rt.ui.swt.SwtEnvironmentEvent;
import org.eclipse.scout.rt.ui.swt.action.SwtScoutToolbarAction;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

public class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    private static IScoutLogger logger = ScoutLogManager.getLogger(ApplicationActionBarAdvisor.class);
    private IActionBarConfigurer m_configurer;
    private ToolBarManager m_toolbar;
    private ISwtEnvironment m_environment;

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer, ISwtEnvironment environment) {
        super(configurer);
        this.m_configurer = configurer;
        this.m_environment = environment;
        this.m_environment.addEnvironmentListener(new ISwtEnvironmentListener(){

            @Override
            public void environmentChanged(SwtEnvironmentEvent e) {
                if (e.getType() == 2 && ApplicationActionBarAdvisor.this.m_toolbar.getControl() != null && !ApplicationActionBarAdvisor.this.m_toolbar.getControl().isDisposed()) {
                    ApplicationActionBarAdvisor.this.initViewButtons(ApplicationActionBarAdvisor.this.getEnvironment().getScoutDesktop());
                }
            }
        });
    }

    public ISwtEnvironment getEnvironment() {
        return this.m_environment;
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        menuBar.add((IContributionItem)new MenuManager("", "file"));
    }

    public void initViewButtons(IDesktop d) {
        if (d != null) {
            SwtScoutToolbarAction swtAction;
            for (IViewButton scoutViewButton : d.getViewButtons()) {
                if (!scoutViewButton.isVisible() || !scoutViewButton.isVisibleGranted()) continue;
                swtAction = new SwtScoutToolbarAction((IAction)scoutViewButton, this.getEnvironment(), (IToolBarManager)this.m_toolbar);
                this.contributeToCoolBar(swtAction);
            }
            for (IToolButton scoutToolButton : d.getToolButtons()) {
                if (!scoutToolButton.isVisible() || !scoutToolButton.isVisibleGranted()) continue;
                swtAction = new SwtScoutToolbarAction((IAction)scoutToolButton, this.getEnvironment(), (IToolBarManager)this.m_toolbar);
                this.contributeToCoolBar(swtAction);
            }
            this.m_configurer.getCoolBarManager().update(true);
        }
    }

    protected void contributeToCoolBar(Action swtAction) {
        ActionContributionItem contributionItem = new ActionContributionItem((org.eclipse.jface.action.IAction)swtAction);
        contributionItem.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        this.m_toolbar.add((IContributionItem)contributionItem);
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        this.m_toolbar = new ToolBarManager(0x820000);
        ToolBarContributionItem item = new ToolBarContributionItem((IToolBarManager)this.m_toolbar, "main");
        coolBar.add((IContributionItem)item);
    }
}

