/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.table.celleditor;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scout.commons.BooleanUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.holders.BooleanHolder;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableUtility;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBooleanColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField;
import org.eclipse.scout.rt.ui.swt.basic.ISwtScoutComposite;
import org.eclipse.scout.rt.ui.swt.basic.table.ISwtScoutTable;
import org.eclipse.scout.rt.ui.swt.basic.table.celleditor.IFormFieldPopupListener;
import org.eclipse.scout.rt.ui.swt.basic.table.celleditor.SwtScoutFormFieldPopup;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.scout.rt.ui.swt.keystroke.SwtKeyStroke;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class SwtScoutTableCellEditor {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutTableCellEditor.class);
    private static final String DUMMY_VALUE = "Dummy";
    private final ISwtScoutTable m_tableComposite;
    private final Listener m_rowHeightListener;
    private P_FocusLostListener m_focusLostListener = new P_FocusLostListener();

    public SwtScoutTableCellEditor(ISwtScoutTable tableComposite) {
        this.m_tableComposite = tableComposite;
        this.m_rowHeightListener = new Listener(){

            public void handleEvent(Event event) {
                event.height = Math.max(event.height, UiDecorationExtensionPoint.getLookAndFeel().getLogicalGridLayoutRowHeight());
            }
        };
    }

    public void initialize() {
        TableViewer viewer = this.m_tableComposite.getSwtTableViewer();
        String[] columnPropertyNames = new String[viewer.getTable().getColumnCount()];
        CellEditor[] oldEditors = viewer.getCellEditors();
        CellEditor[] newEditors = new CellEditor[columnPropertyNames.length];
        boolean hasEditors = false;
        int i = 0;
        while (i < columnPropertyNames.length) {
            TableColumn swtCol = viewer.getTable().getColumn(i);
            IColumn scoutCol = (IColumn)swtCol.getData("scoutColumn");
            if (scoutCol != null) {
                columnPropertyNames[i] = "" + scoutCol.getColumnIndex();
                if (scoutCol.isEditable()) {
                    hasEditors = true;
                    newEditors[i] = new P_SwtCellEditor((Composite)viewer.getTable(), scoutCol);
                }
            } else {
                columnPropertyNames[i] = "";
            }
            ++i;
        }
        viewer.setCellModifier((ICellModifier)new P_SwtCellModifier());
        viewer.setColumnProperties(columnPropertyNames);
        viewer.setCellEditors(newEditors);
        if (oldEditors != null && oldEditors.length > 0) {
            CellEditor[] cellEditorArray = oldEditors;
            int n = oldEditors.length;
            int n2 = 0;
            while (n2 < n) {
                CellEditor editor = cellEditorArray[n2];
                if (editor != null) {
                    editor.dispose();
                }
                ++n2;
            }
        }
        if (hasEditors) {
            viewer.getTable().addListener(41, this.m_rowHeightListener);
        } else {
            viewer.getTable().removeListener(41, this.m_rowHeightListener);
        }
    }

    protected Control createEditorControl(Composite parent, ITableRow scoutRow, IColumn<?> scoutCol) {
        IFormField formField = this.createFormField(scoutRow, scoutCol);
        if (formField == null) {
            return null;
        }
        ISwtScoutComposite<Object> swtScoutFormField = formField instanceof IStringField && ((IStringField)formField).isMultilineText() ? this.createEditorCompositePopup(parent, formField, scoutRow, scoutCol) : this.m_tableComposite.getEnvironment().createFormField(parent, formField);
        if (swtScoutFormField != null) {
            this.decorateEditorComposite((ISwtScoutComposite<? extends IFormField>)swtScoutFormField, scoutRow, scoutCol);
            return swtScoutFormField.getSwtContainer();
        }
        return null;
    }

    protected ISwtScoutComposite<? extends IFormField> createEditorCompositePopup(Composite parent, IFormField formField, final ITableRow scoutRow, final IColumn<?> scoutCol) {
        GridData gd = formField.getGridData();
        gd.h = 1;
        gd.w = 0;
        gd.weightY = 1.0;
        gd.weightX = 1.0;
        formField.setGridDataInternal(gd);
        TableColumn swtCol = this.getSwtColumn(scoutCol);
        final P_SwtCellEditor cellEditor = (P_SwtCellEditor)this.m_tableComposite.getSwtTableViewer().getCellEditors()[this.getSwtColumnIndex(swtCol)];
        int prefWidth = gd.widthInPixel;
        int minWidth = swtCol.getWidth();
        int prefHeight = gd.heightInPixel;
        int minHeight = Math.max(105, this.m_tableComposite.getSwtTableViewer().getTable().getItemHeight());
        prefHeight = Math.max(prefHeight, minHeight);
        prefWidth = Math.max(prefWidth, minWidth);
        Composite cellEditorComposite = new Composite(parent, 0);
        final SwtScoutFormFieldPopup formFieldDialog = new SwtScoutFormFieldPopup(cellEditorComposite);
        formFieldDialog.setPrefHeight(prefHeight);
        formFieldDialog.setPrefWidth(prefWidth);
        formFieldDialog.setMinHeight(minHeight);
        formFieldDialog.setMinWidth(minWidth);
        final ICellModifier defaultCellModifier = this.m_tableComposite.getSwtTableViewer().getCellModifier();
        this.m_tableComposite.getSwtTableViewer().setCellModifier((ICellModifier)new P_SwtCellModifier(this){

            @Override
            public void modify(Object element, String property, Object value) {
                formFieldDialog.touch();
                super.modify(element, property, value);
            }
        });
        final IFocusDelegate defaultFocusDelegate = cellEditor.getFocusDelegate();
        cellEditor.setFocusDelegate(new IFocusDelegate(){

            @Override
            public void doSetFocus() {
            }
        });
        final IFormFieldPopupListener formFieldPopupListener = new IFormFieldPopupListener(){

            @Override
            public void handleEvent(int event) {
                if ((event & 1) > 0) {
                    cellEditor.stopCellEditing();
                } else if ((event & 2) > 0) {
                    cellEditor.cancelCellEditing();
                }
                if ((event & 8) > 0) {
                    SwtScoutTableCellEditor.this.enqueueEditNextTableCell(scoutRow, scoutCol, false);
                } else if ((event & 4) > 0) {
                    SwtScoutTableCellEditor.this.enqueueEditNextTableCell(scoutRow, scoutCol, true);
                }
            }
        };
        formFieldDialog.addListener(formFieldPopupListener);
        cellEditorComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                formFieldDialog.removeListener(formFieldPopupListener);
                cellEditor.setFocusDelegate(defaultFocusDelegate);
                SwtScoutTableCellEditor.this.m_tableComposite.getSwtTableViewer().setCellModifier(defaultCellModifier);
                e.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        formFieldDialog.closePopup();
                    }
                });
            }
        });
        formFieldDialog.createField(parent, formField, this.m_tableComposite.getEnvironment());
        return formFieldDialog;
    }

    protected IFormField createFormField(final ITableRow scoutRow, final IColumn<?> scoutCol) {
        if (scoutRow == null || scoutCol == null) {
            return null;
        }
        final Holder result = new Holder();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                result.setValue((Object)((ITable)SwtScoutTableCellEditor.this.m_tableComposite.getScoutObject()).getUIFacade().prepareCellEditFromUI(scoutRow, scoutCol));
            }
        };
        try {
            this.m_tableComposite.getEnvironment().invokeScoutLater(t, 2345L).join(2345L);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for the Form-Field to be created.", (Throwable)e);
        }
        return (IFormField)result.getValue();
    }

    protected void decorateEditorComposite(ISwtScoutComposite<? extends IFormField> editorComposite, ITableRow scoutRow, IColumn<?> scoutCol) {
    }

    protected void saveEditorFromSwt() {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((ITable)SwtScoutTableCellEditor.this.m_tableComposite.getScoutObject()).getUIFacade().completeCellEditFromUI();
            }
        };
        this.m_tableComposite.getEnvironment().invokeScoutLater(t, 0L);
    }

    protected void cancelEditorFromSwt() {
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((ITable)SwtScoutTableCellEditor.this.m_tableComposite.getScoutObject()).getUIFacade().cancelCellEditFromUI();
            }
        };
        this.m_tableComposite.getEnvironment().invokeScoutLater(t, 0L);
    }

    protected void enqueueEditNextTableCell(final ITableRow row, final IColumn<?> col, final boolean forward) {
        if (row == null || col == null) {
            return;
        }
        this.m_tableComposite.getEnvironment().invokeScoutLater(new Runnable(){

            @Override
            public void run() {
                if (SwtScoutTableCellEditor.this.m_tableComposite.getEnvironment() == null) {
                    return;
                }
                ITable table = (ITable)SwtScoutTableCellEditor.this.m_tableComposite.getScoutObject();
                TableUtility.editNextTableCell((ITable)table, (ITableRow)row, (IColumn)col, (boolean)forward, (TableUtility.ITableCellEditorFilter)new TableUtility.ITableCellEditorFilter(){

                    public boolean accept(ITableRow rowx, IColumn<?> colx) {
                        return true;
                    }
                });
            }
        }, 0L);
    }

    protected IColumn<?> getScoutColumn(String property) {
        if (property != null && property.matches("[0-9]+")) {
            int colIndex = Integer.parseInt(property);
            return ((ITable)this.m_tableComposite.getScoutObject()).getColumnSet().getColumn(colIndex);
        }
        return null;
    }

    private TableColumn getSwtColumn(IColumn<?> scoutCol) {
        TableColumn[] tableColumnArray = this.m_tableComposite.getSwtTableViewer().getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn swtCol = tableColumnArray[n2];
            IColumn candidate = (IColumn)swtCol.getData("scoutColumn");
            if (candidate != null && CompareUtility.equals((Object)candidate.getColumnId(), (Object)scoutCol.getColumnId())) {
                return swtCol;
            }
            ++n2;
        }
        return null;
    }

    private int getSwtColumnIndex(TableColumn swtCol) {
        Table table = this.m_tableComposite.getSwtTableViewer().getTable();
        int i = 0;
        while (i < table.getColumnCount()) {
            if (table.getColumn(i) == swtCol) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static interface IDeactivateListener {
        public void canceled(ColumnViewerEditorDeactivationEvent var1);

        public void saved(ColumnViewerEditorDeactivationEvent var1);
    }

    private static interface IFocusDelegate {
        public void doSetFocus();
    }

    private class P_FocusLostListener
    implements Listener {
        private P_FocusLostListener() {
        }

        public void install() {
            SwtScoutTableCellEditor.this.m_tableComposite.getEnvironment().getDisplay().addFilter(15, (Listener)this);
        }

        public void uninstall() {
            SwtScoutTableCellEditor.this.m_tableComposite.getEnvironment().getDisplay().removeFilter(15, (Listener)this);
        }

        public void handleEvent(Event event) {
            Widget w = event.widget;
            if (w == null || !(w instanceof Control) || w.isDisposed()) {
                return;
            }
            TableViewer viewer = SwtScoutTableCellEditor.this.m_tableComposite.getSwtTableViewer();
            if (!viewer.isCellEditorActive()) {
                return;
            }
            Control focusOwner = (Control)w;
            Table table = SwtScoutTableCellEditor.this.m_tableComposite.getSwtTableViewer().getTable();
            if (SwtUtility.isAncestorOf((Control)table, focusOwner)) {
                return;
            }
            if (focusOwner.getShell() != table.getShell()) {
                Composite parentFocusOwner = focusOwner.getShell().getParent();
                while (parentFocusOwner != null) {
                    if (parentFocusOwner.getShell() == table.getShell()) {
                        return;
                    }
                    parentFocusOwner = parentFocusOwner.getShell().getParent();
                }
            }
            CellEditor[] cellEditorArray = viewer.getCellEditors();
            int n = cellEditorArray.length;
            int n2 = 0;
            while (n2 < n) {
                CellEditor editor = cellEditorArray[n2];
                if (editor != null && editor.isActivated() && editor instanceof P_SwtCellEditor) {
                    ((P_SwtCellEditor)editor).stopCellEditing();
                    break;
                }
                ++n2;
            }
        }
    }

    private class P_SwtCellEditor
    extends CellEditor {
        private Composite m_container;
        private Object m_value;
        private ITableRow m_editScoutRow;
        private IFocusDelegate m_focusDelegate;
        private IColumn<?> m_scoutCol;
        private ViewerCell m_cell;
        private Image m_image;

        protected P_SwtCellEditor(Composite parent, IColumn<?> scoutCol) {
            super(parent);
            this.m_scoutCol = scoutCol;
            this.m_focusDelegate = new P_FocusDelegate();
        }

        protected Control createControl(Composite parent) {
            this.m_container = new Composite(parent, 0){

                public Point computeSize(int wHint, int hHint, boolean changed) {
                    return new Point(wHint, hHint);
                }
            };
            this.m_container.setLayout((Layout)new FillLayout());
            SwtScoutTableCellEditor.this.m_tableComposite.getEnvironment().addKeyStroke((Widget)this.m_container, new SwtKeyStroke(27){

                @Override
                public void handleSwtAction(Event e) {
                    e.doit = false;
                    P_SwtCellEditor.this.fireCancelEditor();
                }
            });
            SwtScoutTableCellEditor.this.m_tableComposite.getEnvironment().addKeyStroke((Widget)this.m_container, new SwtKeyStroke(13){

                @Override
                public void handleSwtAction(Event e) {
                    e.doit = false;
                    P_SwtCellEditor.this.fireApplyEditorValue();
                    P_SwtCellEditor.this.deactivate();
                }
            });
            SwtScoutTableCellEditor.this.m_tableComposite.getEnvironment().addKeyStroke((Widget)this.m_container, new SwtKeyStroke(0x1000050){

                @Override
                public void handleSwtAction(Event e) {
                    e.doit = false;
                    P_SwtCellEditor.this.fireApplyEditorValue();
                    P_SwtCellEditor.this.deactivate();
                }
            });
            return this.m_container;
        }

        protected void doSetFocus() {
            this.m_focusDelegate.doSetFocus();
        }

        protected Object doGetValue() {
            return this.m_value;
        }

        protected void doSetValue(Object value) {
            this.m_value = value;
        }

        public void activate(ColumnViewerEditorActivationEvent e) {
            SwtScoutTableCellEditor.this.m_focusLostListener.install();
            if (!(e.getSource() instanceof ViewerCell)) {
                return;
            }
            this.m_cell = (ViewerCell)e.getSource();
            this.m_editScoutRow = (ITableRow)this.m_cell.getElement();
            if (this.m_scoutCol instanceof IBooleanColumn) {
                if (e.sourceEvent instanceof MouseEvent) {
                    return;
                }
                this.m_image = this.m_cell.getImage();
                this.m_cell.setImage(null);
            }
            if (this.m_editScoutRow != null) {
                SwtScoutTableCellEditor.this.createEditorControl(this.m_container, this.m_editScoutRow, this.m_scoutCol);
            }
            this.m_container.layout(true, true);
            this.m_container.setVisible(true);
        }

        protected void deactivate(ColumnViewerEditorDeactivationEvent e) {
            if (this.m_cell != null && this.m_image != null) {
                this.m_cell.setImage(this.m_image);
            }
            this.m_cell = null;
            this.m_image = null;
            this.m_editScoutRow = null;
            Control[] controlArray = this.m_container.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.dispose();
                ++n2;
            }
            if (e.eventType == 1) {
                SwtScoutTableCellEditor.this.cancelEditorFromSwt();
            }
            super.deactivate(e);
            SwtScoutTableCellEditor.this.m_focusLostListener.uninstall();
        }

        protected boolean dependsOnExternalFocusListener() {
            return false;
        }

        public void stopCellEditing() {
            this.fireApplyEditorValue();
            this.deactivate();
        }

        public void cancelCellEditing() {
            this.fireCancelEditor();
            this.deactivate();
        }

        public IFocusDelegate getFocusDelegate() {
            return this.m_focusDelegate;
        }

        public void setFocusDelegate(IFocusDelegate focusDelegate) {
            this.m_focusDelegate = focusDelegate;
        }

        private class P_FocusDelegate
        implements IFocusDelegate {
            private P_FocusDelegate() {
            }

            @Override
            public void doSetFocus() {
                P_SwtCellEditor.this.m_container.traverse(16);
                Control focusControl = P_SwtCellEditor.this.m_container.getDisplay().getFocusControl();
                if (focusControl != null && SwtUtility.isAncestorOf((Control)P_SwtCellEditor.this.m_container, focusControl)) {
                    focusControl.addTraverseListener(new TraverseListener(){

                        public void keyTraversed(TraverseEvent e) {
                            switch (e.detail) {
                                case 2: 
                                case 4: {
                                    e.doit = false;
                                    break;
                                }
                                case 16: {
                                    e.doit = false;
                                    ITableRow currentScoutRow = P_SwtCellEditor.this.m_editScoutRow;
                                    P_SwtCellEditor.this.fireApplyEditorValue();
                                    P_SwtCellEditor.this.deactivate();
                                    SwtScoutTableCellEditor.this.enqueueEditNextTableCell(currentScoutRow, P_SwtCellEditor.this.m_scoutCol, true);
                                    break;
                                }
                                case 8: {
                                    e.doit = false;
                                    ITableRow currentScoutRow = P_SwtCellEditor.this.m_editScoutRow;
                                    P_SwtCellEditor.this.fireApplyEditorValue();
                                    P_SwtCellEditor.this.deactivate();
                                    SwtScoutTableCellEditor.this.enqueueEditNextTableCell(currentScoutRow, P_SwtCellEditor.this.m_scoutCol, false);
                                }
                            }
                        }
                    });
                }
            }
        }
    }

    private class P_SwtCellModifier
    implements ICellModifier {
        private P_SwtCellModifier() {
        }

        public void modify(Object element, String property, Object value) {
            SwtScoutTableCellEditor.this.saveEditorFromSwt();
        }

        public Object getValue(Object element, String property) {
            return SwtScoutTableCellEditor.DUMMY_VALUE;
        }

        public boolean canModify(Object element, String property) {
            final ITable table = (ITable)SwtScoutTableCellEditor.this.m_tableComposite.getScoutObject();
            final ITableRow row = (ITableRow)element;
            final IColumn<?> column = SwtScoutTableCellEditor.this.getScoutColumn(property);
            final BooleanHolder result = new BooleanHolder();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (table != null && row != null && column != null) {
                        result.setValue((Object)table.isCellEditable(row, column));
                    }
                }
            };
            try {
                SwtScoutTableCellEditor.this.m_tableComposite.getEnvironment().invokeScoutLater(r, 2345L).join(2345L);
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while waiting for the model to determine the cell's editability.", (Throwable)e);
            }
            return BooleanUtility.nvl((Boolean)((Boolean)result.getValue()), (boolean)false);
        }

        /* synthetic */ P_SwtCellModifier(P_SwtCellModifier p_SwtCellModifier, P_SwtCellModifier p_SwtCellModifier2) {
            this();
        }
    }
}

