/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.testing.codegen;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.testing.SdkAssert;
import org.eclipse.scout.sdk.testing.internal.SdkTestingApi;
import org.eclipse.scout.sdk.util.NamingUtility;
import org.eclipse.scout.sdk.util.signature.IImportValidator;
import org.eclipse.scout.sdk.util.signature.ImportValidator;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;

public class ApiTestGenerator {
    public static final String NL = "\n";
    private IJavaElement m_element;
    private Set<String> m_usedMemberNames;

    public ApiTestGenerator(IJavaElement element) {
        this.m_element = element;
        this.m_usedMemberNames = new HashSet<String>();
    }

    public String buildSource() throws JavaModelException {
        ImportValidator validator = new ImportValidator();
        StringBuilder sourceBuilder = new StringBuilder();
        sourceBuilder.append("/**").append(NL);
        sourceBuilder.append("* @Generated with ").append(this.getClass().getName()).append(NL);
        sourceBuilder.append("*/").append(NL);
        sourceBuilder.append("private void testApiOf").append(this.m_element.getElementName()).append("() throws ").append(validator.getTypeName(Signature.createTypeSignature((String)Exception.class.getName(), (boolean)true))).append(" {").append(NL);
        this.buildElement(this.m_element, sourceBuilder, (IImportValidator)validator);
        sourceBuilder.append("}");
        StringBuilder result = new StringBuilder();
        for (String imp : validator.getImportsToCreate()) {
            result.append(imp).append(NL);
        }
        result.append(sourceBuilder.toString());
        return result.toString();
    }

    protected void buildElement(IJavaElement element, StringBuilder source, IImportValidator validator) throws JavaModelException {
        switch (element.getElementType()) {
            case 5: {
                IType[] iTypeArray = ((ICompilationUnit)element).getTypes();
                int n = iTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IType t = iTypeArray[n2];
                    this.buildType(t, source, validator);
                    ++n2;
                }
                break;
            }
            case 7: {
                this.buildType((IType)element, source, validator);
                break;
            }
            case 9: {
                this.buildMethod((IMethod)element, source, validator);
                break;
            }
            case 8: {
                this.buildField((IField)element, source, validator);
            }
        }
    }

    protected void buildType(IType type, StringBuilder source, IImportValidator validator) throws JavaModelException {
        String sdkAssertRef = validator.getTypeName(Signature.createTypeSignature((String)SdkAssert.class.getName(), (boolean)true));
        String iTypeRef = validator.getTypeName(Signature.createTypeSignature((String)IType.class.getName(), (boolean)true));
        String typeVarName = this.getMemberName((IJavaElement)type);
        source.append("// type ").append(type.getElementName()).append(NL);
        source.append(iTypeRef).append(" ").append(typeVarName).append(" = ");
        source.append(sdkAssertRef).append(".assertTypeExists(").append("\"").append(type.getFullyQualifiedName()).append("\");").append(NL);
        this.buildType(type, typeVarName, source, validator, sdkAssertRef, iTypeRef);
    }

    protected void buildType(IType type, String typeVarName, StringBuilder source, IImportValidator validator, String sdkAssertRef, String iTypeRef) throws JavaModelException {
        String[] intSignatures;
        source.append(sdkAssertRef).append(".assertHasFlags(").append(typeVarName).append(", ").append(type.getFlags()).append(");").append(NL);
        String superClassSig = type.getSuperclassTypeSignature();
        if (!StringUtility.isNullOrEmpty((String)superClassSig)) {
            source.append(sdkAssertRef).append(".assertHasSuperTypeSignature(").append(typeVarName).append(", \"").append(superClassSig).append("\");").append(NL);
        }
        if ((intSignatures = type.getSuperInterfaceTypeSignatures()).length > 0) {
            source.append(sdkAssertRef).append(".assertHasSuperIntefaceSignatures(").append(typeVarName).append(", new String[]{");
            int i = 0;
            while (i < intSignatures.length) {
                source.append("\"").append(intSignatures[i]).append("\"");
                if (i < intSignatures.length - 1) {
                    source.append(", ");
                }
                ++i;
            }
            source.append("});").append(NL);
        }
        this.createAnnotationsAsserts((IAnnotatable)type, type, source, typeVarName, sdkAssertRef);
        source.append(NL);
        source.append("// fields of ").append(type.getElementName()).append(NL);
        String iFieldRef = validator.getTypeName(Signature.createTypeSignature((String)IField.class.getName(), (boolean)true));
        IField[] fields = type.getFields();
        source.append(sdkAssertRef).append(".assertEquals(\"field count of '").append(type.getElementName()).append("'\", ").append(Integer.toString(fields.length)).append(", ").append(typeVarName).append(".getFields().length);").append(NL);
        IField[] iFieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            IField f = iFieldArray[n2];
            String fieldVarName = this.getMemberName((IJavaElement)f);
            source.append(iFieldRef).append(" ").append(fieldVarName).append(" = ").append(sdkAssertRef).append(".assertFieldExist(").append(typeVarName).append(", \"").append(f.getElementName()).append("\");").append(NL);
            this.buildField(f, fieldVarName, source, validator, sdkAssertRef);
            ++n2;
        }
        source.append(NL);
        String iMethodRef = validator.getTypeName(Signature.createTypeSignature((String)IMethod.class.getName(), (boolean)true));
        IMethod[] methods = type.getMethods();
        source.append(sdkAssertRef).append(".assertEquals(\"method count of '").append(type.getElementName()).append("'\", ").append(Integer.toString(methods.length)).append(", ").append(typeVarName).append(".getMethods().length);").append(NL);
        IMethod[] iMethodArray = methods;
        int n3 = methods.length;
        int n4 = 0;
        while (n4 < n3) {
            IMethod method = iMethodArray[n4];
            String methodVarName = this.getMemberName((IJavaElement)method);
            source.append(iMethodRef).append(" ").append(methodVarName).append(" = ").append(sdkAssertRef).append(".assertMethodExist(").append(typeVarName).append(", \"").append(method.getElementName()).append("\", new String[]{");
            this.buildMethod(method, methodVarName, source, validator, sdkAssertRef);
            ++n4;
        }
        source.append(NL);
        IType[] innerTypes = type.getTypes();
        source.append(sdkAssertRef).append(".assertEquals(\"inner types count of '").append(type.getElementName()).append("'\", ").append(Integer.toString(innerTypes.length)).append(", ").append(typeVarName).append(".getTypes().length);").append(NL);
        IType[] iTypeArray = innerTypes;
        int n5 = innerTypes.length;
        n3 = 0;
        while (n3 < n5) {
            IType innerType = iTypeArray[n3];
            String innerTypeVarName = this.getMemberName((IJavaElement)innerType);
            source.append("// type ").append(innerType.getElementName()).append(NL);
            source.append(iTypeRef).append(" ").append(innerTypeVarName).append(" = ");
            source.append(sdkAssertRef).append(".assertTypeExists(").append(typeVarName).append(", \"").append(innerType.getElementName()).append("\");").append(NL);
            this.buildType(innerType, innerTypeVarName, source, validator, sdkAssertRef, iTypeRef);
            ++n3;
        }
    }

    protected void buildMethod(IMethod method, StringBuilder source, IImportValidator validator) throws JavaModelException {
        String sdkAssertRef = validator.getTypeName(Signature.createTypeSignature((String)SdkAssert.class.getName(), (boolean)true));
        String methodVarName = this.getMemberName((IJavaElement)method);
        this.buildMethod(method, methodVarName, source, validator, sdkAssertRef);
    }

    protected void buildMethod(IMethod method, String methodVarName, StringBuilder source, IImportValidator validator, String sdkAssertRef) throws JavaModelException {
        String returnTypeSig;
        String[] parameterSignatures = method.getParameterTypes();
        if (parameterSignatures.length > 0) {
            int i = 0;
            while (i < parameterSignatures.length) {
                source.append("\"").append(parameterSignatures[i]).append("\"");
                if (i < parameterSignatures.length - 1) {
                    source.append(", ");
                }
                ++i;
            }
        }
        source.append("});").append(NL);
        if (method.isConstructor()) {
            source.append(sdkAssertRef).append(".assertTrue(").append(methodVarName).append(".isConstructor());").append(NL);
        }
        if (!StringUtility.isNullOrEmpty((String)(returnTypeSig = method.getReturnType()))) {
            source.append(sdkAssertRef).append(".assertMethodReturnTypeSignature(").append(methodVarName).append(", \"").append(returnTypeSig).append("\");").append(NL);
        }
        this.createAnnotationsAsserts((IAnnotatable)method, method.getDeclaringType(), source, methodVarName, sdkAssertRef);
        if (CompareUtility.equals((Object)method.getElementName(), (Object)"initValidationRules") && method.getParameters().length == 1) {
            this.createInitValidationRulesAssert(method, methodVarName, source, sdkAssertRef);
        }
    }

    protected void buildField(IField field, StringBuilder source, IImportValidator validator) throws JavaModelException {
        String sdkAssertRef = validator.getTypeName(Signature.createTypeSignature((String)SdkAssert.class.getName(), (boolean)true));
        String fieldVarName = this.getMemberName((IJavaElement)field);
        this.buildField(field, fieldVarName, source, validator, sdkAssertRef);
    }

    protected void buildField(IField field, String fieldVarName, StringBuilder source, IImportValidator validator, String sdkAssertRef) throws JavaModelException {
        source.append(sdkAssertRef).append(".assertHasFlags(").append(fieldVarName).append(", ").append(field.getFlags()).append(");").append(NL);
        source.append(sdkAssertRef).append(".assertFieldSignature(").append(fieldVarName).append(", ").append("\"").append(field.getTypeSignature()).append("\");").append(NL);
        this.createAnnotationsAsserts((IAnnotatable)field, field.getDeclaringType(), source, fieldVarName, sdkAssertRef);
    }

    protected void createInitValidationRulesAssert(IMethod method, String methodVarName, StringBuilder source, String sdkAssertRef) {
        try {
            ISourceRange range = TypeUtility.getContentSourceRange((IMethod)method);
            String methodSource = method.getOpenable().getBuffer().getText(range.getOffset(), range.getLength());
            BufferedReader reader = null;
            try {
                source.append(sdkAssertRef).append(".assertMethodValidationRules(").append(methodVarName).append(", new String[]{");
                reader = new BufferedReader(new StringReader(methodSource));
                String line = reader.readLine();
                boolean superCall = false;
                boolean commaFirst = false;
                while (line != null) {
                    if (!StringUtility.isNullOrEmpty((String)(line = line.trim()))) {
                        if (line.matches("^super\\.initValidationRules\\([^\\)]*\\)\\;$")) {
                            superCall = true;
                        } else {
                            if (commaFirst) {
                                source.append(", ");
                            } else {
                                commaFirst = true;
                            }
                            source.append("\"").append(line).append("\"");
                        }
                    }
                    line = reader.readLine();
                }
                source.append("}, ").append(Boolean.toString(superCall)).append(");").append(NL);
            }
            catch (IOException e) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e1) {
                        SdkTestingApi.logError("could not close reader.", e1);
                    }
                }
                SdkTestingApi.logError("could not parse initValidationRulesMethod on '" + method.getDeclaringType().getFullyQualifiedName() + "'.", e);
            }
        }
        catch (CoreException e) {
            SdkTestingApi.logError("could not parse initValidationRulesMethod on '" + method.getDeclaringType().getFullyQualifiedName() + "'.", e);
        }
    }

    public void createAnnotationsAsserts(IAnnotatable annotatable, IType resolveContext, StringBuilder source, String annotatableRef, String sdkAssertRef) {
        try {
            IAnnotation[] iAnnotationArray = annotatable.getAnnotations();
            int n = iAnnotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation a = iAnnotationArray[n2];
                String annotationSignature = SignatureUtility.getResolvedSignature((String)Signature.createTypeSignature((String)a.getElementName(), (boolean)false), (IType)resolveContext);
                source.append(sdkAssertRef).append(".assertAnnotation(").append(annotatableRef).append(", \"").append(SignatureUtility.getFullyQualifiedName((String)annotationSignature)).append("\");").append(NL);
                ++n2;
            }
        }
        catch (CoreException e) {
            StringBuilder message = new StringBuilder("could not create annotation asserts for '");
            if (annotatable instanceof IJavaElement) {
                message.append(((IJavaElement)annotatable).getElementName());
            } else {
                message.append(annotatable);
            }
            message.append("'.");
            SdkTestingApi.logError(message.toString(), e);
        }
    }

    private String getMemberName(IJavaElement e) {
        String memberName = NamingUtility.ensureStartWithLowerCase((String)e.getElementName());
        if (this.m_usedMemberNames.contains(memberName)) {
            int counter = 1;
            String workingName = String.valueOf(memberName) + counter;
            while (this.m_usedMemberNames.contains(workingName)) {
                workingName = String.valueOf(memberName) + ++counter;
            }
            memberName = workingName;
        }
        this.m_usedMemberNames.add(memberName);
        return memberName;
    }
}

