/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.delete;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.form.field.BoxDeleteOperation;
import org.eclipse.scout.sdk.ui.action.AbstractScoutHandler;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.dialog.MemberSelectionDialog;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.swt.widgets.Shell;

public class FormFieldDeleteAction
extends AbstractScoutHandler {
    private final Set<IType> m_formFieldTypes = new LinkedHashSet<IType>();

    public FormFieldDeleteAction() {
        super(Texts.get((String)"DeleteWithPopup"), ScoutSdkUi.getImageDescriptor("formField_remove.png"), "Delete", true, IScoutHandler.Category.DELETE);
    }

    @Override
    public Object execute(Shell shell, IPage[] selection, ExecutionEvent event) throws ExecutionException {
        IType[] members = this.m_formFieldTypes.toArray(new IType[this.m_formFieldTypes.size()]);
        MemberSelectionDialog m_confirmDialog = new MemberSelectionDialog(shell, Texts.get((String)"DeleteFormField"), Texts.get((String)"SelectFieldsToRemove"));
        m_confirmDialog.setMembers((IMember[])members);
        m_confirmDialog.setSelectedMembers((IMember[])members);
        if (m_confirmDialog.open() == 0) {
            IMember[] selectedMembers = m_confirmDialog.getSelectedMembers();
            BoxDeleteOperation[] deleteOperations = new BoxDeleteOperation[selectedMembers.length];
            int i = 0;
            while (i < selectedMembers.length) {
                deleteOperations[i] = new BoxDeleteOperation((IType)selectedMembers[i]);
                ++i;
            }
            OperationJob job = new OperationJob((IOperation[])deleteOperations);
            job.schedule();
        }
        return null;
    }

    @Override
    public boolean isVisible() {
        for (IType field : this.m_formFieldTypes) {
            if (this.isEditable((IJavaElement)field)) continue;
            return false;
        }
        return true;
    }

    public void addFormFieldType(IType formFieldType) {
        this.m_formFieldTypes.add(formFieldType);
    }
}

