/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.delete;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.jdt.JavaElementDeleteOperation;
import org.eclipse.scout.sdk.ui.action.AbstractScoutHandler;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.dialog.IMemberSelectionChangedListener;
import org.eclipse.scout.sdk.ui.dialog.MemberSelectionDialog;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.swt.widgets.Shell;

public class MemberListDeleteAction
extends AbstractScoutHandler {
    private final Set<IMember> m_membersToDelete = new TreeSet<IMember>(new Comparator<IMember>(){

        @Override
        public int compare(IMember t1, IMember t2) {
            CompositeObject ct1 = new CompositeObject(new Object[]{t1.getElementName(), t1});
            CompositeObject ct2 = new CompositeObject(new Object[]{t2.getElementName(), t2});
            return ct1.compareTo(ct2);
        }
    });
    private MemberSelectionDialog m_confirmDialog;

    public MemberListDeleteAction() {
        super(Texts.get((String)"DeleteWithPopup"), ScoutSdkUi.getImageDescriptor("remove.png"), "Delete", true, IScoutHandler.Category.DELETE);
    }

    @Override
    public Object execute(Shell shell, IPage[] selection, ExecutionEvent event) throws ExecutionException {
        this.m_confirmDialog = new MemberSelectionDialog(shell, "Delete");
        this.m_confirmDialog.addMemberSelectionListener(new IMemberSelectionChangedListener(){

            @Override
            public void handleSelectionChanged(IMember[] s) {
                MemberListDeleteAction.this.m_confirmDialog.setMessage("");
                boolean canOk = s != null && s.length > 0;
                MemberListDeleteAction.this.m_confirmDialog.getOkButton().setEnabled(canOk);
            }
        });
        this.m_confirmDialog.setMembers(this.m_membersToDelete.toArray(new IMember[this.m_membersToDelete.size()]));
        this.m_confirmDialog.setSelectedMembers(this.m_membersToDelete.toArray(new IMember[this.m_membersToDelete.size()]));
        if (this.m_confirmDialog.open() == 0) {
            JavaElementDeleteOperation op = new JavaElementDeleteOperation();
            op.setMembers((IJavaElement[])this.m_confirmDialog.getSelectedMembers());
            OperationJob job = new OperationJob(new IOperation[]{op});
            job.schedule();
        }
        return null;
    }

    @Override
    public boolean isVisible() {
        if (this.m_membersToDelete.size() < 1) {
            return false;
        }
        for (IMember m : this.m_membersToDelete) {
            if (this.isEditable((IJavaElement)m)) continue;
            return false;
        }
        return true;
    }

    public boolean addMemberToDelete(IMember m) {
        return this.m_membersToDelete.add(m);
    }

    public boolean removeMemberToDelete(IMember m) {
        return this.m_membersToDelete.remove(m);
    }
}

