/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.dto;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.action.AbstractScoutHandler;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.scout.sdk.workspace.dto.formdata.FormDataAnnotation;
import org.eclipse.scout.sdk.workspace.dto.formdata.FormDataDtoUpdateOperation;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class FormDataUpdateAction
extends AbstractScoutHandler {
    private IType m_formDataOwner;

    public FormDataUpdateAction() {
        super(Texts.get((String)"UpdateFormData"), ScoutSdkUi.getImageDescriptor("tool_loading.gif"), null, false, IScoutHandler.Category.UDPATE);
    }

    @Override
    public boolean isVisible() {
        return this.isEditable((IJavaElement)this.getFormDataOwner()) && this.getFormDataOwner().getDeclaringType() == null;
    }

    public void setFormDataOwner(IType formDataOwner) {
        this.m_formDataOwner = formDataOwner;
    }

    @Override
    public Object execute(Shell shell, IPage[] selection, ExecutionEvent event) throws ExecutionException {
        try {
            FormDataAnnotation formDataAnnotation = ScoutTypeUtility.findFormDataAnnotation((IType)this.getFormDataOwner(), (ITypeHierarchy)TypeUtility.getSuperTypeHierarchy((IType)this.getFormDataOwner()));
            if (FormDataAnnotation.isCreate((FormDataAnnotation)formDataAnnotation) && TypeUtility.exists((IJavaElement)formDataAnnotation.getFormDataType())) {
                OperationJob job = new OperationJob(new IOperation[]{new FormDataDtoUpdateOperation(this.getFormDataOwner(), formDataAnnotation)});
                job.schedule();
            } else {
                MessageBox box = new MessageBox(shell, 34);
                box.setMessage(Texts.get((String)"CheckFormDataAnnot"));
                box.open();
            }
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("unable to calculate form data type for update of element '" + this.getFormDataOwner().getFullyQualifiedName() + "'.", e);
        }
        return null;
    }

    private IType getFormDataOwner() {
        return this.m_formDataOwner;
    }
}

