/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.rename;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.action.rename.AbstractRenameAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.jdt.JdtRenameTransaction;
import org.eclipse.scout.sdk.util.NamingUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class FormFieldRenameAction
extends AbstractRenameAction {
    private IType m_formField;

    @Override
    protected void fillTransaction(JdtRenameTransaction transaction, String newName) throws CoreException {
        transaction.add(this.getFormField(), newName);
        IMethod getter = ScoutTypeUtility.getFormFieldGetterMethod((IType)this.getFormField());
        if (TypeUtility.exists((IJavaElement)getter)) {
            transaction.add(getter, "get" + NamingUtility.ensureStartWithUpperCase((String)newName));
        }
    }

    @Override
    public boolean isVisible() {
        return this.isEditable((IJavaElement)this.m_formField);
    }

    @Override
    protected IStatus validate(String newName) {
        IStatus inheritedStatus = this.getJavaNameStatus(newName);
        if (inheritedStatus.matches(4)) {
            return inheritedStatus;
        }
        try {
            if (FormFieldRenameAction.findInnerType(this.getFormField().getCompilationUnit().getAllTypes()[0], newName, true) != null) {
                return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
            }
        }
        catch (CoreException e) {
            ScoutSdkUi.logError("error during finding already existing types in form.", e);
            return new Status(4, "org.eclipse.scout.sdk.ui", "Exception in validation (see logfile).");
        }
        return inheritedStatus;
    }

    public IType getFormField() {
        return this.m_formField;
    }

    public static IType findInnerType(IType declaringType, String simpleName, boolean ignoreCase) throws JavaModelException {
        if (ignoreCase ? declaringType.getElementName().equalsIgnoreCase(simpleName) : declaringType.getElementName().equals(simpleName)) {
            return declaringType;
        }
        IType[] iTypeArray = declaringType.getTypes();
        if (iTypeArray.length != 0) {
            IType innerType = iTypeArray[0];
            return FormFieldRenameAction.findInnerType(innerType, simpleName, ignoreCase);
        }
        return null;
    }

    public void setFormField(IType formField) {
        this.m_formField = formField;
    }
}

