/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.extensions.preferences;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.extensions.preferences.IScoutProjectScrolledContent;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutBundleFilter;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class AbstractScoutProjectPreferencePage<T extends IScoutProjectScrolledContent<U>, U>
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Combo m_projectCombo;
    private Text m_searchFilter;
    private T m_currentProjectSetting;
    private Composite m_container;
    private final Map<IScoutBundle, T> m_projectSettings;

    public AbstractScoutProjectPreferencePage(String desc, Class<T> contentClass, String ... scoutBundleTypes) {
        this.setDescription(desc);
        IScoutBundleFilter projectFilter = ScoutBundleFilters.getMultiFilterAnd((IScoutBundleFilter[])new IScoutBundleFilter[]{ScoutBundleFilters.getWorkspaceBundlesFilter(), ScoutBundleFilters.getBundlesOfTypeFilter((String[])scoutBundleTypes)});
        IScoutBundle[] rootProjects = ScoutSdkCore.getScoutWorkspace().getBundleGraph().getBundles(projectFilter);
        this.m_projectSettings = new HashMap<IScoutBundle, T>(rootProjects.length);
        IScoutBundle[] iScoutBundleArray = rootProjects;
        int n = rootProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutBundle p = iScoutBundleArray[n2];
            try {
                this.m_projectSettings.put(p, (IScoutProjectScrolledContent)contentClass.newInstance());
            }
            catch (InstantiationException e) {
                ScoutSdkUi.logError(e);
            }
            catch (IllegalAccessException e) {
                ScoutSdkUi.logError(e);
            }
            ++n2;
        }
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.save();
        return super.performOk();
    }

    protected void performApply() {
        this.save();
        super.performApply();
    }

    protected void performDefaults() {
        this.reset();
        super.performDefaults();
    }

    private void save() {
        for (IScoutProjectScrolledContent c : this.m_projectSettings.values()) {
            c.save();
        }
    }

    private void reset() {
        for (IScoutProjectScrolledContent c : this.m_projectSettings.values()) {
            c.reset();
        }
    }

    protected Control createContents(Composite p) {
        this.m_container = new Composite(p, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_container.setLayout((Layout)layout);
        if (this.m_projectSettings.size() < 1) {
            Label noProjectLabel = new Label(this.m_container, 0);
            noProjectLabel.setText(Texts.get((String)"NoScoutProjectForDefaultSuperClassMsg"));
            return this.m_container;
        }
        final Composite parent = this.m_container;
        final ProgressIndicator indicator = new ProgressIndicator(parent, 65536);
        indicator.beginTask(this.getTotalWork());
        GridData indicatorData = new GridData(768);
        indicatorData.horizontalSpan = 2;
        indicatorData.heightHint = 15;
        indicator.setLayoutData((Object)indicatorData);
        Job j = new Job("load scout sdk settings..."){

            protected IStatus run(IProgressMonitor monitor) {
                if (!parent.isDisposed()) {
                    try {
                        AbstractScoutProjectPreferencePage.this.loadAllModels(new IScoutProjectScrolledContent.IModelLoadProgressObserver<U>(){

                            @Override
                            public void loaded(U justLoadedModel) {
                                if (parent != null && !parent.isDisposed()) {
                                    parent.getDisplay().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (!indicator.isDisposed()) {
                                                indicator.worked(1.0);
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        if (!parent.isDisposed()) {
                            parent.getDisplay().asyncExec(new Runnable(parent, indicator){
                                private final /* synthetic */ Composite val$parent;
                                private final /* synthetic */ ProgressIndicator val$indicator;
                                {
                                    this.val$parent = composite;
                                    this.val$indicator = progressIndicator;
                                }

                                @Override
                                public void run() {
                                    if (this.val$parent != null && !this.val$parent.isDisposed()) {
                                        try {
                                            this.val$parent.getShell().setRedraw(false);
                                            this.val$indicator.dispose();
                                            AbstractScoutProjectPreferencePage.this.createHeader(AbstractScoutProjectPreferencePage.this.m_container);
                                            AbstractScoutProjectPreferencePage.this.createSettingsLists(AbstractScoutProjectPreferencePage.this.m_container);
                                            AbstractScoutProjectPreferencePage.this.initializeValues();
                                        }
                                        finally {
                                            this.val$parent.getShell().setRedraw(true);
                                            this.val$parent.getShell().layout(true);
                                            this.val$parent.getShell().redraw();
                                        }
                                    }
                                }
                            });
                        }
                        throw throwable;
                    }
                    if (!parent.isDisposed()) {
                        parent.getDisplay().asyncExec(new /* invalid duplicate definition of identical inner class */);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        j.setSystem(true);
        j.schedule();
        return this.m_container;
    }

    private void createHeader(Composite parent) {
        Composite headerComposite = new Composite(parent, 0);
        headerComposite.setLayoutData((Object)new GridData(768));
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginBottom = 8;
        headerComposite.setLayout((Layout)gl);
        Label projectLabel = new Label(headerComposite, 0);
        projectLabel.setText(Texts.get((String)"ScoutProjectLabel"));
        GridData labelGridData = new GridData();
        labelGridData.verticalIndent = 10;
        projectLabel.setLayoutData((Object)labelGridData);
        this.m_projectCombo = new Combo(headerComposite, 12);
        this.m_projectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedName = AbstractScoutProjectPreferencePage.this.m_projectCombo.getItem(AbstractScoutProjectPreferencePage.this.m_projectCombo.getSelectionIndex());
                AbstractScoutProjectPreferencePage.this.projectChanged(selectedName);
            }
        });
        GridData comboGridData = new GridData(768);
        comboGridData.verticalIndent = 10;
        this.m_projectCombo.setLayoutData((Object)comboGridData);
        this.m_searchFilter = new Text(headerComposite, 2436);
        this.m_searchFilter.setMessage(Texts.get((String)"TypeFilterText"));
        this.m_searchFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractScoutProjectPreferencePage.this.applySearchPattern(AbstractScoutProjectPreferencePage.this.m_searchFilter.getText());
            }
        });
        GridData filterGridData = new GridData(768);
        filterGridData.horizontalSpan = 2;
        filterGridData.verticalIndent = 10;
        this.m_searchFilter.setLayoutData((Object)filterGridData);
    }

    private void createSettingsLists(Composite parent) {
        for (Map.Entry<IScoutBundle, T> e : this.m_projectSettings.entrySet()) {
            ((IScoutProjectScrolledContent)e.getValue()).createContent(parent);
        }
    }

    private void applySearchPattern(String pattern) {
        try {
            this.m_container.setRedraw(false);
            pattern = "*" + pattern.trim() + "*";
            for (IScoutProjectScrolledContent scrolledArea : this.m_projectSettings.values()) {
                scrolledArea.setSearchPattern(pattern);
                scrolledArea.reflow();
            }
        }
        finally {
            this.m_container.setRedraw(true);
            this.m_container.layout(true, true);
            this.m_container.redraw();
        }
    }

    protected abstract void loadAllModels(IScoutProjectScrolledContent.IModelLoadProgressObserver<U> var1);

    protected abstract int getTotalWork();

    protected Map<IScoutBundle, T> getProjectModelMap() {
        return this.m_projectSettings;
    }

    private void initializeValues() {
        Object[] projectNames = new String[this.m_projectSettings.size()];
        int i = 0;
        for (IScoutBundle p : this.m_projectSettings.keySet()) {
            projectNames[i++] = p.getSymbolicName();
        }
        Arrays.sort(projectNames);
        this.m_projectCombo.setItems((String[])projectNames);
        this.m_projectCombo.select(0);
        this.projectChanged((String)projectNames[0]);
    }

    private void projectChanged(String projectName) {
        if (this.m_currentProjectSetting != null) {
            this.m_currentProjectSetting.setVisible(false);
        }
        for (IScoutBundle p : this.m_projectSettings.keySet()) {
            if (!p.getSymbolicName().equals(projectName)) continue;
            this.m_currentProjectSetting = (IScoutProjectScrolledContent)this.m_projectSettings.get(p);
            this.m_currentProjectSetting.setVisible(true);
            break;
        }
        this.m_container.layout(true);
        this.m_container.redraw();
    }
}

