/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.extensions.preferences;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.ui.extensions.preferences.DefaultSuperClassModel;
import org.eclipse.scout.sdk.ui.extensions.preferences.IScoutProjectScrolledContent;
import org.eclipse.scout.sdk.ui.fields.SimpleScrolledComposite;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.prefs.BackingStoreException;

public class SuperTypePreferenceScrolledContent
implements IScoutProjectScrolledContent<DefaultSuperClassModel> {
    private final List<Combo> m_allSuperTypeCombos = new ArrayList<Combo>();
    private final List<Label> m_allLabels = new ArrayList<Label>();
    private List<DefaultSuperClassModel> m_entries;
    private SimpleScrolledComposite m_scrollArea;

    @Override
    public void loadModel(List<DefaultSuperClassModel> entries, IScoutProjectScrolledContent.IModelLoadProgressObserver<DefaultSuperClassModel> observer) {
        this.m_entries = new ArrayList<DefaultSuperClassModel>(entries);
        for (DefaultSuperClassModel model : this.m_entries) {
            model.load();
            if (observer == null) continue;
            observer.loaded(model);
        }
    }

    @Override
    public void createContent(Composite parent) {
        this.m_scrollArea = new SimpleScrolledComposite(parent);
        Composite c = this.m_scrollArea.getBody();
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = 2;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        c.setLayout((Layout)gl);
        for (DefaultSuperClassModel entry : this.m_entries) {
            String[] proposals = entry.getProposals();
            String selectedValue = null;
            int selIndex = entry.getInitialSelectetdIndex();
            selectedValue = selIndex >= 0 ? entry.getProposals()[selIndex] : "";
            Label l = new Label(c, 0);
            l.setToolTipText(entry.interfaceFqn);
            l.setText(String.valueOf(entry.label) + ": ");
            l.setLayoutData((Object)new GridData());
            this.m_allLabels.add(l);
            final DefaultSuperClassModel model = entry;
            final Combo co = new Combo(c, 12);
            co.setToolTipText(selectedValue);
            co.setItems(entry.getProposalDisplayTexts());
            co.setEnabled(proposals.length > 1);
            co.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String selectedName = model.getProposals()[co.getSelectionIndex()];
                    co.setToolTipText(selectedName);
                }
            });
            co.select(entry.getInitialSelectetdIndex());
            co.setLayoutData((Object)new GridData(768));
            this.m_allSuperTypeCombos.add(co);
        }
    }

    @Override
    public void save() {
        final HashSet modifiedProjects = new HashSet(1);
        this.visitCombos(new ISuperTypeComboVisitor(){

            @Override
            public void visit(Combo combo, String selectedValue, DefaultSuperClassModel model) {
                String prefKey = RuntimeClasses.getPreferenceKey((String)model.interfaceFqn);
                modifiedProjects.add(model.scoutProject);
                if (model.defaultVal.equals(selectedValue)) {
                    model.scoutProject.getPreferences().remove(prefKey);
                } else {
                    model.scoutProject.getPreferences().put(prefKey, selectedValue);
                }
            }
        });
        for (IScoutBundle p : modifiedProjects) {
            try {
                p.getPreferences().flush();
            }
            catch (BackingStoreException ex) {
                ScoutSdkUi.logError("Unable to save new super type configuration for project '" + p.getSymbolicName() + "'.", ex);
            }
        }
    }

    @Override
    public void reset() {
        this.visitCombos(new ISuperTypeComboVisitor(){

            @Override
            public void visit(Combo combo, String selectedValue, DefaultSuperClassModel model) {
                combo.select(model.getDefaultIndex());
            }
        });
    }

    private void visitCombos(ISuperTypeComboVisitor visitor) {
        int i = 0;
        while (i < this.m_entries.size()) {
            Combo combo = this.m_allSuperTypeCombos.get(i);
            DefaultSuperClassModel model = this.m_entries.get(i);
            String curVal = model.getProposals()[combo.getSelectionIndex()];
            visitor.visit(combo, curVal, model);
            ++i;
        }
    }

    @Override
    public void setVisible(boolean visible) {
        ((GridData)this.m_scrollArea.getLayoutData()).exclude = !visible;
        this.m_scrollArea.setVisible(visible);
        this.m_scrollArea.reflow(true);
    }

    @Override
    public void reflow() {
        this.m_scrollArea.reflow(true);
    }

    @Override
    public void setSearchPattern(String pattern) {
        char[] searchPatternArray = pattern.toCharArray();
        int i = 0;
        while (i < this.m_allSuperTypeCombos.size()) {
            boolean visible;
            Combo cbo = this.m_allSuperTypeCombos.get(i);
            Label lbl = this.m_allLabels.get(i);
            DefaultSuperClassModel model = this.m_entries.get(i);
            boolean bl = visible = CharOperation.match((char[])searchPatternArray, (char[])model.interfaceFqn.toCharArray(), (boolean)false) || CharOperation.match((char[])searchPatternArray, (char[])model.label.toCharArray(), (boolean)false);
            if (!visible) {
                String[] stringArray = model.getProposals();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    boolean matches = CharOperation.match((char[])searchPatternArray, (char[])s.toCharArray(), (boolean)false);
                    if (matches) {
                        visible = matches;
                        break;
                    }
                    ++n2;
                }
            }
            cbo.setVisible(visible);
            ((GridData)cbo.getLayoutData()).exclude = !visible;
            lbl.setVisible(visible);
            ((GridData)lbl.getLayoutData()).exclude = !visible;
            ++i;
        }
    }

    private static interface ISuperTypeComboVisitor {
        public void visit(Combo var1, String var2, DefaultSuperClassModel var3);
    }
}

