/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.extensions.quickassist;

import java.util.EventListener;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.NlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.nls.sdk.ui.action.NlsEntryModifyAction;
import org.eclipse.scout.nls.sdk.ui.action.NlsEntryNewAction;
import org.eclipse.scout.sdk.extensions.classidgenerators.ClassIdGenerationContext;
import org.eclipse.scout.sdk.extensions.classidgenerators.ClassIdGenerators;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.jdt.annotation.AnnotationNewOperation;
import org.eclipse.scout.sdk.sourcebuilder.annotation.AnnotationSourceBuilderFactory;
import org.eclipse.scout.sdk.sourcebuilder.annotation.IAnnotationSourceBuilder;
import org.eclipse.scout.sdk.ui.extensions.quickassist.IClassIdDocumentationListener;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.widgets.Shell;

public class ClassIdDocumentationSupport {
    private final IType m_type;
    private final INlsProject m_project;
    private final EventListenerList m_eventListeners;

    public ClassIdDocumentationSupport(IType type) {
        this(type, ClassIdDocumentationSupport.computeNlsProject(type));
    }

    public ClassIdDocumentationSupport(IType type, INlsProject nlsProject) {
        this.m_type = type;
        this.m_project = nlsProject;
        this.m_eventListeners = new EventListenerList();
    }

    public void addModifiedListener(IClassIdDocumentationListener l) {
        this.m_eventListeners.add(IClassIdDocumentationListener.class, (EventListener)l);
    }

    public void removeModifiedListener(IClassIdDocumentationListener l) {
        this.m_eventListeners.remove(IClassIdDocumentationListener.class, (EventListener)l);
    }

    private static INlsProject computeNlsProject(IType t) {
        IScoutBundle scoutBundle;
        if (TypeUtility.exists((IJavaElement)t) && (scoutBundle = ScoutTypeUtility.getScoutBundle((IJavaElement)t)) != null) {
            return scoutBundle.getDocsNlsProject();
        }
        return null;
    }

    public void editDocumentation(Shell shell) {
        INlsEntry nlsEntry = this.getNlsEntry();
        if (nlsEntry == null) {
            this.createNew(shell);
        } else {
            this.editExisting(nlsEntry, shell);
        }
    }

    public INlsEntry getNlsEntry() {
        INlsProject nlsProject = this.getNlsProject();
        if (nlsProject != null) {
            try {
                String classId = ScoutTypeUtility.getClassIdAnnotationValue((IType)this.getType());
                if (StringUtility.hasText((String)classId)) {
                    String key = this.generateNlsKey(classId);
                    return nlsProject.getEntry(key);
                }
            }
            catch (JavaModelException e) {
                ScoutSdkUi.logError("Unable to get the documentation text for type '" + this.getType().getFullyQualifiedName() + "'.", e);
            }
        }
        return null;
    }

    protected void editExisting(INlsEntry nlsEntry, Shell shell) {
        NlsEntryModifyAction action = new NlsEntryModifyAction(shell, nlsEntry, nlsEntry.getProject());
        action.run();
        try {
            action.join();
        }
        catch (InterruptedException e) {
            ScoutSdkUi.logWarning(e);
        }
        NlsEntry e = action.getEntry();
        if (e != null) {
            this.fireModified((INlsEntry)e, 8);
        }
    }

    protected void createNew(Shell shell) {
        boolean createClassIdAnnotation;
        String classId = null;
        try {
            classId = ScoutTypeUtility.getClassIdAnnotationValue((IType)this.getType());
        }
        catch (JavaModelException e1) {
            ScoutSdkUi.logWarning("Unable to get @ClassId annotation value from type '" + this.getType() + "'.", e1);
        }
        boolean bl = createClassIdAnnotation = classId == null;
        if (createClassIdAnnotation) {
            classId = ClassIdGenerators.generateNewId((ClassIdGenerationContext)new ClassIdGenerationContext(this.getType()));
        }
        String key = this.generateNlsKey(classId);
        NlsEntry entry = new NlsEntry(key, this.getNlsProject());
        NlsEntryNewAction action = new NlsEntryNewAction(shell, this.getNlsProject(), entry, true);
        action.run();
        try {
            action.join();
        }
        catch (InterruptedException e) {
            ScoutSdkUi.logWarning(e);
        }
        entry = action.getEntry();
        if (entry != null) {
            boolean keyModified = CompareUtility.notEquals((Object)key, (Object)entry.getKey());
            if (createClassIdAnnotation || keyModified) {
                this.updateClassIdAnnotation(entry, classId, keyModified, shell);
            } else {
                this.fireModified((INlsEntry)entry, 2);
            }
        }
    }

    protected void fireModified(INlsEntry documentationEntry, int type) {
        IClassIdDocumentationListener[] iClassIdDocumentationListenerArray = (IClassIdDocumentationListener[])this.m_eventListeners.getListeners(IClassIdDocumentationListener.class);
        int n = iClassIdDocumentationListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClassIdDocumentationListener l = iClassIdDocumentationListenerArray[n2];
            if (l != null) {
                try {
                    l.modified(type, documentationEntry, this.getType());
                }
                catch (Exception e) {
                    ScoutSdkUi.logError("Error invoking class id documentation listener '" + l.getClass().getName() + "'.", e);
                }
            }
            ++n2;
        }
    }

    protected void updateClassIdAnnotation(final NlsEntry entry, String classId, boolean keyModified, final Shell shell) {
        if (keyModified) {
            classId = entry.getKey();
        }
        IAnnotationSourceBuilder sourceBuilder = AnnotationSourceBuilderFactory.createClassIdAnnotation((String)classId);
        OperationJob j = new OperationJob(new IOperation[]{new AnnotationNewOperation(sourceBuilder, (IMember)this.getType())});
        j.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ClassIdDocumentationSupport.this.fireModified((INlsEntry)entry, 4);
                    }
                });
            }
        });
        j.schedule();
    }

    protected String generateNlsKey(String classId) {
        return this.getNlsProject().generateKey(classId);
    }

    public IType getType() {
        return this.m_type;
    }

    public INlsProject getNlsProject() {
        return this.m_project;
    }
}

